/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.diff;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.netbeans.modules.versioning.diff.EditorSaveCookie;
import org.netbeans.modules.versioning.util.CollectionUtils;
import org.netbeans.modules.versioning.util.SimpleLookup;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.util.WeakListeners;

public class DiffLookup
extends SimpleLookup
implements PropertyChangeListener {
    private EditorCookie.Observable observableEditorCookie;
    private Object[] withoutSaveCookie;
    private Object[] withSaveCookie;
    private PropertyChangeListener weakList;

    @Override
    protected void validateData(Object[] data) throws IllegalArgumentException {
        super.validateData(data);
        boolean observableEditorCookiePresent = false;
        boolean fileObjectPresent = false;
        for (Object o : data) {
            if (o instanceof EditorCookie.Observable) {
                if (observableEditorCookiePresent) {
                    throw new IllegalArgumentException("multiple instances of EditorCookie.Observable in the data");
                }
                observableEditorCookiePresent = true;
            }
            if (!(o instanceof FileObject)) continue;
            if (fileObjectPresent) {
                throw new IllegalArgumentException("multiple instances of FileObject in the data");
            }
            fileObjectPresent = true;
        }
    }

    @Override
    protected void setValidatedData(Object[] data) {
        EditorCookie.Observable observableEdCookie = null;
        SaveCookie saveCookie = null;
        FileObject fileObj = null;
        for (Object o : data) {
            if (o instanceof SaveCookie) {
                saveCookie = (SaveCookie)o;
                break;
            }
            if (o instanceof EditorCookie.Observable) {
                observableEdCookie = (EditorCookie.Observable)o;
            }
            if (!(o instanceof FileObject)) continue;
            fileObj = (FileObject)o;
        }
        if (saveCookie == null && observableEdCookie != null) {
            this.setDataSpecial(data, observableEdCookie, fileObj);
        } else {
            this.setDataSpecial(data, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDataSpecial(Object[] data, EditorCookie.Observable editorCookie, FileObject fileObj) {
        Object object = this.dataSetLock;
        synchronized (object) {
            Object[] newData;
            if (this.observableEditorCookie != null) {
                this.observableEditorCookie.removePropertyChangeListener(this.weakList);
            }
            this.observableEditorCookie = editorCookie;
            if (this.observableEditorCookie != null) {
                this.weakList = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.observableEditorCookie);
                this.observableEditorCookie.addPropertyChangeListener(this.weakList);
            }
            if (this.observableEditorCookie == null) {
                this.withoutSaveCookie = null;
                this.withSaveCookie = null;
                newData = data;
            } else {
                this.withoutSaveCookie = data;
                this.withSaveCookie = CollectionUtils.appendItem(this.withoutSaveCookie, new EditorSaveCookie((EditorCookie)editorCookie, fileObj));
                newData = this.observableEditorCookie.isModified() ? this.withSaveCookie : this.withoutSaveCookie;
            }
            this.setDataImpl(newData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object source = evt.getSource();
        Object object = this.dataSetLock;
        synchronized (object) {
            if (source != this.observableEditorCookie) {
                return;
            }
            this.setDataImpl(this.observableEditorCookie.isModified() ? this.withSaveCookie : this.withoutSaveCookie);
        }
    }
}

