/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.history;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.geom.Rectangle2D;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.plaf.TextUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.modules.versioning.history.AbstractSummaryView;
import org.netbeans.modules.versioning.history.LinkButton;
import org.netbeans.modules.versioning.history.RevisionItemCell;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.modules.versioning.util.VCSHyperlinkProvider;
import org.netbeans.modules.versioning.util.VCSHyperlinkSupport;
import org.netbeans.modules.versioning.util.VCSKenaiAccessor;
import org.openide.ErrorManager;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

class SummaryCellRenderer
implements ListCellRenderer {
    private static final double DARKEN_FACTOR = 0.95;
    private static final double DARKEN_FACTOR_UNINTERESTING = 0.975;
    private final AbstractSummaryView summaryView;
    private final Map<String, VCSKenaiAccessor.KenaiUser> kenaiUsersMap;
    private final VCSHyperlinkSupport linkerSupport;
    private Color selectionBackgroundColor;
    private Color selectionBackground;
    private Color selectionForeground;
    private static final Color LINK_COLOR = UIManager.getColor("nb.html.link.foreground");
    private ActionRenderer ar;
    private MoreRevisionsRenderer mr;
    private DefaultListCellRenderer dlcr;
    private ListCellRenderer remainingFilesRenderer;
    private final ListCellRenderer lessFilesRenderer;
    private AttributeSet searchHiliteAttrs;
    private static final Icon ICON_COLLAPSED = UIManager.getIcon("Tree.collapsedIcon");
    private static final Icon ICON_EXPANDED = UIManager.getIcon("Tree.expandedIcon");
    private static final int INDENT = ICON_EXPANDED.getIconWidth() + 3;
    private static final JLabel EMPTY_SPACE_LABEL = new JLabel();
    private static final String PREFIX_PATH_FROM = NbBundle.getMessage(SummaryCellRenderer.class, (String)"MSG_SummaryCellRenderer.pathPrefixFrom");
    private Collection<VCSHyperlinkProvider> hpInstances;
    Map<Object, Reference<ListCellRenderer>> renderers;
    private static final String FIELDS_SEPARATOR = "      ";
    private static final String LINK_STRING = " ...";
    private static final int LINK_STRING_LEN = " ...".length();

    public SummaryCellRenderer(AbstractSummaryView summaryView, VCSHyperlinkSupport linkerSupport, Map<String, VCSKenaiAccessor.KenaiUser> kenaiUsersMap) {
        this.selectionBackground = this.selectionBackgroundColor = new JList().getSelectionBackground();
        this.selectionForeground = new JList().getSelectionForeground();
        this.ar = new ActionRenderer();
        this.mr = new MoreRevisionsRenderer();
        this.dlcr = new DefaultListCellRenderer();
        this.remainingFilesRenderer = new RemainingFilesRenderer();
        this.lessFilesRenderer = new LessFilesRenderer();
        this.renderers = new WeakHashMap<Object, Reference<ListCellRenderer>>();
        this.summaryView = summaryView;
        this.kenaiUsersMap = kenaiUsersMap;
        this.linkerSupport = linkerSupport;
        this.searchHiliteAttrs = ((FontColorSettings)MimeLookup.getLookup((MimePath)MimePath.get((String)"text/x-java")).lookup(FontColorSettings.class)).getFontColors("highlight-search");
    }

    private static Color darker(Color c) {
        return SummaryCellRenderer.darker(c, 0.95);
    }

    private static Color darkerUninteresting(Color c) {
        return SummaryCellRenderer.darker(c, 0.975);
    }

    private static Color darker(Color c, double factor) {
        return new Color(Math.max((int)((double)c.getRed() * factor), 0), Math.max((int)((double)c.getGreen() * factor), 0), Math.max((int)((double)c.getBlue() * factor), 0));
    }

    private static Color lessInteresting(Color c, Color bg) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        r += (bg.getRed() - r) / 5;
        g += (bg.getGreen() - g) / 5;
        b += (bg.getBlue() - b) / 5;
        return new Color(r, g, b);
    }

    private static String getColorString(Color c) {
        return "#" + SummaryCellRenderer.getHex(c.getRed()) + SummaryCellRenderer.getHex(c.getGreen()) + SummaryCellRenderer.getHex(c.getBlue());
    }

    private static String getHex(int i) {
        String hex = Integer.toHexString(i & 0xFF);
        if (hex.length() == 1) {
            hex = "0" + hex;
        }
        return hex;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean hasFocus) {
        if (value instanceof AbstractSummaryView.RevisionItem) {
            ListCellRenderer ren = this.getRenderer(value);
            if (ren == null) {
                ren = new RevisionRenderer();
                this.renderers.put(value, new SoftReference<ListCellRenderer>(ren));
            }
            return ren.getListCellRendererComponent(list, value, index, selected, hasFocus);
        }
        if (value instanceof AbstractSummaryView.EventItem) {
            ListCellRenderer ren = this.getRenderer(value);
            if (ren == null) {
                ren = new EventRenderer();
                this.renderers.put(value, new SoftReference<ListCellRenderer>(ren));
            }
            return ren.getListCellRendererComponent(list, value, index, selected, hasFocus);
        }
        if (value instanceof AbstractSummaryView.LoadingEventsItem) {
            Component comp = this.dlcr.getListCellRendererComponent((JList<?>)list, NbBundle.getMessage(SummaryCellRenderer.class, (String)"MSG_LoadingEvents"), index, selected, hasFocus);
            if (comp instanceof JComponent) {
                ((JComponent)comp).setBorder(BorderFactory.createEmptyBorder(0, INDENT, 0, 0));
            }
            return comp;
        }
        if (value instanceof AbstractSummaryView.ShowAllEventsItem) {
            return this.remainingFilesRenderer.getListCellRendererComponent(list, value, index, selected, hasFocus);
        }
        if (value instanceof AbstractSummaryView.ShowLessEventsItem) {
            return this.lessFilesRenderer.getListCellRendererComponent(list, value, index, selected, hasFocus);
        }
        if (value instanceof AbstractSummaryView.ActionsItem) {
            return this.ar.getListCellRendererComponent(list, value, index, selected, hasFocus);
        }
        if (value instanceof AbstractSummaryView.MoreRevisionsItem) {
            return this.mr.getListCellRendererComponent(list, value, index, selected, hasFocus);
        }
        return EMPTY_SPACE_LABEL;
    }

    private int getMaxPathWidth(JList list, AbstractSummaryView.RevisionItem revision, Graphics g) {
        assert (revision.revisionExpanded);
        assert (EventQueue.isDispatchThread());
        Collection<AbstractSummaryView.LogEntry.Event> events = ((AbstractSummaryView.LogEntry)revision.getUserData()).isEventsInitialized() ? ((AbstractSummaryView.LogEntry)revision.getUserData()).getEvents() : ((AbstractSummaryView.LogEntry)revision.getUserData()).getDummyEvents();
        int maxWidth = -1;
        if (events.size() < 20) {
            block0: for (AbstractSummaryView.LogEntry.Event event : events) {
                int i = 0;
                for (String path : SummaryCellRenderer.getInterestingPaths(event)) {
                    if (++i == 2) {
                        if (path == null) continue block0;
                        path = PREFIX_PATH_FROM + path;
                    }
                    StringBuilder sb = new StringBuilder(event.getAction()).append(" ").append(path);
                    FontMetrics fm = list.getFontMetrics(list.getFont());
                    Rectangle2D rect = fm.getStringBounds(sb.toString(), g);
                    maxWidth = Math.max(maxWidth, (int)rect.getWidth() + 1);
                }
            }
        }
        return maxWidth;
    }

    public Collection<VCSHyperlinkProvider> getHyperlinkProviders() {
        if (this.hpInstances == null) {
            Lookup.Result hpResult = Lookup.getDefault().lookupResult(VCSHyperlinkProvider.class);
            this.hpInstances = hpResult.allInstances();
        }
        return this.hpInstances;
    }

    public VCSKenaiAccessor.KenaiUser getKenaiUser(String author) {
        VCSKenaiAccessor.KenaiUser kenaiUser = null;
        if (this.kenaiUsersMap != null && author != null && !author.isEmpty()) {
            kenaiUser = this.kenaiUsersMap.get(author);
        }
        return kenaiUser;
    }

    private ListCellRenderer getRenderer(Object value) {
        Reference<ListCellRenderer> ref = this.renderers.get(value);
        return ref == null ? null : ref.get();
    }

    private static String[] getInterestingPaths(AbstractSummaryView.LogEntry.Event event) {
        ArrayList<String> paths = new ArrayList<String>(2);
        String path = event.getPath();
        String original = event.getOriginalPath();
        paths.add(path);
        if (original != null && !path.equals(original)) {
            paths.add(original);
        }
        return paths.toArray(new String[paths.size()]);
    }

    static /* synthetic */ Color access$1200(Color x0, Color x1) {
        return SummaryCellRenderer.lessInteresting(x0, x1);
    }

    public class ShowLessFilesLink
    extends VCSHyperlinkSupport.Hyperlink {
        private Rectangle bounds;
        private final AbstractSummaryView.RevisionItem item;

        private ShowLessFilesLink(AbstractSummaryView.RevisionItem item) {
            this.item = item;
        }

        @Override
        public void computeBounds(JTextPane textPane) {
        }

        public void computeBounds(Component component) {
            this.bounds = component.getBounds();
        }

        @Override
        public boolean mouseMoved(Point p, JComponent component) {
            if (this.bounds != null && this.bounds.contains(p)) {
                component.setCursor(Cursor.getPredefinedCursor(12));
                component.setToolTipText(NbBundle.getMessage(SummaryCellRenderer.class, (String)"MSG_ShowLessFiles"));
                return true;
            }
            return false;
        }

        @Override
        public boolean mouseClicked(Point p) {
            if (this.bounds != null && this.bounds.contains(p)) {
                SummaryCellRenderer.this.summaryView.showRemainingFiles(this.item, false);
                return true;
            }
            return false;
        }
    }

    public class ShowRemainingFilesLink
    extends VCSHyperlinkSupport.Hyperlink {
        private Rectangle bounds;
        private final AbstractSummaryView.RevisionItem item;

        private ShowRemainingFilesLink(AbstractSummaryView.RevisionItem item) {
            this.item = item;
        }

        @Override
        public void computeBounds(JTextPane textPane) {
        }

        public void computeBounds(Component component) {
            this.bounds = component.getBounds();
        }

        @Override
        public boolean mouseMoved(Point p, JComponent component) {
            if (this.bounds != null && this.bounds.contains(p)) {
                component.setCursor(Cursor.getPredefinedCursor(12));
                int i = this.item.getNextFilesToShowCount();
                String tooltip = i > 0 ? NbBundle.getMessage(SummaryCellRenderer.class, (String)"MSG_ShowMoreFiles", (Object)i) : NbBundle.getMessage(SummaryCellRenderer.class, (String)"MSG_ShowAllFiles");
                component.setToolTipText(tooltip);
                return true;
            }
            return false;
        }

        @Override
        public boolean mouseClicked(Point p) {
            if (this.bounds != null && this.bounds.contains(p)) {
                SummaryCellRenderer.this.summaryView.showRemainingFiles(this.item, true);
                return true;
            }
            return false;
        }
    }

    public class EventActionsLink
    extends VCSHyperlinkSupport.Hyperlink {
        private Rectangle bounds;
        private final AbstractSummaryView.EventItem item;

        private EventActionsLink(AbstractSummaryView.EventItem item) {
            this.item = item;
        }

        @Override
        public void computeBounds(JTextPane textPane) {
        }

        public void computeBounds(JButton button) {
            this.bounds = button.getBounds();
        }

        @Override
        public boolean mouseMoved(Point p, JComponent component) {
            if (this.bounds != null && this.bounds.contains(p)) {
                component.setCursor(Cursor.getPredefinedCursor(12));
                component.setToolTipText(NbBundle.getMessage(SummaryCellRenderer.class, (String)"MSG_ShowActions"));
                return true;
            }
            return false;
        }

        @Override
        public boolean mouseClicked(Point p) {
            if (this.bounds != null && this.bounds.contains(p)) {
                this.item.actionsToPopup(p);
                return true;
            }
            return false;
        }
    }

    public class ExpandLink
    extends VCSHyperlinkSupport.Hyperlink {
        private Rectangle bounds;
        private final AbstractSummaryView.RevisionItem item;

        private ExpandLink(AbstractSummaryView.RevisionItem item) {
            this.item = item;
        }

        @Override
        public void computeBounds(JTextPane textPane) {
        }

        public void computeBounds(JButton button) {
            this.bounds = button.getBounds();
        }

        @Override
        public boolean mouseMoved(Point p, JComponent component) {
            if (this.bounds != null && this.bounds.contains(p)) {
                component.setCursor(Cursor.getPredefinedCursor(12));
                if (this.item.revisionExpanded) {
                    component.setToolTipText(NbBundle.getMessage(SummaryCellRenderer.class, (String)"MSG_CollapseRevision"));
                } else {
                    component.setToolTipText(NbBundle.getMessage(SummaryCellRenderer.class, (String)"MSG_ExpandRevision"));
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean mouseClicked(Point p) {
            if (this.bounds != null && this.bounds.contains(p)) {
                ((AbstractSummaryView.LogEntry)this.item.getUserData()).cancelExpand();
                this.item.setExpanded(!this.item.revisionExpanded);
                SummaryCellRenderer.this.summaryView.itemChanged(p);
                return true;
            }
            return false;
        }
    }

    private class ExpandMsgHyperlink
    extends VCSHyperlinkSupport.StyledDocumentHyperlink {
        private Rectangle bounds;
        private final int startoffset;
        private final AbstractSummaryView.RevisionItem item;
        private final String revision;

        public ExpandMsgHyperlink(AbstractSummaryView.RevisionItem item, int startoffset, String revision) {
            this.startoffset = startoffset;
            this.revision = revision;
            this.item = item;
        }

        @Override
        public boolean mouseMoved(Point p, JComponent component) {
            if (this.bounds != null && this.bounds.contains(p)) {
                component.setCursor(Cursor.getPredefinedCursor(12));
                component.setToolTipText(NbBundle.getMessage(SummaryCellRenderer.class, (String)"MSG_ExpandCommitMessage"));
                return true;
            }
            return false;
        }

        @Override
        public boolean mouseClicked(Point p) {
            if (this.bounds != null && this.bounds.contains(p)) {
                this.item.messageExpanded = true;
                SummaryCellRenderer.this.linkerSupport.remove(this, this.revision);
                SummaryCellRenderer.this.summaryView.itemChanged(p);
                return true;
            }
            return false;
        }

        @Override
        public void computeBounds(JTextPane textPane) {
            this.computeBounds(textPane, null);
        }

        public void computeBounds(JTextPane textPane, VCSHyperlinkSupport.BoundsTranslator translator) {
            Rectangle tpBounds = textPane.getBounds();
            TextUI tui = textPane.getUI();
            this.bounds = new Rectangle();
            try {
                Rectangle mtv = tui.modelToView(textPane, this.startoffset, Position.Bias.Forward);
                if (mtv == null) {
                    return;
                }
                Rectangle startr = mtv.getBounds();
                mtv = tui.modelToView(textPane, this.startoffset + LINK_STRING_LEN, Position.Bias.Backward);
                if (mtv == null) {
                    return;
                }
                Rectangle endr = mtv.getBounds();
                this.bounds = new Rectangle(tpBounds.x + startr.x, startr.y, endr.x - startr.x, startr.height);
                if (null != translator) {
                    translator.correctTranslation(textPane, this.bounds);
                }
            }
            catch (BadLocationException ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public void insertString(StyledDocument sd, Style style) throws BadLocationException {
            sd.insertString(this.startoffset, SummaryCellRenderer.LINK_STRING, style);
        }
    }

    private class ActionHyperlink
    extends VCSHyperlinkSupport.Hyperlink {
        private Map<Component, Rectangle> bounds = Collections.emptyMap();
        private Map<Component, Action> labels;

        @Override
        public void computeBounds(JTextPane textPane) {
        }

        public void computeBounds(Map<Component, Action> labels) {
            this.labels = labels;
            this.bounds = new HashMap<Component, Rectangle>(labels.size());
            for (Map.Entry<Component, Action> e : labels.entrySet()) {
                this.bounds.put(e.getKey(), e.getKey().getBounds());
            }
        }

        @Override
        public boolean mouseMoved(Point p, JComponent component) {
            for (Map.Entry<Component, Rectangle> e : this.bounds.entrySet()) {
                if (!e.getValue().contains(p)) continue;
                component.setCursor(Cursor.getPredefinedCursor(12));
                component.setToolTipText((String)this.labels.get(e.getKey()).getValue("Name"));
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean mouseClicked(Point p) {
            for (Map.Entry<Component, Rectangle> e : this.bounds.entrySet()) {
                if (!e.getValue().contains(p)) continue;
                Utils.setWaitCursor(true);
                try {
                    this.labels.get(e.getKey()).actionPerformed(new ActionEvent(this.labels.get(e.getKey()), 1001, null));
                }
                finally {
                    Utils.setWaitCursor(false);
                }
                return true;
            }
            return false;
        }
    }

    private class MoreRevisionsRenderer
    extends JPanel
    implements ListCellRenderer {
        private String id;
        private final List<JLabel> labels;
        private final Color backgroundColor;
        private final JLabel more10Label;
        private final JLabel allLabel;
        private final JLabel more100Label;
        private final JLabel more50Label;
        private final Map<Component, String> tooltips;
        private final Map<Component, Integer> moreLabelValues;

        public MoreRevisionsRenderer() {
            this.setLayout(new FlowLayout(0, 0, 3));
            this.setBorder(BorderFactory.createMatteBorder(3, 0, 0, 0, UIManager.getColor("List.background")));
            this.labels = new ArrayList<JLabel>();
            this.labels.add(new JLabel(NbBundle.getMessage(SummaryCellRenderer.class, (String)"MSG_ShowMore")));
            this.more10Label = new JLabel();
            this.labels.add(this.more10Label);
            this.labels.add(new JLabel("/"));
            this.more50Label = new JLabel();
            this.labels.add(this.more50Label);
            this.labels.add(new JLabel("/"));
            this.more100Label = new JLabel();
            this.labels.add(this.more100Label);
            this.labels.add(new JLabel("/"));
            this.allLabel = new JLabel();
            this.labels.add(this.allLabel);
            for (JLabel lbl : this.labels) {
                lbl.setBorder(BorderFactory.createEmptyBorder());
                this.add(lbl);
            }
            this.labels.get(0).setBorder(BorderFactory.createEmptyBorder(0, INDENT, 0, 0));
            this.backgroundColor = SummaryCellRenderer.darker(UIManager.getColor("List.background"));
            this.moreLabelValues = new HashMap<Component, Integer>(4);
            this.moreLabelValues.put(this.more10Label, 10);
            this.moreLabelValues.put(this.more50Label, 50);
            this.moreLabelValues.put(this.more100Label, 100);
            this.moreLabelValues.put(this.allLabel, -1);
            this.tooltips = new HashMap<Component, String>(4);
            this.tooltips.put(this.more10Label, NbBundle.getMessage(SummaryCellRenderer.class, (String)"MSG_Show10MoreRevisions"));
            this.tooltips.put(this.more50Label, NbBundle.getMessage(SummaryCellRenderer.class, (String)"MSG_Show50MoreRevisions"));
            this.tooltips.put(this.more100Label, NbBundle.getMessage(SummaryCellRenderer.class, (String)"MSG_Show100MoreRevisions"));
            this.tooltips.put(this.allLabel, NbBundle.getMessage(SummaryCellRenderer.class, (String)"MSG_ShowMoreRevisionsAll"));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.id = ((AbstractSummaryView.MoreRevisionsItem)value).getItemId();
            if (SummaryCellRenderer.this.linkerSupport.getLinker(MoreRevisionsHyperlink.class, this.id) == null) {
                SummaryCellRenderer.this.linkerSupport.add((VCSHyperlinkSupport.Hyperlink)new MoreRevisionsHyperlink(), this.id);
            }
            Component comp = SummaryCellRenderer.this.dlcr.getListCellRendererComponent((JList<?>)list, "<html><a href=\"more\">MORE</a>", index, isSelected, cellHasFocus);
            this.setLabelLinkText(this.more10Label, "10", isSelected ? comp.getForeground() : LINK_COLOR);
            this.setLabelLinkText(this.more50Label, "50", isSelected ? comp.getForeground() : LINK_COLOR);
            this.setLabelLinkText(this.more100Label, "100", isSelected ? comp.getForeground() : LINK_COLOR);
            this.setLabelLinkText(this.allLabel, NbBundle.getMessage(SummaryCellRenderer.class, (String)"MSG_AllRevisions"), isSelected ? comp.getForeground() : LINK_COLOR);
            for (JLabel lbl : this.labels) {
                lbl.setForeground(comp.getForeground());
                lbl.setBackground(isSelected ? comp.getBackground() : this.backgroundColor);
            }
            this.setBackground(isSelected ? comp.getBackground() : this.backgroundColor);
            return this;
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            MoreRevisionsHyperlink link = SummaryCellRenderer.this.linkerSupport.getLinker(MoreRevisionsHyperlink.class, this.id);
            if (link != null) {
                link.computeBounds();
            }
        }

        private JLabel setLabelLinkText(JLabel lbl, String text, Color fgColor) {
            StringBuilder sb = new StringBuilder("<html><a href=\"more\">");
            if (fgColor == null) {
                sb.append(text);
            } else {
                sb.append("<font color=\"").append(SummaryCellRenderer.getColorString(fgColor)).append("\">").append(text).append("</font>");
            }
            sb.append("</a></html>");
            lbl.setText(sb.toString());
            return lbl;
        }

        private class MoreRevisionsHyperlink
        extends VCSHyperlinkSupport.Hyperlink {
            private Map<Component, Rectangle> bounds = Collections.emptyMap();

            private MoreRevisionsHyperlink() {
            }

            @Override
            public void computeBounds(JTextPane textPane) {
            }

            public void computeBounds() {
                this.bounds = new HashMap<Component, Rectangle>(MoreRevisionsRenderer.this.labels.size());
                for (JLabel lbl : new JLabel[]{MoreRevisionsRenderer.this.more10Label, MoreRevisionsRenderer.this.more50Label, MoreRevisionsRenderer.this.more100Label, MoreRevisionsRenderer.this.allLabel}) {
                    this.bounds.put(lbl, lbl.getBounds());
                }
            }

            @Override
            public boolean mouseMoved(Point p, JComponent component) {
                for (Map.Entry<Component, Rectangle> e : this.bounds.entrySet()) {
                    if (!e.getValue().contains(p)) continue;
                    component.setCursor(Cursor.getPredefinedCursor(12));
                    component.setToolTipText((String)MoreRevisionsRenderer.this.tooltips.get(e.getKey()));
                    return true;
                }
                return false;
            }

            @Override
            public boolean mouseClicked(Point p) {
                for (Map.Entry<Component, Rectangle> e : this.bounds.entrySet()) {
                    if (!e.getValue().contains(p)) continue;
                    SummaryCellRenderer.this.summaryView.moreRevisions((Integer)MoreRevisionsRenderer.this.moreLabelValues.get(e.getKey()));
                    return true;
                }
                return false;
            }
        }
    }

    private class ActionRenderer
    extends JPanel
    implements ListCellRenderer {
        private String id;
        private Map<Component, Action> labels;
        private final Map<String, JLabel> ACTION_LABELS = new HashMap<String, JLabel>();

        public ActionRenderer() {
            this.setLayout(new FlowLayout(0, 5, 0));
            this.setBorder(BorderFactory.createEmptyBorder(3, INDENT - 5, 5, 0));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Action[] actions = ((AbstractSummaryView.LogEntry)((AbstractSummaryView.ActionsItem)value).getParent().getUserData()).getActions();
            this.id = ((AbstractSummaryView.ActionsItem)value).getItemId();
            this.removeAll();
            this.labels = new HashMap<Component, Action>(actions.length);
            Component comp = SummaryCellRenderer.this.dlcr.getListCellRendererComponent((JList<?>)list, "<html><a href=\"action\">ACTION_NAME</a>", index, isSelected, cellHasFocus);
            this.setBackground(comp.getBackground());
            for (Action a : actions) {
                JLabel label = this.getLabelFor((String)a.getValue("Name"), isSelected ? comp.getForeground() : LINK_COLOR);
                label.setForeground(comp.getForeground());
                label.setBackground(comp.getBackground());
                label.setBorder(BorderFactory.createEmptyBorder());
                this.labels.put(label, a);
                this.add(label);
            }
            if (SummaryCellRenderer.this.linkerSupport.getLinker(ActionHyperlink.class, this.id) == null) {
                SummaryCellRenderer.this.linkerSupport.add((VCSHyperlinkSupport.Hyperlink)new ActionHyperlink(), this.id);
            }
            return this;
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            ActionHyperlink link = SummaryCellRenderer.this.linkerSupport.getLinker(ActionHyperlink.class, this.id);
            if (link != null) {
                link.computeBounds(this.labels);
            }
        }

        private JLabel getLabelFor(String actionName, Color fontColor) {
            JLabel lbl = this.ACTION_LABELS.get(actionName);
            if (lbl == null) {
                lbl = new JLabel();
                this.ACTION_LABELS.put(actionName, lbl);
            }
            StringBuilder sb = new StringBuilder("<html><a href=\"action\">");
            if (fontColor == null) {
                sb.append(actionName);
            } else {
                sb.append("<font color=\"").append(SummaryCellRenderer.getColorString(fontColor)).append("\">").append(actionName).append("</font>");
            }
            sb.append("</a></html>");
            lbl.setText(sb.toString());
            return lbl;
        }
    }

    private class LessFilesRenderer
    extends JPanel
    implements ListCellRenderer {
        private String id;
        private Component comp;

        public LessFilesRenderer() {
            this.setLayout(new BoxLayout(this, 0));
            this.setBorder(BorderFactory.createEmptyBorder(0, INDENT, 3, 0));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            AbstractSummaryView.ShowLessEventsItem item = (AbstractSummaryView.ShowLessEventsItem)value;
            this.id = item.getItemId();
            if (SummaryCellRenderer.this.linkerSupport.getLinker(ShowLessFilesLink.class, this.id) == null) {
                SummaryCellRenderer.this.linkerSupport.add((VCSHyperlinkSupport.Hyperlink)new ShowLessFilesLink(item.getParent()), this.id);
            }
            StringBuilder sb = new StringBuilder("<html><a href=\"expand\">");
            String label = NbBundle.getMessage(SummaryCellRenderer.class, (String)"MSG_ShowLessFiles");
            if (isSelected) {
                Component c = SummaryCellRenderer.this.dlcr.getListCellRendererComponent((JList<?>)list, "<html><a href=\"expand\">ACTION_NAME</a>", index, isSelected, cellHasFocus);
                sb.append("<font color=\"").append(SummaryCellRenderer.getColorString(c.getForeground())).append("\">").append(label).append("</font>");
            } else if (LINK_COLOR != null) {
                sb.append("<font color=\"").append(SummaryCellRenderer.getColorString(LINK_COLOR)).append("\">").append(label).append("</font>");
            } else {
                sb.append(label);
            }
            sb.append("</a></html>");
            this.comp = SummaryCellRenderer.this.dlcr.getListCellRendererComponent((JList<?>)list, sb.toString(), index, isSelected, cellHasFocus);
            this.removeAll();
            this.add(this.comp);
            this.comp.setMaximumSize(this.comp.getPreferredSize());
            this.setBackground(this.comp.getBackground());
            return this;
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            ShowLessFilesLink link = SummaryCellRenderer.this.linkerSupport.getLinker(ShowLessFilesLink.class, this.id);
            if (link != null) {
                link.computeBounds(this.comp);
            }
        }
    }

    private class RemainingFilesRenderer
    extends JPanel
    implements ListCellRenderer {
        private String id;
        private Component comp;

        public RemainingFilesRenderer() {
            this.setLayout(new BoxLayout(this, 0));
            this.setBorder(BorderFactory.createEmptyBorder(0, INDENT, 3, 0));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            AbstractSummaryView.ShowAllEventsItem item = (AbstractSummaryView.ShowAllEventsItem)value;
            this.id = item.getItemId();
            if (SummaryCellRenderer.this.linkerSupport.getLinker(ShowRemainingFilesLink.class, this.id) == null) {
                SummaryCellRenderer.this.linkerSupport.add((VCSHyperlinkSupport.Hyperlink)new ShowRemainingFilesLink(item.getParent()), this.id);
            }
            StringBuilder sb = new StringBuilder("<html><a href=\"expand\">");
            int i = item.getParent().getNextFilesToShowCount();
            String label = i > 0 ? NbBundle.getMessage(SummaryCellRenderer.class, (String)"MSG_ShowMoreFiles", (Object)i) : NbBundle.getMessage(SummaryCellRenderer.class, (String)"MSG_ShowAllFiles");
            if (isSelected) {
                Component c = SummaryCellRenderer.this.dlcr.getListCellRendererComponent((JList<?>)list, "<html><a href=\"expand\">ACTION_NAME</a>", index, isSelected, cellHasFocus);
                sb.append("<font color=\"").append(SummaryCellRenderer.getColorString(c.getForeground())).append("\">").append(label).append("</font>");
            } else if (LINK_COLOR != null) {
                sb.append("<font color=\"").append(SummaryCellRenderer.getColorString(LINK_COLOR)).append("\">").append(label).append("</font>");
            } else {
                sb.append(label);
            }
            sb.append("</a></html>");
            this.comp = SummaryCellRenderer.this.dlcr.getListCellRendererComponent((JList<?>)list, sb.toString(), index, isSelected, cellHasFocus);
            this.removeAll();
            this.add(this.comp);
            this.comp.setMaximumSize(this.comp.getPreferredSize());
            this.setBackground(this.comp.getBackground());
            return this;
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            ShowRemainingFilesLink link = SummaryCellRenderer.this.linkerSupport.getLinker(ShowRemainingFilesLink.class, this.id);
            if (link != null) {
                link.computeBounds(this.comp);
            }
        }
    }

    private class EventRenderer
    extends JPanel
    implements ListCellRenderer {
        private boolean lastSelection = false;
        private final JLabel pathLabel;
        private final JLabel actionLabel;
        private final JButton actionButton;
        private String id;
        private final String PATH_COLOR = SummaryCellRenderer.access$1300(SummaryCellRenderer.access$1200(UIManager.getColor("List.foreground"), UIManager.getColor("List.background")));

        public EventRenderer() {
            this.pathLabel = new JLabel();
            this.actionLabel = new JLabel();
            this.actionButton = new LinkButton("...");
            this.actionButton.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            FlowLayout l = new FlowLayout(0, 0, 0);
            l.setAlignOnBaseline(true);
            this.setLayout(l);
            this.add(this.actionLabel);
            this.actionLabel.setBorder(BorderFactory.createEmptyBorder(0, INDENT, 0, 10));
            this.add(this.pathLabel);
            this.add(this.actionButton);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean hasFocus) {
            AbstractSummaryView.EventItem item = (AbstractSummaryView.EventItem)value;
            if (this.pathLabel.getText().isEmpty() || this.lastSelection != selected) {
                Color backgroundColor;
                Color foregroundColor;
                this.lastSelection = selected;
                if (selected) {
                    foregroundColor = SummaryCellRenderer.this.selectionForeground;
                    backgroundColor = SummaryCellRenderer.this.selectionBackground;
                } else {
                    foregroundColor = UIManager.getColor("List.foreground");
                    backgroundColor = UIManager.getColor("List.background");
                }
                this.id = item.getItemId();
                if (SummaryCellRenderer.this.linkerSupport.getLinker(ExpandLink.class, this.id) == null) {
                    SummaryCellRenderer.this.linkerSupport.add((VCSHyperlinkSupport.Hyperlink)new EventActionsLink(item), this.id);
                }
                this.pathLabel.setFont(list.getFont());
                this.pathLabel.setForeground(foregroundColor);
                this.pathLabel.setBackground(backgroundColor);
                this.actionLabel.setBackground(backgroundColor);
                this.setBackground(backgroundColor);
                StringBuilder sb = new StringBuilder("<html><body>");
                sb.append("<b>");
                String action = ((AbstractSummaryView.LogEntry.Event)item.getUserData()).getAction();
                String color = SummaryCellRenderer.this.summaryView.getActionColors().get(action);
                if (color != null && !selected) {
                    sb.append("<font color=\"").append(color).append("\">").append(action).append("</font>");
                } else {
                    this.actionLabel.setForeground(foregroundColor);
                    sb.append(action);
                }
                sb.append("</b></body></html>");
                this.actionLabel.setText(sb.toString());
                sb = new StringBuilder("<html><body>");
                int i = 0;
                for (String path : SummaryCellRenderer.getInterestingPaths((AbstractSummaryView.LogEntry.Event)item.getUserData())) {
                    if (++i == 2 && path == null) continue;
                    int idx = path.lastIndexOf("/");
                    if (i == 2) {
                        sb.append("<br>").append(PREFIX_PATH_FROM);
                    }
                    if (idx < 0 || selected) {
                        sb.append(path);
                        continue;
                    }
                    sb.append("<font color=\"").append(this.PATH_COLOR).append("\">").append(path.substring(0, ++idx)).append("</font>");
                    sb.append(path.substring(idx, path.length()));
                }
                this.pathLabel.setText(sb.append("</body></html>").toString());
                int width = SummaryCellRenderer.this.getMaxPathWidth(list, item.getParent(), this.pathLabel.getGraphics());
                if (width > -1) {
                    width = width + 15 + INDENT - this.actionLabel.getPreferredSize().width;
                    this.pathLabel.setPreferredSize(new Dimension(width, this.pathLabel.getPreferredSize().height));
                }
            }
            return this;
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            EventActionsLink link = SummaryCellRenderer.this.linkerSupport.getLinker(EventActionsLink.class, this.id);
            if (link != null) {
                link.computeBounds(this.actionButton);
            }
        }
    }

    private static class MessageTooltip
    extends VCSHyperlinkSupport.Hyperlink {
        private Rectangle[] bounds;
        private final int start;
        private final int end;
        private final String text;

        private MessageTooltip(String text, int start, int end) {
            this.start = start;
            this.end = end;
            this.text = this.prepareText(text);
        }

        @Override
        public boolean mouseMoved(Point p, JComponent component) {
            if (this.bounds != null && component.getToolTipText() == null) {
                for (Rectangle b : this.bounds) {
                    if (!b.contains(p)) continue;
                    component.setToolTipText(this.text);
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean mouseClicked(Point p) {
            return false;
        }

        @Override
        public void computeBounds(JTextPane textPane) {
            this.computeBounds(textPane, null);
        }

        public void computeBounds(JTextPane textPane, VCSHyperlinkSupport.BoundsTranslator translator) {
            Rectangle tpBounds = textPane.getBounds();
            TextUI tui = textPane.getUI();
            try {
                int lastY = -1;
                Rectangle rec = null;
                LinkedList<Rectangle> rects = new LinkedList<Rectangle>();
                for (int pos = this.start; pos <= this.end; ++pos) {
                    Rectangle startr = tui.modelToView(textPane, pos, Position.Bias.Forward);
                    Rectangle endr = tui.modelToView(textPane, pos + 1, Position.Bias.Backward);
                    if (null == startr || null == endr) continue;
                    if (startr.y > lastY) {
                        rects.add(rec);
                        rec = new Rectangle(tpBounds.x + startr.x, startr.y, endr.x - startr.x, startr.height);
                        lastY = rec.y;
                        continue;
                    }
                    rec.setSize(rec.width + endr.x - startr.x, rec.height);
                }
                if (null != translator) {
                    translator.correctTranslation(textPane, rec);
                }
                rects.add(rec);
                rects.remove(0);
                this.bounds = rects.toArray(new Rectangle[rects.size()]);
            }
            catch (BadLocationException ex) {
                this.bounds = null;
            }
        }

        private String prepareText(String text) {
            return "<html><body>" + text.replace("\n", "<br>") + "</body></html>";
        }
    }

    private class RevisionRenderer
    extends JPanel
    implements ListCellRenderer {
        private String id;
        private boolean lastSelection = false;
        private final RevisionItemCell revisionCell = new RevisionItemCell();
        private final JButton expandButton;
        private boolean lastMessageExpanded;
        private boolean lastRevisionExpanded;
        private int lastWidth;
        private Collection<AbstractSummaryView.SummaryViewMaster.SearchHighlight> lastHighlights;

        public RevisionRenderer() {
            SummaryCellRenderer.this.selectionForeground = new JList().getSelectionForeground();
            this.expandButton = new LinkButton(ICON_COLLAPSED);
            this.expandButton.setBorder(BorderFactory.createEmptyBorder());
            this.setBorder(BorderFactory.createMatteBorder(3, 0, 0, 0, UIManager.getColor("List.background")));
            this.setLayout(new BorderLayout(3, 0));
            this.expandButton.setMaximumSize(this.expandButton.getPreferredSize());
            this.expandButton.setMinimumSize(this.expandButton.getPreferredSize());
            this.add((Component)this.expandButton, "West");
            this.add((Component)this.revisionCell, "Center");
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean hasFocus) {
            AbstractSummaryView.RevisionItem item = (AbstractSummaryView.RevisionItem)value;
            AbstractSummaryView.LogEntry entry = (AbstractSummaryView.LogEntry)item.getUserData();
            Collection<AbstractSummaryView.SummaryViewMaster.SearchHighlight> highlights = SummaryCellRenderer.this.summaryView.getMaster().getSearchHighlights();
            if (this.revisionCell.getRevisionControl().getStyledDocument().getLength() == 0 || this.revisionCell.getDateControl().getStyledDocument().getLength() == 0 || this.revisionCell.getAuthorControl().getStyledDocument().getLength() == 0 || this.revisionCell.getCommitMessageControl().getStyledDocument().getLength() == 0 || selected != this.lastSelection || item.messageExpanded != this.lastMessageExpanded || item.revisionExpanded != this.lastRevisionExpanded || !highlights.equals(this.lastHighlights)) {
                Color backgroundColor;
                this.lastSelection = selected;
                this.lastMessageExpanded = item.messageExpanded;
                this.lastRevisionExpanded = item.revisionExpanded;
                this.lastHighlights = highlights;
                if (selected) {
                    backgroundColor = SummaryCellRenderer.this.selectionBackground;
                } else {
                    backgroundColor = UIManager.getColor("List.background");
                    backgroundColor = entry.isLessInteresting() ? SummaryCellRenderer.darkerUninteresting(backgroundColor) : SummaryCellRenderer.darker(backgroundColor);
                }
                this.setBackground(backgroundColor);
                this.revisionCell.setBackground(backgroundColor);
                if (item.revisionExpanded) {
                    this.expandButton.setIcon(ICON_EXPANDED);
                } else {
                    this.expandButton.setIcon(ICON_COLLAPSED);
                }
                this.id = item.getItemId();
                if (SummaryCellRenderer.this.linkerSupport.getLinker(ExpandLink.class, this.id) == null) {
                    SummaryCellRenderer.this.linkerSupport.add((VCSHyperlinkSupport.Hyperlink)new ExpandLink(item), this.id);
                }
                try {
                    this.addRevision(this.revisionCell.getRevisionControl(), item, selected, highlights);
                    this.addCommitMessage(this.revisionCell.getCommitMessageControl(), item, selected, highlights);
                    this.addAuthor(this.revisionCell.getAuthorControl(), item, selected, highlights);
                    this.addDate(this.revisionCell.getDateControl(), item, selected, highlights);
                }
                catch (BadLocationException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
            }
            this.lastWidth = this.resizePane(this.revisionCell.getCommitMessageControl().getText(), list, this.lastWidth);
            return this;
        }

        private int resizePane(String text, JList list, int lastWidth) {
            int width;
            if (text == null) {
                text = "";
            }
            if ((width = SummaryCellRenderer.this.summaryView.getMaster().getComponent().getWidth()) > 0 && width != lastWidth) {
                String[] rows = text.split("\n");
                FontMetrics fm = list.getFontMetrics(list.getFont());
                int lines = 0;
                for (String row : rows) {
                    Rectangle2D rect = fm.getStringBounds(row, this.revisionCell.getGraphics());
                    lines += (int)(rect.getWidth() / (double)(width - 80) + 1.0);
                }
                int ph = fm.getHeight() * (lines + 1) + 4;
                this.revisionCell.setPreferredSize(new Dimension(width - 50 - ICON_COLLAPSED.getIconWidth(), ph));
                this.setPreferredSize(this.revisionCell.getPreferredSize());
            }
            return width;
        }

        private void addRevision(JTextPane pane, AbstractSummaryView.RevisionItem item, boolean selected, Collection<AbstractSummaryView.SummaryViewMaster.SearchHighlight> highlights) throws BadLocationException {
            StyledDocument sd = pane.getStyledDocument();
            this.clearSD(pane, sd);
            Style selectedStyle = this.createSelectedStyle(pane);
            Style normalStyle = this.createNormalStyle(pane);
            Style hiliteStyle = this.createHiliteStyleStyle(pane, normalStyle, SummaryCellRenderer.this.searchHiliteAttrs);
            Style style = selected ? selectedStyle : normalStyle;
            sd.insertString(0, ((AbstractSummaryView.LogEntry)item.getUserData()).getRevision(), style);
            if (!selected) {
                for (AbstractSummaryView.LogEntry.RevisionHighlight revisionHighlight : ((AbstractSummaryView.LogEntry)item.getUserData()).getRevisionHighlights()) {
                    Style s = pane.addStyle(null, normalStyle);
                    StyleConstants.setForeground(s, revisionHighlight.getForeground());
                    StyleConstants.setBackground(s, revisionHighlight.getBackground());
                    sd.setCharacterAttributes(revisionHighlight.getStart(), revisionHighlight.getLength(), s, false);
                }
                for (AbstractSummaryView.SummaryViewMaster.SearchHighlight searchHighlight : highlights) {
                    if (searchHighlight.getKind() != AbstractSummaryView.SummaryViewMaster.SearchHighlight.Kind.REVISION) continue;
                    int doclen = sd.getLength();
                    String highlightMessage = searchHighlight.getSearchText();
                    String revisionText = ((AbstractSummaryView.LogEntry)item.getUserData()).getRevision().toLowerCase();
                    int idx = revisionText.indexOf(highlightMessage);
                    if (idx <= -1) continue;
                    sd.setCharacterAttributes(doclen - revisionText.length() + idx, highlightMessage.length(), hiliteStyle, false);
                }
            }
        }

        private void addAuthor(JTextPane pane, AbstractSummaryView.RevisionItem item, boolean selected, Collection<AbstractSummaryView.SummaryViewMaster.SearchHighlight> highlights) throws BadLocationException {
            VCSKenaiAccessor.KenaiUser kenaiUser;
            AbstractSummaryView.LogEntry entry = (AbstractSummaryView.LogEntry)item.getUserData();
            StyledDocument sd = pane.getStyledDocument();
            this.clearSD(pane, sd);
            Style selectedStyle = this.createSelectedStyle(pane);
            Style normalStyle = this.createNormalStyle(pane);
            Style style = selected ? selectedStyle : normalStyle;
            Style authorStyle = this.createAuthorStyle(pane, normalStyle);
            Style hiliteStyle = this.createHiliteStyleStyle(pane, normalStyle, SummaryCellRenderer.this.searchHiliteAttrs);
            String author = entry.getAuthor();
            VCSHyperlinkSupport.AuthorLinker l = SummaryCellRenderer.this.linkerSupport.getLinker(VCSHyperlinkSupport.AuthorLinker.class, this.id);
            if (l == null && (kenaiUser = SummaryCellRenderer.this.getKenaiUser(author)) != null) {
                l = new VCSHyperlinkSupport.AuthorLinker(kenaiUser, authorStyle, sd, author);
                SummaryCellRenderer.this.linkerSupport.add((VCSHyperlinkSupport.Hyperlink)l, this.id);
            }
            int pos = sd.getLength();
            if (l != null) {
                l.insertString(sd, selected ? style : null);
            } else {
                sd.insertString(sd.getLength(), author, style);
            }
            if (!selected) {
                for (AbstractSummaryView.SummaryViewMaster.SearchHighlight highlight : highlights) {
                    if (highlight.getKind() != AbstractSummaryView.SummaryViewMaster.SearchHighlight.Kind.AUTHOR) continue;
                    int doclen = sd.getLength();
                    String highlightMessage = highlight.getSearchText();
                    String authorText = sd.getText(pos, doclen - pos).toLowerCase();
                    int idx = authorText.indexOf(highlightMessage);
                    if (idx <= -1) continue;
                    sd.setCharacterAttributes(doclen - authorText.length() + idx, highlightMessage.length(), hiliteStyle, false);
                }
            }
        }

        private void addDate(JTextPane pane, AbstractSummaryView.RevisionItem item, boolean selected, Collection<AbstractSummaryView.SummaryViewMaster.SearchHighlight> highlights) throws BadLocationException {
            AbstractSummaryView.LogEntry entry = (AbstractSummaryView.LogEntry)item.getUserData();
            StyledDocument sd = pane.getStyledDocument();
            this.clearSD(pane, sd);
            Style selectedStyle = this.createSelectedStyle(pane);
            Style normalStyle = this.createNormalStyle(pane);
            Style style = selected ? selectedStyle : normalStyle;
            sd.insertString(sd.getLength(), entry.getDate(), style);
        }

        private void addCommitMessage(JTextPane pane, AbstractSummaryView.RevisionItem item, boolean selected, Collection<AbstractSummaryView.SummaryViewMaster.SearchHighlight> highlights) throws BadLocationException {
            AbstractSummaryView.LogEntry entry = (AbstractSummaryView.LogEntry)item.getUserData();
            StyledDocument sd = pane.getStyledDocument();
            this.clearSD(pane, sd);
            Style selectedStyle = this.createSelectedStyle(pane);
            Style normalStyle = this.createNormalStyle(pane);
            Style linkStyle = this.createLinkStyle(pane, normalStyle);
            Style hiliteStyle = this.createHiliteStyleStyle(pane, normalStyle, SummaryCellRenderer.this.searchHiliteAttrs);
            Style issueHyperlinkStyle = this.createIssueHyperlinkStyle(pane, normalStyle);
            Style style = selected ? selectedStyle : normalStyle;
            boolean messageChanged = !entry.getMessage().isEmpty();
            String commitMessage = entry.getMessage().trim();
            int i = 0;
            int nlc = -1;
            while (i != -1) {
                i = commitMessage.indexOf(10, i + 1);
                ++nlc;
            }
            if (nlc > 0 && !item.messageExpanded) {
                commitMessage = commitMessage.substring(0, commitMessage.indexOf("\n"));
            }
            VCSHyperlinkSupport.IssueLinker l = SummaryCellRenderer.this.linkerSupport.getLinker(VCSHyperlinkSupport.IssueLinker.class, this.id);
            if (messageChanged) {
                this.lastWidth = -1;
                if (l != null) {
                    SummaryCellRenderer.this.linkerSupport.remove(l, this.id);
                    l = null;
                }
            }
            if (l == null) {
                for (VCSHyperlinkProvider hp : SummaryCellRenderer.this.getHyperlinkProviders()) {
                    l = VCSHyperlinkSupport.IssueLinker.create(hp, issueHyperlinkStyle, SummaryCellRenderer.this.summaryView.getRoot(), sd, commitMessage);
                    if (l == null) continue;
                    SummaryCellRenderer.this.linkerSupport.add((VCSHyperlinkSupport.Hyperlink)l, this.id);
                    break;
                }
            }
            if (l != null) {
                l.insertString(sd, style);
            } else {
                sd.insertString(0, commitMessage, style);
            }
            int lineEnd = sd.getText(0, sd.getLength()).indexOf("\n");
            if (lineEnd == -1) {
                lineEnd = sd.getLength();
            }
            Style s = pane.addStyle(null, style);
            StyleConstants.setBold(s, true);
            sd.setCharacterAttributes(0, lineEnd, s, false);
            int msglen = commitMessage.length();
            int doclen = sd.getLength();
            if (nlc > 0 && !item.messageExpanded) {
                ExpandMsgHyperlink el = SummaryCellRenderer.this.linkerSupport.getLinker(ExpandMsgHyperlink.class, this.id);
                if (el == null) {
                    el = new ExpandMsgHyperlink(item, sd.getLength(), this.id);
                    SummaryCellRenderer.this.linkerSupport.add((VCSHyperlinkSupport.Hyperlink)el, this.id);
                }
                el.insertString(sd, linkStyle);
            }
            MessageTooltip mtt = SummaryCellRenderer.this.linkerSupport.getLinker(MessageTooltip.class, this.id);
            SummaryCellRenderer.this.linkerSupport.remove(mtt, this.id);
            MessageTooltip messageTooltip = new MessageTooltip(entry.getMessage(), 0, sd.getLength());
            SummaryCellRenderer.this.linkerSupport.add((VCSHyperlinkSupport.Hyperlink)messageTooltip, this.id);
            if (!selected) {
                for (AbstractSummaryView.SummaryViewMaster.SearchHighlight highlight : highlights) {
                    if (highlight.getKind() != AbstractSummaryView.SummaryViewMaster.SearchHighlight.Kind.MESSAGE) continue;
                    String highlightMessage = highlight.getSearchText();
                    int idx = commitMessage.toLowerCase().indexOf(highlightMessage);
                    if (idx == -1) {
                        if (nlc <= 0 || item.messageExpanded || !entry.getMessage().toLowerCase().contains(highlightMessage)) continue;
                        sd.setCharacterAttributes(doclen, sd.getLength(), hiliteStyle, false);
                        continue;
                    }
                    sd.setCharacterAttributes(doclen - msglen + idx, highlightMessage.length(), hiliteStyle, false);
                }
            }
            if (selected) {
                sd.setCharacterAttributes(0, Integer.MAX_VALUE, style, false);
            }
        }

        private Style createNormalStyle(JTextPane textPane) {
            Style normalStyle = textPane.addStyle("normal", null);
            StyleConstants.setForeground(normalStyle, UIManager.getColor("List.foreground"));
            return normalStyle;
        }

        private Style createIssueHyperlinkStyle(JTextPane textPane, Style normalStyle) {
            Style issueHyperlinkStyle = textPane.addStyle("issuehyperlink", normalStyle);
            StyleConstants.setForeground(issueHyperlinkStyle, LINK_COLOR == null ? Color.BLUE : LINK_COLOR);
            StyleConstants.setUnderline(issueHyperlinkStyle, true);
            return issueHyperlinkStyle;
        }

        private Style createAuthorStyle(JTextPane textPane, Style normalStyle) {
            Style authorStyle = textPane.addStyle("author", normalStyle);
            StyleConstants.setForeground(authorStyle, LINK_COLOR == null ? Color.BLUE : LINK_COLOR);
            return authorStyle;
        }

        private Style createLinkStyle(JTextPane textPane, Style normalStyle) {
            Style linkStyle = textPane.addStyle("link", normalStyle);
            StyleConstants.setForeground(linkStyle, LINK_COLOR == null ? Color.BLUE : LINK_COLOR);
            StyleConstants.setBold(linkStyle, true);
            return linkStyle;
        }

        private Style createNoindentStyle(JTextPane textPane) {
            Style noindentStyle = textPane.addStyle("noindent", null);
            StyleConstants.setLeftIndent(noindentStyle, 0.0f);
            return noindentStyle;
        }

        private Style createSelectedStyle(JTextPane textPane) {
            Style selectedStyle = textPane.addStyle("selected", null);
            StyleConstants.setForeground(selectedStyle, SummaryCellRenderer.this.selectionForeground);
            StyleConstants.setBackground(selectedStyle, SummaryCellRenderer.this.selectionBackground);
            return selectedStyle;
        }

        private Style createHiliteStyleStyle(JTextPane textPane, Style normalStyle, AttributeSet searchHiliteAttrs) {
            Style hiliteStyle = textPane.addStyle("hilite", normalStyle);
            Color c = (Color)searchHiliteAttrs.getAttribute(StyleConstants.Background);
            if (c != null) {
                StyleConstants.setBackground(hiliteStyle, c);
            }
            if ((c = (Color)searchHiliteAttrs.getAttribute(StyleConstants.Foreground)) != null) {
                StyleConstants.setForeground(hiliteStyle, c);
            }
            return hiliteStyle;
        }

        @Override
        public void paint(Graphics g) {
            ExpandLink link;
            MessageTooltip tt;
            ExpandMsgHyperlink expandMsg;
            VCSHyperlinkSupport.IssueLinker issue;
            super.paint(g);
            VCSHyperlinkSupport.AuthorLinker author = SummaryCellRenderer.this.linkerSupport.getLinker(VCSHyperlinkSupport.AuthorLinker.class, this.id);
            if (author != null) {
                author.computeBounds(this.revisionCell.getAuthorControl(), this.revisionCell);
            }
            if ((issue = SummaryCellRenderer.this.linkerSupport.getLinker(VCSHyperlinkSupport.IssueLinker.class, this.id)) != null) {
                issue.computeBounds(this.revisionCell.getCommitMessageControl(), this.revisionCell);
            }
            if ((expandMsg = SummaryCellRenderer.this.linkerSupport.getLinker(ExpandMsgHyperlink.class, this.id)) != null) {
                expandMsg.computeBounds(this.revisionCell.getCommitMessageControl(), this.revisionCell);
            }
            if ((tt = SummaryCellRenderer.this.linkerSupport.getLinker(MessageTooltip.class, this.id)) != null) {
                tt.computeBounds(this.revisionCell.getCommitMessageControl(), this.revisionCell);
            }
            if ((link = SummaryCellRenderer.this.linkerSupport.getLinker(ExpandLink.class, this.id)) != null) {
                link.computeBounds(this.expandButton);
            }
        }

        private void clearSD(JTextPane pane, StyledDocument sd) {
            try {
                Style noindentStyle = this.createNoindentStyle(pane);
                sd.remove(0, sd.getLength());
                sd.setParagraphAttributes(0, sd.getLength(), noindentStyle, false);
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

