/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openfile;

import java.awt.FileDialog;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import org.netbeans.modules.openfile.OpenFile;
import org.netbeans.modules.openfile.OpenFileDialogFilter;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.UserCancelException;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class OpenFileAction
implements ActionListener {
    private static File currentDirectory = null;
    private static String currentFileFilter = null;
    private static boolean running;

    private HelpCtx getHelpCtx() {
        return new HelpCtx(OpenFileAction.class);
    }

    protected JFileChooser prepareFileChooser() {
        FileChooserBuilder fcb = new FileChooserBuilder(OpenFileAction.class);
        fcb.setSelectionApprover((FileChooserBuilder.SelectionApprover)new OpenFileSelectionApprover());
        fcb.setFilesOnly(true);
        fcb.addDefaultFileFilters();
        for (OpenFileDialogFilter filter : Lookup.getDefault().lookupAll(OpenFileDialogFilter.class)) {
            fcb.addFileFilter((FileFilter)filter);
        }
        JFileChooser chooser = fcb.createFileChooser();
        chooser.setMultiSelectionEnabled(true);
        chooser.getCurrentDirectory().listFiles();
        chooser.setCurrentDirectory(OpenFileAction.getCurrentDirectory());
        if (currentFileFilter != null) {
            for (FileFilter ff : chooser.getChoosableFileFilters()) {
                if (!currentFileFilter.equals(ff.getDescription())) continue;
                chooser.setFileFilter(ff);
                break;
            }
        }
        HelpCtx.setHelpIDString((JComponent)chooser, (String)this.getHelpCtx().getHelpID());
        return chooser;
    }

    public static File[] chooseFilesToOpen(JFileChooser chooser) throws UserCancelException {
        File[] files;
        do {
            int selectedOption;
            if ((selectedOption = chooser.showOpenDialog(WindowManager.getDefault().getMainWindow())) == 0) continue;
            throw new UserCancelException();
        } while ((files = chooser.getSelectedFiles()).length == 0);
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        if (running) {
            return;
        }
        try {
            File[] files;
            running = true;
            JFileChooser chooser = this.prepareFileChooser();
            try {
                if (Boolean.getBoolean("nb.native.filechooser")) {
                    String oldFileDialogProp = System.getProperty("apple.awt.fileDialogForDirectories");
                    System.setProperty("apple.awt.fileDialogForDirectories", "false");
                    FileDialog fileDialog = new FileDialog(WindowManager.getDefault().getMainWindow());
                    fileDialog.setMode(0);
                    fileDialog.setDirectory(OpenFileAction.getCurrentDirectory().getAbsolutePath());
                    fileDialog.setTitle(chooser.getDialogTitle());
                    fileDialog.setVisible(true);
                    if (null != oldFileDialogProp) {
                        System.setProperty("apple.awt.fileDialogForDirectories", oldFileDialogProp);
                    } else {
                        System.clearProperty("apple.awt.fileDialogForDirectories");
                    }
                    if (fileDialog.getDirectory() == null || fileDialog.getFile() == null) throw new UserCancelException();
                    String selFile = fileDialog.getFile();
                    File dir = new File(fileDialog.getDirectory());
                    files = new File[]{new File(dir, selFile)};
                    currentDirectory = dir;
                } else {
                    files = OpenFileAction.chooseFilesToOpen(chooser);
                    currentDirectory = chooser.getCurrentDirectory();
                    if (chooser.getFileFilter() != null) {
                        currentFileFilter = chooser.getFileFilter().getDescription();
                    }
                }
            }
            catch (UserCancelException ex) {
                running = false;
                return;
            }
            for (int i = 0; i < files.length; ++i) {
                OpenFile.openFile(files[i], -1);
            }
            return;
        }
        finally {
            running = false;
        }
    }

    private static File getCurrentDirectory() {
        File f;
        DataObject d;
        TopComponent activated;
        if (Boolean.getBoolean("netbeans.openfile.197063") && (activated = TopComponent.getRegistry().getActivated()) != null && WindowManager.getDefault().isOpenedEditorTopComponent(activated) && (d = (DataObject)activated.getLookup().lookup(DataObject.class)) != null && (f = FileUtil.toFile((FileObject)d.getPrimaryFile())) != null) {
            return f.getParentFile();
        }
        if (currentDirectory != null && currentDirectory.exists()) {
            return currentDirectory;
        }
        currentDirectory = FileSystemView.getFileSystemView().getDefaultDirectory();
        return currentDirectory;
    }

    private static class OpenFileSelectionApprover
    implements FileChooserBuilder.SelectionApprover {
        private OpenFileSelectionApprover() {
        }

        public boolean approve(File[] selectedFiles) {
            ArrayList<String> errorMsgs = null;
            for (int i = 0; i < selectedFiles.length; ++i) {
                String msgPatternRef = null;
                File file = selectedFiles[i];
                if (!file.exists()) {
                    msgPatternRef = "MSG_FileDoesNotExist";
                } else if (file.isDirectory()) {
                    msgPatternRef = "MSG_FileIsADirectory";
                } else if (!file.isFile()) {
                    msgPatternRef = "MSG_FileIsNotPlainFile";
                }
                if (msgPatternRef == null) continue;
                if (errorMsgs == null) {
                    errorMsgs = new ArrayList<String>(selectedFiles.length - i);
                }
                errorMsgs.add(NbBundle.getMessage(OpenFileAction.class, (String)msgPatternRef, (Object)file.getName()));
            }
            if (errorMsgs == null) {
                return true;
            }
            JPanel panel = new JPanel(new GridLayout(errorMsgs.size(), 0, 0, 2));
            for (String errMsg : errorMsgs) {
                panel.add(new JLabel(errMsg));
            }
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)panel, 2));
            return false;
        }
    }
}

