/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5.util;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.tomcat5.TomcatFactory;
import org.netbeans.modules.tomcat5.customizer.CustomizerSupport;
import org.netbeans.modules.tomcat5.deploy.TomcatManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.EditableProperties;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class TomcatProperties {
    private static final Logger LOGGER = Logger.getLogger(TomcatProperties.class.getName());
    public static final String PLAT_PROP_ANT_NAME = "platform.ant.name";
    public static final String DEBUG_TYPE_SOCKET = "SEL_debuggingType_socket";
    public static final String DEBUG_TYPE_SHARED = "SEL_debuggingType_shared";
    public static final String BUNDLED_TOMCAT_SETTING = "J2EE/BundledTomcat/Setting";
    private static final String PROP_URL = "url";
    private static final String PROP_USERNAME = "username";
    private static final String PROP_PASSWORD = "password";
    public static final String PROP_SERVER_PORT = "httpportnumber";
    private static final String PROP_DISPLAY_NAME = "displayName";
    public static final String PROP_SHUTDOWN = "admin_port";
    public static final String PROP_MONITOR = "monitor_enabled";
    public static final String PROP_PROXY_ENABLED = "proxy_enabled";
    private static final String PROP_CUSTOM_SCRIPT = "custom_script_enabled";
    private static final String PROP_SCRIPT_PATH = "script_path";
    private static final String PROP_FORCE_STOP = "forceStopOption";
    private static final String PROP_DEBUG_TYPE = "debug_type";
    private static final String PROP_DEBUG_PORT = "debugger_port";
    private static final String PROP_SHARED_MEM = "shared_memory";
    private static final String PROP_JAVA_PLATFORM = "java_platform";
    private static final String PROP_JAVA_OPTS = "java_opts";
    private static final String PROP_SEC_MANAGER = "securityStartupOption";
    private static final String PROP_SOURCES = "sources";
    private static final String PROP_JAVADOCS = "javadocs";
    private static final String PROP_OPEN_LOG = "openContextLogOnRun";
    private static final String PROP_TIMESTAMP = "timestamp";
    private static final String PROP_HOST = "host";
    public static final String PROP_RUNNING_CHECK_TIMEOUT = "runningCheckTimeout";
    private static final String PROP_INSTANCE_ID = "instance_id";
    public static final String PROP_AUTOREGISTERED = "autoregistered";
    private static final String PROP_DRIVER_DEPLOYMENT = "driverDeploymentEnabled";
    public static final String PROP_SERVER_HEADER = "server_header";
    private static final boolean DEF_VALUE_SEC_MANAGER = false;
    private static final boolean DEF_VALUE_CUSTOM_SCRIPT = false;
    private static final String DEF_VALUE_SCRIPT_PATH = "";
    private static final boolean DEF_VALUE_FORCE_STOP = false;
    private static final String DEF_VALUE_JAVA_OPTS = "";
    private static final String DEF_VALUE_DEBUG_TYPE = Utilities.isWindows() ? "SEL_debuggingType_shared" : "SEL_debuggingType_socket";
    private static final boolean DEF_VALUE_MONITOR = true;
    private static final boolean DEF_VALUE_PROXY_ENABLED = true;
    private static final int DEF_VALUE_DEBUG_PORT = 11550;
    private static final int DEF_VALUE_DEBUG_PORT_BUNDLED = 11555;
    private static final int DEF_VALUE_SERVER_PORT = 8080;
    public static final int DEF_VALUE_SHUTDOWN_PORT = 8005;
    public static final int DEF_VALUE_BUNDLED_SERVER_PORT = 8084;
    public static final int DEF_VALUE_BUNDLED_SHUTDOWN_PORT = 8025;
    private static final String DEF_VALUE_SHARED_MEM = "tomcat_shared_memory_id";
    private static final boolean DEF_VALUE_OPEN_LOG = true;
    private static final String DEF_VALUE_HOST = "localhost";
    public static final int DEF_VALUE_RUNNING_CHECK_TIMEOUT = 2000;
    private static final String DEF_VALUE_DISPLAY_NAME = NbBundle.getMessage(TomcatProperties.class, (String)"LBL_DefaultDisplayName");
    private static final boolean DEF_VALUE_DRIVER_DEPLOYMENT = true;
    private static final int DEF_VALUE_DEPLOYMENT_TIMEOUT = 120;
    private static final int DEF_VALUE_STARTUP_TIMEOUT = 120;
    private static final int DEF_VALUE_SHUTDOWN_TIMEOUT = 120;
    private TomcatManager tm;
    private InstanceProperties ip;
    private File homeDir;
    private File baseDir;

    public TomcatProperties(TomcatManager tm) throws IllegalArgumentException {
        this.tm = tm;
        this.ip = tm.getInstanceProperties();
        String catalinaHome = null;
        String catalinaBase = null;
        String uri = this.ip.getProperty(PROP_URL);
        String home = "home=";
        String base = ":base=";
        String uriString = "http://";
        int uriOffset = uri.indexOf("http://");
        int homeOffset = uri.indexOf("home=") + "home=".length();
        int baseOffset = uri.indexOf(":base=", homeOffset);
        if (homeOffset >= "home=".length()) {
            FileObject fo;
            int homeEnd = baseOffset > 0 ? baseOffset : (uriOffset > 0 ? uriOffset - 1 : uri.length());
            int baseEnd = uriOffset > 0 ? uriOffset - 1 : uri.length();
            catalinaHome = uri.substring(homeOffset, homeEnd);
            if (baseOffset > 0) {
                catalinaBase = uri.substring(baseOffset + ":base=".length(), baseEnd);
            }
            if (catalinaHome.length() > 0 && catalinaHome.charAt(0) == '$' && (fo = FileUtil.getConfigFile((String)BUNDLED_TOMCAT_SETTING)) != null) {
                catalinaHome = fo.getAttribute(catalinaHome.substring(1)).toString();
                if (catalinaBase != null && catalinaBase.length() > 0 && catalinaBase.charAt(0) == '$') {
                    catalinaBase = fo.getAttribute(catalinaBase.substring(1)).toString();
                }
            }
        }
        if (catalinaHome == null) {
            throw new IllegalArgumentException("CATALINA_HOME must not be null.");
        }
        this.homeDir = new File(catalinaHome);
        if (!this.homeDir.isAbsolute()) {
            InstalledFileLocator ifl = InstalledFileLocator.getDefault();
            this.homeDir = ifl.locate(catalinaHome, null, false);
        }
        if (!this.homeDir.exists()) {
            throw new IllegalArgumentException("CATALINA_HOME directory does not exist.");
        }
        if (catalinaBase != null) {
            this.baseDir = new File(catalinaBase);
            if (!this.baseDir.isAbsolute()) {
                InstalledFileLocator ifl = InstalledFileLocator.getDefault();
                this.baseDir = ifl.locate(catalinaBase, null, false);
                if (this.baseDir == null) {
                    this.baseDir = new File(System.getProperty("netbeans.user"), catalinaBase);
                }
            }
        }
        this.ip.addPropertyChangeListener(evt -> {
            String name = evt.getPropertyName();
            if (PROP_SERVER_PORT.equals(name) || PROP_USERNAME.equals(name) || PROP_PASSWORD.equals(name)) {
                try {
                    this.storeAntDeploymentProperties(this.getAntDeploymentPropertiesFile(), false);
                }
                catch (IOException ioe) {
                    Logger.getLogger(TomcatProperties.class.getName()).log(Level.INFO, null, ioe);
                }
            }
        });
    }

    public void storeAntDeploymentProperties(File file, boolean create) throws IOException {
        if (!create && !file.exists()) {
            return;
        }
        EditableProperties antProps = new EditableProperties(false);
        antProps.setProperty("tomcat.home", this.homeDir.getAbsolutePath());
        antProps.setProperty("tomcat.url", this.getWebUrl());
        antProps.setProperty("tomcat.username", this.getUsername());
        file.createNewFile();
        FileObject fo = FileUtil.toFileObject((File)file);
        try (FileLock lock = fo.lock();
             OutputStream os = fo.getOutputStream(lock);){
            antProps.store(os);
        }
    }

    public File getAntDeploymentPropertiesFile() {
        return new File(System.getProperty("netbeans.user"), this.getInstanceID() + ".properties");
    }

    private String getInstanceID() {
        String serverID;
        String prefix;
        String name = this.ip.getProperty(PROP_INSTANCE_ID);
        if (name != null) {
            return name;
        }
        switch (this.tm.getTomcatVersion()) {
            case TOMCAT_90: {
                prefix = "tomcat90";
                serverID = "Tomcat90";
                break;
            }
            case TOMCAT_80: {
                prefix = "tomcat80";
                serverID = "Tomcat80";
                break;
            }
            case TOMCAT_70: {
                prefix = "tomcat70";
                serverID = "Tomcat70";
                break;
            }
            case TOMCAT_60: {
                prefix = "tomcat60";
                serverID = "Tomcat60";
                break;
            }
            case TOMCAT_55: {
                prefix = "tomcat55";
                serverID = "Tomcat55";
                break;
            }
            default: {
                prefix = "tomcat50";
                serverID = "Tomcat";
            }
        }
        String[] instanceURLs = Deployment.getDefault().getInstancesOfServer(serverID);
        int i = 0;
        while (name == null) {
            name = i == 0 ? prefix : prefix + "_" + i;
            for (String url : instanceURLs) {
                String anotherName;
                InstanceProperties ip;
                if (this.tm.getUri().equals(url) || (ip = InstanceProperties.getInstanceProperties((String)url)) == null || !name.equals(anotherName = ip.getProperty(PROP_INSTANCE_ID))) continue;
                name = null;
                break;
            }
            ++i;
        }
        this.ip.setProperty(PROP_INSTANCE_ID, name);
        return name;
    }

    public String getWebUrl() {
        return "http://" + this.getHost() + ":" + this.getServerPort();
    }

    public File getCatalinaHome() {
        return this.homeDir;
    }

    public File getCatalinaBase() {
        return this.baseDir;
    }

    public File getCatalinaDir() {
        return this.baseDir == null ? this.homeDir : this.baseDir;
    }

    public File getLibsDir() {
        String libsDir = this.tm.isTomcat50() || this.tm.isTomcat55() ? "common/lib" : "lib";
        return new File(this.getCatalinaHome(), libsDir);
    }

    public File getMonitorLibFolder() {
        if (this.tm.isBundledTomcat()) {
            return new File(this.baseDir, "nblib");
        }
        return this.tm.isTomcat50() || this.tm.isTomcat55() ? new File(this.homeDir, "common/lib") : new File(this.homeDir, "lib");
    }

    public File getJavaEndorsedDir() {
        if (TomcatManager.TomcatVersion.TOMCAT_50 == this.tm.getTomcatVersion() || TomcatManager.TomcatVersion.TOMCAT_55 == this.tm.getTomcatVersion()) {
            return new File(this.getCatalinaHome(), "common/endorsed");
        }
        return new File(this.getCatalinaHome(), "endorsed");
    }

    public String getUsername() {
        String val = this.ip.getProperty(PROP_USERNAME);
        return val != null ? val : "";
    }

    public void setUsername(String value) {
        this.ip.setProperty(PROP_USERNAME, value);
    }

    public String getPassword() {
        String val = this.ip.getProperty(PROP_PASSWORD);
        return val != null ? val : "";
    }

    public void setPassword(String value) {
        this.ip.setProperty(PROP_PASSWORD, value);
    }

    public JavaPlatform getJavaPlatform() {
        String currentJvm = this.ip.getProperty(PROP_JAVA_PLATFORM);
        JavaPlatformManager jpm = JavaPlatformManager.getDefault();
        JavaPlatform[] installedPlatforms = jpm.getPlatforms(null, new Specification("J2SE", null));
        for (int i = 0; i < installedPlatforms.length; ++i) {
            String platformName = (String)installedPlatforms[i].getProperties().get(PLAT_PROP_ANT_NAME);
            if (platformName == null || !platformName.equals(currentJvm)) continue;
            return installedPlatforms[i];
        }
        return jpm.getDefaultPlatform();
    }

    public void setJavaPlatform(JavaPlatform javaPlatform) {
        this.ip.setProperty(PROP_JAVA_PLATFORM, (String)javaPlatform.getProperties().get(PLAT_PROP_ANT_NAME));
    }

    public String getJavaOpts() {
        String val = this.ip.getProperty(PROP_JAVA_OPTS);
        return val != null ? val : "";
    }

    public void setJavaOpts(String javaOpts) {
        this.ip.setProperty(PROP_JAVA_OPTS, javaOpts);
    }

    public boolean getSecManager() {
        String val = this.ip.getProperty(PROP_SEC_MANAGER);
        return val != null ? Boolean.valueOf(val) : false;
    }

    public void setSecManager(boolean enabled) {
        this.ip.setProperty(PROP_SEC_MANAGER, Boolean.toString(enabled));
    }

    public boolean getCustomScript() {
        String val = this.ip.getProperty(PROP_CUSTOM_SCRIPT);
        return val != null ? Boolean.valueOf(val) : false;
    }

    public void setCustomScript(boolean enabled) {
        this.ip.setProperty(PROP_CUSTOM_SCRIPT, Boolean.toString(enabled));
    }

    public String getScriptPath() {
        String val = this.ip.getProperty(PROP_SCRIPT_PATH);
        return val != null ? val : "";
    }

    public void setScriptPath(String path) {
        this.ip.setProperty(PROP_SCRIPT_PATH, path);
    }

    public boolean getForceStop() {
        if (Utilities.isWindows()) {
            return false;
        }
        String val = this.ip.getProperty(PROP_FORCE_STOP);
        return val != null ? Boolean.valueOf(val) : false;
    }

    public void setForceStop(boolean enabled) {
        this.ip.setProperty(PROP_FORCE_STOP, Boolean.toString(enabled));
    }

    public String getDebugType() {
        String val = this.ip.getProperty(PROP_DEBUG_TYPE);
        if (DEBUG_TYPE_SHARED.equalsIgnoreCase(val) && Utilities.isWindows() || DEBUG_TYPE_SOCKET.equalsIgnoreCase(val)) {
            return val;
        }
        return DEF_VALUE_DEBUG_TYPE;
    }

    public void setDebugType(String type) {
        this.ip.setProperty(PROP_DEBUG_TYPE, type);
    }

    public boolean getMonitor() {
        String val = this.ip.getProperty(PROP_MONITOR);
        return val != null ? Boolean.valueOf(val) : true;
    }

    public void setMonitor(boolean enabled) {
        this.ip.setProperty(PROP_MONITOR, Boolean.toString(enabled));
    }

    public boolean getProxyEnabled() {
        String val = this.ip.getProperty(PROP_PROXY_ENABLED);
        return val != null ? Boolean.valueOf(val) : true;
    }

    public void setProxyEnabled(boolean enabled) {
        this.ip.setProperty(PROP_PROXY_ENABLED, Boolean.toString(enabled));
    }

    public int getDebugPort() {
        String val = this.ip.getProperty(PROP_DEBUG_PORT);
        if (val != null) {
            try {
                return Integer.parseInt(val);
            }
            catch (NumberFormatException nfe) {
                Logger.getLogger(TomcatProperties.class.getName()).log(Level.INFO, null, nfe);
            }
        }
        if (this.tm.isBundledTomcat()) {
            return 11555;
        }
        return 11550;
    }

    public void setDebugPort(int port) {
        this.ip.setProperty(PROP_DEBUG_PORT, Integer.toString(port));
    }

    public int getServerPort() {
        String val = this.ip.getProperty(PROP_SERVER_PORT);
        if (val != null) {
            try {
                int port = Integer.parseInt(val);
                if (port >= 0 && port <= 65535) {
                    return port;
                }
            }
            catch (NumberFormatException nfe) {
                Logger.getLogger(TomcatProperties.class.getName()).log(Level.INFO, null, nfe);
            }
        }
        return this.tm.isBundledTomcat() ? 8084 : 8080;
    }

    public void setServerPort(int port) {
        this.ip.setProperty(PROP_SERVER_PORT, Integer.toString(port));
    }

    public String getServerHeader() {
        String val = this.ip.getProperty(PROP_SERVER_HEADER);
        if (val != null) {
            return val;
        }
        return "Apache-Coyote/1.1";
    }

    public void setServerHeader(String serverHeader) {
        this.ip.setProperty(PROP_SERVER_HEADER, serverHeader);
    }

    public int getShutdownPort() {
        String val = this.ip.getProperty(PROP_SHUTDOWN);
        if (val != null) {
            try {
                int port = Integer.parseInt(val);
                if (port >= 0 && port <= 65535) {
                    return port;
                }
            }
            catch (NumberFormatException nfe) {
                Logger.getLogger(TomcatProperties.class.getName()).log(Level.INFO, null, nfe);
            }
        }
        return this.tm.isBundledTomcat() ? 8025 : 8005;
    }

    public void setShutdownPort(int port) {
        this.ip.setProperty(PROP_SHUTDOWN, Integer.toString(port));
    }

    public String getSharedMem() {
        String val = this.ip.getProperty(PROP_SHARED_MEM);
        return val != null && val.length() > 0 ? val : DEF_VALUE_SHARED_MEM;
    }

    public void setSharedMem(String val) {
        this.ip.setProperty(PROP_SHARED_MEM, val);
    }

    public int getDeploymentTimeout() {
        String val = this.ip.getProperty("deploymentTimeout");
        if (val != null) {
            try {
                int timeout = Integer.parseInt(val);
                if (timeout >= 1) {
                    return timeout;
                }
            }
            catch (NumberFormatException nfe) {
                Logger.getLogger(TomcatProperties.class.getName()).log(Level.INFO, null, nfe);
            }
        }
        return 120;
    }

    public void setDeploymentTimeout(int timeout) {
        this.ip.setProperty("deploymentTimeout", Integer.toString(timeout));
    }

    public int getStartupTimeout() {
        String val = this.ip.getProperty("startupTimeout");
        if (val != null) {
            try {
                int timeout = Integer.parseInt(val);
                if (timeout >= 1) {
                    return timeout;
                }
            }
            catch (NumberFormatException nfe) {
                Logger.getLogger(TomcatProperties.class.getName()).log(Level.INFO, null, nfe);
            }
        }
        return 120;
    }

    public void setStartupTimeout(int timeout) {
        this.ip.setProperty("startupTimeout", Integer.toString(timeout));
    }

    public int getShutdownTimeout() {
        String val = this.ip.getProperty("shutdownTimeout");
        if (val != null) {
            try {
                int timeout = Integer.parseInt(val);
                if (timeout >= 1) {
                    return timeout;
                }
            }
            catch (NumberFormatException nfe) {
                Logger.getLogger(TomcatProperties.class.getName()).log(Level.INFO, null, nfe);
            }
        }
        return 120;
    }

    public void setShutdownTimeout(int timeout) {
        this.ip.setProperty("shutdownTimeout", Integer.toString(timeout));
    }

    public boolean getDriverDeployment() {
        String val = this.ip.getProperty(PROP_DRIVER_DEPLOYMENT);
        return val != null ? Boolean.valueOf(val) : true;
    }

    public void setDriverDeployment(boolean enabled) {
        this.ip.setProperty(PROP_DRIVER_DEPLOYMENT, Boolean.toString(enabled));
    }

    public List getClasses() {
        File tomee;
        String[] nbFilter = new String[]{"httpmonitor", "schema2beans", "jasper-compiler-jdt", "jasper-jdt"};
        String[] implFilter = new String[]{"-impl.jar"};
        ArrayList<URL> retValue = new ArrayList<URL>();
        retValue.addAll(TomcatProperties.listUrls(new File(this.homeDir, this.tm.libFolder()), nbFilter));
        if (this.tm.isTomEE() && (tomee = TomcatFactory.getTomEEWebAppJar(this.homeDir, this.baseDir)) != null) {
            retValue.addAll(TomcatProperties.listUrls(tomee.getParentFile(), nbFilter));
        }
        if (this.tm.isTomcat60()) {
            try {
                retValue.add(new File(this.homeDir, "bin/tomcat-juli.jar").toURI().toURL());
            }
            catch (MalformedURLException e) {
                LOGGER.log(Level.WARNING, "$CATALINA_HOME/bin/tomcat-juli.jar not found", e);
            }
        }
        retValue.addAll(TomcatProperties.listUrls(new File(this.homeDir, "common/endorsed"), implFilter));
        retValue.addAll(TomcatProperties.listUrls(new File(this.homeDir, "shared/lib"), implFilter));
        retValue.addAll(TomcatProperties.listUrls(new File(this.homeDir, "jaxws/lib"), implFilter));
        retValue.addAll(TomcatProperties.listUrls(new File(this.homeDir, "jaxb/lib"), implFilter));
        retValue.addAll(TomcatProperties.listUrls(new File(this.homeDir, "jwsdp-shared/lib"), implFilter));
        retValue.addAll(TomcatProperties.listUrls(new File(this.homeDir, "jaxp/lib"), implFilter));
        retValue.addAll(TomcatProperties.listUrls(new File(this.homeDir, "jaxrpc/lib"), implFilter));
        retValue.addAll(TomcatProperties.listUrls(new File(this.homeDir, "jaxr/lib"), implFilter));
        retValue.addAll(TomcatProperties.listUrls(new File(this.homeDir, "saaj/lib"), implFilter));
        retValue.addAll(TomcatProperties.listUrls(new File(this.homeDir, "sjsxp/lib"), implFilter));
        retValue.addAll(TomcatProperties.listUrls(new File(this.homeDir, "jstl/lib"), implFilter));
        retValue.addAll(TomcatProperties.listUrls(new File(this.baseDir, "shared/lib"), nbFilter));
        return retValue;
    }

    public List getSources() {
        String path = this.ip.getProperty(PROP_SOURCES);
        if (path == null) {
            return new ArrayList();
        }
        return CustomizerSupport.tokenizePath(path);
    }

    public void setSources(List path) {
        this.ip.setProperty(PROP_SOURCES, CustomizerSupport.buildPath(path));
        this.tm.getTomcatPlatform().notifyLibrariesChanged();
    }

    private static void addFileToList(List<URL> list, File f) {
        URL u = FileUtil.urlForArchiveOrDir((File)f);
        if (u != null) {
            list.add(u);
        }
    }

    public List getJavadocs() {
        String path = this.ip.getProperty(PROP_JAVADOCS);
        if (path == null) {
            ArrayList<URL> list = new ArrayList<URL>();
            File jspApiDoc = new File(this.homeDir, "webapps/tomcat-docs/jspapi");
            File servletApiDoc = new File(this.homeDir, "webapps/tomcat-docs/servletapi");
            if (jspApiDoc.exists() && servletApiDoc.exists()) {
                TomcatProperties.addFileToList(list, jspApiDoc);
                TomcatProperties.addFileToList(list, servletApiDoc);
            } else {
                File j2eeDoc = InstalledFileLocator.getDefault().locate("docs/javaee-doc-api.jar", null, false);
                if (j2eeDoc != null) {
                    TomcatProperties.addFileToList(list, j2eeDoc);
                }
            }
            File docs = new File(this.homeDir, "docs/api");
            if (docs.exists()) {
                TomcatProperties.addFileToList(list, docs);
            }
            return list;
        }
        return CustomizerSupport.tokenizePath(path);
    }

    public void setJavadocs(List path) {
        this.ip.setProperty(PROP_JAVADOCS, CustomizerSupport.buildPath(path));
        this.tm.getTomcatPlatform().notifyLibrariesChanged();
    }

    public void setOpenContextLogOnRun(boolean val) {
        this.ip.setProperty(PROP_OPEN_LOG, Boolean.toString(val));
    }

    public boolean getOpenContextLogOnRun() {
        String val = this.ip.getProperty(PROP_OPEN_LOG);
        if (val != null) {
            return Boolean.valueOf(val.toString());
        }
        return true;
    }

    public void setTimestamp(long timestamp) {
        this.ip.setProperty(PROP_TIMESTAMP, Long.toString(timestamp));
    }

    public long getTimestamp() {
        String val = this.ip.getProperty(PROP_TIMESTAMP);
        if (val != null) {
            try {
                return Long.parseLong(val);
            }
            catch (NumberFormatException nfe) {
                Logger.getLogger(TomcatProperties.class.getName()).log(Level.INFO, null, nfe);
            }
        }
        return -1L;
    }

    public File getServerXml() {
        String confServerXml = "conf/server.xml";
        File serverXml = null;
        if (this.baseDir != null) {
            serverXml = new File(this.baseDir, confServerXml);
        }
        if (serverXml == null || !serverXml.exists()) {
            serverXml = new File(this.getCatalinaHome(), confServerXml);
        }
        return serverXml;
    }

    @CheckForNull
    public File getTomeeXml() {
        String confTomeeXml = "conf/tomee.xml";
        String confOpenejbXml = "conf/openejb.xml";
        File tomeeXml = null;
        if (this.baseDir != null && !(tomeeXml = new File(this.baseDir, confTomeeXml)).isFile()) {
            tomeeXml = new File(this.baseDir, confOpenejbXml);
        }
        if (!(tomeeXml != null && tomeeXml.isFile() || (tomeeXml = new File(this.getCatalinaHome(), confTomeeXml)).isFile())) {
            tomeeXml = new File(this.getCatalinaHome(), confOpenejbXml);
        }
        if (tomeeXml.isFile()) {
            return tomeeXml;
        }
        return null;
    }

    public String getHost() {
        String val = this.ip.getProperty(PROP_HOST);
        return val != null ? val : DEF_VALUE_HOST;
    }

    public int getRunningCheckTimeout() {
        String val = this.ip.getProperty(PROP_RUNNING_CHECK_TIMEOUT);
        if (val != null) {
            try {
                return Integer.parseInt(val);
            }
            catch (NumberFormatException nfe) {
                Logger.getLogger(TomcatProperties.class.getName()).log(Level.INFO, null, nfe);
            }
        }
        return 2000;
    }

    public String getDisplayName() {
        String val = this.ip.getProperty(PROP_DISPLAY_NAME);
        return val != null && val.length() > 0 ? val : DEF_VALUE_DISPLAY_NAME;
    }

    private static List<URL> listUrls(File folder, String[] filter) {
        Object[] jars = folder.listFiles((dir, name) -> {
            if (!name.endsWith(".jar") || !dir.equals(folder)) {
                return false;
            }
            for (int i = 0; i < filter.length; ++i) {
                if (name.indexOf(filter[i]) == -1) continue;
                return false;
            }
            return true;
        });
        if (jars == null) {
            return Collections.emptyList();
        }
        Arrays.sort(jars);
        ArrayList<URL> urls = new ArrayList<URL>(jars.length);
        for (int i = 0; i < jars.length; ++i) {
            TomcatProperties.addFileToList(urls, (File)jars[i]);
        }
        return urls;
    }
}

