/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5.deploy;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.OperationUnsupportedException;
import javax.enterprise.deploy.spi.status.ClientConfiguration;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.modules.j2ee.common.ClasspathUtil;
import org.netbeans.modules.j2ee.common.DatasourceHelper;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.plugins.spi.JDBCDriverDeployer;
import org.netbeans.modules.tomcat5.deploy.TomcatManager;
import org.netbeans.modules.tomcat5.progress.ProgressEventSupport;
import org.netbeans.modules.tomcat5.progress.Status;
import org.netbeans.modules.tomcat5.util.TomcatProperties;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class TomcatJDBCDriverDeployer
implements JDBCDriverDeployer {
    private static final Logger LOG = Logger.getLogger(TomcatJDBCDriverDeployer.class.getName());
    private final TomcatManager manager;

    public TomcatJDBCDriverDeployer(TomcatManager manager) {
        this.manager = manager;
    }

    public boolean supportsDeployJDBCDrivers(Target target) {
        return this.manager.getTomcatProperties().getDriverDeployment();
    }

    public ProgressObject deployJDBCDrivers(Target target, Set<Datasource> datasources) {
        return new DriverDeploymentProgressObject(datasources);
    }

    private class DriverDeploymentProgressObject
    implements ProgressObject,
    Runnable {
        private final ProgressEventSupport eventSupport;
        private final Set<Datasource> datasources;

        public DriverDeploymentProgressObject(Set<Datasource> datasources) {
            this.eventSupport = new ProgressEventSupport(TomcatJDBCDriverDeployer.this);
            this.datasources = datasources;
            String msg = NbBundle.getMessage(TomcatJDBCDriverDeployer.class, (String)"MSG_CheckingMissingDrivers");
            this.eventSupport.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, CommandType.DISTRIBUTE, msg, StateType.RUNNING));
            RequestProcessor.getDefault().post((Runnable)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            List<FileObject> jdbcDriverFiles = this.jdbcDriversToDeploy();
            if (!jdbcDriverFiles.isEmpty()) {
                TomcatProperties tp = TomcatJDBCDriverDeployer.this.manager.getTomcatProperties();
                for (FileObject file : jdbcDriverFiles) {
                    String msg;
                    File libsDir = tp.getLibsDir();
                    File toJar = new File(libsDir, file.getNameExt());
                    try (BufferedInputStream is = new BufferedInputStream(file.getInputStream());){
                        msg = NbBundle.getMessage(TomcatJDBCDriverDeployer.class, (String)"MSG_DeployingJDBCDrivers", (Object)toJar.getPath());
                        this.eventSupport.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, CommandType.DISTRIBUTE, msg, StateType.RUNNING));
                        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(toJar));){
                            FileUtil.copy((InputStream)is, (OutputStream)os);
                        }
                    }
                    catch (IOException e) {
                        LOG.log(Level.INFO, null, e);
                        msg = NbBundle.getMessage(TomcatJDBCDriverDeployer.class, (String)"MSG_DeployingJDBCDriversFailed", (Object)toJar.getPath(), (Object)libsDir.getPath());
                        this.eventSupport.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, CommandType.DISTRIBUTE, msg, StateType.FAILED));
                        return;
                    }
                }
                TomcatJDBCDriverDeployer.this.manager.setNeedsRestart(true);
            }
            this.eventSupport.fireHandleProgressEvent(null, new Status(ActionType.EXECUTE, CommandType.DISTRIBUTE, "", StateType.COMPLETED));
        }

        private List<FileObject> jdbcDriversToDeploy() {
            ArrayList<FileObject> jdbcDriverFiles = new ArrayList<FileObject>();
            Collection<File> driverCP = this.getJDBCDriverClasspath();
            for (Datasource datasource : this.datasources) {
                String className = datasource.getDriverClassName();
                boolean exists = false;
                try {
                    exists = ClasspathUtil.containsClass(driverCP, (String)className);
                }
                catch (IOException e) {
                    LOG.log(Level.INFO, null, e);
                }
                if (exists) continue;
                for (DatabaseConnection databaseConnection : DatasourceHelper.findDatabaseConnections((Datasource)datasource)) {
                    JDBCDriver[] jdbcDrivers;
                    JDBCDriver connDriver = databaseConnection.getJDBCDriver();
                    if (connDriver != null) {
                        jdbcDrivers = new JDBCDriver[]{connDriver};
                    } else {
                        String driverClass = databaseConnection.getDriverClass();
                        jdbcDrivers = JDBCDriverManager.getDefault().getDrivers(driverClass);
                    }
                    for (JDBCDriver jdbcDriver : jdbcDrivers) {
                        for (URL url : jdbcDriver.getURLs()) {
                            FileObject file = URLMapper.findFileObject((URL)url);
                            if (file == null) continue;
                            jdbcDriverFiles.add(file);
                        }
                    }
                }
            }
            return jdbcDriverFiles;
        }

        private Collection<File> getJDBCDriverClasspath() {
            TomcatProperties tp = TomcatJDBCDriverDeployer.this.manager.getTomcatProperties();
            return Arrays.asList(tp.getLibsDir().listFiles());
        }

        public DeploymentStatus getDeploymentStatus() {
            return this.eventSupport.getDeploymentStatus();
        }

        public TargetModuleID[] getResultTargetModuleIDs() {
            return null;
        }

        public ClientConfiguration getClientConfiguration(TargetModuleID targetModuleID) {
            return null;
        }

        public boolean isCancelSupported() {
            return false;
        }

        public void cancel() throws OperationUnsupportedException {
            throw new OperationUnsupportedException("Cancel is not supported");
        }

        public boolean isStopSupported() {
            return false;
        }

        public void stop() throws OperationUnsupportedException {
            throw new OperationUnsupportedException("Stop is not supported");
        }

        public void addProgressListener(ProgressListener progressListener) {
            this.eventSupport.addProgressListener(progressListener);
        }

        public void removeProgressListener(ProgressListener progressListener) {
            this.eventSupport.removeProgressListener(progressListener);
        }
    }
}

