/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5.ui.nodes;

import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import org.netbeans.modules.tomcat5.AuthorizationException;
import org.netbeans.modules.tomcat5.deploy.TomcatManager;
import org.netbeans.modules.tomcat5.deploy.TomcatModule;
import org.netbeans.modules.tomcat5.ui.nodes.TomcatWebModule;
import org.netbeans.modules.tomcat5.ui.nodes.TomcatWebModuleNode;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class TomcatWebModuleChildrenFactory
extends ChildFactory<TomcatWebModule> {
    private static final TomcatWebModule MODULE_WAITING_MARK = new TomcatWebModule(null, null, false);
    private static final Logger LOGGER = Logger.getLogger(TomcatWebModuleChildrenFactory.class.getName());
    private final Lookup lookup;

    public TomcatWebModuleChildrenFactory(Lookup lookup) {
        this.lookup = lookup;
    }

    public void updateKeys() {
        this.refresh(false);
    }

    protected Node createNodeForKey(TomcatWebModule key) {
        if (key == MODULE_WAITING_MARK) {
            return this.createWaitNode();
        }
        TomcatWebModuleNode node = new TomcatWebModuleNode(key);
        key.setRepresentedNode((Node)node);
        return node;
    }

    protected boolean createKeys(List<TomcatWebModule> toPopulate) {
        DeploymentManager manager = (DeploymentManager)this.lookup.lookup(DeploymentManager.class);
        Target target = (Target)this.lookup.lookup(Target.class);
        TreeSet<TomcatWebModule> list = new TreeSet<TomcatWebModule>(TomcatWebModule.TOMCAT_WEB_MODULE_COMPARATOR);
        if (manager instanceof TomcatManager && target != null) {
            TomcatManager tm = (TomcatManager)manager;
            if (tm.isSuspended() || !tm.isRunning(true)) {
                return true;
            }
            try {
                int i;
                TargetModuleID[] modules = manager.getRunningModules(ModuleType.WAR, new Target[]{target});
                for (i = 0; i < modules.length; ++i) {
                    list.add(new TomcatWebModule(manager, (TomcatModule)modules[i], true));
                }
                modules = manager.getNonRunningModules(ModuleType.WAR, new Target[]{target});
                for (i = 0; i < modules.length; ++i) {
                    list.add(new TomcatWebModule(manager, (TomcatModule)modules[i], false));
                }
            }
            catch (Exception e) {
                if (e.getCause() instanceof AuthorizationException) {
                    String errMsg = NbBundle.getMessage(TomcatWebModuleChildrenFactory.class, (String)"MSG_AuthorizationFailed", (Object)(tm.isAboveTomcat70() ? "manager-script" : "manager"));
                    NotifyDescriptor.Message notDesc = new NotifyDescriptor.Message((Object)errMsg, 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)notDesc);
                }
                LOGGER.log(Level.INFO, null, e);
            }
        }
        toPopulate.addAll(list);
        return true;
    }
}

