/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.testng.ui.wizards;

import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.SourceGroupModifier;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.testng.api.TestNGSupport;
import org.netbeans.spi.java.project.support.ui.templates.JavaTemplates;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;

public final class NewTestSuiteWizardIterator
implements WizardDescriptor.InstantiatingIterator<WizardDescriptor> {
    private transient int index;
    private transient WizardDescriptor.Panel[] panels;
    private transient WizardDescriptor wiz;

    private WizardDescriptor.Panel[] createPanels(WizardDescriptor wizardDescriptor) {
        Project project = Templates.getProject((WizardDescriptor)wizardDescriptor);
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] groups = this.getTestRoots(sources);
        if (groups.length == 0 && SourceGroupModifier.createSourceGroup((Project)project, (String)"java", (String)"test") != null) {
            groups = this.getTestRoots(sources);
        }
        if (groups.length == 0) {
            groups = sources.getSourceGroups("generic");
        }
        return new WizardDescriptor.Panel[]{JavaTemplates.createPackageChooser((Project)project, (SourceGroup[])groups)};
    }

    private String[] createSteps(String[] before, WizardDescriptor.Panel[] panels) {
        assert (panels != null);
        int diff = 0;
        if (before == null) {
            before = new String[]{};
        } else if (before.length > 0) {
            diff = "...".equals(before[before.length - 1]) ? 1 : 0;
        }
        String[] res = new String[before.length - diff + panels.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = i < before.length - diff ? before[i] : panels[i - before.length + diff].getComponent().getName();
        }
        return res;
    }

    public Set<DataObject> instantiate() throws IOException {
        FileObject targetFolder = Templates.getTargetFolder((WizardDescriptor)this.wiz);
        TestNGSupport.findTestNGSupport((Project)FileOwnerQuery.getOwner((FileObject)targetFolder)).configureProject(targetFolder);
        String targetName = Templates.getTargetName((WizardDescriptor)this.wiz);
        DataFolder df = DataFolder.findFolder((FileObject)targetFolder);
        FileObject template = Templates.getTemplate((WizardDescriptor)this.wiz);
        DataObject dTemplate = DataObject.find((FileObject)template);
        String pkgName = NewTestSuiteWizardIterator.getSelectedPackageName(targetFolder);
        String suiteName = pkgName + " suite";
        String projectName = ProjectUtils.getInformation((Project)FileOwnerQuery.getOwner((FileObject)targetFolder)).getName();
        if (pkgName == null || pkgName.trim().length() < 1) {
            pkgName = ".*";
            suiteName = "All tests for " + projectName;
        }
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("suiteName", projectName);
        props.put("testName", suiteName);
        props.put("pkg", pkgName);
        DataObject dobj = dTemplate.createFromTemplate(df, targetName, props);
        return Collections.singleton(dobj);
    }

    public void initialize(WizardDescriptor wiz) {
        this.wiz = wiz;
        this.index = 0;
        this.panels = this.createPanels(wiz);
        String[] beforeSteps = null;
        Object prop = wiz.getProperty("WizardPanel_contentData");
        if (prop != null && prop instanceof String[]) {
            beforeSteps = (String[])prop;
        }
        String[] steps = this.createSteps(beforeSteps, this.panels);
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = c.getName();
            }
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    public void uninitialize(WizardDescriptor wiz) {
        this.wiz = null;
        this.panels = null;
    }

    public String name() {
        return "";
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener l) {
    }

    public final void removeChangeListener(ChangeListener l) {
    }

    private static String getSelectedPackageName(FileObject targetFolder) {
        Project project = FileOwnerQuery.getOwner((FileObject)targetFolder);
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] groups = sources.getSourceGroups("java");
        String packageName = null;
        for (int i = 0; i < groups.length && packageName == null; ++i) {
            packageName = FileUtil.getRelativePath((FileObject)groups[i].getRootFolder(), (FileObject)targetFolder);
        }
        if (packageName != null) {
            packageName = packageName.replaceAll("/", ".");
        }
        return packageName;
    }

    private SourceGroup[] getTestRoots(Sources srcs) {
        SourceGroup[] groups = srcs.getSourceGroups("java");
        assert (groups != null) : "Cannot return null from Sources.getSourceGroups: " + srcs;
        ArrayList<SourceGroup> result = new ArrayList<SourceGroup>(2);
        for (SourceGroup sg : groups) {
            if (!sg.getName().startsWith("${test") && !"2TestSourceRoot".equals(sg.getName())) continue;
            result.add(sg);
        }
        return result.toArray(new SourceGroup[result.size()]);
    }
}

