/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.terminal.ioprovider;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Keymap;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.lib.terminalemulator.ActiveRegion;
import org.netbeans.lib.terminalemulator.ActiveTerm;
import org.netbeans.lib.terminalemulator.ActiveTermListener;
import org.netbeans.lib.terminalemulator.Coord;
import org.netbeans.lib.terminalemulator.Extent;
import org.netbeans.lib.terminalemulator.Term;
import org.netbeans.lib.terminalemulator.TermAdapter;
import org.netbeans.lib.terminalemulator.TermListener;
import org.netbeans.lib.terminalemulator.TermStream;
import org.netbeans.lib.terminalemulator.support.DefaultFindState;
import org.netbeans.lib.terminalemulator.support.FindState;
import org.netbeans.lib.terminalemulator.support.TermOptions;
import org.netbeans.modules.terminal.api.IOResizable;
import org.netbeans.modules.terminal.api.ui.IOVisibilityControl;
import org.netbeans.modules.terminal.api.ui.TerminalContainer;
import org.netbeans.modules.terminal.ioprovider.Task;
import org.netbeans.modules.terminal.ioprovider.TerminalInputOutput;
import org.netbeans.modules.terminal.nb.TermAdvancedOption;
import org.netbeans.modules.terminal.nb.actions.ActionFactory;
import org.netbeans.modules.terminal.nb.actions.PinTabAction;
import org.netbeans.modules.terminal.spi.ui.ExternalCommandActionProvider;
import org.netbeans.modules.terminal.support.OpenInEditorAction;
import org.netbeans.modules.terminal.support.TerminalPinSupport;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.datatransfer.MultiTransferObject;
import org.openide.util.lookup.Lookups;
import org.openide.windows.IOContainer;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

public final class Terminal
extends JComponent {
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private final IOContainer ioContainer;
    private final TerminalInputOutput tio;
    private final String name;
    private final MouseAdapter mouseAdapter;
    private final CallBacks callBacks = new CallBacks();
    private final ActiveTerm term;
    private final TermListener termListener;
    private FindState findState;
    private static final Preferences prefs = NbPreferences.forModule(TermAdvancedOption.class);
    private final TermOptions termOptions;
    private final TermOptionsPCL termOptionsPCL = new TermOptionsPCL();
    private final FileObject shortcutsDir = FileUtil.getConfigFile((String)"Terminal/Shortcuts");
    private final ShortcutsListener shortcutsListener = new ShortcutsListener();
    private String title;
    private boolean customTitle;
    private boolean visibleInContainer;
    private boolean outConnected;
    private boolean errConnected;
    private boolean extConnected;
    private boolean disposed;
    private boolean closable = true;
    private boolean pinned = false;
    private String cwd;
    private boolean closedUnconditionally;
    private final ImageIcon icon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/terminal/support/pin.png", (boolean)false);
    private Action copyAction = ActionFactory.forID("org.netbeans.modules.terminal.actions.CopyAction");
    private Action pasteAction = ActionFactory.forID("org.netbeans.modules.terminal.actions.PasteAction");
    private Action findAction = ActionFactory.forID("org.netbeans.modules.terminal.actions.FindAction");
    private Action wrapAction = ActionFactory.forID("org.netbeans.modules.terminal.actions.WrapAction");
    private Action largerFontAction = ActionFactory.forID("org.netbeans.modules.terminal.actions.LargerFontAction");
    private Action smallerFontAction = ActionFactory.forID("org.netbeans.modules.terminal.actions.SmallerFontAction");
    private Action setTitleAction = ActionFactory.forID("org.netbeans.modules.terminal.actions.SetTitleAction");
    private Action pinTabAction = ActionFactory.forID("org.netbeans.modules.terminal.actions.PinTabAction");
    private Action clearAction = ActionFactory.forID("org.netbeans.modules.terminal.actions.ClearAction");
    private Action dumpSequencesAction = ActionFactory.forID("org.netbeans.modules.terminal.actions.DumpSequenceAction");
    private Action closeAction = ActionFactory.forID("org.netbeans.modules.terminal.actions.CloseAction");
    private Action switchTabAction = ActionFactory.forID("org.netbeans.modules.terminal.actions.SwitchTabAction");
    private Action newTabAction = ActionFactory.forID("org.netbeans.modules.terminal.actions.NewTabAction");

    Terminal(IOContainer ioContainer, TerminalInputOutput tio, String name) {
        if (ioContainer == null) {
            throw new IllegalArgumentException("ioContainer cannot be null");
        }
        this.ioContainer = ioContainer;
        this.tio = tio;
        this.name = name;
        this.termOptions = TermOptions.getDefault((Preferences)prefs);
        this.term = this.createActiveTerminal();
        this.applyDebugFlags();
        this.term.setCursorVisible(true);
        this.findState = new DefaultFindState((Term)this.term);
        this.term.setHorizontallyScrollable(false);
        this.term.setEmulation("xterm");
        this.term.setBackground(Color.white);
        this.term.setHistorySize(4000);
        this.term.setRenderingHints(this.getRenderingHints());
        this.term.addListener((TermListener)new TermAdapter(){

            public void cwdChanged(String aCwd) {
                Terminal.this.cwd = aCwd;
            }
        });
        this.shortcutsDir.addFileChangeListener((FileChangeListener)this.shortcutsListener);
        this.termOptions.addPropertyChangeListener((PropertyChangeListener)this.termOptionsPCL);
        this.applyTermOptions(true);
        HashSet<Action> actions = new HashSet<Action>();
        HashSet<Action> awareActions = new HashSet<Action>();
        actions.add(this.newTabAction);
        actions.add(this.copyAction);
        actions.add(this.pasteAction);
        actions.add(this.findAction);
        actions.add(this.wrapAction);
        actions.add(this.largerFontAction);
        actions.add(this.smallerFontAction);
        actions.add(this.setTitleAction);
        actions.add(this.pinTabAction);
        actions.add(this.clearAction);
        actions.add(this.dumpSequencesAction);
        actions.add(this.closeAction);
        actions.add(this.switchTabAction);
        for (Action action : actions) {
            if (action instanceof ContextAwareAction) {
                action = ((ContextAwareAction)action).createContextAwareInstance(Lookups.fixed((Object[])new Object[]{this}));
            }
            awareActions.add(action);
        }
        final TerminalPinSupport support = TerminalPinSupport.getDefault();
        TerminalPinSupport.DetailsStateListener listener = new TerminalPinSupport.DetailsStateListener(){

            @Override
            public void detailsAdded(Term notifiedTerm) {
                if (notifiedTerm != Terminal.this.term) {
                    return;
                }
                TerminalPinSupport.TerminalPinningDetails pinDetails = support.findPinningDetails(notifiedTerm);
                if (pinDetails != null) {
                    boolean customTitle = pinDetails.isCustomTitle();
                    Terminal.this.setCustomTitle(customTitle);
                    if (customTitle) {
                        Terminal.this.setTitle(pinDetails.getTitle());
                    }
                    Terminal.this.pin(true);
                }
            }
        };
        support.addDetailsStateListener((TerminalPinSupport.DetailsStateListener)WeakListeners.create(TerminalPinSupport.DetailsStateListener.class, (EventListener)listener, (Object)support));
        this.setupKeymap(awareActions);
        this.mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    Point p = SwingUtilities.convertPoint((Component)e.getSource(), e.getPoint(), Terminal.this.term.getScreen());
                    Terminal.this.postPopupMenu(p);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    Point p = SwingUtilities.convertPoint((Component)e.getSource(), e.getPoint(), Terminal.this.term.getScreen());
                    Terminal.this.postPopupMenu(p);
                }
            }
        };
        this.term.getScreen().addMouseListener(this.mouseAdapter);
        this.term.getScreen().getActionMap().put("org.openide.actions.PopupAction", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Point p = Terminal.this.getPopupPosition();
                Terminal.this.postPopupMenu(p);
            }
        });
        this.term.getScreen().addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (e.isAltDown() || e.isAltGraphDown() || e.isControlDown()) {
                    int change = -e.getWheelRotation();
                    Terminal.this.changeFontSizeBy(change);
                    e.consume();
                }
            }
        });
        this.termListener = new MyTermListener();
        this.term.addListener(this.termListener);
        this.term.setActionListener(new ActiveTermListener(){

            public void action(ActiveRegion r, InputEvent e) {
                Object userObject = r.getUserObject();
                if (userObject == null) {
                    return;
                }
                if (r.isLink() && userObject instanceof String) {
                    String text = (String)userObject;
                    int lineNumber = -1;
                    String filePath = text;
                    int colonIdx = text.lastIndexOf(58);
                    if (colonIdx > 2) {
                        try {
                            lineNumber = Integer.parseInt(text.substring(colonIdx + 1));
                            filePath = text.substring(0, colonIdx);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    OpenInEditorAction.post(filePath, lineNumber);
                } else if (userObject instanceof OutputListener) {
                    OutputListener ol = (OutputListener)r.getUserObject();
                    if (ol == null) {
                        return;
                    }
                    Extent extent = r.getExtent();
                    String text = Terminal.this.term.textWithin(extent.begin, extent.end);
                    TerminalOutputEvent oe = new TerminalOutputEvent(Terminal.this.tio, text);
                    ol.outputLineAction((OutputEvent)oe);
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this.term, "Center");
        this.setFocusable(false);
    }

    void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        this.term.getScreen().removeMouseListener(this.mouseAdapter);
        this.term.removeListener(this.termListener);
        this.term.setActionListener(null);
        this.findState = null;
        this.shortcutsDir.removeFileChangeListener((FileChangeListener)this.shortcutsListener);
        this.termOptions.removePropertyChangeListener((PropertyChangeListener)this.termOptionsPCL);
        this.tio.dispose();
    }

    boolean isDisposed() {
        return this.disposed;
    }

    public IOContainer.CallBacks callBacks() {
        return this.callBacks;
    }

    public String name() {
        return this.name;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    @Override
    public void requestFocus() {
        this.term.getScreen().requestFocus();
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.term.getScreen().requestFocusInWindow();
    }

    private void applyDebugFlags() {
        String value = System.getProperty("Term.debug");
        if (value == null) {
            return;
        }
        int flags = 0;
        StringTokenizer st = new StringTokenizer(value, ",");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.equalsIgnoreCase("ops")) {
                flags |= 1;
                continue;
            }
            if (s.equalsIgnoreCase("keys")) {
                flags |= 2;
                continue;
            }
            if (s.equalsIgnoreCase("input")) {
                flags |= 4;
                continue;
            }
            if (s.equalsIgnoreCase("output")) {
                flags |= 8;
                continue;
            }
            if (s.equalsIgnoreCase("wrap")) {
                flags |= 0x10;
                continue;
            }
            if (s.equalsIgnoreCase("margins")) {
                flags |= 0x20;
                continue;
            }
            if (!s.equalsIgnoreCase("sequences")) continue;
            this.term.setSequenceLogging(true);
        }
        this.term.setDebugFlags(flags);
    }

    private void applyTermOptions(boolean initial) {
        this.term.setFixedFont(true);
        this.term.setFont(this.termOptions.getFont());
        this.term.setBackground(this.termOptions.getBackground());
        this.term.setForeground(this.termOptions.getForeground());
        this.term.setHighlightColor(this.termOptions.getSelectionBackground());
        this.term.setHistorySize(this.termOptions.getHistorySize());
        this.term.setTabSize(this.termOptions.getTabSize());
        this.term.setSelectByWordDelimiters(this.termOptions.getSelectByWordDelimiters());
        this.term.setClickToType(this.termOptions.getClickToType());
        this.term.setScrollOnInput(this.termOptions.getScrollOnInput());
        this.term.setScrollOnOutput(this.termOptions.getScrollOnOutput());
        this.term.setAltSendsEscape(this.termOptions.getAltSendsEscape());
        if (initial) {
            this.term.setHorizontallyScrollable(!this.termOptions.getLineWrap());
        }
        this.applyShortcuts();
        this.setSize(this.getPreferredSize());
        this.validate();
    }

    public ActiveTerm term() {
        return this.term;
    }

    public String getCwd() {
        return this.cwd;
    }

    public void setTitle(String title) {
        this.customTitle = true;
        this.updateName(title);
    }

    public void resetTitle() {
        this.customTitle = false;
        this.updateName("");
    }

    public String getTitle() {
        return this.title;
    }

    public FindState getFindState() {
        return this.findState;
    }

    public void activateSearch() {
        if (this.findState.isVisible()) {
            return;
        }
        this.findState.setVisible(true);
        Container ancestor = SwingUtilities.getAncestorOfClass(TerminalContainer.class, this);
        if (ancestor instanceof TerminalContainer) {
            Task.ActivateSearch t = new Task.ActivateSearch((TerminalContainer)ancestor, this);
            t.post();
        }
    }

    public void changeFontSizeBy(int d) {
        int oldFontSize = this.termOptions.getFontSize();
        int newFontSze = oldFontSize + d;
        if (newFontSze <= 8) {
            newFontSze = 8;
        } else if (newFontSze >= 48) {
            newFontSze = 48;
        }
        TermOptions.getDefault((Preferences)prefs).setFontSize(newFontSze);
    }

    public boolean isPinned() {
        return this.pinned;
    }

    public void setPinned(boolean pinned) {
        this.pinned = pinned;
    }

    public boolean isCustomTitle() {
        return this.customTitle;
    }

    public void setCustomTitle(boolean customTitle) {
        this.customTitle = customTitle;
    }

    void setClosedUnconditionally(boolean closedUnconditionally) {
        this.closedUnconditionally = closedUnconditionally;
    }

    boolean isClosedUnconditionally() {
        return this.closedUnconditionally;
    }

    public void closeUnconditionally() {
        this.setClosedUnconditionally(true);
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (!this.isVisibleInContainer()) {
            return;
        }
        if (this.isPinnable()) {
            final AtomicBoolean canceled = new AtomicBoolean(false);
            if (this.pinned && !this.closedUnconditionally) {
                boolean CLOSE_AND_UNPIN = false;
                boolean CLOSE = true;
                int CANCEL = 2;
                String CMD_CLOSE_AND_UNPIN = "CloseAndUnpin";
                String CMD_CLOSE = "Close";
                String CMD_CANCEL = "Cancel";
                Object[] options = new JButton[]{new JButton(NbBundle.getMessage(Terminal.class, (String)"TXT_CloseAndUnpin", (Object)this.getTitle())), new JButton(NbBundle.getMessage(Terminal.class, (String)"TXT_Close")), new JButton(NbBundle.getMessage(Terminal.class, (String)"TXT_Cancel"))};
                ActionListener commandListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String command = e.getActionCommand();
                        if ("CloseAndUnpin".equals(command)) {
                            Action pinTabAction = ActionFactory.forID("org.netbeans.modules.terminal.actions.PinTabAction");
                            if (pinTabAction != null) {
                                pinTabAction.actionPerformed(null);
                            }
                        } else {
                            if ("Cancel".equals(command)) {
                                canceled.set(true);
                                return;
                            }
                            if ("Close".equals(command)) {
                                return;
                            }
                        }
                    }
                };
                options[0].setActionCommand("CloseAndUnpin");
                options[1].setActionCommand("Close");
                options[2].setActionCommand("Cancel");
                options[0].addActionListener(commandListener);
                options[1].addActionListener(commandListener);
                options[2].addActionListener(commandListener);
                String message = NbBundle.getMessage(Terminal.class, (String)"LBL_CloseTerminal", (Object)this.getTitle());
                DialogDescriptor dd = new DialogDescriptor((Object)message, NbBundle.getMessage(Terminal.class, (String)"TXT_CloseTerminalTitle"), true, options, (Object)options[0], 0, null, null);
                dd.setClosingOptions(options);
                Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
                try {
                    dialog.setVisible(true);
                }
                catch (Throwable th) {
                    if (!(th.getCause() instanceof InterruptedException)) {
                        throw new RuntimeException(th);
                    }
                    dd.setValue(options[2]);
                }
                finally {
                    dialog.dispose();
                }
                if (dd.getValue().equals(-1)) {
                    canceled.set(true);
                }
            }
            if (canceled.get()) {
                return;
            }
        }
        this.ioContainer.remove((JComponent)this);
    }

    public void setVisibleInContainer(boolean visible) {
        boolean wasVisible = this.visibleInContainer;
        this.visibleInContainer = visible;
        if (visible != wasVisible) {
            this.tio.pcs().firePropertyChange("IOVisibility.PROP_VISIBILITY", wasVisible, visible);
        }
    }

    public boolean isVisibleInContainer() {
        return this.visibleInContainer;
    }

    public void setOutConnected(boolean outConnected) {
        boolean wasConnected = this.isConnected();
        this.outConnected = outConnected;
        if (!outConnected) {
            this.errConnected = false;
        }
        if (this.isConnected() != wasConnected) {
            this.updateName();
            this.tio.pcs().firePropertyChange("IOConnect.PROP_CONNECTED", wasConnected, this.isConnected());
        }
    }

    public void setErrConnected(boolean errConnected) {
        boolean wasConnected = this.isConnected();
        this.errConnected = errConnected;
        if (this.isConnected() != wasConnected) {
            this.updateName();
            this.tio.pcs().firePropertyChange("IOConnect.PROP_CONNECTED", wasConnected, this.isConnected());
        }
    }

    public void setExtConnected(boolean extConnected) {
        boolean wasConnected = this.isConnected();
        this.extConnected = extConnected;
        if (this.isConnected() != wasConnected) {
            this.updateName();
            this.tio.pcs().firePropertyChange("IOConnect.PROP_CONNECTED", wasConnected, this.isConnected());
        }
    }

    public boolean isConnected() {
        return this.outConnected || this.errConnected || this.extConnected;
    }

    private boolean okToHide() {
        try {
            this.tio.vcs().fireVetoableChange("IOVisibility.PROP_VISIBILITY", true, false);
        }
        catch (PropertyVetoException ex) {
            return false;
        }
        return true;
    }

    public void setClosable(boolean closable) {
        this.closable = closable;
        this.putClientProperty("noCloseButton", !closable);
    }

    public boolean isClosable() {
        return this.closable;
    }

    public void updateName(String name) {
        this.title = name;
        this.updateName();
    }

    private void updateName() {
        Task.UpdateName task = new Task.UpdateName(this.ioContainer, this);
        task.post();
    }

    private void updateTooltopText(String text) {
        Task.SetToolTipText task = new Task.SetToolTipText(this.ioContainer, this, text);
        task.post();
    }

    private void setIcon(Icon icon) {
        Task.SetIcon task = new Task.SetIcon(this.ioContainer, this, icon);
        task.post();
    }

    public void pin(boolean newState) {
        if (newState) {
            this.setIcon(this.icon);
        } else {
            this.setIcon(null);
        }
        TerminalPinSupport.getDefault().findPinningDetails((Term)this.term).setPinned(newState);
        this.setPinned(newState);
        this.pinTabAction.putValue("Name", PinTabAction.getMessage(newState));
    }

    private boolean isPinnable() {
        Object clientProperty = this.getClientProperty("pinAction");
        return clientProperty != null && clientProperty.equals("enabled");
    }

    private void setupKeymap(Set<Action> actions) {
        JComponent comp = this.term.getScreen();
        ActionMap actionMap = comp.getActionMap();
        ActionMap newActionMap = new ActionMap();
        newActionMap.setParent(actionMap);
        InputMap inputMap = comp.getInputMap();
        InputMap newInputMap = new InputMap();
        newInputMap.setParent(inputMap);
        HashSet<KeyStroke> passKeystrokes = new HashSet<KeyStroke>();
        for (Action a : actions) {
            String n = (String)a.getValue("Name");
            Object key = a.getValue("AcceleratorKey");
            if (key == null) continue;
            if (key instanceof KeyStroke) {
                KeyStroke accelerator = (KeyStroke)key;
                newInputMap.put(accelerator, n);
                newActionMap.put(n, a);
                passKeystrokes.add(accelerator);
                continue;
            }
            if (!(key instanceof KeyStroke[])) continue;
            for (KeyStroke accelerator : (KeyStroke[])key) {
                newInputMap.put(accelerator, n);
                newActionMap.put(n, a);
                passKeystrokes.add(accelerator);
            }
        }
        comp.setActionMap(newActionMap);
        comp.setInputMap(0, newInputMap);
        this.term.setKeyStrokeSet(passKeystrokes);
    }

    private Point getPopupPosition() {
        int offset = 25;
        return new Point(25, 25);
    }

    private void postPopupMenu(Point p) {
        this.findAction.setEnabled(!this.findState.isVisible());
        this.findAction.setEnabled(false);
        Container container = SwingUtilities.getAncestorOfClass(TerminalContainer.class, this);
        boolean isTerminalContainer = container instanceof TerminalContainer;
        JPopupMenu menu = Utilities.actionsToPopup((Action[])new Action[]{this.newTabAction, null, this.copyAction, this.pasteAction, null, isTerminalContainer ? this.findAction : null, null, this.wrapAction, this.largerFontAction, this.smallerFontAction, null, this.setTitleAction, this.isPinnable() ? this.pinTabAction : null, null, this.clearAction, this.isClosable() ? this.closeAction : null, System.getProperty("Term.debug") != null ? this.dumpSequencesAction : null}, (Lookup)Lookups.fixed((Object[])new Object[]{this}));
        menu.putClientProperty("container", this.ioContainer);
        menu.putClientProperty("component", this);
        menu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        menu.show(this.term.getScreen(), p.x, p.y);
    }

    private Map<?, ?> getRenderingHints() {
        AttributeSet attributes;
        FontColorSettings fcs;
        Map renderingHints = null;
        Lookup lookup = MimeLookup.getLookup((String)"text/plain");
        if (lookup != null && (fcs = (FontColorSettings)lookup.lookup(FontColorSettings.class)) != null && (attributes = fcs.getFontColors("default")) != null) {
            renderingHints = (Map)attributes.getAttribute(EditorStyleConstants.RenderingHints);
        }
        return renderingHints;
    }

    public void setHyperlinkListener(final HyperlinkListener hyperlinkListener) {
        this.term.setActionListener(new ActiveTermListener(){

            public void action(ActiveRegion r, InputEvent e) {
                if (r.isLink()) {
                    String url = (String)r.getUserObject();
                    hyperlinkListener.action(url);
                }
            }
        });
    }

    void scrollTo(Coord coord) {
        this.term.possiblyNormalize(coord);
    }

    private void applyShortcuts() {
        if (!this.termOptions.getIgnoreKeymap()) {
            HashSet<String> actions = new HashSet<String>();
            for (FileObject def : this.shortcutsDir.getChildren()) {
                try {
                    DataObject dobj = DataObject.find((FileObject)def);
                    InstanceCookie ic = (InstanceCookie)dobj.getLookup().lookup(InstanceCookie.class);
                    if (ic == null) continue;
                    actions.add(ic.instanceCreate().getClass().getName());
                }
                catch (Exception e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
            }
            this.term.setKeymap((Keymap)Lookup.getDefault().lookup(Keymap.class), actions);
            this.term.getScreen().setFocusTraversalKeysEnabled(false);
        } else {
            this.term.setKeymap(null, null);
            this.term.getScreen().setFocusTraversalKeysEnabled(true);
        }
    }

    private ActiveTerm createActiveTerminal() {
        Clipboard aSystemClipboard = (Clipboard)Lookup.getDefault().lookup(Clipboard.class);
        if (aSystemClipboard == null) {
            aSystemClipboard = this.getToolkit().getSystemClipboard();
        }
        return new MyActiveTerm(aSystemClipboard);
    }

    private static class TransferHandlerImpl
    extends TransferHandler {
        private DataFlavor dataObjectDnd = null;
        private DataFlavor multiTransferObject = null;
        private final SupportStream stream;

        public TransferHandlerImpl(SupportStream stream) {
            try {
                this.dataObjectDnd = new DataFlavor("application/x-java-openide-dataobjectdnd;class=org.openide.loaders.DataObject;mask={0}");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            try {
                this.multiTransferObject = new DataFlavor("application/x-java-openide-multinode;class=org.openide.util.datatransfer.MultiTransferObject;mask={0}");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            this.stream = stream;
        }

        private void display(List<String> strings) {
            StringBuilder sb = new StringBuilder();
            for (String string : strings) {
                sb.append('\'');
                sb.append(string);
                sb.append('\'');
                sb.append(' ');
            }
            final String str = sb.toString();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    stream.sendChars(str.toCharArray(), 0, str.length());
                }
            });
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            boolean canHandleDO = this.dataObjectDnd != null && support.isDataFlavorSupported(this.dataObjectDnd);
            boolean canHandleMTO = this.multiTransferObject != null && support.isDataFlavorSupported(this.multiTransferObject);
            boolean canHandleList = support.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
            if (canHandleDO || canHandleList) {
                return true;
            }
            if (canHandleMTO) {
                try {
                    MultiTransferObject mto = (MultiTransferObject)support.getTransferable().getTransferData(this.multiTransferObject);
                    for (int i = 0; i < mto.getCount(); ++i) {
                        if (!mto.isDataFlavorSupported(i, this.dataObjectDnd)) continue;
                        return true;
                    }
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return false;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            Transferable transferable = support.getTransferable();
            try {
                if (this.multiTransferObject != null && support.isDataFlavorSupported(this.multiTransferObject)) {
                    MultiTransferObject mto = (MultiTransferObject)transferable.getTransferData(this.multiTransferObject);
                    ArrayList<String> strings = new ArrayList<String>();
                    for (int i = 0; i < mto.getCount(); ++i) {
                        DataObject dObj;
                        FileObject fObj;
                        if (!mto.isDataFlavorSupported(i, this.dataObjectDnd) || (fObj = (FileObject)(dObj = (DataObject)mto.getTransferData(i, this.dataObjectDnd)).getLookup().lookup(FileObject.class)) == null) continue;
                        strings.add(fObj.getPath());
                    }
                    this.display(strings);
                    return true;
                }
                if (this.dataObjectDnd != null && support.isDataFlavorSupported(this.dataObjectDnd)) {
                    DataObject dObj = (DataObject)transferable.getTransferData(this.dataObjectDnd);
                    FileObject fObj = (FileObject)dObj.getLookup().lookup(FileObject.class);
                    if (fObj != null) {
                        String str = fObj.getPath();
                        this.display(Arrays.asList(str));
                        return true;
                    }
                } else if (support.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                    ArrayList<String> strings = new ArrayList<String>();
                    for (File file : list) {
                        strings.add(file.getAbsolutePath());
                    }
                    this.display(strings);
                    return true;
                }
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }
    }

    private static class SupportStream
    extends TermStream {
        private SupportStream() {
        }

        public void flush() {
            if (this.toDCE == this.toDTE) {
                this.toDCE.flush();
            } else {
                this.toDTE.flush();
                this.toDCE.flush();
            }
        }

        public void putChar(char c) {
            this.toDTE.putChar(c);
        }

        public void putChars(char[] buf, int offset, int count) {
            this.toDTE.putChars(buf, offset, count);
        }

        public void sendChar(char c) {
            this.toDCE.sendChar(c);
        }

        public void sendChars(char[] c, int offset, int count) {
            this.toDCE.sendChars(c, offset, count);
        }
    }

    private static final class MyActiveTerm
    extends ActiveTerm {
        private final Clipboard systemClipboard;

        private MyActiveTerm(Clipboard systemClipboard) {
            this.systemClipboard = systemClipboard;
        }

        public void copyToClipboard() {
            String text = this.getSelectedText();
            if (text != null) {
                StringSelection ss = new StringSelection(text);
                this.systemClipboard.setContents(ss, ss);
            }
        }
    }

    private class ShortcutsListener
    extends FileChangeAdapter {
        private ShortcutsListener() {
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
            Terminal.this.applyShortcuts();
        }

        public void fileChanged(FileEvent fe) {
            Terminal.this.applyShortcuts();
        }

        public void fileDataCreated(FileEvent fe) {
            Terminal.this.applyShortcuts();
        }

        public void fileDeleted(FileEvent fe) {
            Terminal.this.applyShortcuts();
        }

        public void fileFolderCreated(FileEvent fe) {
            Terminal.this.applyShortcuts();
        }

        public void fileRenamed(FileRenameEvent fe) {
            Terminal.this.applyShortcuts();
        }
    }

    public static interface HyperlinkListener {
        public void action(String var1);
    }

    private static class TerminalOutputEvent
    extends OutputEvent {
        private final String text;

        public TerminalOutputEvent(InputOutput io, String text) {
            super(io);
            this.text = text;
        }

        public String getLine() {
            return this.text;
        }
    }

    private class MyTermListener
    implements TermListener {
        private static final int MAX_TITLE_LENGTH = 35;
        private static final String PREFIX = "...";
        private static final String INFIX = " - ";

        private MyTermListener() {
        }

        public void sizeChanged(Dimension cells, Dimension pixels) {
            IOResizable.Size size = new IOResizable.Size(cells, pixels);
            Terminal.this.tio.pcs().firePropertyChange("IOResizable.PROP_SIZE", null, size);
        }

        public void cwdChanged(String cwd) {
            if (!Terminal.this.customTitle) {
                int newLength = PREFIX.length() + INFIX.length() + cwd.length();
                String newTitle = Terminal.this.name.concat(INFIX).concat(cwd);
                Terminal.this.updateTooltopText(newTitle);
                if (newLength > 35) {
                    newTitle = Terminal.this.name.concat(INFIX).concat(PREFIX).concat(cwd.substring(newLength - 35));
                }
                Terminal.this.updateName(newTitle);
            }
        }

        public void titleChanged(String title) {
            if (!Terminal.this.customTitle) {
                String newTitle = title;
                Terminal.this.updateTooltopText(newTitle);
                if (title.length() > 35) {
                    newTitle = PREFIX.concat(title.substring(title.length() - 35));
                }
                Terminal.this.updateName(newTitle);
            }
        }

        public void externalToolCalled(String command) {
            if (!command.startsWith("ext[::] ")) {
                return;
            }
            if (!(command = command.substring("ext[::] ".length())).startsWith("ideopen")) {
                return;
            }
            ExternalCommandActionProvider.getProvider(command).handle(command, Lookups.fixed((Object[])new Object[]{Terminal.this.getCwd(), Terminal.this.term}));
        }
    }

    private class CallBacks
    implements IOContainer.CallBacks,
    Lookup.Provider {
        private final Lookup lookup = Lookups.fixed((Object[])new Object[]{new MyIOVisibilityControl()});

        private CallBacks() {
        }

        public Lookup getLookup() {
            return this.lookup;
        }

        public void closed() {
            Terminal.this.setVisibleInContainer(false);
        }

        public void selected() {
        }

        public void activated() {
        }

        public void deactivated() {
        }

        private class MyIOVisibilityControl
        extends IOVisibilityControl {
            private MyIOVisibilityControl() {
            }

            @Override
            protected boolean okToClose() {
                if (Terminal.this.isClosedUnconditionally()) {
                    return true;
                }
                return Terminal.this.okToHide();
            }

            @Override
            protected boolean isClosable() {
                if (Terminal.this.isClosedUnconditionally()) {
                    return true;
                }
                return Terminal.this.isClosable();
            }
        }
    }

    private class TermOptionsPCL
    implements PropertyChangeListener {
        private TermOptionsPCL() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Terminal.this.applyTermOptions(false);
        }
    }
}

