/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.team.commons.treelist;

import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.SwingUtilities;
import org.netbeans.modules.team.commons.treelist.ListNode;
import org.netbeans.modules.team.commons.treelist.TreeListListener;
import org.netbeans.modules.team.commons.treelist.TreeListModelListener;
import org.netbeans.modules.team.commons.treelist.TreeListNode;

public class TreeListModel
extends AbstractListModel
implements TreeListListener {
    private final ArrayList<TreeListNode> nodes = new ArrayList(500);
    private List<TreeListModelListener> modelListeners = new ArrayList<TreeListModelListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSize() {
        ArrayList<TreeListNode> arrayList = this.nodes;
        synchronized (arrayList) {
            return this.nodes.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getElementAt(int index) {
        ArrayList<TreeListNode> arrayList = this.nodes;
        synchronized (arrayList) {
            if (index < 0 || index >= this.nodes.size()) {
                return null;
            }
            return this.nodes.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRoot(int rootIndex, TreeListNode root) {
        int firstIndex = -1;
        int lastIndex = -1;
        ArrayList<TreeListNode> arrayList = this.nodes;
        synchronized (arrayList) {
            int parentIndex;
            int index = this.getAllNodesIndex(rootIndex);
            if (index < 0 || index >= this.nodes.size()) {
                this.nodes.add(root);
            } else {
                this.nodes.add(index, root);
            }
            firstIndex = parentIndex = this.nodes.indexOf(root);
            root.setListener(this);
            root.attach();
            if (root.isExpanded()) {
                if (!root.getChildren().isEmpty()) {
                    lastIndex = this.addNodes(parentIndex + 1, root.getChildren()) - 1;
                } else {
                    root.setExpanded(true);
                }
            }
        }
        if (firstIndex >= 0) {
            if (lastIndex < firstIndex) {
                lastIndex = firstIndex;
            }
            this.fireIntervalAdded(this, firstIndex, lastIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRoot(TreeListNode root) {
        int firstIndex = -1;
        int lastIndex = -1;
        ArrayList<TreeListNode> arrayList = this.nodes;
        synchronized (arrayList) {
            firstIndex = this.nodes.indexOf(root);
            if (firstIndex < 0) {
                root.dispose();
                return;
            }
            ArrayList<TreeListNode> toRemove = this.findDescendants(root);
            if (null == toRemove) {
                toRemove = new ArrayList(1);
            }
            toRemove.add(0, root);
            lastIndex = this.nodes.indexOf(toRemove.get(toRemove.size() - 1));
            for (TreeListNode node : toRemove) {
                node.dispose();
            }
            this.nodes.removeAll(toRemove);
        }
        if (firstIndex >= 0) {
            this.fireIntervalRemoved(this, firstIndex, lastIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        int lastIndex = -1;
        ArrayList<TreeListNode> arrayList = this.nodes;
        synchronized (arrayList) {
            lastIndex = this.nodes.size() - 1;
            for (TreeListNode node : this.nodes) {
                node.dispose();
            }
            this.nodes.clear();
        }
        this.fireIntervalRemoved(this, 0, lastIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TreeListNode> getRootNodes() {
        ArrayList<TreeListNode> res = new ArrayList<TreeListNode>(this.getSize());
        ArrayList<TreeListNode> arrayList = this.nodes;
        synchronized (arrayList) {
            for (TreeListNode n : this.nodes) {
                if (null != n.getParent()) continue;
                res.add(n);
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TreeListNode> getAllNodes() {
        ArrayList<TreeListNode> arrayList = this.nodes;
        synchronized (arrayList) {
            ArrayList<TreeListNode> res = new ArrayList<TreeListNode>(this.nodes);
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeChildrenOf(TreeListNode parent) {
        int firstIndex = -1;
        int lastIndex = -1;
        ArrayList<TreeListNode> arrayList = this.nodes;
        synchronized (arrayList) {
            ArrayList<TreeListNode> toRemove = this.findDescendants(parent);
            if (null == toRemove) {
                return;
            }
            firstIndex = this.nodes.indexOf(toRemove.get(0));
            lastIndex = this.nodes.indexOf(toRemove.get(toRemove.size() - 1));
            for (TreeListNode node : toRemove) {
                node.dispose();
            }
            this.nodes.removeAll(toRemove);
        }
        if (firstIndex >= 0) {
            this.fireIntervalRemoved(this, firstIndex, lastIndex);
        }
    }

    private ArrayList<TreeListNode> findDescendants(TreeListNode parent) {
        TreeListNode child;
        ArrayList<TreeListNode> descendants = null;
        int parentIndex = this.nodes.indexOf(parent);
        if (parentIndex < 0) {
            return null;
        }
        for (int i = parentIndex + 1; i < this.nodes.size() && (child = this.nodes.get(i)).isDescendantOf(parent); ++i) {
            if (null == descendants) {
                descendants = new ArrayList<TreeListNode>(20);
            }
            descendants.add(child);
        }
        return descendants;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addChildrenOf(TreeListNode parent) {
        int firstIndex = -1;
        int lastIndex = -1;
        List<TreeListNode> children = parent.getChildren();
        if (children == null || children.isEmpty()) {
            return;
        }
        ArrayList<TreeListNode> arrayList = this.nodes;
        synchronized (arrayList) {
            firstIndex = this.nodes.indexOf(parent);
            if (firstIndex < 0) {
                return;
            }
            lastIndex = this.addNodes(++firstIndex, children) - 1;
        }
        if (firstIndex >= 0) {
            if (lastIndex < firstIndex) {
                lastIndex = firstIndex;
            }
            this.fireIntervalAdded(this, firstIndex, lastIndex);
            this.fireNodeExpanded(parent);
        }
    }

    private int addNodes(int insertPoint, List<TreeListNode> newNodes) {
        for (int i = 0; i < newNodes.size(); ++i) {
            TreeListNode node = newNodes.get(i);
            if (this.nodes.contains(node)) continue;
            node.setListener(this);
            node.attach();
            this.nodes.add(insertPoint++, node);
            if (!node.isExpanded()) continue;
            if (!node.getChildren().isEmpty()) {
                insertPoint = this.addNodes(insertPoint, node.getChildren());
                continue;
            }
            node.setExpanded(true);
        }
        return insertPoint;
    }

    @Override
    public void childrenRemoved(TreeListNode parent) {
        this.removeChildrenOf(parent);
    }

    @Override
    public void childrenAdded(TreeListNode parent) {
        this.addChildrenOf(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void contentChanged(ListNode node) {
        int index = -1;
        ArrayList<TreeListNode> arrayList = this.nodes;
        synchronized (arrayList) {
            index = this.nodes.indexOf(node);
        }
        if (index >= 0) {
            this.fireContentsChanged(this, index, index);
        }
    }

    @Override
    public void contentSizeChanged(ListNode node) {
    }

    @Override
    protected void fireContentsChanged(final Object source, final int index0, final int index1) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TreeListModel.super.fireContentsChanged(source, index0, index1);
                }
            });
        } else {
            super.fireContentsChanged(source, index0, index1);
        }
    }

    @Override
    protected void fireIntervalAdded(final Object source, final int index0, final int index1) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TreeListModel.super.fireIntervalAdded(source, index0, index1);
                }
            });
        } else {
            super.fireIntervalAdded(source, index0, index1);
        }
    }

    @Override
    protected void fireIntervalRemoved(final Object source, final int index0, final int index1) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TreeListModel.super.fireIntervalRemoved(source, index0, index1);
                }
            });
        } else {
            super.fireIntervalRemoved(source, index0, index1);
        }
    }

    private int getAllNodesIndex(int rootIndex) {
        List<TreeListNode> rootNodes = this.getRootNodes();
        if (rootIndex < 0 || rootIndex >= rootNodes.size()) {
            return -1;
        }
        TreeListNode rootNode = rootNodes.get(rootIndex);
        int index = this.nodes.indexOf(rootNode);
        return index;
    }

    public void addModelListener(TreeListModelListener listener) {
        this.modelListeners.add(listener);
    }

    public void removeModelListener(TreeListModelListener listener) {
        this.modelListeners.remove(listener);
    }

    private void fireNodeExpanded(TreeListNode node) {
        for (TreeListModelListener listener : this.modelListeners) {
            listener.nodeExpanded(node);
        }
    }
}

