/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client.cli.commands;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.netbeans.modules.subversion.client.cli.SvnCommand;
import org.openide.xml.XMLUtil;
import org.tigris.subversion.svnclientadapter.ISVNDirEntry;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ListCommand
extends SvnCommand {
    private static DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private byte[] output;
    private final SVNUrl url;
    private final SVNRevision revision;
    private final boolean recursive;

    public ListCommand(SVNUrl url, SVNRevision revision, boolean recursive) {
        this.url = url;
        this.revision = revision;
        this.recursive = recursive;
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    @Override
    protected boolean hasBinaryOutput() {
        return true;
    }

    @Override
    protected boolean notifyOutput() {
        return false;
    }

    @Override
    protected int getCommand() {
        return 11;
    }

    @Override
    public void prepareCommand(SvnCommand.Arguments arguments) throws IOException {
        arguments.add("list");
        if (this.recursive) {
            arguments.add("-R");
        }
        arguments.add("--xml");
        arguments.add(this.revision);
        arguments.add(this.url);
    }

    @Override
    public void output(byte[] bytes) {
        this.output = bytes;
    }

    public ISVNDirEntry[] getEntries() throws SVNClientException {
        if (this.output == null || this.output.length == 0) {
            return new ISVNDirEntry[0];
        }
        try {
            XMLReader saxReader = XMLUtil.createXMLReader();
            XmlEntriesHandler xmlEntriesHandler = new XmlEntriesHandler();
            saxReader.setContentHandler(xmlEntriesHandler);
            saxReader.setErrorHandler(xmlEntriesHandler);
            InputSource source = new InputSource(new ByteArrayInputStream(this.output));
            saxReader.parse(source);
            return xmlEntriesHandler.getEntryAttributes();
        }
        catch (SAXException ex) {
            throw new SVNClientException((Throwable)ex);
        }
        catch (IOException ex) {
            throw new SVNClientException((Throwable)ex);
        }
    }

    private class XmlEntriesHandler
    extends DefaultHandler {
        private static final String LIST_ELEMENT_NAME = "list";
        private static final String ENTRY_ELEMENT_NAME = "entry";
        private static final String NAME_ELEMENT_NAME = "name";
        private static final String SIZE_ELEMENT_NAME = "size";
        private static final String COMMIT_ELEMENT_NAME = "commit";
        private static final String AUTHOR_ELEMENT_NAME = "author";
        private static final String DATE_ELEMENT_NAME = "date";
        private static final String KIND_ATTRIBUTE = "kind";
        private static final String PATH_ATTRIBUTE = "path";
        private static final String REVISION_ATTRIBUTE = "revision";
        private String REVISION_ATTR = "revision_attr";
        private String KIND_ATTR = "kind_attr";
        private String PATH_ATTR = "path_attr";
        private List<ISVNDirEntry> entries = new ArrayList<ISVNDirEntry>();
        private Map<String, String> values;
        private String tag;

        private XmlEntriesHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes elementAttributes) throws SAXException {
            this.tag = qName.trim();
            if (ENTRY_ELEMENT_NAME.equals(qName)) {
                this.values = new HashMap<String, String>();
                this.values.put(this.KIND_ATTR, elementAttributes.getValue(KIND_ATTRIBUTE));
            } else if (COMMIT_ELEMENT_NAME.equals(qName)) {
                this.values.put(this.REVISION_ATTR, elementAttributes.getValue(REVISION_ATTRIBUTE));
            }
            if (this.values != null) {
                this.values.put(this.tag, "");
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.values == null || this.tag == null) {
                return;
            }
            String s = this.toString(length, ch, start);
            this.values.put(this.tag, s);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.tag = null;
            if (ENTRY_ELEMENT_NAME.equals(qName)) {
                if (this.values != null) {
                    String name = this.values.get(NAME_ELEMENT_NAME);
                    if (name == null) {
                        throw new SAXException("'name' tag expected under 'entry'");
                    }
                    String commit = this.values.get(COMMIT_ELEMENT_NAME);
                    if (commit == null) {
                        throw new SAXException("'commit' tag expected under 'entry'");
                    }
                    String author = this.values.get(AUTHOR_ELEMENT_NAME);
                    Date date = null;
                    String dateValue = this.values.get(DATE_ELEMENT_NAME);
                    if (dateValue != null) {
                        try {
                            date = dateFormat.parse(dateValue);
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                    }
                    SVNRevision.Number revision = null;
                    String revisionValue = this.values.get(this.REVISION_ATTR);
                    if (revisionValue != null && !revisionValue.trim().equals("")) {
                        try {
                            revision = new SVNRevision.Number(Long.parseLong(revisionValue));
                        }
                        catch (NumberFormatException e) {
                            revision = new SVNRevision.Number(-1L);
                        }
                    }
                    long size = 0L;
                    String kindValue = this.values.get(this.KIND_ATTR);
                    SVNNodeKind kind = SVNNodeKind.UNKNOWN;
                    if ("file".equals(kindValue)) {
                        kind = SVNNodeKind.FILE;
                        String sizeValue = this.values.get(SIZE_ELEMENT_NAME);
                        if (sizeValue == null) {
                            throw new SAXException("'size' tag expected under 'entry'");
                        }
                        try {
                            size = Long.parseLong(sizeValue);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    } else if ("dir".equals(kindValue)) {
                        kind = SVNNodeKind.DIR;
                    }
                    this.entries.add(new DirEntry(name, date, revision, false, author, kind, size));
                }
                this.values = null;
            }
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            throw e;
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            throw e;
        }

        public ISVNDirEntry[] getEntryAttributes() {
            return this.entries != null ? this.entries.toArray(new ISVNDirEntry[0]) : new ISVNDirEntry[]{};
        }

        private String toString(int length, char[] ch, int start) {
            char[] c = new char[length];
            System.arraycopy(ch, start, c, 0, length);
            return new String(c);
        }
    }

    private class DirEntry
    implements ISVNDirEntry {
        private String path;
        private Date lastChangedDate;
        private SVNRevision.Number lastChangedRevision;
        private boolean hasProps;
        private String lastCommitAuthor;
        private SVNNodeKind kind;
        private long size;

        public DirEntry(String path, Date lastChangedDate, SVNRevision.Number lastChangedRevision, boolean hasProps, String lastCommitAuthor, SVNNodeKind kind, long size) {
            this.path = path;
            this.lastChangedDate = lastChangedDate;
            this.lastChangedRevision = lastChangedRevision;
            this.hasProps = hasProps;
            this.lastCommitAuthor = lastCommitAuthor;
            this.kind = kind;
            this.size = size;
        }

        public String getPath() {
            return this.path;
        }

        public Date getLastChangedDate() {
            return this.lastChangedDate;
        }

        public SVNRevision.Number getLastChangedRevision() {
            return this.lastChangedRevision;
        }

        public boolean getHasProps() {
            return this.hasProps;
        }

        public String getLastCommitAuthor() {
            return this.lastCommitAuthor;
        }

        public SVNNodeKind getNodeKind() {
            return this.kind;
        }

        public long getSize() {
            return this.size;
        }
    }
}

