/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion;

import java.io.File;
import java.io.Serializable;
import java.util.ResourceBundle;
import java.util.logging.Level;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.WorkingCopyAttributesCache;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;

public class FileInformation
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int STATUS_UNKNOWN = 0;
    public static final int STATUS_NOTVERSIONED_NOTMANAGED = 1;
    public static final int STATUS_NOTVERSIONED_EXCLUDED = 2;
    public static final int STATUS_NOTVERSIONED_NEWLOCALLY = 4;
    public static final int STATUS_VERSIONED_UPTODATE = 8;
    public static final int STATUS_VERSIONED_MODIFIEDLOCALLY_CONTENT = 16;
    public static final int STATUS_VERSIONED_MODIFIEDINREPOSITORY = 32;
    public static final int STATUS_VERSIONED_CONFLICT_CONTENT = 64;
    public static final int STATUS_VERSIONED_MERGE = 128;
    public static final int STATUS_VERSIONED_REMOVEDLOCALLY = 256;
    public static final int STATUS_VERSIONED_NEWINREPOSITORY = 512;
    public static final int STATUS_VERSIONED_REMOVEDINREPOSITORY = 1024;
    public static final int STATUS_VERSIONED_DELETEDLOCALLY = 2048;
    public static final int STATUS_VERSIONED_ADDEDLOCALLY = 4096;
    public static final int STATUS_LOCKED = 8192;
    public static final int STATUS_VERSIONED_CONFLICT_TREE = 16384;
    public static final int STATUS_VERSIONED_CONFLICT = 16448;
    public static final int STATUS_LOCKED_REMOTELY = 32768;
    public static final int STATUS_VERSIONED_MODIFIEDLOCALLY_PROPERTY = 65536;
    public static final int STATUS_VERSIONED_MODIFIEDLOCALLY = 65552;
    public static final int STATUS_ALL = -1;
    public static final int STATUS_MANAGED = -2;
    public static final int STATUS_VERSIONED = 89592;
    public static final int STATUS_IN_REPOSITORY = 86008;
    public static final int STATUS_LOCAL_CHANGE = 88532;
    public static final int STATUS_REVERTIBLE_CHANGE = 88528;
    public static final int STATUS_REMOTE_CHANGE = 1696;
    private final int status;
    private final int propStatus;
    private transient ISVNStatus entry;
    private final boolean isDirectory;
    private static final String STATUS_UNKNOWN_EXT = "W";
    private static final String STATUS_NOTVERSIONED_NOTMANAGED_EXT = "Z";
    private static final String STATUS_NOTVERSIONED_EXCLUDED_EXT = "I";
    private static final String STATUS_NOTVERSIONED_NEWLOCALLY_EXT = "?";
    private static final String STATUS_VERSIONED_UPTODATE_EXT = "S";
    private static final String STATUS_VERSIONED_MODIFIEDLOCALLY_EXT = "M";
    private static final String STATUS_VERSIONED_MODIFIEDINREPOSITORY_EXT = "G";
    private static final String STATUS_VERSIONED_CONFLICT_EXT = "C";
    private static final String STATUS_VERSIONED_MERGE_EXT = "P";
    private static final String STATUS_VERSIONED_REMOVEDLOCALLY_EXT = "R";
    private static final String STATUS_VERSIONED_NEWINREPOSITORY_EXT = "N";
    private static final String STATUS_VERSIONED_REMOVEDINREPOSITORY_EXT = "D";
    private static final String STATUS_VERSIONED_DELETEDLOCALLY_EXT = "E";
    private static final String STATUS_VERSIONED_ADDEDLOCALLY_EXT = "A";

    public FileInformation() {
        this.status = 0;
        this.propStatus = 0;
        this.isDirectory = false;
    }

    private FileInformation(int status, int propStatus, ISVNStatus entry, boolean isDirectory) {
        this.status = status;
        this.propStatus = propStatus;
        this.entry = entry;
        this.isDirectory = isDirectory;
    }

    FileInformation(int status, ISVNStatus entry) {
        this(status, 0, entry, entry.getNodeKind() == SVNNodeKind.DIR);
    }

    FileInformation(int status, boolean isDirectory) {
        this(status, 0, null, isDirectory);
    }

    public FileInformation(int status, int propStatus, boolean isDirectory) {
        this(status, propStatus, null, isDirectory);
    }

    public int getStatus() {
        return this.status;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public ISVNStatus getEntry(File file) {
        if (!(file == null || this.entry != null && this.entry.getFile().equals(file))) {
            this.readEntry(file);
        }
        return this.entry;
    }

    private void readEntry(File file) {
        block2: {
            try {
                this.entry = SvnUtils.getSingleStatus(Subversion.getInstance().getClient(false), file);
            }
            catch (SVNClientException e) {
                if (WorkingCopyAttributesCache.getInstance().isSuppressed(e)) break block2;
                Subversion.LOG.log(Level.INFO, null, e);
            }
        }
    }

    public String getStatusText() {
        return this.getStatusText(-1);
    }

    public String getStatusText(int displayStatuses) {
        int status = this.status & displayStatuses;
        ResourceBundle loc = NbBundle.getBundle(FileInformation.class);
        String retval = status == 0 ? loc.getString("CTL_FileInfoStatus_Unknown") : (FileInformation.match(status, 2) ? loc.getString("CTL_FileInfoStatus_Excluded") : (FileInformation.match(status, 4) ? loc.getString("CTL_FileInfoStatus_NewLocally") : (FileInformation.match(status, 4096) ? (this.entry != null && this.entry.isCopied() ? loc.getString("CTL_FileInfoStatus_AddedLocallyCopied") : loc.getString("CTL_FileInfoStatus_AddedLocally")) : (FileInformation.match(status, 8) ? loc.getString("CTL_FileInfoStatus_UpToDate") : (FileInformation.match(status, 16384) ? loc.getString("CTL_FileInfoStatus_TreeConflict") : (FileInformation.match(status, 16448) ? loc.getString("CTL_FileInfoStatus_Conflict") : (FileInformation.match(status, 128) ? loc.getString("CTL_FileInfoStatus_Merge") : (FileInformation.match(status, 2048) ? loc.getString("CTL_FileInfoStatus_DeletedLocally") : (FileInformation.match(status, 256) ? loc.getString("CTL_FileInfoStatus_RemovedLocally") : (FileInformation.match(status, 65552) ? loc.getString("CTL_FileInfoStatus_ModifiedLocally") : (FileInformation.match(status, 512) ? loc.getString("CTL_FileInfoStatus_NewInRepository") : (FileInformation.match(status, 32) ? loc.getString("CTL_FileInfoStatus_ModifiedInRepository") : (FileInformation.match(status, 1024) ? loc.getString("CTL_FileInfoStatus_RemovedInRepository") : "")))))))))))));
        if ((this.status & 0x2000) != 0) {
            if (!retval.isEmpty()) {
                retval = retval + "/";
            }
            retval = retval + loc.getString("CTL_FileInfoStatus_LockedLocally");
        } else if ((this.status & 0x8000) != 0) {
            if (!retval.isEmpty()) {
                retval = retval + "/";
            }
            retval = retval + loc.getString("CTL_FileInfoStatus_LockedRemotely");
        }
        return retval;
    }

    public String getShortStatusText() {
        ResourceBundle loc = NbBundle.getBundle(FileInformation.class);
        if (FileInformation.match(this.status, 2)) {
            return loc.getString("CTL_FileInfoStatus_Excluded_Short");
        }
        if (FileInformation.match(this.status, 4)) {
            return loc.getString("CTL_FileInfoStatus_NewLocally_Short");
        }
        if (FileInformation.match(this.status, 4096)) {
            if (this.entry != null && this.entry.isCopied()) {
                return loc.getString("CTL_FileInfoStatus_AddedLocallyCopied_Short");
            }
            return loc.getString("CTL_FileInfoStatus_AddedLocally_Short");
        }
        if (this.status == 256) {
            return loc.getString("CTL_FileInfoStatus_RemovedLocally_Short");
        }
        if (this.status == 2048) {
            return loc.getString("CTL_FileInfoStatus_DeletedLocally_Short");
        }
        if (FileInformation.match(this.status, 65552)) {
            return loc.getString("CTL_FileInfoStatus_ModifiedLocally_Short");
        }
        if (FileInformation.match(this.status, 16384)) {
            return loc.getString("CTL_FileInfoStatus_TreeConflict_Short");
        }
        if (FileInformation.match(this.status, 16448)) {
            return loc.getString("CTL_FileInfoStatus_Conflict_Short");
        }
        return "";
    }

    private static boolean match(int status, int mask) {
        return (status & mask) != 0;
    }

    public String toString() {
        return "Text: " + this.status + " " + this.getStatusText(this.status) + "\nProp: " + this.propStatus + " " + this.getStatusText(this.propStatus);
    }
}

