/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.netbeans.modules.properties.BundleStructure;
import org.netbeans.modules.properties.Element;
import org.netbeans.modules.properties.FindPerformer;
import org.netbeans.modules.properties.MultiBundleStructure;
import org.netbeans.modules.properties.PropertiesDataObject;
import org.netbeans.modules.properties.PropertiesFileEntry;
import org.netbeans.modules.properties.PropertiesRequestProcessor;
import org.netbeans.modules.properties.PropertiesStructure;
import org.netbeans.modules.properties.PropertiesTableCellEditor;
import org.netbeans.modules.properties.PropertiesTableModel;
import org.netbeans.modules.properties.PropertyPanel;
import org.netbeans.modules.properties.TableViewSettings;
import org.netbeans.modules.properties.Util;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.loaders.MultiDataObject;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;

public class BundleEditPanel
extends JPanel
implements PropertyChangeListener {
    private BundleStructure structure;
    private DocumentListener listener;
    private static TableViewSettings settings;
    static final long serialVersionUID = -843810329041244483L;
    private Element.ItemElem lastSelectedBundleKey;
    private int lastSelectedColumn;
    private boolean selectionUpdateDisabled = false;
    private JButton addButton;
    private JCheckBox autoResizeCheck;
    private JPanel buttonPanel;
    private JLabel commentLabel;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JButton removeButton;
    private JScrollPane scrollPane;
    private JTable table;
    private JPanel tablePanel;
    private JTextArea textComment;
    private JTextArea textValue;
    private JLabel valueLabel;
    private JPanel valuePanel;

    @Deprecated
    public BundleEditPanel(final PropertiesDataObject obj, PropertiesTableModel propTableModel) {
        this.structure = obj.getBundleStructure();
        this.initComponents();
        this.initAccessibility();
        this.initSettings();
        this.table.setColumnModel(new TableViewColumnModel());
        JTableHeader header = this.table.getTableHeader();
        header.setDefaultRenderer(new TableViewHeaderRenderer(obj, header.getDefaultRenderer()));
        this.table.setModel(propTableModel);
        JTextField textField = new JTextField();
        textField.getDocument().putProperty("filterNewlines", Boolean.FALSE);
        textField.setBorder(new LineBorder(Color.black));
        textField.getAccessibleContext().setAccessibleName(NbBundle.getBundle(BundleEditPanel.class).getString("ACSN_CellEditor"));
        textField.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(BundleEditPanel.class).getString("ACSD_CellEditor"));
        this.listener = new ModifiedListener();
        this.table.setDefaultEditor(PropertiesTableModel.StringPair.class, new PropertiesTableCellEditor(textField, this.textComment, this.textValue, this.valueLabel, this.listener));
        this.table.setDefaultRenderer(PropertiesTableModel.StringPair.class, new TableViewRenderer());
        this.updateAddButton();
        this.table.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("tableCellEditor")) {
                    BundleEditPanel.this.updateEnabled();
                } else if (evt.getPropertyName().equals("model")) {
                    BundleEditPanel.this.updateAddButton();
                } else if (evt.getPropertyName().equals("marginChanged") || evt.getPropertyName().equals("columnMoved") || evt.getPropertyName().equals("componentHidden")) {
                    BundleEditPanel.this.saveEditorValue(false);
                }
            }
        });
        this.table.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TableColumnModel colModel = BundleEditPanel.this.table.getColumnModel();
                int columnModelIndex = colModel.getColumnIndexAtX(e.getX());
                if (columnModelIndex < 0) {
                    return;
                }
                int modelIndex = colModel.getColumn(columnModelIndex).getModelIndex();
                if (modelIndex < 0) {
                    return;
                }
                obj.getBundleStructure().sort(modelIndex);
            }
        });
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                final boolean correctCellSelection = !BundleEditPanel.this.selectionUpdateDisabled;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BundleEditPanel.this.updateSelection(correctCellSelection);
                    }
                });
            }
        });
    }

    public BundleEditPanel(final BundleStructure structure, PropertiesTableModel propTableModel) {
        this.structure = structure;
        this.initComponents();
        this.initAccessibility();
        this.initSettings();
        this.table.setColumnModel(new TableViewColumnModel());
        JTableHeader header = this.table.getTableHeader();
        header.setDefaultRenderer(new TableViewHeaderRenderer(structure, header.getDefaultRenderer()));
        this.table.setModel(propTableModel);
        JTextField textField = new JTextField();
        textField.getDocument().putProperty("filterNewlines", Boolean.FALSE);
        textField.setBorder(new LineBorder(Color.black));
        textField.getAccessibleContext().setAccessibleName(NbBundle.getBundle(BundleEditPanel.class).getString("ACSN_CellEditor"));
        textField.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(BundleEditPanel.class).getString("ACSD_CellEditor"));
        this.listener = new ModifiedListener();
        this.table.setDefaultEditor(PropertiesTableModel.StringPair.class, new PropertiesTableCellEditor(textField, this.textComment, this.textValue, this.valueLabel, this.listener));
        this.table.setDefaultRenderer(PropertiesTableModel.StringPair.class, new TableViewRenderer());
        this.updateAddButton();
        this.table.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("tableCellEditor")) {
                    BundleEditPanel.this.updateEnabled();
                } else if (evt.getPropertyName().equals("model")) {
                    BundleEditPanel.this.updateAddButton();
                } else if (evt.getPropertyName().equals("marginChanged") || evt.getPropertyName().equals("columnMoved") || evt.getPropertyName().equals("componentHidden")) {
                    BundleEditPanel.this.saveEditorValue(false);
                    if (evt.getPropertyName().equals("columnMoved") && evt.getOldValue() != null && evt.getNewValue() != null) {
                        int fromIndex = (Integer)evt.getOldValue();
                        int toIndex = (Integer)evt.getNewValue();
                        if (fromIndex != 0 && toIndex != 0) {
                            ((MultiBundleStructure)structure).moveEntry(fromIndex - 1, toIndex - 1);
                        }
                    }
                }
            }
        });
        this.table.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TableColumnModel colModel = BundleEditPanel.this.table.getColumnModel();
                int columnModelIndex = colModel.getColumnIndexAtX(e.getX());
                if (columnModelIndex < 0) {
                    return;
                }
                int modelIndex = columnModelIndex;
                if (modelIndex < 0) {
                    return;
                }
                BundleEditPanel.this.saveEditorValue(false);
                structure.sort(modelIndex);
            }
        });
        ListSelectionListener listSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                final boolean correctCellSelection = !BundleEditPanel.this.selectionUpdateDisabled;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BundleEditPanel.this.updateSelection(correctCellSelection);
                    }
                });
            }
        };
        this.table.getColumnModel().getSelectionModel().addListSelectionListener(listSelectionListener);
        this.table.getSelectionModel().addListSelectionListener(listSelectionListener);
    }

    protected void stopEditing() {
        this.saveEditorValue(true);
    }

    protected void saveEditorValue(boolean stopEditing) {
        if (!this.table.isEditing()) {
            return;
        }
        TableCellEditor cellEdit = this.table.getCellEditor();
        if (cellEdit != null) {
            if (stopEditing) {
                cellEdit.stopCellEditing();
            } else {
                int row = this.table.getEditingRow();
                int col = this.table.getEditingColumn();
                if (row != -1 && col != -1) {
                    this.table.setValueAt(cellEdit.getCellEditorValue(), row, col);
                }
            }
        }
    }

    private void updateEnabled() {
        this.textValue.setEditable(this.table.isEditing());
        this.textValue.setEnabled(this.table.isEditing());
        if (this.table.isEditing()) {
            PropertiesTableModel.StringPair sp = (PropertiesTableModel.StringPair)this.table.getCellEditor().getCellEditorValue();
            this.textComment.setEditable(sp.isCommentEditable());
            this.textComment.setEnabled(sp.isCommentEditable());
        } else {
            this.textComment.setEditable(false);
            this.textComment.setEnabled(false);
        }
    }

    private void updateSelection(boolean correctCellSelection) {
        String comment;
        String value;
        int row = this.table.getSelectedRow();
        int column = this.table.getSelectedColumn();
        if (row == -1 && correctCellSelection) {
            final Element.ItemElem ex = this.lastSelectedBundleKey;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    String key;
                    int idx;
                    if (ex == null) {
                        return;
                    }
                    String[] keys = BundleEditPanel.this.structure.getKeys();
                    for (idx = 0; idx < keys.length && !(key = keys[idx]).equals(ex.getKey()); ++idx) {
                    }
                    if (idx < keys.length) {
                        BundleEditPanel.this.table.requestFocusInWindow();
                        Rectangle rect = BundleEditPanel.this.table.getCellRect(idx, 0, true);
                        BundleEditPanel.this.table.scrollRectToVisible(rect);
                        BundleEditPanel.this.table.changeSelection(idx, BundleEditPanel.this.lastSelectedColumn, false, false);
                    }
                }
            });
        }
        this.lastSelectedColumn = column;
        this.removeButton.setEnabled(row >= 0 && !this.structure.isReadOnly());
        if (column == -1) {
            value = "";
            comment = "";
            this.lastSelectedBundleKey = null;
        } else if (column == 0) {
            Element.ItemElem elem = this.structure.getItem(0, row);
            value = this.structure.keyAt(row);
            this.lastSelectedBundleKey = elem;
            comment = elem != null ? elem.getComment() : "";
        } else {
            Element.ItemElem elem = this.structure.getItem(column - 1, row);
            if (elem != null) {
                value = elem.getValue();
                comment = elem.getComment();
            } else {
                value = "";
                comment = "";
            }
            this.lastSelectedBundleKey = elem;
        }
        this.textValue.getDocument().removeDocumentListener(this.listener);
        this.textComment.getDocument().removeDocumentListener(this.listener);
        this.textValue.setText(value);
        this.textComment.setText(comment);
        this.textValue.getDocument().addDocumentListener(this.listener);
        this.textComment.getDocument().addDocumentListener(this.listener);
    }

    private void updateAddButton() {
        this.addButton.setEnabled(!this.structure.isReadOnly());
    }

    public JTable getTable() {
        return this.table;
    }

    private void initSettings() {
        settings = TableViewSettings.getDefault();
        settings.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)settings));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.repaint();
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(BundleEditPanel.class).getString("ACS_BundleEditPanel"));
        this.table.getAccessibleContext().setAccessibleName(NbBundle.getBundle(BundleEditPanel.class).getString("ACSN_CTL_Table"));
        this.table.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(BundleEditPanel.class).getString("ACSD_CTL_Table"));
        this.textValue.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(BundleEditPanel.class).getString("ACS_CTL_TEXTVALUE"));
        this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(BundleEditPanel.class).getString("ACS_LBL_AddPropertyButton"));
        this.textComment.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(BundleEditPanel.class).getString("ACS_CTL_TEXTCOMMENT"));
        this.autoResizeCheck.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(BundleEditPanel.class).getString("ACS_CTL_AutoResize"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(BundleEditPanel.class).getString("ACS_LBL_RemovePropertyButton"));
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.table.requestFocusInWindow();
    }

    private void initComponents() {
        this.tablePanel = new JPanel();
        this.scrollPane = new JScrollPane();
        this.table = new BundleTable();
        this.valuePanel = new JPanel();
        this.commentLabel = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.textComment = new JTextArea();
        this.valueLabel = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.textValue = new JTextArea();
        this.buttonPanel = new JPanel();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.autoResizeCheck = new JCheckBox();
        this.setFocusCycleRoot(true);
        this.setLayout(new GridBagLayout());
        this.tablePanel.setLayout(new GridBagLayout());
        this.table.setCellSelectionEnabled(true);
        this.scrollPane.setViewportView(this.table);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.tablePanel.add((Component)this.scrollPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.tablePanel, gridBagConstraints);
        this.valuePanel.setLayout(new GridBagLayout());
        this.commentLabel.setLabelFor(this.textComment);
        Mnemonics.setLocalizedText((JLabel)this.commentLabel, (String)NbBundle.getBundle(BundleEditPanel.class).getString("LBL_CommentLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(11, 11, 0, 0);
        this.valuePanel.add((Component)this.commentLabel, gridBagConstraints);
        this.textComment.setEditable(false);
        this.textComment.setLineWrap(true);
        this.textComment.setRows(3);
        this.textComment.setEnabled(false);
        this.jScrollPane2.setViewportView(this.textComment);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(11, 11, 0, 0);
        this.valuePanel.add((Component)this.jScrollPane2, gridBagConstraints);
        this.valueLabel.setLabelFor(this.textValue);
        Mnemonics.setLocalizedText((JLabel)this.valueLabel, (String)NbBundle.getBundle(BundleEditPanel.class).getString("LBL_ValueLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(11, 11, 11, 0);
        this.valuePanel.add((Component)this.valueLabel, gridBagConstraints);
        this.textValue.setEditable(false);
        this.textValue.setLineWrap(true);
        this.textValue.setRows(3);
        this.textValue.setEnabled(false);
        this.jScrollPane3.setViewportView(this.textValue);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(7, 11, 11, 0);
        this.valuePanel.add((Component)this.jScrollPane3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.valuePanel, gridBagConstraints);
        this.buttonPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getBundle(BundleEditPanel.class).getString("LBL_AddPropertyButton"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BundleEditPanel.this.addButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        this.buttonPanel.add((Component)this.addButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getBundle(BundleEditPanel.class).getString("LBL_RemovePropertyButton"));
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BundleEditPanel.this.removeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = new Insets(5, 11, 11, 11);
        this.buttonPanel.add((Component)this.removeButton, gridBagConstraints);
        this.autoResizeCheck.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.autoResizeCheck, (String)NbBundle.getBundle(BundleEditPanel.class).getString("CTL_AutoResize"));
        this.autoResizeCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BundleEditPanel.this.autoResizeCheckActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.buttonPanel.add((Component)this.autoResizeCheck, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.add((Component)this.buttonPanel, gridBagConstraints);
    }

    private void autoResizeCheckActionPerformed(ActionEvent evt) {
        if (this.autoResizeCheck.isSelected()) {
            this.table.setAutoResizeMode(4);
        } else {
            this.table.setAutoResizeMode(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeButtonActionPerformed(ActionEvent evt) {
        int selectedRow = this.table.getSelectedRow();
        if (selectedRow == -1) {
            return;
        }
        this.stopEditing();
        String key = ((PropertiesTableModel.StringPair)this.table.getModel().getValueAt(selectedRow, 0)).getValue();
        if (key == null) {
            return;
        }
        NotifyDescriptor.Confirmation msg = new NotifyDescriptor.Confirmation((Object)MessageFormat.format(NbBundle.getBundle(BundleEditPanel.class).getString("MSG_DeleteKeyQuestion"), key), 2);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)msg).equals(NotifyDescriptor.OK_OPTION)) {
            try {
                this.structure.getOpenSupport().atomicUndoRedoFlag = new Object();
                for (int i = 0; i < this.structure.getEntryCount(); ++i) {
                    PropertiesStructure ps;
                    PropertiesFileEntry entry = this.structure.getNthEntry(i);
                    if (entry == null || (ps = entry.getHandler().getStructure()) == null) continue;
                    ps.deleteItem(key);
                }
            }
            finally {
                this.structure.getOpenSupport().atomicUndoRedoFlag = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addButtonActionPerformed(ActionEvent evt) {
        this.stopEditing();
        PropertyPanel panel = new PropertyPanel();
        Object selectedOption = DialogDisplayer.getDefault().notify((NotifyDescriptor)new DialogDescriptor((Object)panel, NbBundle.getMessage(BundleEditPanel.class, (String)"CTL_NewPropertyTitle")));
        if (selectedOption != NotifyDescriptor.OK_OPTION) {
            return;
        }
        final String key = panel.getKey();
        String value = panel.getValue();
        String comment = panel.getComment();
        boolean keyAdded = false;
        try {
            this.selectionUpdateDisabled = true;
            this.structure.getOpenSupport().atomicUndoRedoFlag = new Object();
            String existingLocales = "";
            String comma = ",\r\n";
            for (int i = 0; i < this.structure.getEntryCount(); ++i) {
                PropertiesFileEntry entry = this.structure.getNthEntry(i);
                if (entry != null && !entry.getHandler().getStructure().addItem(key, value, comment)) {
                    existingLocales = existingLocales + Util.getLocaleLabel((MultiDataObject.Entry)entry) + comma;
                    continue;
                }
                keyAdded = true;
            }
            if (!existingLocales.equals("")) {
                existingLocales = existingLocales.substring(0, existingLocales.length() - comma.length());
                NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)MessageFormat.format(NbBundle.getBundle(BundleEditPanel.class).getString("MSG_KeyExists"), key, existingLocales), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
            }
        }
        finally {
            this.structure.getOpenSupport().atomicUndoRedoFlag = null;
            this.selectionUpdateDisabled = false;
        }
        if (keyAdded) {
            PropertiesRequestProcessor.getInstance().post(new Runnable(){

                @Override
                public void run() {
                    int rowIndex = BundleEditPanel.this.structure.getKeyIndexByName(key);
                    if (rowIndex != -1) {
                        final int row = rowIndex;
                        boolean column = true;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    Rectangle cellRect;
                                    BundleEditPanel.this.selectionUpdateDisabled = true;
                                    if (BundleEditPanel.this.table.getAutoscrolls() && (cellRect = BundleEditPanel.this.table.getCellRect(row, 1, false)) != null) {
                                        BundleEditPanel.this.table.scrollRectToVisible(cellRect);
                                    }
                                    BundleEditPanel.this.table.getColumnModel().getSelectionModel().setSelectionInterval(1, 1);
                                    BundleEditPanel.this.table.getSelectionModel().setSelectionInterval(row, row);
                                    BundleEditPanel.this.table.requestFocusInWindow();
                                    BundleEditPanel.this.table.editCellAt(row, 1);
                                }
                                finally {
                                    BundleEditPanel.this.selectionUpdateDisabled = false;
                                }
                            }
                        });
                    }
                }
            });
        }
    }

    private class TableViewColumnModel
    extends DefaultTableColumnModel {
        private AncestorListener ancestorListener;

        private TableViewColumnModel() {
        }

        @Override
        public void moveColumn(int fromIndex, int toIndex) {
            super.moveColumn(fromIndex, toIndex);
            if ((fromIndex == 0 || toIndex == 0) && fromIndex != toIndex) {
                super.moveColumn(toIndex, fromIndex);
            }
        }

        @Override
        public void addColumn(TableColumn aColumn) {
            if (aColumn == null) {
                throw new IllegalArgumentException("Object is null");
            }
            this.tableColumns.addElement(aColumn);
            aColumn.addPropertyChangeListener(this);
            this.adjustColumnWidths();
            this.fireColumnAdded(new TableColumnModelEvent(this, 0, this.getColumnCount() - 1));
        }

        private void adjustColumnWidths() {
            int computedColumnWidth;
            Rectangle screenBounds = Utilities.getUsableScreenBounds();
            int columnWidth = screenBounds.width / 10;
            int totalWidth = 0;
            TopComponent tc = (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, BundleEditPanel.this.table);
            if (tc != null) {
                totalWidth = tc.getBounds().width;
            } else if (this.ancestorListener == null) {
                this.ancestorListener = new AncestorListener(){

                    @Override
                    public void ancestorAdded(AncestorEvent evt) {
                        if (evt.getAncestor() instanceof TopComponent) {
                            TableViewColumnModel.this.adjustColumnWidths();
                            BundleEditPanel.this.table.removeAncestorListener(TableViewColumnModel.this.ancestorListener);
                            TableViewColumnModel.this.ancestorListener = null;
                        }
                    }

                    @Override
                    public void ancestorMoved(AncestorEvent evt) {
                    }

                    @Override
                    public void ancestorRemoved(AncestorEvent evt) {
                    }
                };
                BundleEditPanel.this.table.addAncestorListener(this.ancestorListener);
            }
            int remainder = 0;
            if ((totalWidth -= ((BundleEditPanel)BundleEditPanel.this).scrollPane.getInsets().left + ((BundleEditPanel)BundleEditPanel.this).scrollPane.getInsets().right + 12 + 11) > 0 && (computedColumnWidth = totalWidth / BundleEditPanel.this.table.getColumnCount()) > columnWidth) {
                columnWidth = computedColumnWidth - BundleEditPanel.this.table.getColumnModel().getColumnMargin();
                remainder = totalWidth % BundleEditPanel.this.table.getColumnCount();
            }
            for (int i = 0; i < BundleEditPanel.this.table.getColumnCount(); ++i) {
                TableColumn column = BundleEditPanel.this.table.getColumnModel().getColumn(i);
                if (i == 0) {
                    column.setPreferredWidth(columnWidth + remainder);
                    column.setWidth(columnWidth + remainder);
                    continue;
                }
                column.setPreferredWidth(columnWidth);
                column.setWidth(columnWidth);
            }
            this.recalcWidthCache();
            BundleEditPanel.this.table.revalidate();
            BundleEditPanel.this.table.getTableHeader().repaint();
        }
    }

    private static final class TableViewHeaderRenderer
    implements TableCellRenderer {
        private static final String ICON_PKG = "org/netbeans/modules/properties/";
        private static final String SORT_ASC_ICON = "org/netbeans/modules/properties/columnSortedAsc.gif";
        private static final String SORT_DESC_ICON = "org/netbeans/modules/properties/columnSortedDesc.gif";
        private final BundleStructure bundleStructure;
        private final TableCellRenderer origRenderer;
        private ImageIcon iconSortAsc;
        private ImageIcon iconSortDesc;

        @Deprecated
        TableViewHeaderRenderer(PropertiesDataObject propDataObj, TableCellRenderer origRenderer) {
            this.bundleStructure = propDataObj.getBundleStructure();
            this.origRenderer = origRenderer;
        }

        TableViewHeaderRenderer(BundleStructure bundleStructure, TableCellRenderer origRenderer) {
            this.bundleStructure = bundleStructure;
            this.origRenderer = origRenderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component comp = this.origRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (comp instanceof JLabel) {
                JLabel label = (JLabel)comp;
                BundleStructure bundleStruct = this.bundleStructure;
                int sortIndex = table.convertColumnIndexToView(bundleStruct.getSortIndex());
                if (column == sortIndex) {
                    boolean ascending = bundleStruct.getSortOrder();
                    label.setIcon(this.getSortIcon(ascending));
                    label.setHorizontalTextPosition(2);
                } else {
                    label.setIcon(null);
                }
            }
            return comp;
        }

        private ImageIcon getSortIcon(boolean ascending) {
            if (ascending) {
                if (this.iconSortAsc == null) {
                    this.iconSortAsc = ImageUtilities.loadImageIcon((String)SORT_ASC_ICON, (boolean)false);
                }
                return this.iconSortAsc;
            }
            if (this.iconSortDesc == null) {
                this.iconSortDesc = ImageUtilities.loadImageIcon((String)SORT_DESC_ICON, (boolean)false);
            }
            return this.iconSortDesc;
        }
    }

    private class ModifiedListener
    implements DocumentListener {
        private ModifiedListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.documentModified();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.documentModified();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.documentModified();
        }

        private void documentModified() {
            int column = BundleEditPanel.this.table.getEditingColumn();
            if (column != 0) {
                ((PropertiesTableModel)BundleEditPanel.this.table.getModel()).getFileEntry(column).getDataObject().setModified(true);
            } else {
                for (int i = 0; i < BundleEditPanel.this.structure.getEntryCount(); ++i) {
                    PropertiesDataObject dataObject = (PropertiesDataObject)BundleEditPanel.this.structure.getNthEntry(i).getDataObject();
                    dataObject.setModified(true);
                }
            }
        }
    }

    private class TableViewRenderer
    extends DefaultTableCellRenderer {
        private TableViewRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                return this;
            }
            PropertiesTableModel.StringPair sp = (PropertiesTableModel.StringPair)value;
            this.setFont(settings.getFont());
            if (hasFocus) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(noFocusBorder);
            }
            String text = null;
            if (sp.getValue() != null) {
                text = sp.getValue();
            }
            if (BasicHTML.isHTMLString(text)) {
                text = " " + text;
            }
            this.setValue(text == null ? "" : text);
            if (sp.isKeyType()) {
                this.setBackground(settings.getKeyBackground());
            } else if (sp.getValue() != null) {
                this.setBackground(settings.getValueBackground());
            } else {
                this.setBackground(settings.getShadowColor());
            }
            if (sp.isKeyType()) {
                this.setForeground(settings.getKeyColor());
            } else {
                this.setForeground(settings.getValueColor());
            }
            Color back = this.getBackground();
            boolean colorMatch = back != null && back.equals(table.getBackground()) && table.isOpaque();
            this.setOpaque(!colorMatch);
            return this;
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (FindPerformer.getFindPerformer(BundleEditPanel.this.table).isHighlightSearch()) {
                String text = this.getText();
                String findString = FindPerformer.getFindPerformer(BundleEditPanel.this.table).getFindString();
                if (text != null && text.length() > 0 && findString != null && findString.length() > 0) {
                    int index = 0;
                    int width = (int)g.getFontMetrics().getStringBounds(findString, g).getWidth();
                    Color oldColor = g.getColor();
                    while ((index = text.indexOf(findString, index)) >= 0) {
                        int x = (int)g.getFontMetrics().getStringBounds(text.substring(0, index), g).getWidth() + this.getInsets().left;
                        g.setColor(settings.getHighlightBackground());
                        g.fillRect(x, 0, width, g.getClipBounds().height);
                        g.setColor(settings.getHighlightColor());
                        g.drawString(findString, x, -((int)g.getFontMetrics().getStringBounds(findString, g).getY()));
                        index += findString.length();
                    }
                    g.setColor(oldColor);
                }
            }
        }
    }

    static class BundleTable
    extends JTable {
        public BundleTable() {
            this.setRowHeight(this.getCellFontHeight() + 1);
        }

        @Override
        public int convertColumnIndexToModel(int arg0) {
            return arg0;
        }

        @Override
        public int convertColumnIndexToView(int arg0) {
            return arg0;
        }

        @Override
        public void columnMoved(TableColumnModelEvent evt) {
            if (evt.getFromIndex() == evt.getToIndex()) {
                this.firePropertyChange("columnMoved", null, null);
            } else {
                this.firePropertyChange("columnMoved", evt.getFromIndex(), evt.getToIndex());
            }
            super.columnMoved(evt);
        }

        @Override
        public void columnMarginChanged(ChangeEvent evt) {
            if (this.isEditing()) {
                this.firePropertyChange("marginChanged", null, null);
            }
            super.columnMarginChanged(evt);
        }

        public void removeEditorSilent() {
            TableCellEditor editor = this.getCellEditor();
            if (editor != null) {
                editor.removeCellEditorListener(this);
                if (this.editorComp != null) {
                    this.remove(this.editorComp);
                }
                Rectangle cellRect = this.getCellRect(this.editingRow, this.editingColumn, false);
                this.setCellEditor(null);
                this.setEditingColumn(-1);
                this.setEditingRow(-1);
                this.editorComp = null;
                this.repaint(cellRect);
            }
        }

        private int getCellFontHeight() {
            FontMetrics fm;
            Font cellFont = UIManager.getFont("TextField.font");
            if (cellFont != null && (fm = this.getFontMetrics(cellFont)) != null) {
                return fm.getHeight();
            }
            return 14;
        }
    }
}

