/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.dependency;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.lsp.ResourceModificationException;
import org.netbeans.api.lsp.TextDocumentEdit;
import org.netbeans.api.lsp.WorkspaceEdit;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.project.dependency.Bundle;
import org.netbeans.modules.project.dependency.ProjectOperationException;
import org.netbeans.modules.project.dependency.reload.ProjectReloadInternal;
import org.netbeans.modules.project.dependency.reload.ReloadApiAccessor;
import org.netbeans.modules.project.dependency.spi.ProjectReloadImplementation;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Lookup;
import org.openide.util.Pair;
import org.openide.util.RequestProcessor;
import org.openide.util.Union2;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public final class ProjectReload {
    private static final Logger LOG = Logger.getLogger(ProjectReloadInternal.class.getName());
    private static final int STATE_COALESCE_TIMEOUT_MS = 100;
    private static final HashMap<ProjectState, RequestProcessor.Task> notifiers = new HashMap();
    private static AtomicInteger eventId = new AtomicInteger(0);

    public static ProjectState getProjectState(Project p) {
        return ProjectReload.getProjectState(p, false);
    }

    public static ProjectState getProjectState(Project p, boolean attemptLoad) throws ProjectOperationException {
        Pair<ProjectReloadInternal.StateRef, ProjectState> pair = ProjectReloadInternal.getInstance().getProjectState0(p, Lookup.EMPTY, true);
        if (!(pair == null || attemptLoad && ((ProjectState)pair.second()).getQuality() == Quality.NONE)) {
            return (ProjectState)pair.second();
        }
        boolean blockingLoadAttempted = ProjectReloadInternal.RELOAD_RP.isRequestProcessorThread();
        if (!attemptLoad || blockingLoadAttempted) {
            if (attemptLoad) {
                LOG.log(Level.WARNING, "Attempt to call getProjectState() synchronously from a project loader with no known project state. To avoid a deadlock, NONE is returned.");
                LOG.log(Level.WARNING, "Check the calling operation:", new Throwable());
            }
            return (ProjectState)ProjectReloadInternal.getInstance().getProjectState0(p, Lookup.EMPTY, false).second();
        }
        try {
            return ProjectReload.withProjectState(p, StateRequest.load().toQuality(Quality.NONE).tryQuality(Quality.SIMPLE).consistent(false).offline()).get();
        }
        catch (ExecutionException ex) {
            if (ex.getCause() instanceof ProjectOperationException) {
                throw (ProjectOperationException)ex.getCause();
            }
            throw new ProjectOperationException(p, ProjectOperationException.State.ERROR, ex.getMessage(), ex.getCause());
        }
        catch (InterruptedException ex) {
            throw new ProjectOperationException(p, ProjectOperationException.State.CANCELLED, ex.getMessage(), ex);
        }
    }

    public static CompletableFuture<ProjectState> withProjectState(Project p, StateRequest stateRequest) {
        Throwable origin = new Throwable();
        LOG.log(Level.FINE, "REQUESTED: Reload {0}, request: {1}", new Object[]{p, stateRequest});
        Pair<ProjectReloadInternal.StateRef, ProjectState> projectData = ProjectReloadInternal.getInstance().getProjectState0(p, stateRequest.getContext() == null ? Lookup.EMPTY : stateRequest.getContext(), false);
        ProjectState lastKnown = (ProjectState)projectData.second();
        boolean doReload = ProjectReloadInternal.checkConsistency(lastKnown, ReloadApiAccessor.get().getParts(lastKnown), stateRequest);
        if (!doReload && lastKnown.target.isAtLeast(stateRequest.getTargetQuality())) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "FINISHED: Reload {0}, request: {1}, state {2} - NOOP, finished", new Object[]{p, stateRequest, lastKnown.toString()});
            }
            return CompletableFuture.completedFuture(lastKnown);
        }
        String reason = stateRequest.getReason();
        if (reason == null) {
            reason = Bundle.TEXT_RefreshProject(ProjectReload.projectName(p));
            stateRequest.reloadReason(reason);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Reload {0}, last known state: {1}", new Object[]{p, lastKnown == null ? "null" : lastKnown.toString()});
        }
        if (lastKnown.getQuality() == Quality.NONE && stateRequest.isConsistent()) {
            LOG.log(Level.FINE, "Reload {0}: Have NONE but need to have files for consistency check", lastKnown);
            CompletableFuture<ProjectState> initialF = ProjectReload.withProjectState1(p, StateRequest.load().toQuality(Quality.NONE).consistent(false).offline(), lastKnown, projectData, origin);
            AtomicReference nested = new AtomicReference();
            CompletionStage toReturn = initialF.thenCompose(initS -> {
                CompletableFuture<ProjectState> n;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "Reload {0}: got initial state {1}", new Object[]{p, initS.toString()});
                }
                if (Quality.NONE.isWorseThan(initS.getQuality())) {
                    n = ProjectReload.withProjectState(p, stateRequest);
                } else {
                    Pair<ProjectReloadInternal.StateRef, ProjectState> newData = ProjectReloadInternal.getInstance().getProjectState0(p, stateRequest.getContext() == null ? Lookup.EMPTY : stateRequest.getContext(), false);
                    n = ProjectReload.withProjectState1(p, stateRequest, (ProjectState)newData.second(), newData, origin);
                }
                nested.set(n);
                return n;
            });
            ((CompletableFuture)toReturn).whenComplete((s, e) -> {
                if (e instanceof CompletionException) {
                    e = e.getCause();
                }
                if (e instanceof CancellationException) {
                    initialF.cancel(true);
                    CompletableFuture n = (CompletableFuture)nested.get();
                    if (n != null) {
                        n.cancel(true);
                    }
                }
            });
            return toReturn;
        }
        return ProjectReload.withProjectState1(p, stateRequest, lastKnown, projectData, origin);
    }

    static CompletableFuture<ProjectState> withProjectState1(Project p, StateRequest stateRequest, ProjectState lastKnown, Pair<ProjectReloadInternal.StateRef, ProjectState> projectData, Throwable origin) {
        StateRequest fRequest = stateRequest;
        HashSet<FileObject> nowEdited = new HashSet<FileObject>();
        for (FileObject f : lastKnown.getEditedFiles()) {
            if (f.getLookup().lookup(SaveCookie.class) == null) continue;
            nowEdited.add(f);
        }
        if (!nowEdited.isEmpty() && stateRequest.isConsistent()) {
            if (stateRequest.isSaveModifications()) {
                LOG.log(Level.FINER, "Reload {0}, request: {1} - prompt save files: {2}", new Object[]{p, stateRequest, nowEdited});
                NotifyDescriptor.Confirmation confirm = new NotifyDescriptor.Confirmation((Object)Bundle.CONFIRM_ProjectFileSave(ProjectReload.projectName(p), stateRequest.getReason(), lastKnown.getEditedFiles().size()), stateRequest.getReason(), 2, 3);
                return DialogDisplayer.getDefault().notifyFuture((NotifyDescriptor)confirm).thenComposeAsync(nd -> {
                    if (nd.getValue() == NotifyDescriptor.OK_OPTION) {
                        ArrayList documentChanges = new ArrayList();
                        ArrayList mods = new ArrayList(nowEdited);
                        mods.forEach(f -> documentChanges.add(Union2.createFirst((Object)new TextDocumentEdit(URLMapper.findURL((FileObject)f, (int)1).toExternalForm(), Collections.emptyList()))));
                        LOG.log(Level.FINER, "Reload {0}, request: {1} - saving files: {2}", new Object[]{p, fRequest, nowEdited});
                        WorkspaceEdit wkEdit = new WorkspaceEdit(documentChanges);
                        CompletionStage f2 = ((CompletableFuture)WorkspaceEdit.applyEdits(Collections.singletonList(wkEdit), (boolean)true).exceptionallyCompose(t -> {
                            ProjectOperationException pex;
                            LOG.log(Level.FINER, "Reload {0}, request: {1} - save ERROR", new Object[]{p, fRequest});
                            LOG.log(Level.FINER, "Save exception:", (Throwable)t);
                            if (t instanceof ResourceModificationException) {
                                ResourceModificationException ex = (ResourceModificationException)t;
                                FileObject failedFile = (FileObject)mods.get(ex.getFailedEditIndex());
                                pex = new ProjectOperationException(p, ProjectOperationException.State.OUT_OF_SYNC, Bundle.ERR_SaveFailed(ProjectReload.projectName(p), Collections.singleton(failedFile)));
                            } else {
                                pex = new ProjectOperationException(p, ProjectOperationException.State.ERROR, Bundle.ERR_SaveProjectFailed(ProjectReload.projectName(p)));
                            }
                            pex.initCause((Throwable)t);
                            return CompletableFuture.failedFuture(pex);
                        })).thenCompose(list -> ProjectReloadInternal.getInstance().withProjectState2((ProjectReloadInternal.StateRef)projectData.first(), p, fRequest, origin));
                        return f2;
                    }
                    LOG.log(Level.FINER, "Reload {0}, request: {1} - save CANCELLED", new Object[]{p, fRequest});
                    ProjectOperationException ex = new ProjectOperationException(p, ProjectOperationException.State.OUT_OF_SYNC, Bundle.ERR_ProjectFilesModified(ProjectReload.projectName(p), lastKnown.getEditedFiles().size()), new HashSet<FileObject>(lastKnown.getEditedFiles()));
                    return CompletableFuture.failedFuture(ex);
                }, (Executor)ProjectReloadInternal.RELOAD_RP);
            }
            LOG.log(Level.FINER, "Reload {0}, request: {1} - fail on modified files", new Object[]{p, fRequest});
            ProjectOperationException ex = new ProjectOperationException(p, ProjectOperationException.State.OUT_OF_SYNC, Bundle.ERR_ProjectFilesModified(ProjectReload.projectName(p), nowEdited.size()), nowEdited);
            return CompletableFuture.failedFuture(ex);
        }
        return ProjectReloadInternal.getInstance().withProjectState2((ProjectReloadInternal.StateRef)projectData.first(), p, stateRequest, origin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void queueStateChange(final ProjectState s) {
        final AtomicReference<RequestProcessor.Task> cur = new AtomicReference<RequestProcessor.Task>();
        HashMap<ProjectState, RequestProcessor.Task> hashMap = notifiers;
        synchronized (hashMap) {
            RequestProcessor.Task t = notifiers.get(s);
            if (t != null) {
                if (t.isFinished()) {
                    LOG.log(Level.FINER, "State change {1} for {0} - piggyback on project operation", new Object[]{s, t});
                    return;
                }
            } else {
                class R
                implements Runnable {
                    final int id = eventId.incrementAndGet();

                    R() {
                    }

                    @Override
                    public void run() {
                        boolean[] processed = new boolean[1];
                        ProjectReloadInternal.getInstance().runProjectAction(s.getProject(), () -> {
                            processed[0] = true;
                            HashMap<ProjectState, RequestProcessor.Task> hashMap = notifiers;
                            synchronized (hashMap) {
                                notifiers.remove(s, cur.get());
                            }
                            LOG.log(Level.FINE, "Firing state change {1} for {0}", new Object[]{s, this});
                            ProjectReloadInternal.RELOAD_RP.post(s::fireChange);
                        });
                        if (!processed[0]) {
                            LOG.log(Level.FINE, "Postponed state change {1} for {0}", new Object[]{s, this});
                        }
                    }

                    public String toString() {
                        return "" + this.id;
                    }
                }
                t = ProjectReloadInternal.NOTIFIER.create((Runnable)new R(), false);
                notifiers.put(s, t);
            }
            LOG.log(Level.FINE, "Queue state change {1} for {0}", new Object[]{s, t});
            t.schedule(100);
            cur.set(t);
        }
    }

    private static String projectName(Project p) {
        return ProjectUtils.getInformation((Project)p).getDisplayName();
    }

    static {
        ReloadApiAccessor.set(new ReloadApiAccessor(){

            @Override
            public ProjectState createState(Project project, long timestamp, ProjectReloadInternal.StateParts parts, Quality status, Quality target, boolean consistent, boolean valid, Collection<FileObject> loaded, Collection<FileObject> modified, Collection<FileObject> edited, Object track) {
                return new ProjectState(project, timestamp, parts, status, target, consistent, valid, loaded, modified, edited, track);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void chainPrevious(ProjectState ps, ProjectState old, Collection<ProjectState> collector) {
                List<Reference<ProjectState>> ocol;
                if (old == null) {
                    return;
                }
                ArrayList<Reference<ProjectState>> olds = new ArrayList<Reference<ProjectState>>();
                olds.add(new WeakReference<ProjectState>(old));
                Object object = old;
                synchronized (object) {
                    ocol = old.previous;
                    old.previous = null;
                }
                if (ocol != null) {
                    for (Reference reference : ocol) {
                        ProjectState s = (ProjectState)reference.get();
                        if (s == null) continue;
                        collector.add(s);
                        olds.add(reference);
                    }
                }
                object = ps;
                synchronized (object) {
                    if (ps.previous != null) {
                        olds.addAll(ps.previous);
                    }
                    ps.previous = olds;
                }
            }

            @Override
            public void fireInvalid(ProjectState ps) {
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.log(Level.FINER, "State " + ps + " invalidated", new Throwable());
                }
                ps.valid = false;
                ProjectReload.queueStateChange(ps);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateProjectState(ProjectState ps, boolean inconsistent, boolean invalid, Collection<FileObject> modified, Collection<FileObject> edited, ProjectState targetQualityFrom) {
                boolean fire = false;
                ProjectState projectState = ps;
                synchronized (projectState) {
                    if (inconsistent) {
                        fire |= ps.consistent;
                        ps.consistent = false;
                    }
                    if (invalid) {
                        fire |= ps.valid;
                        ps.valid = false;
                    }
                    if (modified != null) {
                        fire = true;
                        ps.modified = modified;
                    }
                    if (edited != null) {
                        fire = true;
                        ps.edited = edited;
                    }
                    if (targetQualityFrom != null && !ps.target.isWorseThan(targetQualityFrom.target)) {
                        ps.target = targetQualityFrom.target;
                        fire = true;
                    }
                }
                if (fire) {
                    if (LOG.isLoggable(Level.FINER)) {
                        LOG.log(Level.FINER, "State {0} changed - consistent={1}, valid={2}", new Object[]{ps.toString(), ps.isConsistent(), ps.isValid()});
                    }
                    ProjectReload.queueStateChange(ps);
                }
            }

            @Override
            public ProjectReloadInternal.StateParts getParts(ProjectState state) {
                return state.parts;
            }
        });
    }

    public static final class ProjectState {
        private final Project project;
        private final Quality status;
        private final Collection<FileObject> loaded;
        private final long timestamp;
        private final ProjectReloadInternal.StateParts parts;
        private final Object track;
        private volatile Lookup lookup;
        private volatile Quality target;
        private volatile boolean consistent;
        private volatile Collection<FileObject> edited;
        private volatile Collection<FileObject> modified;
        private volatile boolean valid;
        private List<ChangeListener> changeListeners;
        private List<Reference<ProjectState>> previous;

        ProjectState(Project project, long timestamp, ProjectReloadInternal.StateParts parts, Quality status, Quality target, boolean consistent, boolean valid, Collection<FileObject> loaded, Collection<FileObject> modified, Collection<FileObject> edited, Object track) {
            this.track = track;
            this.timestamp = timestamp;
            this.valid = valid;
            this.project = project;
            this.status = status;
            this.target = target.isAtLeast(status) ? target : status;
            this.consistent = consistent;
            this.modified = modified;
            this.loaded = loaded;
            this.parts = parts;
            this.edited = edited;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public boolean isValid() {
            return this.valid;
        }

        public Collection<FileObject> getLoadedFiles() {
            return Collections.unmodifiableCollection(this.loaded);
        }

        public Lookup getLookup() {
            Lookup lkp;
            if (this.lookup != null) {
                return this.lookup;
            }
            ArrayList fixed = new ArrayList();
            ArrayList<Lookup> lkps = new ArrayList<Lookup>();
            for (ProjectReloadImplementation.ProjectStateData part : this.parts.values()) {
                Lookup partL;
                if (part == null) continue;
                Object pd = part.getProjectData();
                if (pd != null) {
                    fixed.add(pd);
                }
                if ((partL = part.getLookup()) == null || partL == Lookup.EMPTY) continue;
                lkps.add(partL);
            }
            if (lkps.isEmpty()) {
                lkp = fixed.isEmpty() ? Lookup.EMPTY : Lookups.fixed((Object[])fixed.toArray(Object[]::new));
            } else {
                if (!fixed.isEmpty()) {
                    lkps.add(0, Lookups.fixed((Object[])fixed.toArray(Object[]::new)));
                }
                lkp = new ProxyLookup((Lookup[])lkps.toArray(Lookup[]::new));
            }
            this.lookup = lkp;
            return lkp;
        }

        public Project getProject() {
            return this.project;
        }

        public Quality getQuality() {
            return this.status;
        }

        public boolean isConsistent() {
            return this.consistent;
        }

        public Collection<FileObject> getChangedFiles() {
            return Collections.unmodifiableCollection(this.modified);
        }

        public Collection<FileObject> getEditedFiles() {
            return Collections.unmodifiableCollection(this.edited);
        }

        public boolean isModified() {
            return !this.modified.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChangeListener(ChangeListener l) {
            ProjectState projectState = this;
            synchronized (projectState) {
                if (this.changeListeners == null) {
                    this.changeListeners = new ArrayList<ChangeListener>();
                }
                this.changeListeners.add(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeChangeListener(ChangeListener l) {
            ProjectState projectState = this;
            synchronized (projectState) {
                if (this.changeListeners != null) {
                    this.changeListeners.remove(l);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void fireChange() {
            ArrayList<ChangeListener> ll = new ArrayList<ChangeListener>();
            ArrayList<ProjectState> olds = null;
            ProjectState projectState = this;
            synchronized (projectState) {
                if (this.previous != null) {
                    Iterator<Reference<ProjectState>> it = this.previous.iterator();
                    while (it.hasNext()) {
                        Reference<ProjectState> ps = it.next();
                        ProjectState p = ps.get();
                        if (p == null) {
                            it.remove();
                            continue;
                        }
                        if (olds == null) {
                            olds = new ArrayList<ProjectState>();
                        }
                        olds.add(p);
                    }
                }
                if (this.changeListeners != null) {
                    ll.addAll(this.changeListeners);
                } else if (olds == null) {
                    return;
                }
            }
            if (olds != null) {
                for (ProjectState p : olds) {
                    p.fireChange();
                }
            }
            if (!ll.isEmpty()) {
                ChangeEvent e = new ChangeEvent(this);
                ll.forEach(l -> l.stateChanged(e));
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.project).append("@").append(Integer.toHexString(System.identityHashCode(this))).append("[");
            sb.append("quality=").append((Object)this.getQuality());
            sb.append(", consistent=").append(this.isConsistent());
            sb.append(", valid=").append(this.isValid());
            sb.append(", loaded=").append(this.getLoadedFiles());
            sb.append(", modified=").append(this.getLoadedFiles());
            sb.append("]");
            return sb.toString();
        }
    }

    public static enum Quality {
        NONE,
        UNTRUSTED,
        FALLBACK,
        INCOMPLETE,
        BROKEN,
        SIMPLE,
        LOADED,
        RESOLVED,
        CONSISTENT;


        public boolean isAtLeast(Quality s) {
            return this.ordinal() >= s.ordinal();
        }

        public boolean isWorseThan(Quality s) {
            return this.ordinal() < s.ordinal();
        }
    }

    public static final class StateRequest {
        private Quality tryQuality;
        private Quality minQuality;
        private boolean consistent = true;
        private boolean forceReload;
        private boolean saveModifications;
        private boolean offlineOperation;
        private String reason;
        private boolean grantTrust;
        private Lookup context;

        StateRequest(Quality quality, boolean forceReload, boolean saveModifications, boolean consistent, boolean offlineOperation) {
            this.minQuality = this.tryQuality = quality;
            this.forceReload = forceReload;
            this.consistent = consistent;
            this.saveModifications = saveModifications;
            this.offlineOperation = offlineOperation;
        }

        public Quality getMinQuality() {
            return this.minQuality;
        }

        public Quality getTargetQuality() {
            return this.tryQuality;
        }

        public boolean isGrantTrust() {
            return this.grantTrust;
        }

        public boolean isConsistent() {
            return this.consistent;
        }

        public boolean isForceReload() {
            return this.forceReload;
        }

        public boolean isSaveModifications() {
            return this.saveModifications;
        }

        public boolean isOfflineOperation() {
            return this.offlineOperation;
        }

        public String getReason() {
            return this.reason;
        }

        public StateRequest toQuality(Quality q) {
            this.minQuality = this.tryQuality = q;
            return this;
        }

        public StateRequest tryQuality(Quality q) {
            this.tryQuality = q;
            if (q.isWorseThan(this.minQuality)) {
                this.minQuality = q;
            }
            return this;
        }

        public StateRequest grantTrust() {
            this.grantTrust = true;
            return this;
        }

        public StateRequest consistent(boolean c) {
            this.consistent = c;
            return this;
        }

        public StateRequest forceReload() {
            this.forceReload = true;
            return this;
        }

        public StateRequest saveModifications() {
            this.saveModifications = true;
            return this;
        }

        public StateRequest online() {
            this.offlineOperation = false;
            return this;
        }

        public StateRequest offline() {
            this.offlineOperation = true;
            return this;
        }

        public StateRequest reloadReason(String reason) {
            this.reason = reason;
            return this;
        }

        public StateRequest copy() {
            StateRequest sr = new StateRequest(this.minQuality, this.forceReload, this.saveModifications, this.consistent, this.offlineOperation);
            sr.tryQuality = this.tryQuality;
            return sr;
        }

        public StateRequest context(Lookup ctx) {
            this.context = ctx;
            return this;
        }

        public Lookup getContext() {
            return this.context;
        }

        public String toString() {
            return String.format("Request@%s[quality=%s, force=%b, consistent=%b, offline=%b, save=%b, reason:%s]", Integer.toHexString(System.identityHashCode(this)), this.minQuality.name(), this.forceReload, this.consistent, this.offlineOperation, this.saveModifications, this.reason);
        }

        public static StateRequest load() {
            return new StateRequest(Quality.SIMPLE, false, false, false, false);
        }

        public static StateRequest refresh() {
            return new StateRequest(Quality.SIMPLE, false, false, true, false);
        }

        public static StateRequest reload() {
            return new StateRequest(Quality.SIMPLE, true, false, true, false);
        }
    }
}

