/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.symfony2;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.spi.phpmodule.ImportantFilesImplementation;
import org.netbeans.modules.php.symfony2.preferences.SymfonyPreferences;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;

public final class ConfigurationFiles
extends FileChangeAdapter
implements ImportantFilesImplementation {
    private static final String CONFIG_DIRECTORY = "config";
    private final PhpModule phpModule;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private FileObject sourceDirectory = null;

    ConfigurationFiles(PhpModule phpModule) {
        assert (phpModule != null);
        this.phpModule = phpModule;
    }

    public Collection<ImportantFilesImplementation.FileInfo> getFiles() {
        FileObject sourceDir = this.getSourceDirectory();
        if (sourceDir == null) {
            return Collections.emptyList();
        }
        FileObject appDir = sourceDir.getFileObject(SymfonyPreferences.getAppDir(this.phpModule));
        if (appDir == null) {
            return Collections.emptyList();
        }
        List<ImportantFilesImplementation.FileInfo> files = Collections.emptyList();
        FileObject configDir = appDir.getFileObject(CONFIG_DIRECTORY);
        if (configDir != null && configDir.isFolder() && configDir.isValid()) {
            for (FileObject child : configDir.getChildren()) {
                if (!child.isData()) continue;
                if (files.isEmpty()) {
                    files = new ArrayList<ImportantFilesImplementation.FileInfo>();
                }
                files.add(new ImportantFilesImplementation.FileInfo(child));
            }
            Collections.sort(files, ImportantFilesImplementation.FileInfo.COMPARATOR);
        }
        return files;
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    private void fireChange() {
        this.changeSupport.fireChange();
    }

    @CheckForNull
    private synchronized FileObject getSourceDirectory() {
        if (this.sourceDirectory == null) {
            this.sourceDirectory = this.phpModule.getSourceDirectory();
            if (this.sourceDirectory != null) {
                File sources = FileUtil.toFile((FileObject)this.sourceDirectory);
                this.addListener(new File(new File(sources, SymfonyPreferences.getAppDir(this.phpModule)), CONFIG_DIRECTORY));
            }
        }
        return this.sourceDirectory;
    }

    private void addListener(File path) {
        block2: {
            try {
                FileUtil.addFileChangeListener((FileChangeListener)this, (File)path);
            }
            catch (IllegalArgumentException ex) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError(path);
            }
        }
    }

    public void fileRenamed(FileRenameEvent fe) {
        this.fireChange();
    }

    public void fileDeleted(FileEvent fe) {
        this.fireChange();
    }

    public void fileDataCreated(FileEvent fe) {
        this.fireChange();
    }

    public void fileFolderCreated(FileEvent fe) {
        this.fireChange();
    }
}

