/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui;

import java.awt.Color;
import java.awt.Image;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.MutableComboBoxModel;
import javax.swing.UIManager;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.php.api.PhpVersion;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.api.util.UiUtils;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.PhpVisibilityQuery;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.ui.BrowseFolders;
import org.netbeans.modules.php.project.ui.LocalServer;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class Utils {
    private static final Logger LOGGER = Logger.getLogger(Utils.class.getName());
    private static final String PLACEHOLDER_BADGE_ICON = "org/netbeans/modules/php/project/ui/resources/placeholder-badge.png";
    private static final String LIBRARIES_BADGE_ICON = "org/netbeans/modules/php/project/ui/resources/libraries-badge.png";
    public static final URL PLACEHOLDER_BADGE_URL = Utils.class.getResource("org/netbeans/modules/php/project/ui/resources/placeholder-badge.png");
    private static final char[] INVALID_FILENAME_CHARS = new char[]{'/', '\\', '|', ':', '*', '?', '\"', '<', '>'};

    private Utils() {
    }

    @NonNull
    public static Color getErrorForeground() {
        Color result = UIManager.getDefaults().getColor("nb.errorForeground");
        if (result == null) {
            result = Color.RED;
        }
        return Utils.getSafeColor(result.getRed(), result.getGreen(), result.getBlue());
    }

    public static Color getSafeColor(int red, int green, int blue) {
        red = Math.max(red, 0);
        red = Math.min(red, 255);
        green = Math.max(green, 0);
        green = Math.min(green, 255);
        blue = Math.max(blue, 0);
        blue = Math.min(blue, 255);
        return new Color(red, green, blue);
    }

    public static Color getHintBackground() {
        Color panelBackground = UIManager.getColor("Panel.background");
        return Utils.getSafeColor(panelBackground.getRed() - 10, panelBackground.getGreen() - 10, panelBackground.getBlue() - 10);
    }

    public static Image getIncludePathIcon(boolean opened) {
        Image badge = ImageUtilities.loadImage((String)LIBRARIES_BADGE_ICON, (boolean)false);
        return ImageUtilities.mergeImages((Image)UiUtils.getTreeFolderIcon((boolean)opened), (Image)badge, (int)8, (int)8);
    }

    public static boolean isValidUrl(String url) {
        if (url == null) {
            return false;
        }
        if (!url.startsWith("http://") && !url.startsWith("https://")) {
            return false;
        }
        try {
            new URL(url).toURI();
        }
        catch (MalformedURLException | URISyntaxException ex) {
            return false;
        }
        return true;
    }

    public static File browseFileAction(String dirKey, String title) {
        return Utils.browseAction(dirKey, title, true, null);
    }

    public static File browseFileAction(String dirKey, String title, File workDir) {
        return Utils.browseAction(dirKey, title, true, workDir);
    }

    public static File browseLocationAction(String dirKey, String title) {
        return Utils.browseAction(dirKey, title, false, null);
    }

    public static File browseLocationAction(String dirKey, String title, File workDir) {
        return Utils.browseAction(dirKey, title, false, workDir);
    }

    private static File browseAction(String dirKey, String title, boolean filesOnly, File workDir) {
        FileChooserBuilder builder = new FileChooserBuilder(dirKey).setTitle(title);
        if (workDir != null) {
            builder.setDefaultWorkingDirectory(workDir).forceUseOfDefaultWorkingDirectory(true);
        }
        if (filesOnly) {
            builder.setFilesOnly(true);
        } else {
            builder.setDirectoriesOnly(true);
        }
        File selectedFile = builder.showOpenDialog();
        if (selectedFile != null) {
            return FileUtil.normalizeFile((File)selectedFile);
        }
        return null;
    }

    public static void browseLocalServerAction(JComboBox<LocalServer> localServerComboBox, MutableComboBoxModel<LocalServer> localServerComboBoxModel, String newSubfolderName, String title, String dirKey) {
        File newLocation;
        File preselected = null;
        LocalServer ls = (LocalServer)localServerComboBox.getSelectedItem();
        if (ls.getDocumentRoot() != null && ls.getDocumentRoot().length() > 0) {
            preselected = new File(ls.getDocumentRoot());
        }
        if ((newLocation = new FileChooserBuilder(dirKey).setTitle(title).setDirectoriesOnly(true).setDefaultWorkingDirectory(preselected).showOpenDialog()) == null) {
            return;
        }
        File file = newSubfolderName == null ? newLocation : new File(newLocation, newSubfolderName);
        String projectLocation = file.getAbsolutePath();
        for (int i = 0; i < localServerComboBoxModel.getSize(); ++i) {
            LocalServer element = (LocalServer)localServerComboBoxModel.getElementAt(i);
            if (!projectLocation.equals(element.getSrcRoot())) continue;
            localServerComboBox.setSelectedIndex(i);
            break;
        }
        LocalServer localServer = new LocalServer(newLocation.getAbsolutePath(), projectLocation);
        localServerComboBoxModel.addElement(localServer);
        localServerComboBox.setSelectedItem(localServer);
    }

    public static File browseTestSources(JTextField textField, PhpProject phpProject) {
        File selectedFile = new FileChooserBuilder("nb.php.test.dir").setTitle(NbBundle.getMessage(Utils.class, (String)"LBL_SelectUnitTestFolder", (Object)ProjectUtils.getInformation((Project)phpProject).getDisplayName())).setDirectoriesOnly(true).setDefaultWorkingDirectory(FileUtil.toFile((FileObject)phpProject.getProjectDirectory())).forceUseOfDefaultWorkingDirectory(true).showOpenDialog();
        if (selectedFile != null) {
            selectedFile = FileUtil.normalizeFile((File)selectedFile);
            if (textField != null) {
                textField.setText(selectedFile.getAbsolutePath());
            }
        }
        return selectedFile;
    }

    public static String validateTestSources(PhpProject project, String testDirPath) {
        if (!StringUtils.hasText((String)testDirPath)) {
            return NbBundle.getMessage(Utils.class, (String)"MSG_FolderEmpty");
        }
        File testSourcesFile = new File(testDirPath);
        if (!testSourcesFile.isAbsolute()) {
            return NbBundle.getMessage(Utils.class, (String)"MSG_TestNotAbsolute");
        }
        if (!testSourcesFile.isDirectory()) {
            return NbBundle.getMessage(Utils.class, (String)"MSG_TestNotDirectory");
        }
        FileObject nbproject = project.getProjectDirectory().getFileObject("nbproject");
        FileObject testSourcesFo = FileUtil.toFileObject((File)testSourcesFile);
        if (testSourcesFile.equals(FileUtil.toFile((FileObject)ProjectPropertiesSupport.getSourcesDirectory(project)))) {
            return NbBundle.getMessage(Utils.class, (String)"MSG_TestEqualsSources");
        }
        if (FileUtil.isParentOf((FileObject)nbproject, (FileObject)testSourcesFo) || nbproject.equals(testSourcesFo)) {
            return NbBundle.getMessage(Utils.class, (String)"MSG_TestUnderneathNBMetadata");
        }
        if (!FileUtils.isDirectoryWritable((File)testSourcesFile)) {
            return NbBundle.getMessage(Utils.class, (String)"MSG_TestNotWritable");
        }
        return null;
    }

    public static String warnTestSources(PhpProject project, String testDirPath) {
        File testSourcesFile = new File(testDirPath);
        FileObject testSourcesFo = FileUtil.toFileObject((File)testSourcesFile);
        if (!FileUtil.isParentOf((FileObject)project.getProjectDirectory(), (FileObject)testSourcesFo)) {
            return NbBundle.getMessage(Utils.class, (String)"MSG_TestNotUnderneathProjectFolder");
        }
        return null;
    }

    public static File getCanonicalFile(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static boolean isValidFileName(String fileName) {
        assert (fileName != null);
        if (fileName.trim().length() == 0) {
            return false;
        }
        for (char ch : INVALID_FILENAME_CHARS) {
            if (fileName.indexOf(ch) == -1) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidFileName(File file) {
        assert (file != null);
        for (File tmp = file; tmp != null && !tmp.exists(); tmp = tmp.getParentFile()) {
            if (tmp.isAbsolute() && tmp.getParentFile() == null) {
                return true;
            }
            if (Utils.isValidFileName(tmp.getName())) continue;
            return false;
        }
        return true;
    }

    public static String validateProjectDirectory(String projectPath, String type, boolean allowNonEmpty, boolean allowInRoot) {
        return Utils.validateProjectDirectory(new File(projectPath), type, allowNonEmpty, allowInRoot);
    }

    public static String validateProjectDirectory(File project, String type, boolean allowNonEmpty, boolean allowInRoot) {
        File projLoc;
        File cfl;
        assert (project != null);
        assert (type != null);
        if (!project.isAbsolute()) {
            return NbBundle.getMessage(Utils.class, (String)("MSG_" + type + "NotAbsolute"));
        }
        if (!allowInRoot && Utilities.isUnix() && (cfl = Utils.getCanonicalFile(project)) != null && (cfl.getParentFile() == null || cfl.getParentFile().getParent() == null)) {
            return NbBundle.getMessage(Utils.class, (String)("MSG_" + type + "InRootNotSupported"));
        }
        File destFolder = project.getAbsoluteFile();
        if (Utils.getCanonicalFile(destFolder) == null) {
            return NbBundle.getMessage(Utils.class, (String)("MSG_Illegal" + type + "Location"));
        }
        for (projLoc = FileUtil.normalizeFile((File)destFolder); projLoc != null && !projLoc.exists(); projLoc = projLoc.getParentFile()) {
        }
        if (projLoc == null || !FileUtils.isDirectoryWritable((File)projLoc)) {
            return NbBundle.getMessage(Utils.class, (String)("MSG_" + type + "FolderReadOnly"));
        }
        if (FileUtil.toFileObject((File)projLoc) == null) {
            return NbBundle.getMessage(Utils.class, (String)("MSG_Illegal" + type + "Location"));
        }
        if (!allowNonEmpty) {
            File[] kids = destFolder.listFiles();
            if (destFolder.exists() && kids != null && kids.length > 0) {
                return NbBundle.getMessage(Utils.class, (String)("MSG_" + type + "FolderExists"));
            }
        }
        return null;
    }

    public static String validateSourcesAndCopyTarget(String sources, String copyTarget) {
        if (Utils.subdirectories(sources, copyTarget)) {
            return NbBundle.getMessage(Utils.class, (String)"MSG_SourcesEqualCopyTarget");
        }
        return null;
    }

    public static boolean subdirectories(String dir1, String dir2) {
        assert (dir1 != null);
        assert (dir2 != null);
        if (!dir1.endsWith(File.separator)) {
            dir1 = dir1 + File.separator;
        }
        if (!dir2.endsWith(File.separator)) {
            dir2 = dir2 + File.separator;
        }
        return dir1.startsWith(dir2) || dir2.startsWith(dir1);
    }

    public static String validateAsciiText(String text, String propertyName) {
        assert (propertyName != null);
        if (text == null) {
            return null;
        }
        for (int i = 0; i < text.length(); ++i) {
            if (Utils.isAsciiPrintable(text.charAt(i))) continue;
            return NbBundle.getMessage(Utils.class, (String)"MSG_NonAsciiCharacterFound", (Object)propertyName);
        }
        return null;
    }

    public static boolean isAsciiPrintable(char ch) {
        return ch >= ' ' && ch < '\u007f';
    }

    public static String unifyPath(String path) {
        assert (path != null);
        return path.replace(File.separatorChar, '/');
    }

    public static void browseFolderFile(PhpVisibilityQuery phpVisibilityQuery, FileObject folder, JTextField textField) throws FileNotFoundException {
        String selected = Utils.browseFolderFile(phpVisibilityQuery, folder, textField.getText());
        if (selected != null) {
            textField.setText(selected);
        }
    }

    public static void browseFolderFile(PhpVisibilityQuery phpVisibilityQuery, File folder, JTextField textField) throws FileNotFoundException {
        Utils.browseFolderFile(phpVisibilityQuery, FileUtil.toFileObject((File)folder), textField);
    }

    public static String browseFolderFile(PhpVisibilityQuery phpVisibilityQuery, FileObject folder, String preselected) throws FileNotFoundException {
        if (folder == null) {
            throw new FileNotFoundException();
        }
        FileObject selected = BrowseFolders.showDialog(phpVisibilityQuery, new FileObject[]{folder}, DataObject.class, Utils.securePreselected(preselected, true));
        if (selected != null) {
            return PropertyUtils.relativizeFile((File)FileUtil.toFile((FileObject)folder), (File)FileUtil.toFile((FileObject)selected));
        }
        return null;
    }

    public static void browseSourceFile(PhpProject project, JTextField textField) {
        String selected = Utils.browseSource(project, textField.getText(), false);
        if (selected != null) {
            textField.setText(selected);
        }
    }

    public static String browseSourceFile(PhpProject project, String preselected) {
        return Utils.browseSource(project, preselected, false);
    }

    public static void browseSourceFolder(PhpProject project, JTextField textField) {
        String selected = Utils.browseSource(project, textField.getText(), true);
        if (selected != null) {
            textField.setText(selected);
        }
    }

    public static String browseSourceFolder(PhpProject project, String preselected) {
        return Utils.browseSource(project, preselected, true);
    }

    private static String browseSource(PhpProject project, String preselected, boolean selectDirectory) {
        FileObject rootFolder = ProjectPropertiesSupport.getSourcesDirectory(project);
        assert (rootFolder != null);
        return Utils.browseFolder(project, rootFolder, preselected, selectDirectory);
    }

    @CheckForNull
    public static String browseFolder(PhpProject project, FileObject folder, String preselected) {
        return Utils.browseFolder(project, folder, preselected, true);
    }

    private static String browseFolder(PhpProject project, FileObject rootFolder, String preselected, boolean selectDirectory) {
        FileObject selected = BrowseFolders.showDialog(PhpVisibilityQuery.forProject(project), new FileObject[]{rootFolder}, selectDirectory ? DataFolder.class : DataObject.class, Utils.securePreselected(preselected, !selectDirectory));
        if (selected != null) {
            return PropertyUtils.relativizeFile((File)FileUtil.toFile((FileObject)rootFolder), (File)FileUtil.toFile((FileObject)selected));
        }
        return null;
    }

    private static String securePreselected(String preselected, boolean removeExtension) {
        if (preselected == null) {
            return null;
        }
        String secure = null;
        if (preselected.length() > 0) {
            int idx;
            secure = Utils.unifyPath(preselected);
            if (removeExtension && (idx = secure.lastIndexOf(46)) != -1) {
                secure = secure.substring(0, idx);
            }
        }
        return secure;
    }

    public static void showGeneralOptionsPanel() {
        UiUtils.showOptions((String)"General");
    }

    public static class PhpVersionComboBoxModel
    extends DefaultComboBoxModel<PhpVersion> {
        private static final long serialVersionUID = -48789765465878745L;

        public PhpVersionComboBoxModel() {
            this((PhpVersion)null);
        }

        public PhpVersionComboBoxModel(PhpVersion preselected) {
            super(PhpVersion.values());
            if (preselected != null) {
                this.setSelectedItem(preselected);
            } else {
                this.setSelectedItem(PhpVersion.getDefault());
            }
        }
    }
}

