/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.nette.tester.preferences;

import java.io.File;
import java.util.prefs.Preferences;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.nette.tester.TesterTestingProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class TesterPreferences {
    private static final String PHP_INI_ENABLED = "php.ini.enabled";
    private static final String PHP_INI_PATH = "php.ini.path";
    private static final String TESTER_ENABLED = "tester.enabled";
    private static final String TESTER_PATH = "tester.path";
    private static final String BINARY_ENABLED = "binary.enabled";
    private static final String BINARY_EXECUTABLE = "binary.executable";
    private static final String COVERAGE_SOURCE_PATH_ENABLED = "coverage.source.path.enabled";
    private static final String COVERAGE_SOURCE_PATH = "coverage.source.path";

    private TesterPreferences() {
    }

    public static boolean isPhpIniEnabled(PhpModule phpModule) {
        return TesterPreferences.getPreferences(phpModule).getBoolean(PHP_INI_ENABLED, false);
    }

    public static void setPhpIniEnabled(PhpModule phpModule, boolean phpIniEnabled) {
        TesterPreferences.getPreferences(phpModule).putBoolean(PHP_INI_ENABLED, phpIniEnabled);
    }

    @CheckForNull
    public static String getPhpIniPath(PhpModule phpModule) {
        return TesterPreferences.resolvePath(phpModule, TesterPreferences.getPreferences(phpModule).get(PHP_INI_PATH, null));
    }

    public static void setPhpIniPath(PhpModule phpModule, String phpIniPath) {
        TesterPreferences.getPreferences(phpModule).put(PHP_INI_PATH, TesterPreferences.relativizePath(phpModule, phpIniPath));
    }

    public static boolean isTesterEnabled(PhpModule phpModule) {
        return TesterPreferences.getPreferences(phpModule).getBoolean(TESTER_ENABLED, false);
    }

    public static void setTesterEnabled(PhpModule phpModule, boolean testerEnabled) {
        TesterPreferences.getPreferences(phpModule).putBoolean(TESTER_ENABLED, testerEnabled);
    }

    @CheckForNull
    public static String getTesterPath(PhpModule phpModule) {
        return TesterPreferences.resolvePath(phpModule, TesterPreferences.getPreferences(phpModule).get(TESTER_PATH, null));
    }

    public static void setTesterPath(PhpModule phpModule, String testerPath) {
        TesterPreferences.getPreferences(phpModule).put(TESTER_PATH, TesterPreferences.relativizePath(phpModule, testerPath));
    }

    public static boolean isBinaryEnabled(PhpModule phpModule) {
        return TesterPreferences.getPreferences(phpModule).getBoolean(BINARY_ENABLED, false);
    }

    public static void setBinaryEnabled(PhpModule phpModule, boolean binaryEnabled) {
        TesterPreferences.getPreferences(phpModule).putBoolean(BINARY_ENABLED, binaryEnabled);
    }

    @CheckForNull
    public static String getBinaryExecutable(PhpModule phpModule) {
        return TesterPreferences.getPreferences(phpModule).get(BINARY_EXECUTABLE, null);
    }

    public static void setBinaryExecutable(PhpModule phpModule, @NullAllowed String binaryExecutable) {
        if (binaryExecutable == null) {
            TesterPreferences.getPreferences(phpModule).remove(BINARY_EXECUTABLE);
        } else {
            TesterPreferences.getPreferences(phpModule).put(BINARY_EXECUTABLE, binaryExecutable);
        }
    }

    public static boolean isCoverageSourcePathEnabled(PhpModule phpModule) {
        return TesterPreferences.getPreferences(phpModule).getBoolean(COVERAGE_SOURCE_PATH_ENABLED, false);
    }

    public static void setCoverageSourcePathEnabled(PhpModule phpModule, boolean pathEnabled) {
        TesterPreferences.getPreferences(phpModule).putBoolean(COVERAGE_SOURCE_PATH_ENABLED, pathEnabled);
    }

    @CheckForNull
    public static String getCoverageSourcePath(PhpModule phpModule) {
        return TesterPreferences.resolvePath(phpModule, TesterPreferences.getPreferences(phpModule).get(COVERAGE_SOURCE_PATH, null));
    }

    public static void setCoverageSourcePath(PhpModule phpModule, String sourcePath) {
        TesterPreferences.getPreferences(phpModule).put(COVERAGE_SOURCE_PATH, TesterPreferences.relativizePath(phpModule, sourcePath));
    }

    private static Preferences getPreferences(PhpModule module) {
        return module.getPreferences(TesterTestingProvider.class, true);
    }

    private static String relativizePath(PhpModule phpModule, String filePath) {
        if (!StringUtils.hasText((String)filePath)) {
            return "";
        }
        File file = new File(filePath);
        String path = PropertyUtils.relativizeFile((File)FileUtil.toFile((FileObject)phpModule.getProjectDirectory()), (File)file);
        if (path == null) {
            path = file.getAbsolutePath();
        }
        return path;
    }

    private static String resolvePath(PhpModule phpModule, String filePath) {
        if (!StringUtils.hasText((String)filePath)) {
            return null;
        }
        return PropertyUtils.resolveFile((File)FileUtil.toFile((FileObject)phpModule.getProjectDirectory()), (String)filePath).getAbsolutePath();
    }
}

