/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.latte.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.php.latte.lexer.LatteMarkupTokenId;
import org.netbeans.modules.php.latte.lexer.LatteTopTokenId;

public final class LatteLexerUtils {
    private LatteLexerUtils() {
    }

    public static LanguagePath fetchLanguagePath(TokenHierarchy<?> tokenHierarchy, Language<?> language) {
        LanguagePath result = null;
        for (LanguagePath languagePath : tokenHierarchy.languagePaths()) {
            if (!languagePath.endsWith(LanguagePath.get(language))) continue;
            result = languagePath;
            break;
        }
        return result;
    }

    public static TokenSequence<? extends LatteMarkupTokenId> getLatteMarkupTokenSequence(Snapshot snapshot, int offset) {
        return LatteLexerUtils.getTokenSequence(snapshot.getTokenHierarchy(), offset, LatteMarkupTokenId.language());
    }

    public static TokenSequence<? extends LatteMarkupTokenId> getLatteMarkupTokenSequence(Document document, int offset) {
        TokenHierarchy th = TokenHierarchy.get((Document)document);
        return LatteLexerUtils.getTokenSequence(th, offset, LatteMarkupTokenId.language());
    }

    public static TokenSequence<? extends LatteTopTokenId> getLatteTopTokenSequence(Document document, int offset) {
        TokenHierarchy th = TokenHierarchy.get((Document)document);
        return LatteLexerUtils.getTokenSequence(th, offset, LatteTopTokenId.language());
    }

    public static <L> TokenSequence<? extends L> getTokenSequence(TokenHierarchy<?> th, int offset, Language<? extends L> language) {
        TokenSequence ts = th.tokenSequence(language);
        if (ts == null) {
            List list = th.embeddedTokenSequences(offset, true);
            for (TokenSequence t : list) {
                if (t.language() != language) continue;
                ts = t;
                break;
            }
            if (ts == null) {
                list = th.embeddedTokenSequences(offset, false);
                for (TokenSequence t : list) {
                    if (t.language() != language) continue;
                    ts = t;
                    break;
                }
            }
        }
        return ts;
    }

    public static List<OffsetRange> findForwardMatching(TokenSequence<? extends LatteTopTokenId> topTs, LatteTokenText start, LatteTokenText end) {
        return LatteLexerUtils.findForwardMatching(topTs, start, end, Collections.emptyList());
    }

    public static List<OffsetRange> findForwardMatching(TokenSequence<? extends LatteTopTokenId> topTs, LatteTokenText start, LatteTokenText end, List<LatteTokenText> middle) {
        ArrayList<OffsetRange> result = new ArrayList<OffsetRange>();
        topTs.moveNext();
        int originalOffset = topTs.offset();
        int balance = 1;
        while (topTs.moveNext()) {
            TokenSequence markupTs;
            Token token = topTs.token();
            if (token == null || token.id() != LatteTopTokenId.T_LATTE || (markupTs = topTs.embedded(LatteMarkupTokenId.language())) == null) continue;
            while (markupTs.moveNext()) {
                Token markupToken = markupTs.token();
                if (start.matches((Token<? extends LatteMarkupTokenId>)markupToken)) {
                    ++balance;
                    continue;
                }
                if (end.matches((Token<? extends LatteMarkupTokenId>)markupToken)) {
                    if (--balance != 0) continue;
                    result.add(new OffsetRange(markupTs.offset(), markupTs.offset() + markupToken.length()));
                    break;
                }
                if (!LatteLexerUtils.matchesToken(middle, (Token<? extends LatteMarkupTokenId>)markupToken) || balance != 1) continue;
                result.add(new OffsetRange(markupTs.offset(), markupTs.offset() + markupToken.length()));
                break;
            }
            if (balance != 0) continue;
            break;
        }
        topTs.move(originalOffset);
        return result;
    }

    public static List<OffsetRange> findBackwardMatching(TokenSequence<? extends LatteTopTokenId> topTs, LatteTokenText start, LatteTokenText end) {
        return LatteLexerUtils.findBackwardMatching(topTs, start, end, Collections.emptyList());
    }

    public static List<OffsetRange> findBackwardMatching(TokenSequence<? extends LatteTopTokenId> topTs, LatteTokenText start, LatteTokenText end, List<LatteTokenText> middle) {
        ArrayList<OffsetRange> result = new ArrayList<OffsetRange>();
        topTs.movePrevious();
        int originalOffset = topTs.offset();
        int balance = 1;
        while (topTs.movePrevious()) {
            TokenSequence markupTs;
            Token token = topTs.token();
            if (token == null || token.id() != LatteTopTokenId.T_LATTE || (markupTs = topTs.embedded(LatteMarkupTokenId.language())) == null) continue;
            markupTs.moveEnd();
            while (markupTs.movePrevious()) {
                Token markupToken = markupTs.token();
                if (start.matches((Token<? extends LatteMarkupTokenId>)markupToken)) {
                    ++balance;
                    continue;
                }
                if (end.matches((Token<? extends LatteMarkupTokenId>)markupToken)) {
                    if (--balance != 0) continue;
                    result.add(new OffsetRange(markupTs.offset(), markupTs.offset() + markupToken.length()));
                    break;
                }
                if (!LatteLexerUtils.matchesToken(middle, (Token<? extends LatteMarkupTokenId>)markupToken) || balance != 1) continue;
                result.add(new OffsetRange(markupTs.offset(), markupTs.offset() + markupToken.length()));
                break;
            }
            if (balance != 0) continue;
            break;
        }
        topTs.move(originalOffset);
        return result;
    }

    private static boolean matchesToken(List<LatteTokenText> middle, Token<? extends LatteMarkupTokenId> markupToken) {
        boolean result = false;
        for (LatteTokenText twigTokenText : middle) {
            if (!twigTokenText.matches(markupToken)) continue;
            result = true;
            break;
        }
        return result;
    }

    public static interface LatteTokenText {
        public static final LatteTokenText NONE = new LatteTokenText(){

            @Override
            public boolean matches(Token<? extends LatteMarkupTokenId> token) {
                return false;
            }
        };

        public boolean matches(Token<? extends LatteMarkupTokenId> var1);
    }

    public static final class LatteTokenTextImpl
    implements LatteTokenText {
        private final LatteMarkupTokenId tokenId;
        private final String tokenText;

        public static LatteTokenText create(LatteMarkupTokenId tokenId, String tokenText) {
            return new LatteTokenTextImpl(tokenId, tokenText);
        }

        private LatteTokenTextImpl(LatteMarkupTokenId tokenId, String tokenText) {
            this.tokenId = tokenId;
            this.tokenText = tokenText;
        }

        @Override
        public boolean matches(Token<? extends LatteMarkupTokenId> token) {
            return token != null && token.id() == this.tokenId && this.tokenText.equals(token.text().toString());
        }

        public int hashCode() {
            int hash = 7;
            hash = 71 * hash + Objects.hashCode((Object)this.tokenId);
            hash = 71 * hash + Objects.hashCode(this.tokenText);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LatteTokenTextImpl other = (LatteTokenTextImpl)obj;
            if (this.tokenId != other.tokenId) {
                return false;
            }
            return Objects.equals(this.tokenText, other.tokenText);
        }

        public String toString() {
            return "LatteTokenText{tokenId=" + this.tokenId + ", tokenText=" + this.tokenText + "}";
        }
    }
}

