/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.latte.completion;

import java.util.List;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.php.latte.completion.CompletionProviders;
import org.netbeans.modules.php.latte.completion.LatteCompletionHandler;
import org.netbeans.modules.php.latte.completion.LatteCompletionProposal;
import org.netbeans.modules.php.latte.completion.LatteElement;
import org.netbeans.modules.php.spi.templates.completion.CompletionProvider;
import org.openide.filesystems.FileObject;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum LatteCompletionContext {
    ALL{

        @Override
        public void complete(List<CompletionProposal> completionProposals, LatteCompletionProposal.CompletionRequest request) {
            this.completeMacros(completionProposals, request);
            this.completeHelpers(completionProposals, request);
            this.completeKeywords(completionProposals, request);
        }
    }
    ,
    MACRO{

        @Override
        public void complete(List<CompletionProposal> completionProposals, LatteCompletionProposal.CompletionRequest request) {
            this.completeMacros(completionProposals, request);
            this.completeVariables(completionProposals, request);
        }
    }
    ,
    END_MACRO{

        @Override
        public void complete(List<CompletionProposal> completionProposals, LatteCompletionProposal.CompletionRequest request) {
            this.completeEndMacros(completionProposals, request);
        }
    }
    ,
    HELPER{

        @Override
        public void complete(List<CompletionProposal> completionProposals, LatteCompletionProposal.CompletionRequest request) {
            this.completeHelpers(completionProposals, request);
        }
    }
    ,
    ITERATOR_ITEM{

        @Override
        public void complete(List<CompletionProposal> completionProposals, LatteCompletionProposal.CompletionRequest request) {
            this.completeIteratorItems(completionProposals, request);
        }
    }
    ,
    VARIABLE{

        @Override
        public void complete(List<CompletionProposal> completionProposals, LatteCompletionProposal.CompletionRequest request) {
            this.completeVariables(completionProposals, request);
        }
    }
    ,
    EMPTY_DELIMITERS{

        @Override
        public void complete(List<CompletionProposal> completionProposals, LatteCompletionProposal.CompletionRequest request) {
            this.completeMacros(completionProposals, request);
            this.completeVariables(completionProposals, request);
            this.completeEndMacros(completionProposals, request);
        }
    }
    ,
    CONTROL_MACRO{

        @Override
        public void complete(List<CompletionProposal> completionProposals, LatteCompletionProposal.CompletionRequest request) {
            this.completeControls(completionProposals, request);
        }
    }
    ,
    NONE{

        @Override
        public void complete(List<CompletionProposal> completionProposals, LatteCompletionProposal.CompletionRequest request) {
        }
    };


    public abstract void complete(List<CompletionProposal> var1, LatteCompletionProposal.CompletionRequest var2);

    protected void completeMacros(List<CompletionProposal> completionProposals, LatteCompletionProposal.CompletionRequest request) {
        for (LatteElement macro : LatteCompletionHandler.MACROS) {
            if (!LatteCompletionContext.startsWith(macro.getName(), request.prefix)) continue;
            completionProposals.add(new LatteCompletionProposal.StartMacroCompletionProposal(macro, request));
        }
    }

    protected void completeEndMacros(List<CompletionProposal> completionProposals, LatteCompletionProposal.CompletionRequest request) {
        for (LatteElement endMacro : LatteCompletionHandler.END_MACROS) {
            if (!LatteCompletionContext.startsWith(endMacro.getName(), request.prefix)) continue;
            completionProposals.add(new LatteCompletionProposal.EndMacroCompletionProposal(endMacro, request));
        }
    }

    protected void completeHelpers(List<CompletionProposal> completionProposals, LatteCompletionProposal.CompletionRequest request) {
        for (LatteElement helper : LatteCompletionHandler.HELPERS) {
            if (!LatteCompletionContext.startsWith(helper.getName(), request.prefix)) continue;
            completionProposals.add(new LatteCompletionProposal.HelperCompletionProposal(helper, request));
        }
    }

    protected void completeKeywords(List<CompletionProposal> completionProposals, LatteCompletionProposal.CompletionRequest request) {
        for (LatteElement keyword : LatteCompletionHandler.KEYWORDS) {
            if (!LatteCompletionContext.startsWith(keyword.getName(), request.prefix)) continue;
            completionProposals.add(new LatteCompletionProposal.KeywordCompletionProposal(keyword, request));
        }
    }

    protected void completeIteratorItems(List<CompletionProposal> completionProposals, LatteCompletionProposal.CompletionRequest request) {
        this.completeIteratorFieldItems(completionProposals, request);
        this.completeIteratorMethodItems(completionProposals, request);
    }

    private void completeIteratorFieldItems(List<CompletionProposal> completionProposals, LatteCompletionProposal.CompletionRequest request) {
        for (LatteElement iteratorItem : LatteCompletionHandler.ITERATOR_FIELD_ITEMS) {
            if (!LatteCompletionContext.startsWith(iteratorItem.getName(), request.prefix)) continue;
            completionProposals.add(new LatteCompletionProposal.IteratorFieldItemCompletionProposal(iteratorItem, request));
        }
    }

    private void completeIteratorMethodItems(List<CompletionProposal> completionProposals, LatteCompletionProposal.CompletionRequest request) {
        for (LatteElement iteratorItem : LatteCompletionHandler.ITERATOR_METHOD_ITEMS) {
            if (!LatteCompletionContext.startsWith(iteratorItem.getName(), request.prefix)) continue;
            completionProposals.add(new LatteCompletionProposal.IteratorMethodItemCompletionProposal(iteratorItem, request));
        }
    }

    protected void completeVariables(List<CompletionProposal> completionProposals, LatteCompletionProposal.CompletionRequest request) {
        this.completeDefaultVariables(completionProposals, request);
        this.completeProvidedVariables(completionProposals, request);
    }

    private void completeDefaultVariables(List<CompletionProposal> completionProposals, LatteCompletionProposal.CompletionRequest request) {
        for (LatteElement variable : LatteCompletionHandler.DEFAULT_VARIABLES) {
            if (!LatteCompletionContext.startsWith(variable.getName(), request.prefix)) continue;
            completionProposals.add(new LatteCompletionProposal.DefaultVariableCompletionProposal(variable, request));
        }
    }

    private void completeProvidedVariables(List<CompletionProposal> completionProposals, LatteCompletionProposal.CompletionRequest request) {
        FileObject sourceFileObject = request.parserResult.getSnapshot().getSource().getFileObject();
        List<CompletionProvider> variableProviders = CompletionProviders.getVariableProviders();
        for (CompletionProvider variableProvider : variableProviders) {
            for (String variable : variableProvider.getItems(sourceFileObject, request.prefix)) {
                completionProposals.add(new LatteCompletionProposal.UserVariableCompletionProposal(LatteElement.VariableFactory.create(variable), request));
            }
        }
    }

    protected void completeControls(List<CompletionProposal> completionProposals, LatteCompletionProposal.CompletionRequest request) {
        FileObject sourceFileObject = request.parserResult.getSnapshot().getSource().getFileObject();
        List<CompletionProvider> controlProviders = CompletionProviders.getControlProviders();
        for (CompletionProvider controlProvider : controlProviders) {
            for (String item : controlProvider.getItems(sourceFileObject, request.prefix)) {
                completionProposals.add(new LatteCompletionProposal.ControlCompletionProposal(LatteElement.ControlFactory.create(item), request));
            }
        }
    }

    private static boolean startsWith(String theString, String prefix) {
        return prefix.length() == 0 ? true : theString.toLowerCase().startsWith(prefix.toLowerCase());
    }
}

