/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.packets;

import java.io.UnsupportedEncodingException;
import java.util.Base64;
import org.netbeans.modules.php.dbgp.packets.PropertyCommand;

public class PropertySetCommand
extends PropertyCommand {
    static final String PROPERTY_SET = "property_set";
    private static final String TYPE_ARG = "-t ";
    static final String ADDRESS_ARG = "-a ";
    private static final String LENGTH_ARG = "-l ";
    private String myDataType;
    private int myPropAddress = -1;
    private String myData;

    public PropertySetCommand(String transactionId) {
        super(PROPERTY_SET, transactionId);
    }

    @Override
    public boolean wantAcknowledgment() {
        return true;
    }

    public void setDataType(String type) {
        this.myDataType = type;
    }

    public void setAddress(int address) {
        this.myPropAddress = address;
    }

    public void setData(String data) {
        this.myData = data;
    }

    @Override
    public String getName() {
        return super.getName();
    }

    @Override
    protected String getData() {
        return this.myData;
    }

    @Override
    protected String getArguments() {
        StringBuilder builder;
        block5: {
            builder = new StringBuilder(super.getArguments());
            if (this.myDataType != null) {
                builder.append(" ");
                builder.append(TYPE_ARG);
                builder.append(this.myDataType);
            }
            if (this.myPropAddress != -1) {
                builder.append(" ");
                builder.append(ADDRESS_ARG);
                builder.append(this.myPropAddress);
            }
            if (this.getData() != null && this.getData().length() > 0) {
                try {
                    int size = Base64.getEncoder().encodeToString(this.getData().getBytes("ISO-8859-1")).length();
                    builder.append(" ");
                    builder.append(LENGTH_ARG);
                    builder.append(size);
                }
                catch (UnsupportedEncodingException e) {
                    if ($assertionsDisabled) break block5;
                    throw new AssertionError();
                }
            }
        }
        return builder.toString();
    }
}

