/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.analysis.commands;

import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.base.input.InputProcessor;
import org.netbeans.api.extexecution.base.input.InputProcessors;
import org.netbeans.api.extexecution.base.input.LineProcessor;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.php.analysis.commands.Bundle;
import org.netbeans.modules.php.analysis.options.AnalysisOptions;
import org.netbeans.modules.php.analysis.parsers.CodeSnifferReportParser;
import org.netbeans.modules.php.analysis.results.Result;
import org.netbeans.modules.php.api.executable.InvalidPhpExecutableException;
import org.netbeans.modules.php.api.executable.PhpExecutable;
import org.netbeans.modules.php.api.executable.PhpExecutableValidator;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.queries.Queries;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.api.util.UiUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class CodeSniffer {
    static final Logger LOGGER = Logger.getLogger(CodeSniffer.class.getName());
    public static final String NAME = "phpcs";
    public static final String LONG_NAME = "phpcs" + FileUtils.getScriptExtension((boolean)true);
    static final File XML_LOG = new File(System.getProperty("java.io.tmpdir"), "nb-php-phpcs-log.xml");
    private static final String STANDARD_PARAM = "--standard";
    private static final String STANDARD_PARAM_FORMAT = "--standard=%s";
    private static final String RUNTIME_SET_PARAM = "--runtime-set";
    private static final String DEFAULT_STANDARD_PARAM = "default_standard";
    private static final String LIST_STANDARDS_PARAM = "-i";
    private static final String REPORT_PARAM = "--report=xml";
    private static final String EXTENSIONS_PARAM = "--extensions=%s";
    private static final String ENCODING_PARAM = "--encoding=%s";
    private static final String IGNORE_PARAM = "--ignore=%s";
    private static final String NO_RECURSION_PARAM = "-l";
    private static final List<String> CACHED_STANDARDS = new CopyOnWriteArrayList<String>();
    private final String codeSnifferPath;
    private volatile int analyzeGroupCounter = 1;

    private CodeSniffer(String codeSnifferPath) {
        this.codeSnifferPath = codeSnifferPath;
    }

    public static CodeSniffer getDefault() throws InvalidPhpExecutableException {
        return CodeSniffer.getCustom(AnalysisOptions.getInstance().getCodeSnifferPath());
    }

    public static CodeSniffer getCustom(String path) throws InvalidPhpExecutableException {
        String error = CodeSniffer.validate(path);
        if (error != null) {
            throw new InvalidPhpExecutableException(error);
        }
        return new CodeSniffer(path);
    }

    public static String validate(String codeSnifferPath) {
        return PhpExecutableValidator.validateCommand((String)codeSnifferPath, (String)Bundle.CodeSniffer_script_label());
    }

    public static void clearCachedStandards() {
        CACHED_STANDARDS.clear();
    }

    public void startAnalyzeGroup() {
        this.analyzeGroupCounter = 1;
    }

    @CheckForNull
    public List<Result> analyze(String standard, FileObject file) {
        return this.analyze(standard, file, false);
    }

    @CheckForNull
    public List<Result> analyze(String standard, FileObject file, boolean noRecursion) {
        assert (file.isValid()) : "Invalid file given: " + file;
        try {
            Integer result = this.getExecutable(Bundle.CodeSniffer_analyze(this.analyzeGroupCounter++), this.findWorkDir(file)).additionalParameters(this.getParameters(this.ensureStandard(standard), file, noRecursion)).runAndWait(this.getDescriptor(), "Running code sniffer...");
            if (result == null) {
                return null;
            }
            if (!XML_LOG.isFile() && result == 0) {
                return Collections.emptyList();
            }
            return CodeSnifferReportParser.parse(XML_LOG);
        }
        catch (CancellationException ex) {
            return Collections.emptyList();
        }
        catch (ExecutionException ex) {
            LOGGER.log(Level.INFO, null, ex);
            UiUtils.processExecutionException((ExecutionException)ex, (String)"CodeAnalysis");
            return null;
        }
    }

    @CheckForNull
    public List<String> getStandards() {
        if (!CACHED_STANDARDS.isEmpty()) {
            return Collections.unmodifiableList(CACHED_STANDARDS);
        }
        StandardsOutputProcessorFactory standardsProcessorFactory = new StandardsOutputProcessorFactory();
        try {
            this.getExecutable(Bundle.CodeSniffer_listStandards(), null).additionalParameters(Collections.singletonList(LIST_STANDARDS_PARAM)).runAndWait(this.getDescriptor(), (ExecutionDescriptor.InputProcessorFactory2)standardsProcessorFactory, "Fetching standards...");
            if (!standardsProcessorFactory.hasStandards() && standardsProcessorFactory.hasOutput) {
                return null;
            }
            List<String> standards = standardsProcessorFactory.getStandards();
            CACHED_STANDARDS.addAll(standards);
            return standards;
        }
        catch (CancellationException ex) {
            LOGGER.log(Level.FINE, "Fetching standards cancelled", ex);
        }
        catch (ExecutionException ex) {
            LOGGER.log(Level.INFO, null, ex);
            UiUtils.processExecutionException((ExecutionException)ex, (String)"CodeAnalysis");
        }
        return null;
    }

    @CheckForNull
    private File findWorkDir(FileObject file) {
        assert (file != null);
        Project project = FileOwnerQuery.getOwner((FileObject)file);
        if (project != null) {
            File projectDir = FileUtil.toFile((FileObject)project.getProjectDirectory());
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Project directory for {0} found in {1}", new Object[]{FileUtil.toFile((FileObject)file), projectDir});
            }
            return projectDir;
        }
        return null;
    }

    private PhpExecutable getExecutable(String title, @NullAllowed File workDir) {
        PhpExecutable executable = new PhpExecutable(this.codeSnifferPath).fileOutput(XML_LOG, "UTF-8", false).optionsSubcategory("CodeAnalysis").displayName(title);
        if (workDir != null) {
            executable.workDir(workDir);
        }
        return executable;
    }

    private ExecutionDescriptor getDescriptor() {
        return PhpExecutable.DEFAULT_EXECUTION_DESCRIPTOR.optionsPath("org-netbeans-modules-php-project-ui-options-PHPOptionsCategory/CodeAnalysis").frontWindowOnError(false).inputVisible(false).preExecution(new Runnable(){

            @Override
            public void run() {
                if (XML_LOG.isFile() && !XML_LOG.delete()) {
                    LOGGER.log(Level.INFO, "Cannot delete log file {0}", XML_LOG.getAbsolutePath());
                }
            }
        });
    }

    private List<String> getParameters(String standard, FileObject file, boolean noRecursion) {
        Charset encoding = FileEncodingQuery.getEncoding((FileObject)file);
        ArrayList<String> params = new ArrayList<String>();
        if (!this.codeSnifferPath.contains("--standard=") && !this.codeSnifferPath.contains("--standard ")) {
            params.add(String.format(STANDARD_PARAM_FORMAT, standard));
        }
        params.add(REPORT_PARAM);
        params.add(String.format(EXTENSIONS_PARAM, StringUtils.implode((Collection)FileUtil.getMIMETypeExtensions((String)"text/x-php5"), (String)",")));
        params.add(String.format(ENCODING_PARAM, encoding.name()));
        this.addIgnoredFiles(params, file);
        if (noRecursion) {
            params.add(NO_RECURSION_PARAM);
        }
        params.add(FileUtil.toFile((FileObject)file).getAbsolutePath());
        return params;
    }

    private String ensureStandard(String standard) {
        if (standard != null) {
            return standard;
        }
        List<String> standards = this.getStandards();
        if (standards == null) {
            return "PEAR";
        }
        return standards.get(0);
    }

    private void addIgnoredFiles(List<String> params, FileObject file) {
        Collection ignoredFiles = Queries.getVisibilityQuery((PhpModule)PhpModule.Factory.forFileObject((FileObject)file)).getCodeAnalysisExcludeFiles();
        if (ignoredFiles.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (FileObject fileObject : ignoredFiles) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(FileUtil.getFileDisplayName((FileObject)fileObject).replace(File.separatorChar, '/'));
            sb.append("/*");
        }
        params.add(String.format(IGNORE_PARAM, sb.toString()));
    }

    static final class StandardsOutputProcessorFactory
    implements ExecutionDescriptor.InputProcessorFactory2 {
        static final String LINE_START = "The installed coding standards are ";
        private final List<String> standards = new CopyOnWriteArrayList<String>();
        private volatile boolean hasOutput = false;

        StandardsOutputProcessorFactory() {
        }

        public InputProcessor newInputProcessor(InputProcessor defaultProcessor) {
            return InputProcessors.bridge((LineProcessor)new LineProcessor(){

                public void processLine(String line) {
                    List<String> parsed;
                    hasOutput = true;
                    if (line.startsWith(StandardsOutputProcessorFactory.LINE_START) && (parsed = StandardsOutputProcessorFactory.parseStandards(line)) != null) {
                        standards.addAll(parsed);
                    }
                }

                public void reset() {
                }

                public void close() {
                }
            });
        }

        public List<String> getStandards() {
            return this.standards;
        }

        public boolean hasStandards() {
            return !this.standards.isEmpty();
        }

        public boolean hasOutput() {
            return this.hasOutput;
        }

        @CheckForNull
        public static List<String> parseStandards(String line) {
            assert (line.startsWith(LINE_START)) : line;
            line = line.substring(LINE_START.length());
            ArrayList<String> standards = new ArrayList<String>();
            List tmp = StringUtils.explode((String)line, (String)" and ");
            if (tmp.isEmpty()) {
                LOGGER.log(Level.WARNING, "Standards cannot be parsed from: {0}", line);
                return null;
            }
            if (tmp.size() != 2) {
                LOGGER.log(Level.WARNING, "Unexpected standards in: {0}", line);
                return null;
            }
            standards.add((String)tmp.get(1));
            String rest = (String)tmp.get(0);
            tmp = StringUtils.explode((String)rest, (String)", ");
            if (tmp.isEmpty()) {
                LOGGER.log(Level.WARNING, "Standards cannot be parsed from: {0}", rest);
            } else {
                standards.addAll(tmp);
            }
            Collections.sort(standards);
            return standards;
        }
    }
}

