/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.analysis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.modules.analysis.spi.Analyzer;
import org.netbeans.modules.php.analysis.Bundle;
import org.netbeans.modules.php.analysis.commands.MessDetector;
import org.netbeans.modules.php.analysis.options.AnalysisOptions;
import org.netbeans.modules.php.analysis.options.AnalysisOptionsValidator;
import org.netbeans.modules.php.analysis.results.Result;
import org.netbeans.modules.php.analysis.ui.analyzer.MessDetectorCustomizerPanel;
import org.netbeans.modules.php.analysis.util.AnalysisUtils;
import org.netbeans.modules.php.analysis.util.Mappers;
import org.netbeans.modules.php.api.executable.InvalidPhpExecutableException;
import org.netbeans.modules.php.api.validation.ValidationResult;
import org.netbeans.modules.refactoring.api.Scope;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.HintsController;
import org.openide.filesystems.FileObject;

public class MessDetectorAnalyzerImpl
implements Analyzer {
    private static final Logger LOGGER = Logger.getLogger(MessDetectorAnalyzerImpl.class.getName());
    private final Analyzer.Context context;
    private final AtomicBoolean cancelled = new AtomicBoolean();

    MessDetectorAnalyzerImpl(Analyzer.Context context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<? extends ErrorDescription> analyze() {
        Preferences settings = this.context.getSettings();
        if (settings != null && !settings.getBoolean("messDetector.enabled", false)) {
            return Collections.emptyList();
        }
        MessDetector messDetector = this.getValidMessDetector();
        if (messDetector == null) {
            this.context.reportAnalysisProblem(Bundle.MessDetectorAnalyzerImpl_messDetector_error(), (CharSequence)Bundle.MessDetectorAnalyzerImpl_messDetector_error_description());
            return Collections.emptyList();
        }
        List<String> messDetectorRuleSets = this.getValidMessDetectorRuleSets();
        if (messDetectorRuleSets == null) {
            this.context.reportAnalysisProblem(Bundle.MessDetectorAnalyzerImpl_messDetector_ruleSets_error(), (CharSequence)Bundle.MessDetectorAnalyzerImpl_messDetector_ruleSets_error_description());
            return Collections.emptyList();
        }
        Scope scope = this.context.getScope();
        Map<FileObject, Integer> fileCount = AnalysisUtils.countPhpFiles(scope);
        int totalCount = 0;
        for (Integer count : fileCount.values()) {
            totalCount += count.intValue();
        }
        this.context.start(totalCount);
        try {
            Iterable<? extends ErrorDescription> iterable = this.doAnalyze(scope, messDetector, messDetectorRuleSets, fileCount);
            return iterable;
        }
        finally {
            this.context.finish();
        }
    }

    public boolean cancel() {
        this.cancelled.set(true);
        return true;
    }

    private Iterable<? extends ErrorDescription> doAnalyze(Scope scope, MessDetector messDetector, List<String> messDetectorRuleSets, Map<FileObject, Integer> fileCount) {
        List<Result> results;
        ArrayList<Object> errors = new ArrayList<Object>();
        int progress = 0;
        messDetector.startAnalyzeGroup();
        for (FileObject root : scope.getSourceRoots()) {
            if (this.cancelled.get()) {
                return Collections.emptyList();
            }
            results = messDetector.analyze(messDetectorRuleSets, root);
            if (results == null) {
                this.context.reportAnalysisProblem(Bundle.MessDetectorAnalyzerImpl_analyze_error(), (CharSequence)Bundle.MessDetectorAnalyzerImpl_analyze_error_description());
                return Collections.emptyList();
            }
            errors.addAll(Mappers.map(results));
            this.context.progress(progress += fileCount.get(root).intValue());
        }
        for (FileObject file : scope.getFiles()) {
            if (this.cancelled.get()) {
                return Collections.emptyList();
            }
            results = messDetector.analyze(messDetectorRuleSets, file);
            if (results == null) {
                this.context.reportAnalysisProblem(Bundle.MessDetectorAnalyzerImpl_analyze_error(), (CharSequence)Bundle.MessDetectorAnalyzerImpl_analyze_error_description());
                return Collections.emptyList();
            }
            errors.addAll(Mappers.map(results));
            this.context.progress(progress += fileCount.get(file).intValue());
        }
        for (NonRecursiveFolder nonRecursiveFolder : scope.getFolders()) {
            if (this.cancelled.get()) {
                return Collections.emptyList();
            }
            FileObject folder = nonRecursiveFolder.getFolder();
            ArrayList<FileObject> dataChildren = new ArrayList<FileObject>();
            for (FileObject child : folder.getChildren()) {
                if (!child.isData()) continue;
                dataChildren.add(child);
            }
            if (dataChildren.isEmpty()) continue;
            List<Result> results2 = messDetector.analyze(messDetectorRuleSets, dataChildren);
            if (results2 == null) {
                this.context.reportAnalysisProblem(Bundle.MessDetectorAnalyzerImpl_analyze_error(), (CharSequence)Bundle.MessDetectorAnalyzerImpl_analyze_error_description());
                return Collections.emptyList();
            }
            errors.addAll(Mappers.map(results2));
            this.context.progress(progress += fileCount.get(folder).intValue());
        }
        return errors;
    }

    @CheckForNull
    private MessDetector getValidMessDetector() {
        try {
            return MessDetector.getDefault();
        }
        catch (InvalidPhpExecutableException ex) {
            LOGGER.log(Level.INFO, null, ex);
            return null;
        }
    }

    private List<String> getValidMessDetectorRuleSets() {
        List<String> messDetectorRuleSets = MessDetectorCustomizerPanel.getRuleSets(this.context.getSettings());
        if (messDetectorRuleSets == null) {
            messDetectorRuleSets = AnalysisOptions.getInstance().getMessDetectorRuleSets();
        }
        assert (messDetectorRuleSets != null);
        ValidationResult result = new AnalysisOptionsValidator().validateMessDetectorRuleSets(messDetectorRuleSets).getResult();
        if (result.hasErrors() || result.hasWarnings()) {
            return null;
        }
        return messDetectorRuleSets;
    }

    public static final class MessDetectorAnalyzerFactory
    extends Analyzer.AnalyzerFactory {
        private static final String ICON_PATH = "org/netbeans/modules/php/analysis/ui/resources/mess-detector.png";

        public MessDetectorAnalyzerFactory() {
            super("PhpMessDetector", Bundle.MessDetectorAnalyzerFactory_displayName(), ICON_PATH);
        }

        public Iterable<? extends Analyzer.WarningDescription> getWarnings() {
            return Collections.emptyList();
        }

        public Analyzer.CustomizerProvider<Void, MessDetectorCustomizerPanel> getCustomizerProvider() {
            return new Analyzer.CustomizerProvider<Void, MessDetectorCustomizerPanel>(){

                public Void initialize() {
                    return null;
                }

                public MessDetectorCustomizerPanel createComponent(Analyzer.CustomizerContext<Void, MessDetectorCustomizerPanel> context) {
                    return new MessDetectorCustomizerPanel(context);
                }
            };
        }

        public Analyzer createAnalyzer(Analyzer.Context context) {
            return new MessDetectorAnalyzerImpl(context);
        }

        public void warningOpened(ErrorDescription warning) {
            HintsController.setErrors((FileObject)warning.getFile(), (String)"phpMessDetectorWarning", Collections.singleton(warning));
        }
    }
}

