/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.apigen.options;

import java.util.List;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.apigen.commands.ApiGenScript;
import org.openide.util.ChangeSupport;
import org.openide.util.NbPreferences;

public final class ApiGenOptions {
    private static final String PREFERENCES_PATH = "apigen";
    private static final ApiGenOptions INSTANCE = new ApiGenOptions();
    private static final String APIGEN = "apigen.path";
    final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private volatile boolean apigenSearched = false;

    private ApiGenOptions() {
        this.getPreferences().addPreferenceChangeListener(new PreferenceChangeListener(){

            @Override
            public void preferenceChange(PreferenceChangeEvent evt) {
                ApiGenOptions.this.changeSupport.fireChange();
            }
        });
    }

    public static ApiGenOptions getInstance() {
        return INSTANCE;
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public String getApiGen() {
        String apiGen = this.getPreferences().get(APIGEN, null);
        if (apiGen == null && !this.apigenSearched) {
            this.apigenSearched = true;
            List scripts = FileUtils.findFileOnUsersPath((String[])new String[]{PREFERENCES_PATH, ApiGenScript.SCRIPT_NAME_LONG});
            if (!scripts.isEmpty()) {
                apiGen = (String)scripts.get(0);
                this.setApiGen(apiGen);
            }
        }
        return apiGen;
    }

    public void setApiGen(String apiGen) {
        this.getPreferences().put(APIGEN, apiGen);
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(ApiGenOptions.class).node(PREFERENCES_PATH);
    }
}

