/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.api.executable;

import java.awt.EventQueue;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.extexecution.base.ProcessBuilder;
import org.netbeans.api.extexecution.base.input.InputProcessor;
import org.netbeans.api.extexecution.base.input.InputProcessors;
import org.netbeans.api.progress.BaseProgressUtils;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.php.api.PhpOptions;
import org.netbeans.modules.php.api.executable.Bundle;
import org.netbeans.modules.php.api.executable.InvalidPhpExecutableException;
import org.netbeans.modules.php.api.executable.PhpExecutableValidator;
import org.netbeans.modules.php.api.executable.PhpInterpreter;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.api.util.UiUtils;
import org.netbeans.modules.php.spi.executable.DebugStarter;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Cancellable;
import org.openide.util.Lookup;
import org.openide.util.Pair;
import org.openide.util.Parameters;
import org.openide.util.Utilities;
import org.openide.windows.InputOutput;

public final class PhpExecutable {
    private static final Logger LOGGER = Logger.getLogger(PhpExecutable.class.getName());
    private static final Project DUMMY_PROJECT = new DummyProject();
    public static final ExecutionDescriptor.InputProcessorFactory2 ANSI_STRIPPING_FACTORY = new ExecutionDescriptor.InputProcessorFactory2(){

        public InputProcessor newInputProcessor(InputProcessor defaultProcessor) {
            return InputProcessors.ansiStripping((InputProcessor)defaultProcessor);
        }
    };
    public static final ExecutionDescriptor DEFAULT_EXECUTION_DESCRIPTOR = new ExecutionDescriptor().controllable(true).frontWindow(true).frontWindowOnError(true).inputVisible(true).showProgress(true);
    private final String executable;
    private final List<String> parameters;
    private final String command;
    final List<String> fullCommand = new CopyOnWriteArrayList<String>();
    private String executableName = null;
    private String displayName = null;
    private String optionsSubcategory = null;
    private boolean viaPhpInterpreter = false;
    private boolean viaAutodetection = true;
    private boolean redirectErrorStream = false;
    private File workDir = null;
    private boolean warnUser = true;
    private List<String> additionalParameters = Collections.emptyList();
    private Map<String, String> environmentVariables = Collections.emptyMap();
    private PhpExecutableValidator.ValidationHandler validationHandler = null;
    private File fileOutput = null;
    private Charset outputCharset = null;
    private boolean fileOutputOnly = false;
    private boolean noInfo = false;
    private boolean noDebugConfig = false;

    public PhpExecutable(String command) {
        Pair<String, List<String>> parsedCommand = PhpExecutable.parseCommand(command);
        this.executable = (String)parsedCommand.first();
        this.parameters = (List)parsedCommand.second();
        this.command = command.trim();
    }

    static Pair<String, List<String>> parseCommand(String command) {
        String[] tokens;
        if (command == null) {
            command = "";
        }
        if ((tokens = command.split(" * (?=\\-|/)", 2)).length == 1) {
            LOGGER.log(Level.FINE, "Only program given (no parameters): {0}", command);
            return Pair.of((Object)tokens[0].trim(), Collections.emptyList());
        }
        Pair parsedCommand = Pair.of((Object)tokens[0].trim(), Arrays.asList(Utilities.parseParameters((String)tokens[1].trim())));
        LOGGER.log(Level.FINE, "Parameters parsed: {0} {1}", new Object[]{parsedCommand.first(), parsedCommand.second()});
        return parsedCommand;
    }

    public String getExecutable() {
        return this.executable;
    }

    public List<String> getParameters() {
        return new ArrayList<String>(this.parameters);
    }

    public String getCommand() {
        return this.command;
    }

    public PhpExecutable executableName(@NonNull String executableName) {
        Parameters.notEmpty((CharSequence)"executableName", (CharSequence)executableName);
        this.executableName = executableName;
        return this;
    }

    public PhpExecutable displayName(String displayName) {
        Parameters.notEmpty((CharSequence)"displayName", (CharSequence)displayName);
        this.displayName = displayName;
        return this;
    }

    public PhpExecutable optionsSubcategory(String optionsSubcategory) {
        Parameters.notEmpty((CharSequence)"optionsSubcategory", (CharSequence)optionsSubcategory);
        this.optionsSubcategory = optionsSubcategory;
        return this;
    }

    public PhpExecutable viaPhpInterpreter(boolean viaPhpInterpreter) {
        this.viaPhpInterpreter = viaPhpInterpreter;
        return this;
    }

    public PhpExecutable viaAutodetection(boolean viaAutodetection) {
        this.viaAutodetection = viaAutodetection;
        return this;
    }

    public PhpExecutable redirectErrorStream(boolean redirectErrorStream) {
        this.redirectErrorStream = redirectErrorStream;
        return this;
    }

    public PhpExecutable workDir(@NonNull File workDir) {
        Parameters.notNull((CharSequence)"workDir", (Object)workDir);
        this.workDir = workDir;
        return this;
    }

    public PhpExecutable warnUser(boolean warnUser) {
        this.warnUser = warnUser;
        return this;
    }

    public PhpExecutable additionalParameters(@NonNull List<String> additionalParameters) {
        Parameters.notNull((CharSequence)"additionalParameters", additionalParameters);
        this.additionalParameters = additionalParameters;
        return this;
    }

    public PhpExecutable environmentVariables(Map<String, String> environmentVariables) {
        Parameters.notNull((CharSequence)"environmentVariables", environmentVariables);
        this.environmentVariables = environmentVariables;
        return this;
    }

    public PhpExecutable validationHandler(@NonNull PhpExecutableValidator.ValidationHandler validationHandler) {
        Parameters.notNull((CharSequence)"validationHandler", (Object)validationHandler);
        this.validationHandler = validationHandler;
        return this;
    }

    public PhpExecutable fileOutput(@NonNull File fileOutput, @NonNull String outputCharset, boolean fileOutputOnly) {
        Parameters.notNull((CharSequence)"fileOutput", (Object)fileOutput);
        Parameters.notNull((CharSequence)"outputCharset", (Object)outputCharset);
        this.fileOutput = fileOutput;
        this.outputCharset = Charset.forName(outputCharset);
        this.fileOutputOnly = fileOutputOnly;
        return this;
    }

    public PhpExecutable noInfo(boolean noInfo) {
        this.noInfo = noInfo;
        return this;
    }

    public PhpExecutable noDebugConfig(boolean noDebugConfig) {
        this.noDebugConfig = noDebugConfig;
        return this;
    }

    @CheckForNull
    public Future<Integer> run() {
        return this.run(DEFAULT_EXECUTION_DESCRIPTOR);
    }

    @CheckForNull
    public Future<Integer> run(@NonNull ExecutionDescriptor executionDescriptor) {
        return this.run(executionDescriptor, null);
    }

    @CheckForNull
    public Future<Integer> run(@NonNull ExecutionDescriptor executionDescriptor, @NullAllowed ExecutionDescriptor.InputProcessorFactory2 outProcessorFactory) {
        Parameters.notNull((CharSequence)"executionDescriptor", (Object)executionDescriptor);
        return this.runInternal(executionDescriptor, outProcessorFactory, false);
    }

    @CheckForNull
    public Integer runAndWait(@NonNull String progressMessage) throws ExecutionException {
        return this.runAndWait(DEFAULT_EXECUTION_DESCRIPTOR, progressMessage);
    }

    @CheckForNull
    public Integer runAndWait(@NonNull ExecutionDescriptor executionDescriptor, @NonNull String progressMessage) throws ExecutionException {
        return this.runAndWait(executionDescriptor, null, progressMessage);
    }

    @CheckForNull
    public Integer runAndWait(@NonNull ExecutionDescriptor executionDescriptor, @NullAllowed ExecutionDescriptor.InputProcessorFactory2 outProcessorFactory, @NonNull String progressMessage) throws ExecutionException {
        Parameters.notNull((CharSequence)"progressMessage", (Object)progressMessage);
        final Future<Integer> result = this.run(executionDescriptor, outProcessorFactory);
        if (result == null) {
            return null;
        }
        final AtomicReference executionException = new AtomicReference();
        if (SwingUtilities.isEventDispatchThread() && !result.isDone()) {
            try {
                PhpExecutable.getResult(result, 90L);
            }
            catch (TimeoutException ex) {
                BaseProgressUtils.showProgressDialogAndRun((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            PhpExecutable.getResult(result);
                        }
                        catch (ExecutionException extEx) {
                            executionException.set(extEx);
                        }
                    }
                }, (String)progressMessage);
            }
        }
        if (executionException.get() != null) {
            throw (ExecutionException)executionException.get();
        }
        return PhpExecutable.getResult(result);
    }

    @CheckForNull
    public Integer debug(@NonNull FileObject startFile) throws ExecutionException {
        return this.debug(startFile, DEFAULT_EXECUTION_DESCRIPTOR);
    }

    @CheckForNull
    public Integer debug(@NonNull FileObject startFile, @NonNull ExecutionDescriptor executionDescriptor) throws ExecutionException {
        return this.debug(startFile, executionDescriptor, null);
    }

    @CheckForNull
    public Integer debug(final @NonNull FileObject startFile, final @NonNull ExecutionDescriptor executionDescriptor, final @NullAllowed ExecutionDescriptor.InputProcessorFactory2 outProcessorFactory) throws ExecutionException {
        if (!EventQueue.isDispatchThread()) {
            return this.debugInternal(startFile, executionDescriptor, outProcessorFactory);
        }
        final AtomicReference executionResult = new AtomicReference();
        final AtomicReference executionException = new AtomicReference();
        BaseProgressUtils.showProgressDialogAndRun((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    executionResult.set(PhpExecutable.this.debugInternal(startFile, executionDescriptor, outProcessorFactory));
                }
                catch (ExecutionException ex) {
                    executionException.set(ex);
                }
            }
        }, (String)Bundle.PhpExecutable_debug_progress());
        if (executionException.get() != null) {
            throw (ExecutionException)executionException.get();
        }
        return (Integer)executionResult.get();
    }

    @CheckForNull
    Integer debugInternal(@NonNull FileObject startFile, @NonNull ExecutionDescriptor executionDescriptor, final @NullAllowed ExecutionDescriptor.InputProcessorFactory2 outProcessorFactory) throws ExecutionException {
        if (EventQueue.isDispatchThread()) {
            throw new IllegalStateException("Debugging cannot be called from the UI thread");
        }
        DebugStarter dbgStarter = (DebugStarter)Lookup.getDefault().lookup(DebugStarter.class);
        assert (dbgStarter != null);
        if (dbgStarter.isAlreadyRunning() && PhpExecutable.warnNoMoreDebugSession()) {
            dbgStarter.stop();
            return this.debug(startFile, executionDescriptor, outProcessorFactory);
        }
        final ExecutionDescriptor notControllableExecutionDescriptor = executionDescriptor.controllable(false);
        final AtomicReference result = new AtomicReference();
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        Callable<Cancellable> task = new Callable<Cancellable>(){

            @Override
            public Cancellable call() throws Exception {
                try {
                    result.set(PhpExecutable.this.runInternal(notControllableExecutionDescriptor, outProcessorFactory, true));
                }
                finally {
                    countDownLatch.countDown();
                }
                return new Cancellable(){

                    public boolean cancel() {
                        return true;
                    }
                };
            }
        };
        Project project = FileOwnerQuery.getOwner((FileObject)startFile);
        DebugStarter.Properties props = new DebugStarter.Properties.Builder().setStartFile(startFile).setCloseSession(true).setEncoding(FileEncodingQuery.getEncoding((FileObject)startFile).name()).build();
        dbgStarter.start(project != null ? project : DUMMY_PROJECT, task, props);
        try {
            countDownLatch.await();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        Future res = (Future)result.get();
        if (res == null) {
            return null;
        }
        try {
            res.get();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        catch (CancellationException ex) {
            return 0;
        }
        return 1;
    }

    @CheckForNull
    private Future<Integer> runInternal(ExecutionDescriptor executionDescriptor, ExecutionDescriptor.InputProcessorFactory2 outProcessorFactory, boolean debug) {
        Parameters.notNull((CharSequence)"executionDescriptor", (Object)executionDescriptor);
        String error = this.validationHandler == null ? PhpExecutableValidator.validateCommand(this.executable, this.executableName) : PhpExecutableValidator.validateCommand(this.executable, this.validationHandler);
        if (error != null) {
            if (this.warnUser) {
                UiUtils.invalidScriptProvided((String)error, (String)this.optionsSubcategory);
            }
            return null;
        }
        ProcessBuilder processBuilder = this.getProcessBuilder(debug);
        if (processBuilder == null) {
            return null;
        }
        executionDescriptor = this.getExecutionDescriptor(executionDescriptor, outProcessorFactory);
        return ExecutionService.newService((Callable)processBuilder, (ExecutionDescriptor)executionDescriptor, (String)this.getDisplayName()).run();
    }

    @CheckForNull
    private ProcessBuilder getProcessBuilder(boolean debug) {
        Pair<ProcessBuilder, List<String>> processBuilderInfo = this.createProcessBuilder();
        if (processBuilderInfo == null) {
            return null;
        }
        ProcessBuilder processBuilder = (ProcessBuilder)processBuilderInfo.first();
        List arguments = (List)processBuilderInfo.second();
        for (String string : this.parameters) {
            this.fullCommand.add(string);
            arguments.add(string);
        }
        for (String string : this.additionalParameters) {
            this.fullCommand.add(string);
            arguments.add(string);
        }
        processBuilder.setArguments(arguments);
        if (this.workDir != null) {
            processBuilder.setWorkingDirectory(this.workDir.getAbsolutePath());
        }
        for (Map.Entry entry : this.environmentVariables.entrySet()) {
            processBuilder.getEnvironment().setVariable((String)entry.getKey(), (String)entry.getValue());
        }
        processBuilder.setRedirectErrorStream(this.redirectErrorStream);
        if (debug && !this.noDebugConfig) {
            processBuilder.getEnvironment().setVariable("XDEBUG_CONFIG", "idekey=" + ((PhpOptions)Lookup.getDefault().lookup(PhpOptions.class)).getDebuggerSessionId());
        }
        return processBuilder;
    }

    @CheckForNull
    private Pair<ProcessBuilder, List<String>> createProcessBuilder() {
        PhpInterpreter phpInterpreter;
        ArrayList<String> arguments = new ArrayList<String>();
        this.fullCommand.clear();
        boolean useInterpreter = this.viaPhpInterpreter;
        if (this.viaAutodetection) {
            String exec = this.executable.toLowerCase();
            if (exec.endsWith(".phar")) {
                useInterpreter = true;
            } else {
                FileObject fo = FileUtil.toFileObject((File)new File(this.executable));
                assert (fo != null) : this.executable;
                if (FileUtils.isPhpFile((FileObject)fo)) {
                    useInterpreter = true;
                } else if (Utilities.isWindows()) {
                    if (exec.endsWith(".bat") || exec.endsWith(".cmd")) {
                        useInterpreter = false;
                    }
                } else if (exec.endsWith(".sh")) {
                    useInterpreter = false;
                }
            }
        }
        if (!useInterpreter) {
            this.fullCommand.add(this.executable);
            ProcessBuilder processBuilder = ProcessBuilder.getLocal();
            processBuilder.setExecutable(this.executable);
            return Pair.of((Object)processBuilder, arguments);
        }
        try {
            phpInterpreter = PhpInterpreter.getDefault();
        }
        catch (InvalidPhpExecutableException ex) {
            if (this.warnUser) {
                UiUtils.invalidScriptProvided((String)ex.getLocalizedMessage());
            }
            return null;
        }
        this.fullCommand.add(phpInterpreter.getInterpreter());
        ProcessBuilder processBuilder = ProcessBuilder.getLocal();
        processBuilder.setExecutable(phpInterpreter.getInterpreter());
        for (String param : phpInterpreter.getParameters()) {
            this.fullCommand.add(param);
            arguments.add(param);
        }
        this.fullCommand.add(this.executable);
        arguments.add(this.executable);
        return Pair.of((Object)processBuilder, arguments);
    }

    private String getDisplayName() {
        if (this.displayName != null) {
            return this.displayName;
        }
        return this.getDefaultDisplayName();
    }

    private String getDefaultDisplayName() {
        StringBuilder buffer = new StringBuilder(200);
        buffer.append(this.executable);
        for (String param : this.parameters) {
            buffer.append(" ");
            buffer.append(param);
        }
        return buffer.toString();
    }

    static Integer getResult(Future<Integer> result) throws ExecutionException {
        try {
            return PhpExecutable.getResult(result, null);
        }
        catch (TimeoutException ex) {
            LOGGER.log(Level.WARNING, null, ex);
            return null;
        }
    }

    private static Integer getResult(Future<Integer> result, Long timeout) throws TimeoutException, ExecutionException {
        try {
            if (timeout != null) {
                return result.get(timeout, TimeUnit.MILLISECONDS);
            }
            return result.get();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    private ExecutionDescriptor getExecutionDescriptor(ExecutionDescriptor executionDescriptor, ExecutionDescriptor.InputProcessorFactory2 outProcessorFactory) {
        ExecutionDescriptor.InputProcessorFactory2 fileOutProcessorFactory;
        final CopyOnWriteArrayList<ExecutionDescriptor.InputProcessorFactory2> inputProcessors = new CopyOnWriteArrayList<ExecutionDescriptor.InputProcessorFactory2>();
        ExecutionDescriptor.InputProcessorFactory2 infoOutProcessorFactory = this.getInfoOutputProcessorFactory();
        if (infoOutProcessorFactory != null) {
            inputProcessors.add(infoOutProcessorFactory);
        }
        if ((fileOutProcessorFactory = this.getFileOutputProcessorFactory()) != null) {
            inputProcessors.add(fileOutProcessorFactory);
            if (this.fileOutputOnly) {
                executionDescriptor = executionDescriptor.inputOutput(InputOutput.NULL).frontWindow(false).frontWindowOnError(false);
            }
        }
        if (outProcessorFactory != null) {
            inputProcessors.add(outProcessorFactory);
        }
        if (!inputProcessors.isEmpty()) {
            executionDescriptor = executionDescriptor.outProcessorFactory(new ExecutionDescriptor.InputProcessorFactory2(){

                public InputProcessor newInputProcessor(InputProcessor defaultProcessor) {
                    InputProcessor[] processors = new InputProcessor[inputProcessors.size()];
                    for (int i = 0; i < inputProcessors.size(); ++i) {
                        processors[i] = ((ExecutionDescriptor.InputProcessorFactory2)inputProcessors.get(i)).newInputProcessor(defaultProcessor);
                    }
                    return InputProcessors.proxy((InputProcessor[])processors);
                }
            });
        }
        return executionDescriptor;
    }

    private ExecutionDescriptor.InputProcessorFactory2 getInfoOutputProcessorFactory() {
        if (this.noInfo) {
            return null;
        }
        return new ExecutionDescriptor.InputProcessorFactory2(){

            public InputProcessor newInputProcessor(InputProcessor defaultProcessor) {
                return InputProcessors.proxy((InputProcessor[])new InputProcessor[]{new InfoInputProcessor(defaultProcessor, PhpExecutable.this.fullCommand), defaultProcessor});
            }
        };
    }

    private ExecutionDescriptor.InputProcessorFactory2 getFileOutputProcessorFactory() {
        if (this.fileOutput == null) {
            return null;
        }
        return new ExecutionDescriptor.InputProcessorFactory2(){

            public InputProcessor newInputProcessor(InputProcessor defaultProcessor) {
                return new RedirectOutputProcessor(PhpExecutable.this.fileOutput, PhpExecutable.this.outputCharset);
            }
        };
    }

    private static boolean warnNoMoreDebugSession() {
        NotifyDescriptor.Confirmation descriptor = new NotifyDescriptor.Confirmation((Object)Bundle.PhpExecutable_debug_noMoreSessions(), 2);
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor) == NotifyDescriptor.OK_OPTION;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        sb.append(this.getClass().getName());
        sb.append(" [executable: ");
        sb.append(this.executable);
        sb.append(", parameters: ");
        sb.append(this.parameters);
        sb.append("]");
        return sb.toString();
    }

    static final class DummyProject
    implements Project {
        DummyProject() {
        }

        public FileObject getProjectDirectory() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Lookup getLookup() {
            return Lookup.EMPTY;
        }
    }

    static final class RedirectOutputProcessor
    implements InputProcessor {
        private final File fileOuput;
        private final Charset outputCharset;
        private OutputStream outputStream;

        public RedirectOutputProcessor(File fileOuput, Charset outputCharset) {
            assert (fileOuput != null);
            assert (outputCharset != null);
            this.fileOuput = fileOuput;
            this.outputCharset = outputCharset;
        }

        public void processInput(char[] chars) throws IOException {
            if (this.outputStream == null) {
                this.outputStream = new BufferedOutputStream(new FileOutputStream(this.fileOuput));
            }
            ByteBuffer byteBuffer = this.outputCharset.encode(CharBuffer.wrap(chars));
            byte[] bytes = byteBuffer.array();
            byte[] compactedBytes = new byte[byteBuffer.limit()];
            System.arraycopy(bytes, 0, compactedBytes, 0, compactedBytes.length);
            this.outputStream.write(compactedBytes);
        }

        public void reset() {
        }

        public void close() throws IOException {
            if (this.outputStream != null) {
                this.outputStream.close();
            }
        }
    }

    static final class InfoInputProcessor
    implements InputProcessor {
        private final InputProcessor defaultProcessor;
        private char lastChar;

        public InfoInputProcessor(InputProcessor defaultProcessor, List<String> fullCommand) {
            this.defaultProcessor = defaultProcessor;
            String infoCommand = InfoInputProcessor.colorize(InfoInputProcessor.getInfoCommand(fullCommand)) + "\n";
            try {
                defaultProcessor.processInput(infoCommand.toCharArray());
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, null, ex);
            }
        }

        public void processInput(char[] chars) throws IOException {
            if (chars.length > 0) {
                this.lastChar = chars[chars.length - 1];
            }
        }

        public void reset() throws IOException {
        }

        public void close() throws IOException {
            StringBuilder msg = new StringBuilder(Bundle.InfoInputProcessor_done().length() + 2);
            if (!InfoInputProcessor.isNewLine(this.lastChar)) {
                msg.append("\n");
            }
            msg.append(InfoInputProcessor.colorize(Bundle.InfoInputProcessor_done()));
            msg.append("\n");
            this.defaultProcessor.processInput(msg.toString().toCharArray());
        }

        public static String getInfoCommand(List<String> fullCommand) {
            ArrayList<CallSite> escapedCommand = new ArrayList<CallSite>(fullCommand.size());
            for (String command : fullCommand) {
                escapedCommand.add((CallSite)((Object)("\"" + command.replace("\"", "\\\"") + "\"")));
            }
            return StringUtils.implode(escapedCommand, (String)" ");
        }

        private static String colorize(String msg) {
            return "\u001b[1;30m" + msg + "\u001b[0m";
        }

        private static boolean isNewLine(char ch) {
            return ch == '\n' || ch == '\r' || ch == '\u0000';
        }
    }
}

