/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.tooling.server;

import java.util.concurrent.atomic.AtomicReferenceArray;
import org.netbeans.modules.payara.tooling.data.PayaraVersion;

public class JpaSupport {
    private static final String JPA_PROVIDER_SINCE_V1 = "oracle.toplink.essentials.PersistenceProvider";
    private static final String JPA_PROVIDER_SINCE_V3 = "org.eclipse.persistence.jpa.PersistenceProvider";
    private static final AtomicReferenceArray<ApiVersion> jpaSupport = new AtomicReferenceArray(PayaraVersion.length);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ApiVersion getApiVersion(PayaraVersion version) {
        ApiVersion apiVersion = jpaSupport.get(version.ordinal());
        if (apiVersion != null) {
            return apiVersion;
        }
        AtomicReferenceArray<ApiVersion> atomicReferenceArray = jpaSupport;
        synchronized (atomicReferenceArray) {
            apiVersion = jpaSupport.get(version.ordinal());
            if (apiVersion == null) {
                jpaSupport.set(version.ordinal(), new ApiVersion(true, false, version.ordinal() >= PayaraVersion.PF_4_1_144.ordinal(), version.ordinal() < PayaraVersion.PF_4_1_144.ordinal() ? JPA_PROVIDER_SINCE_V1 : JPA_PROVIDER_SINCE_V3));
            }
        }
        return jpaSupport.get(version.ordinal());
    }

    public static class ApiVersion {
        final boolean _1_0;
        final boolean _2_0;
        final boolean _2_1;
        final String provider;

        ApiVersion(boolean jpa_1_0, boolean jpa_2_0, boolean jpa_2_1, String provider) {
            this._1_0 = jpa_1_0;
            this._2_0 = jpa_2_0;
            this._2_1 = jpa_2_1;
            this.provider = provider;
        }

        public boolean is10() {
            return this._1_0;
        }

        public boolean is20() {
            return this._2_0;
        }

        public boolean is21() {
            return this._2_1;
        }

        public String getProvider() {
            return this.provider;
        }
    }
}

