/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.eecommon.dd.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.payara.spi.Utils;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class PayaraDDVisualPanel
extends JPanel {
    private Project project;
    private String payaraDDFileName;
    private File payaraDDFile;
    private File payaraDDLocation;
    private static final String WEB_XML = "web.xml";
    private JLabel filler1;
    private JLabel labelCreatedFile;
    private JLabel labelFileName;
    private JLabel labelLocation;
    private JLabel labelProjectName;
    private JTextField textCreatedFile;
    private JTextField textFileName;
    private JTextField textLocation;
    private JTextField textProjectName;

    public PayaraDDVisualPanel() {
        this.initComponents();
    }

    void setProject(Project project) {
        this.project = project;
        Lookup lookup = project.getLookup();
        J2eeModuleProvider provider = (J2eeModuleProvider)lookup.lookup(J2eeModuleProvider.class);
        J2eeModule j2eeModule = provider.getJ2eeModule();
        this.payaraDDFileName = this.getConfigFileName(j2eeModule, provider.getServerInstanceID());
        this.payaraDDLocation = j2eeModule.getDeploymentConfigurationFile(WEB_XML).getParentFile();
        this.payaraDDFile = new File(this.payaraDDLocation, this.payaraDDFileName);
        this.textFileName.setText(this.payaraDDFileName);
        this.textProjectName.setText(ProjectUtils.getInformation((Project)project).getDisplayName());
        File projectFolder = FileUtil.toFile((FileObject)project.getProjectDirectory());
        this.textLocation.setText(this.payaraDDLocation != null ? PayaraDDVisualPanel.getRelativePath(this.payaraDDLocation, projectFolder) : null);
        this.textCreatedFile.setText(this.payaraDDLocation != null ? PayaraDDVisualPanel.getRelativePath(this.payaraDDFile, projectFolder) : null);
    }

    String getFileName() {
        return this.payaraDDFileName;
    }

    File getFile() {
        return this.payaraDDFile;
    }

    File getSelectedLocation() {
        return this.payaraDDLocation;
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(PayaraDDVisualPanel.class, (String)"LBL_CreatePayaraDeploymentDescriptor");
    }

    private void initComponents() {
        this.labelFileName = new JLabel();
        this.textFileName = new JTextField();
        this.labelProjectName = new JLabel();
        this.textProjectName = new JTextField();
        this.labelLocation = new JLabel();
        this.textLocation = new JTextField();
        this.labelCreatedFile = new JLabel();
        this.textCreatedFile = new JTextField();
        this.filler1 = new JLabel();
        this.setLayout(new GridBagLayout());
        this.labelFileName.setLabelFor(this.textFileName);
        Mnemonics.setLocalizedText((JLabel)this.labelFileName, (String)NbBundle.getMessage(PayaraDDVisualPanel.class, (String)"LBL_Name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.add((Component)this.labelFileName, gridBagConstraints);
        this.textFileName.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.add((Component)this.textFileName, gridBagConstraints);
        this.textFileName.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PayaraDDVisualPanel.class, (String)"ASCN_Name"));
        this.textFileName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PayaraDDVisualPanel.class, (String)"ASCD_Name"));
        this.labelProjectName.setLabelFor(this.textProjectName);
        Mnemonics.setLocalizedText((JLabel)this.labelProjectName, (String)NbBundle.getMessage(PayaraDDVisualPanel.class, (String)"LBL_Project"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.labelProjectName, gridBagConstraints);
        this.textProjectName.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.textProjectName, gridBagConstraints);
        this.textProjectName.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PayaraDDVisualPanel.class, (String)"ASCN_Project"));
        this.textProjectName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PayaraDDVisualPanel.class, (String)"ASCD_Project"));
        this.labelLocation.setLabelFor(this.textLocation);
        Mnemonics.setLocalizedText((JLabel)this.labelLocation, (String)NbBundle.getMessage(PayaraDDVisualPanel.class, (String)"LBL_Location"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.labelLocation, gridBagConstraints);
        this.textLocation.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.textLocation, gridBagConstraints);
        this.textLocation.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PayaraDDVisualPanel.class, (String)"ASCN_Location"));
        this.textLocation.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PayaraDDVisualPanel.class, (String)"ASCD_Location"));
        this.labelCreatedFile.setLabelFor(this.textCreatedFile);
        Mnemonics.setLocalizedText((JLabel)this.labelCreatedFile, (String)NbBundle.getMessage(PayaraDDVisualPanel.class, (String)"LBL_CreatedFile"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 0, 11, 0);
        this.add((Component)this.labelCreatedFile, gridBagConstraints);
        this.textCreatedFile.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 11, 0);
        this.add((Component)this.textCreatedFile, gridBagConstraints);
        this.textCreatedFile.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PayaraDDVisualPanel.class, (String)"ASCN_CreatedFile"));
        this.textCreatedFile.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PayaraDDVisualPanel.class, (String)"ASCD_CreatedFile"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.filler1, gridBagConstraints);
    }

    private String getConfigFileName(J2eeModule j2eeModule, String serverInstanceID) {
        String result = null;
        J2eeModule.Type moduleType = j2eeModule.getType();
        if (J2eeModule.Type.WAR.equals(moduleType)) {
            result = Utils.useGlassFishPrefix((String)serverInstanceID) ? "payara-web.xml" : "glassfish-web.xml";
        } else if (J2eeModule.Type.EJB.equals(moduleType)) {
            result = Utils.useGlassFishPrefix((String)serverInstanceID) ? "glassfish-ejb-jar.xml" : "sun-ejb-jar.xml";
        } else if (J2eeModule.Type.EAR.equals(moduleType)) {
            result = Utils.useGlassFishPrefix((String)serverInstanceID) ? "glassfish-application.xml" : "sun-application.xml";
        } else if (J2eeModule.Type.CAR.equals(moduleType)) {
            result = Utils.useGlassFishPrefix((String)serverInstanceID) ? "glassfish-application-client.xml" : "sun-application-client.xml";
        }
        return result;
    }

    private static String getRelativePath(File file, File base) {
        String basePath = base.getAbsolutePath();
        String filePath = file.getAbsolutePath();
        if (filePath.startsWith(basePath)) {
            String prefix = "";
            int baseIndex = basePath.lastIndexOf(File.separatorChar);
            if (baseIndex < 0 || baseIndex >= filePath.length()) {
                baseIndex = 0;
            } else {
                prefix = "...";
            }
            return prefix + filePath.substring(baseIndex);
        }
        return filePath;
    }
}

