/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.common.nodes.actions;

import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.payara.common.nodes.actions.RefreshModulesCookie;
import org.netbeans.modules.payara.common.nodes.actions.UnregisterResourceCookie;
import org.netbeans.modules.payara.spi.ServerUtilities;
import org.netbeans.modules.payara.tooling.admin.ResultString;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;

public class UnregisterResourceAction
extends NodeAction {
    protected void performAction(Node[] nodes) {
        if (nodes == null || nodes.length < 1) {
            return;
        }
        for (Node node : nodes) {
            UnregisterResourceCookie uCookie = (UnregisterResourceCookie)node.getCookie(UnregisterResourceCookie.class);
            if (uCookie == null) continue;
            final Future<ResultString> result = uCookie.unregister();
            final Node pNode = node.getParentNode().getParentNode();
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    try {
                        result.get(15000L, ServerUtilities.ACTION_TIMEOUT_UNIT);
                        if (pNode != null) {
                            Node[] nodes;
                            for (Node node : nodes = pNode.getChildren().getNodes()) {
                                RefreshModulesCookie cookie = (RefreshModulesCookie)node.getCookie(RefreshModulesCookie.class);
                                if (cookie == null) continue;
                                cookie.refresh();
                            }
                        }
                    }
                    catch (TimeoutException ex) {
                        Logger.getLogger("payara").log(Level.WARNING, "Timeout waiting on unregister.", ex);
                    }
                    catch (Exception ex) {
                        Logger.getLogger("payara").log(Level.INFO, ex.getLocalizedMessage(), ex);
                    }
                }
            });
        }
    }

    protected boolean enable(Node[] nodes) {
        for (Node node : nodes) {
            UnregisterResourceCookie cookie = (UnregisterResourceCookie)node.getCookie(UnregisterResourceCookie.class);
            if (cookie != null && !cookie.isRunning()) continue;
            return false;
        }
        return true;
    }

    public String getName() {
        return NbBundle.getMessage(UnregisterResourceAction.class, (String)"LBL_UnregisterAction");
    }

    protected boolean asynchronous() {
        return false;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
}

