/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mylyn.util;

import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.openide.util.NetworkSettings;

public class MylynUtils {
    private static final Logger LOG = Logger.getLogger("org.netbeans.libs.bugtracking.mylyn");

    public static TaskRepository createTaskRepository(String connectorKind, String name, String url, String user, char[] password, String httpUser, char[] httpPassword) {
        TaskRepository repository = new TaskRepository(connectorKind, url);
        MylynUtils.setCredentials(repository, user, password, httpUser, httpPassword);
        return repository;
    }

    public static void setCredentials(TaskRepository repository, String user, char[] password, String httpUser, char[] httpPassword) {
        MylynUtils.logCredentials(repository, user, password, "Setting credentials: ");
        AuthenticationCredentials authenticationCredentials = new AuthenticationCredentials(user != null ? user : "", password != null ? new String(password) : "");
        repository.setCredentials(AuthenticationType.REPOSITORY, authenticationCredentials, false);
        if (httpUser != null || httpPassword != null) {
            if (httpUser == null) {
                httpUser = "";
            }
            if (httpPassword == null) {
                httpPassword = new char[]{};
            }
            MylynUtils.logCredentials(repository, httpUser, httpPassword, "Setting http credentials: ");
            authenticationCredentials = new AuthenticationCredentials(httpUser, new String(httpPassword));
            repository.setCredentials(AuthenticationType.HTTP, authenticationCredentials, false);
        } else {
            repository.setCredentials(AuthenticationType.HTTP, null, false);
        }
        URI uri = null;
        try {
            uri = new URI(repository.getUrl());
        }
        catch (URISyntaxException ex) {
            LOG.log(Level.INFO, null, ex);
        }
        String proxyHost = NetworkSettings.getProxyHost((URI)uri);
        if (proxyHost != null && proxyHost.length() > 0) {
            String proxyPort = NetworkSettings.getProxyPort((URI)uri);
            assert (proxyPort != null);
            repository.setDefaultProxyEnabled(false);
            LOG.log(Level.FINEST, "Setting proxy: [{0}:{1},{2}]", new Object[]{proxyHost, proxyPort, repository.getUrl()});
            repository.setProperty("org.eclipse.mylyn.tasklist.repositories.proxy.hostname", proxyHost);
            repository.setProperty("org.eclipse.mylyn.tasklist.repositories.proxy.port", proxyPort);
            String proxyUser = NetworkSettings.getAuthenticationUsername((URI)uri);
            if (proxyUser != null) {
                char[] pwd = NetworkSettings.getAuthenticationPassword((URI)uri);
                String proxyPassword = pwd == null ? "" : new String(pwd);
                MylynUtils.logCredentials(repository, proxyUser, proxyPassword, "Setting proxy credentials: ");
                authenticationCredentials = new AuthenticationCredentials(proxyUser, proxyPassword);
                repository.setCredentials(AuthenticationType.PROXY, authenticationCredentials, false);
            }
        } else {
            repository.setProperty("org.eclipse.mylyn.tasklist.repositories.proxy.hostname", null);
            repository.setProperty("org.eclipse.mylyn.tasklist.repositories.proxy.port", null);
            repository.setCredentials(AuthenticationType.PROXY, null, false);
        }
    }

    public static void logCredentials(TaskRepository repository, String user, char[] psswd, String msg) {
        MylynUtils.logCredentials(repository, user, psswd != null ? new String(psswd) : null, msg);
    }

    public static void logCredentials(TaskRepository repository, String user, String psswd, String msg) {
        LOG.log(Level.FINEST, msg + "[{0}, user={1}, password={2}]", new Object[]{repository.getUrl(), user, MylynUtils.getPasswordLog(psswd)});
    }

    private static boolean isNonProxyHost(String nonProxyHosts, String host) {
        if (nonProxyHosts.equals("")) {
            return false;
        }
        return MylynUtils.dontUseHostName(nonProxyHosts, host) || MylynUtils.dontUseIp(nonProxyHosts, host);
    }

    private static boolean dontUseHostName(String nonProxyHosts, String host) {
        if (host == null) {
            return false;
        }
        boolean dontUseProxy = false;
        StringTokenizer st = new StringTokenizer(nonProxyHosts, ",", false);
        while (st.hasMoreTokens() && !dontUseProxy) {
            String token = st.nextToken().trim();
            int star = token.indexOf("*");
            if (star == -1) {
                dontUseProxy = token.equals(host);
                if (!dontUseProxy) continue;
                LOG.log(Level.FINEST, "Host {0} found in nonProxyHosts: {1}", new Object[]{host, nonProxyHosts});
                continue;
            }
            String start = token.substring(0, star - 1 < 0 ? 0 : star - 1);
            String end = token.substring(star + 1 > token.length() ? token.length() : star + 1);
            boolean bl = dontUseProxy = host.startsWith(start) && host.endsWith(end);
            if (!dontUseProxy) {
                if (end.length() > 1 && end.charAt(0) == '.') {
                    end = end.substring(1, end.length());
                }
                if (start.length() > 1 && start.charAt(start.length() - 1) == '.') {
                    start = start.substring(0, start.length() - 1);
                }
                boolean bl2 = dontUseProxy = host.startsWith(start) && host.endsWith(end);
            }
            if (!dontUseProxy) continue;
            LOG.log(Level.FINEST, "Host {0} found in nonProxyHosts: {1}", new Object[]{host, nonProxyHosts});
        }
        return dontUseProxy;
    }

    private static boolean dontUseIp(String nonProxyHosts, String host) {
        if (host == null) {
            return false;
        }
        String ip = null;
        try {
            ip = InetAddress.getByName(host).getHostAddress();
        }
        catch (UnknownHostException ex) {
            LOG.log(Level.FINE, ex.getLocalizedMessage(), ex);
        }
        if (ip == null) {
            return false;
        }
        boolean dontUseProxy = false;
        StringTokenizer st = new StringTokenizer(nonProxyHosts, ",", false);
        while (st.hasMoreTokens() && !dontUseProxy) {
            String nonProxyHost = st.nextToken();
            int star = nonProxyHost.indexOf("*");
            if (star == -1) {
                dontUseProxy = nonProxyHost.equals(ip);
                if (!dontUseProxy) continue;
                LOG.log(Level.FINEST, "Host''s {0} IP {1} found in nonProxyHosts: {2}", new Object[]{host, ip, nonProxyHosts});
                continue;
            }
            try {
                dontUseProxy = Pattern.matches(nonProxyHost, ip);
                if (!dontUseProxy) continue;
                LOG.log(Level.FINEST, "Host''s {0} IP{1} found in nonProxyHosts: {2}", new Object[]{host, ip, nonProxyHosts});
            }
            catch (PatternSyntaxException patternSyntaxException) {}
        }
        return dontUseProxy;
    }

    private static String getPasswordLog(String psswd) {
        if (psswd == null) {
            return "";
        }
        if ("true".equals(System.getProperty("org.netbeans.modules.bugtracking.logPasswords", "false"))) {
            return psswd;
        }
        return "******";
    }
}

