/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.micronaut;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TypeUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataGroup;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataProperty;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataRepository;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataRepositoryJsonBuilder;

public final class MicronautConfigProperties {
    private static final String CONFIG_METADATA_JSON = "META-INF/spring-configuration-metadata.json";
    private static final ElementHandle<TypeElement> PROPERTY_HANDLE = ElementHandle.createTypeElementHandle((ElementKind)ElementKind.ANNOTATION_TYPE, (String)"io.micronaut.context.annotation.Property");

    private MicronautConfigProperties() {
    }

    public static boolean hasConfigMetadata(Project project) {
        ClassPath cp = MicronautConfigProperties.getExecuteClasspath(project);
        return cp != null && !cp.findAllResources(CONFIG_METADATA_JSON).isEmpty();
    }

    public static Map<String, ConfigurationMetadataProperty> getProperties(Project project) {
        LinkedHashMap<String, ConfigurationMetadataProperty> props = new LinkedHashMap<String, ConfigurationMetadataProperty>();
        ClassPath cp = MicronautConfigProperties.getExecuteClasspath(project);
        if (cp != null) {
            ConfigurationMetadataRepository repository;
            for (FileObject fo : cp.findAllResources(CONFIG_METADATA_JSON)) {
                try {
                    repository = ConfigurationMetadataRepositoryJsonBuilder.create().withJsonResource(fo.getInputStream()).build();
                    props.putAll(repository.getAllProperties());
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            String customRepository = MicronautConfigProperties.getCustomRepository(project);
            if (customRepository != null) {
                try {
                    ByteArrayInputStream stream = new ByteArrayInputStream(customRepository.getBytes(StandardCharsets.UTF_8));
                    repository = ConfigurationMetadataRepositoryJsonBuilder.create().withJsonResource((InputStream)stream).build();
                    props.putAll(repository.getAllProperties());
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        return props;
    }

    public static Map<String, ConfigurationMetadataGroup> getGroups(Project project) {
        LinkedHashMap<String, ConfigurationMetadataGroup> groups = new LinkedHashMap<String, ConfigurationMetadataGroup>();
        ClassPath cp = MicronautConfigProperties.getExecuteClasspath(project);
        if (cp != null) {
            ConfigurationMetadataRepository repository;
            for (FileObject fo : cp.findAllResources(CONFIG_METADATA_JSON)) {
                try {
                    repository = ConfigurationMetadataRepositoryJsonBuilder.create().withJsonResource(fo.getInputStream()).build();
                    groups.putAll(repository.getAllGroups());
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            String customRepository = MicronautConfigProperties.getCustomRepository(project);
            if (customRepository != null) {
                try {
                    ByteArrayInputStream stream = new ByteArrayInputStream(customRepository.getBytes(StandardCharsets.UTF_8));
                    repository = ConfigurationMetadataRepositoryJsonBuilder.create().withJsonResource((InputStream)stream).build();
                    groups.putAll(repository.getAllGroups());
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        return groups;
    }

    private static String getCustomRepository(Project project) {
        final AtomicReference ret = new AtomicReference();
        SourceGroup[] srcGroups = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        for (int i = 0; i < srcGroups.length; ++i) {
            SourceGroup srcGroup = srcGroups[i];
            ClassIndex ci = ClasspathInfo.create((FileObject)srcGroup.getRootFolder()).getClassIndex();
            Set resources = ci.getResources(PROPERTY_HANDLE, EnumSet.of(ClassIndex.SearchKind.TYPE_REFERENCES), EnumSet.of(ClassIndex.SearchScope.SOURCE));
            try {
                ParserManager.parse((Collection)resources.stream().map(resource -> Source.create((FileObject)resource)).collect(Collectors.toList()), (UserTask)new UserTask(){

                    public void run(ResultIterator resultIterator) throws Exception {
                        final CompilationController cc = CompilationController.get((Parser.Result)resultIterator.getParserResult());
                        cc.toPhase(JavaSource.Phase.RESOLVED);
                        final Trees trees = cc.getTrees();
                        final TypeElement te = (TypeElement)PROPERTY_HANDLE.resolve((CompilationInfo)cc);
                        new TreePathScanner<Void, Void>(){

                            @Override
                            public Void visitAnnotation(AnnotationTree node, Void p) {
                                if (te == trees.getElement(new TreePath(this.getCurrentPath(), node.getAnnotationType()))) {
                                    for (ExpressionTree expressionTree : node.getArguments()) {
                                        if (expressionTree.getKind() != Tree.Kind.ASSIGNMENT) continue;
                                        ExpressionTree variable = ((AssignmentTree)expressionTree).getVariable();
                                        ExpressionTree expression = ((AssignmentTree)expressionTree).getExpression();
                                        if (expression.getKind() != Tree.Kind.STRING_LITERAL || variable.getKind() != Tree.Kind.IDENTIFIER || !"name".contentEquals(((IdentifierTree)variable).getName())) continue;
                                        try {
                                            Element el;
                                            String value = (String)((LiteralTree)expression).getValue();
                                            JSONObject group = new JSONObject();
                                            JSONObject property = new JSONObject();
                                            group.put("name", (Object)value);
                                            property.put("name", (Object)value);
                                            TreePath grandParentPath = this.getCurrentPath().getParentPath().getParentPath();
                                            if (grandParentPath.getLeaf().getKind() == Tree.Kind.VARIABLE && (el = trees.getElement(grandParentPath)) != null && el.getKind().isField()) {
                                                String typeName = cc.getTypeUtilities().getTypeName(el.asType(), new TypeUtilities.TypeNameOptions[]{TypeUtilities.TypeNameOptions.PRINT_FQN}).toString();
                                                String sourceTypeName = cc.getElementUtilities().getElementName(el.getEnclosingElement(), true).toString();
                                                property.put("type", (Object)typeName);
                                                property.put("sourceType", (Object)sourceTypeName);
                                                group.put("type", (Object)sourceTypeName);
                                            }
                                            JSONArray groups = new JSONArray();
                                            groups.put((Object)group);
                                            JSONArray properties = new JSONArray();
                                            properties.put((Object)property);
                                            JSONObject data = new JSONObject();
                                            data.put("groups", (Object)groups);
                                            data.put("properties", (Object)properties);
                                            ret.set(data.toString());
                                        }
                                        catch (JSONException ex) {
                                            Exceptions.printStackTrace((Throwable)ex);
                                        }
                                    }
                                }
                                return (Void)super.visitAnnotation(node, p);
                            }
                        }.scan(new TreePath(cc.getCompilationUnit()), (Void)null);
                    }
                });
                continue;
            }
            catch (ParseException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return (String)ret.get();
    }

    private static ClassPath getExecuteClasspath(Project project) {
        SourceGroup[] srcGroups = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        if (srcGroups.length > 0) {
            return ClassPath.getClassPath((FileObject)srcGroups[0].getRootFolder(), (String)"classpath/execute");
        }
        return null;
    }
}

