/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.micronaut.db;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.aggregate.BasicAggregateProgressFactory;
import org.netbeans.api.progress.aggregate.ProgressContributor;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.templates.CreateDescriptor;
import org.netbeans.api.templates.CreateFromTemplateHandler;
import org.netbeans.modules.j2ee.core.api.support.SourceGroups;
import org.netbeans.modules.j2ee.core.api.support.java.GenerationUtils;
import org.netbeans.modules.j2ee.core.api.support.java.SourceUtils;
import org.netbeans.modules.j2ee.persistence.api.entity.generator.EntitiesFromDBGenerator;
import org.netbeans.modules.j2ee.persistence.dd.PersistenceUtils;
import org.netbeans.modules.j2ee.persistence.entitygenerator.CMPMappingModel;
import org.netbeans.modules.j2ee.persistence.entitygenerator.EntityClass;
import org.netbeans.modules.j2ee.persistence.entitygenerator.EntityMember;
import org.netbeans.modules.j2ee.persistence.entitygenerator.EntityRelation;
import org.netbeans.modules.j2ee.persistence.entitygenerator.RelationshipRole;
import org.netbeans.modules.j2ee.persistence.util.JPAClassPathHelper;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.JavaPersistenceGenerator;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.PersistenceGenerator;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.PersistenceGeneratorProvider;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.ProgressPanel;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.RelatedCMPHelper;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.RelatedCMPWizard;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.UpdateType;
import org.netbeans.modules.micronaut.db.Bundle;
import org.netbeans.modules.micronaut.db.Utils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

public class MicronautEntity
extends RelatedCMPWizard {
    private static final String TYPE_MICRONAUT = "micronaut";

    public static MicronautEntity create() {
        return new MicronautEntity(TYPE_MICRONAUT);
    }

    public static CreateFromTemplateHandler handler() {
        return new CreateFromTemplateHandler(){

            protected boolean accept(CreateDescriptor desc) {
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected List<FileObject> createFromTemplate(CreateDescriptor desc) throws IOException {
                ProgressHandle handle = ProgressHandle.createHandle((String)Bundle.MSG_CreatingEntities());
                handle.start();
                try {
                    handle.progress(Bundle.MSG_ReadingTables());
                    FileObject folder = desc.getTarget();
                    Project project = FileOwnerQuery.getOwner((FileObject)folder);
                    if (project == null) {
                        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.MSG_NoProject(folder.getPath()), 0));
                        List<FileObject> list = Collections.emptyList();
                        return list;
                    }
                    SourceGroup sourceGroup = SourceGroups.getFolderSourceGroup((SourceGroup[])ProjectUtils.getSources((Project)project).getSourceGroups("java"), (FileObject)folder);
                    if (sourceGroup == null) {
                        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.MSG_NoSourceGroup(folder.getPath()), 0));
                        List<FileObject> list = Collections.emptyList();
                        return list;
                    }
                    if (!Utils.isDBSupported(sourceGroup) && !Utils.isJPASupported(sourceGroup)) {
                        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.MSG_NoDdSupport(folder.getPath()), 0));
                        List<FileObject> list = Collections.emptyList();
                        return list;
                    }
                    DatabaseConnection connection = ConnectionManager.getDefault().getPreferredConnection(true);
                    if (connection == null) {
                        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.MSG_NoDbConn(), 0));
                        List<FileObject> list = Collections.emptyList();
                        return list;
                    }
                    ConnectionManager.getDefault().connect(connection);
                    Connection conn = connection.getJDBCConnection();
                    ResultSet rs = conn.getMetaData().getTables(conn.getCatalog(), conn.getSchema(), "%", new String[]{"TABLE", "VIEW"});
                    ArrayList<NotifyDescriptor.QuickPick.Item> dbItems = new ArrayList<NotifyDescriptor.QuickPick.Item>();
                    while (rs.next()) {
                        dbItems.add(new NotifyDescriptor.QuickPick.Item(rs.getString("TABLE_NAME"), null));
                    }
                    if (dbItems.isEmpty()) {
                        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.MSG_NoDbTables(connection.getDisplayName()), 0));
                        List<FileObject> list = Collections.emptyList();
                        return list;
                    }
                    NotifyDescriptor.QuickPick qp = new NotifyDescriptor.QuickPick(Bundle.MSG_SelectTables(), Bundle.MSG_SelectTables(), dbItems, true);
                    if (DialogDescriptor.OK_OPTION == DialogDisplayer.getDefault().notify((NotifyDescriptor)qp)) {
                        List selectedItems = qp.getItems().stream().filter(item -> item.isSelected()).map(item -> item.getLabel()).collect(Collectors.toList());
                        handle.progress(Bundle.MSG_CreatingClasses());
                        EntitiesFromDBGenerator generator = new EntitiesFromDBGenerator(selectedItems, false, false, false, EntityRelation.FetchType.DEFAULT, EntityRelation.CollectionType.COLLECTION, SourceGroups.getPackageForFolder((SourceGroup)sourceGroup, (FileObject)folder), sourceGroup, connection, project, null, (PersistenceGenerator)new Generator());
                        ProgressContributor pc = BasicAggregateProgressFactory.createProgressContributor((String)"entity");
                        ArrayList<FileObject> generated = new ArrayList<FileObject>();
                        for (FileObject fo : generator.generate(pc)) {
                            if (fo == null) continue;
                            generated.add(fo);
                        }
                        ArrayList<FileObject> arrayList = generated;
                        return arrayList;
                    }
                }
                catch (IOException | SQLException | DatabaseException ex) {
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)ex.getMessage(), 0));
                }
                finally {
                    handle.finish();
                }
                return Collections.emptyList();
            }
        };
    }

    private MicronautEntity(String type) {
        super(type);
    }

    public Set<DataObject> instantiate(TemplateWizard wiz) throws IOException {
        String wizardTitle = NbBundle.getMessage(MicronautEntity.class, (String)"Templates/Micronaut/Entity");
        wiz.putProperty("NewFileWizard_Title", (Object)wizardTitle);
        return super.instantiate(wiz);
    }

    private static class Generator
    extends JavaPersistenceGenerator {
        private final Set<FileObject> generatedEntityFOs = new HashSet<FileObject>();
        private final Set<FileObject> generatedFOs = new HashSet<FileObject>();
        private final Map<String, String> replacedNames = new HashMap<String, String>();
        private final Map<String, String> replacedTypeNames = new HashMap<String, String>();
        private final Map<String, EntityClass> beanMap = new HashMap<String, EntityClass>();

        private Generator() {
        }

        public Set<FileObject> createdObjects() {
            return this.generatedEntityFOs;
        }

        public void generateBeans(ProgressPanel progressPanel, RelatedCMPHelper helper, FileObject dbschemaFile, ProgressContributor progressContributor) throws IOException {
            try {
                this.doGenerateBeans(progressPanel, helper, progressContributor);
            }
            catch (IOException e) {
                Logger.getLogger(Generator.class.getName()).log(Level.INFO, "IOException, remove generated.");
                for (FileObject generatedFO : this.generatedFOs) {
                    try {
                        generatedFO.delete();
                    }
                    catch (IOException iOException) {}
                }
                throw e;
            }
        }

        private void doGenerateBeans(ProgressPanel progressPanel, RelatedCMPHelper helper, ProgressContributor progressContributor) throws IOException {
            if (helper.getLocation() != null && helper.getPackageName() != null) {
                SourceGroups.getFolderForPackage((SourceGroup)helper.getLocation(), (String)helper.getPackageName());
            }
            boolean jpaSupported = Utils.isJPASupported(helper.getLocation());
            boolean beanValidationSupported = Generator.isBeanValidationSupported(helper.getLocation());
            EntityClass[] entityClasses = helper.getBeans();
            int progressMax = entityClasses.length * 2;
            progressContributor.start(progressMax);
            this.beanMap.clear();
            HashSet<FileObject> generationPackageFOs = new HashSet<FileObject>();
            HashSet<String> generatedEntityClasses = new HashSet<String>();
            block8: for (int i = 0; i < entityClasses.length; ++i) {
                EntityClass entityClass = entityClasses[i];
                String entityClassName = entityClass.getClassName();
                FileObject packageFileObject = entityClass.getPackageFileObject();
                this.beanMap.put(entityClassName, entityClass);
                String progressMsg = NbBundle.getMessage(Generator.class, (String)"TXT_GeneratingClass", (Object)entityClassName);
                progressContributor.progress(progressMsg, i);
                if (progressPanel != null) {
                    progressPanel.setText(progressMsg);
                }
                FileObject entity = packageFileObject.getFileObject(entityClassName, "java");
                switch (entityClass.getUpdateType()) {
                    case RECREATE: 
                    case UPDATE: {
                        String pkClassName;
                        if (entity == null) {
                            String fqn = this.getFQClassName(entityClass.getTableName());
                            int ind = fqn.lastIndexOf(".");
                            String pkg = ind > -1 ? fqn.substring(0, ind) : "";
                            String rel = pkg.replaceAll("\\.", "/");
                            FileObject oldPackage = entityClass.getRootFolder().getFileObject(rel);
                            entity = oldPackage.getFileObject(entityClassName, "java");
                        }
                        if (entityClass.isForTable() && !entityClass.isUsePkField()) {
                            pkClassName = Generator.createPKClassName(entityClassName);
                            FileObject pkFO = packageFileObject.getFileObject(pkClassName, "java");
                            if (pkFO == null) {
                                String fqn = this.getFQClassName(entityClass.getTableName());
                                int ind = fqn.lastIndexOf(46);
                                String pkg = ind > -1 ? fqn.substring(0, ind) : "";
                                String rel = pkg.replaceAll("\\.", "/");
                                FileObject oldPackage = entityClass.getRootFolder().getFileObject(rel);
                                pkFO = oldPackage.getFileObject(pkClassName, "java");
                            }
                            if (pkFO != null) {
                                pkFO.delete();
                            }
                        }
                        entity.delete();
                        entity = null;
                    }
                    case NEW: {
                        String pkClassName;
                        generatedEntityClasses.add(entityClassName);
                        try {
                            String pkMemberName = Generator.getPkMemberName(entityClass);
                            String newName = pkMemberName != null ? Character.toUpperCase(pkMemberName.charAt(0)) + pkMemberName.substring(1) : entityClassName;
                            for (int count = 1; packageFileObject.getFileObject(newName, "java") != null && count < 1000; ++count) {
                                newName = entityClassName + "_" + count;
                            }
                            entity = GenerationUtils.createClass((FileObject)packageFileObject, (String)newName, (String)NbBundle.getMessage(Generator.class, (String)"MSG_Entity_Class", (Object)newName));
                            if (!newName.equals(entityClassName)) {
                                this.replacedNames.put(entityClassName, newName);
                                String pkg = entityClass.getPackage();
                                String entityClassFQN = pkg == null || pkg.isEmpty() ? entityClassName : pkg + "." + entityClassName;
                                String newFQN = pkg == null || pkg.isEmpty() ? newName : pkg + "." + newName;
                                this.replacedTypeNames.put(entityClassFQN, newFQN);
                                generatedEntityClasses.remove(entityClassName);
                                generatedEntityClasses.add(newName);
                            }
                        }
                        catch (RuntimeException ex) {
                            Logger.getLogger(Generator.class.getName()).log(Level.WARNING, "Can't create class {0} from template in package {1} with package fileobject validity {2}.", new Object[]{entityClassName, packageFileObject.getPath(), packageFileObject.isValid()});
                            throw ex;
                        }
                        this.generatedEntityFOs.add(entity);
                        this.generatedFOs.add(entity);
                        generationPackageFOs.add(packageFileObject);
                        if (!entityClass.isForTable() || entityClass.isUsePkField() || packageFileObject.getFileObject(pkClassName = Generator.createPKClassName(entityClassName), "java") != null) continue block8;
                        FileObject pkClass = GenerationUtils.createClass((FileObject)packageFileObject, (String)pkClassName, (String)NbBundle.getMessage(Generator.class, (String)"MSG_PK_Class", (Object)pkClassName, (Object)entityClassName));
                        this.generatedFOs.add(pkClass);
                    }
                }
            }
            Set<ClassPath> bootCPs = Generator.getAllClassPaths(generationPackageFOs, "classpath/boot");
            Set<ClassPath> compileCPs = Generator.getAllClassPaths(generationPackageFOs, "classpath/compile");
            Set<ClassPath> sourceCPs = Generator.getAllClassPaths(generationPackageFOs, "classpath/source");
            JPAClassPathHelper cpHelper = new JPAClassPathHelper(bootCPs, compileCPs, sourceCPs).setModuleBootPaths(Generator.getAllClassPaths(generationPackageFOs, "modules/boot")).setModuleCompilePaths(Generator.getAllClassPaths(generationPackageFOs, "modules/compile")).setModuleClassPaths(Generator.getAllClassPaths(generationPackageFOs, "modules/classpath")).setModuleSourcePaths(Generator.getAllClassPaths(generationPackageFOs, "modules/source"));
            for (int i = 0; i < entityClasses.length; ++i) {
                EntityClass entityClass = entityClasses[i];
                String entityClassName = this.getClassName(entityClass);
                if (!generatedEntityClasses.contains(entityClassName) && !UpdateType.UPDATE.equals((Object)entityClass.getUpdateType())) {
                    progressContributor.progress(entityClasses.length + i);
                    continue;
                }
                String progressMsg = NbBundle.getMessage(Generator.class, (String)"TXT_GeneratingClass", (Object)entityClassName);
                progressContributor.progress(progressMsg, entityClasses.length + i);
                if (progressPanel != null) {
                    progressPanel.setText(progressMsg);
                }
                FileObject entityClassPackageFO = entityClass.getPackageFileObject();
                FileObject entityClassFO = entityClassPackageFO.getFileObject(entityClassName, "java");
                FileObject pkClassFO = entityClass.isForTable() && !entityClass.isUsePkField() ? entityClassPackageFO.getFileObject(Generator.createPKClassName(entityClassName), "java") : null;
                try {
                    JavaSource javaSource = pkClassFO != null && entityClass.getUpdateType() != UpdateType.UPDATE ? JavaSource.create((ClasspathInfo)cpHelper.createClasspathInfo(), (FileObject[])new FileObject[]{entityClassFO, pkClassFO}) : JavaSource.create((ClasspathInfo)cpHelper.createClasspathInfo(), (FileObject[])new FileObject[]{entityClassFO});
                    javaSource.runModificationTask(copy -> {
                        if (copy.getFileObject().equals(entityClassFO)) {
                            new EntityClassGenerator((WorkingCopy)copy, entityClass, jpaSupported, beanValidationSupported).run();
                        } else if (entityClass.getUpdateType() != UpdateType.UPDATE) {
                            new PKClassGenerator((WorkingCopy)copy, entityClass, jpaSupported, beanValidationSupported).run();
                        } else {
                            Logger.getLogger(Generator.class.getName()).log(Level.INFO, "PK Class update isn't supported");
                        }
                    }).commit();
                    continue;
                }
                catch (IOException e) {
                    String message = e.getMessage();
                    String newMessage = message == null ? NbBundle.getMessage(Generator.class, (String)"ERR_GeneratingClass_NoExceptionMessage", (Object)entityClassName) : NbBundle.getMessage(Generator.class, (String)"ERR_GeneratingClass", (Object)entityClassName, (Object)message);
                    throw new IOException(newMessage, e);
                }
            }
            progressContributor.progress(progressMax);
            PersistenceUtils.logUsage(Generator.class, (String)"USG_PERSISTENCE_ENTITY_DB_CREATED", (Object[])new Integer[]{entityClasses.length});
        }

        private static String getPkMemberName(EntityClass entityClass) {
            String memberName;
            List pks;
            if (entityClass != null && (pks = entityClass.getFields().stream().filter(f -> f.isPrimaryKey()).collect(Collectors.toList())).size() == 1 && (memberName = ((EntityMember)pks.get(0)).getMemberName()).length() > 2 && memberName.endsWith("Id")) {
                return memberName.substring(0, memberName.length() - 2);
            }
            return null;
        }

        private static String createPKClassName(String entityClassName) {
            return entityClassName + "PK";
        }

        private String getClassName(EntityClass entityClass) {
            return this.replacedNames.containsKey(entityClass.getClassName()) ? this.replacedNames.get(entityClass.getClassName()) : entityClass.getClassName();
        }

        private static Set<ClassPath> getAllClassPaths(Set<FileObject> fileObjects, String id) {
            HashSet<ClassPath> classPaths = new HashSet<ClassPath>();
            for (FileObject fileObject : fileObjects) {
                ClassPath cp = ClassPath.getClassPath((FileObject)fileObject, (String)id);
                if (cp == null) continue;
                classPaths.add(cp);
            }
            return classPaths;
        }

        private static boolean isBeanValidationSupported(SourceGroup sg) {
            if (sg == null) {
                return false;
            }
            ClassPath compile = ClassPath.getClassPath((FileObject)sg.getRootFolder(), (String)"classpath/compile");
            if (compile == null) {
                return false;
            }
            String notNullAnnotation = "javax.validation.constraints.NotNull";
            return compile.findResource("javax.validation.constraints.NotNull".replace('.', '/') + ".class") != null;
        }

        private final class PKClassGenerator
        extends ClassGenerator {
            public PKClassGenerator(WorkingCopy copy, EntityClass entityClass, boolean jpaSupported, boolean beanValidationSupported) throws IOException {
                super(copy, entityClass, jpaSupported, beanValidationSupported);
            }

            @Override
            protected void initialize() throws IOException {
                this.newClassTree = this.genUtils.ensureNoArgConstructor(this.newClassTree);
                if (this.generateSerdeable) {
                    this.newClassTree = this.genUtils.addAnnotation(this.newClassTree, this.genUtils.createAnnotation("io.micronaut.serde.annotation.Serdeable"));
                }
                this.newClassTree = this.genUtils.addAnnotation(this.newClassTree, this.genUtils.createAnnotation(this.generateJPA ? "javax.persistence.Embeddable" : "io.micronaut.data.annotation.Embeddable"));
            }

            @Override
            protected void generateMember(EntityMember m) throws IOException {
                if (!m.isPrimaryKey()) {
                    return;
                }
                ClassGenerator.Property property = this.createProperty(m);
                this.properties.add(property);
            }

            @Override
            protected void generateRelationship(RelationshipRole relationship) {
            }

            @Override
            protected void finish() {
                ArrayList<VariableTree> parameters = new ArrayList<VariableTree>(this.properties.size());
                for (ClassGenerator.Property property : this.properties) {
                    parameters.add(this.genUtils.removeModifiers(property.getField()));
                }
                this.constructors.add(this.genUtils.createAssignmentConstructor(this.genUtils.createModifiers(Modifier.PUBLIC), this.pkClassName, parameters));
            }
        }

        private class EntityClassGenerator
        extends ClassGenerator {
            private final String entityClassName;
            private final List<ClassGenerator.Property> nonNullableProps;
            private final List<String> pkColumnNames;
            private final List<VariableTree> pkClassVariables;
            private ClassGenerator.Property pkProperty;
            private boolean pkGenerated;

            public EntityClassGenerator(WorkingCopy copy, EntityClass entityClass, boolean jpaSupported, boolean beanValidationSupported) throws IOException {
                super(copy, entityClass, jpaSupported, beanValidationSupported);
                this.nonNullableProps = new ArrayList<ClassGenerator.Property>();
                this.pkColumnNames = new ArrayList<String>();
                this.pkClassVariables = new ArrayList<VariableTree>();
                this.entityClassName = Generator.this.getClassName(entityClass);
                assert (this.typeElement.getSimpleName().contentEquals(this.entityClassName));
            }

            @Override
            protected void initialize() throws IOException {
                List<ExpressionTree> tableAnnArgs;
                this.newClassTree = this.genUtils.ensureNoArgConstructor(this.newClassTree);
                if (this.needsPKClass) {
                    String pkFieldName = this.createFieldName(this.pkClassName);
                    this.pkProperty = (ClassGenerator)this.new ClassGenerator.Property(Modifier.PROTECTED, Collections.singletonList(this.genUtils.createAnnotation(this.generateJPA ? "javax.persistence.EmbeddedId" : "io.micronaut.data.annotation.EmbeddedId")), this.pkFQClassName, pkFieldName);
                    this.properties.add(this.pkProperty);
                }
                if (this.generateSerdeable) {
                    this.newClassTree = this.genUtils.addAnnotation(this.newClassTree, this.genUtils.createAnnotation("io.micronaut.serde.annotation.Serdeable"));
                }
                if (this.generateJPA) {
                    this.newClassTree = this.genUtils.addAnnotation(this.newClassTree, this.genUtils.createAnnotation("javax.persistence.Entity"));
                    if (this.dbMappings.getTableName() != null && !this.entityClassName.equalsIgnoreCase(this.dbMappings.getTableName())) {
                        tableAnnArgs = Collections.singletonList(this.genUtils.createAnnotationArgument("name", (Object)this.dbMappings.getTableName()));
                        this.newClassTree = this.genUtils.addAnnotation(this.newClassTree, this.genUtils.createAnnotation("javax.persistence.Table", tableAnnArgs));
                    }
                } else if (this.dbMappings.getTableName() != null && !this.entityClassName.equalsIgnoreCase(this.dbMappings.getTableName())) {
                    tableAnnArgs = Collections.singletonList(this.genUtils.createAnnotationArgument(null, (Object)this.dbMappings.getTableName()));
                    this.newClassTree = this.genUtils.addAnnotation(this.newClassTree, this.genUtils.createAnnotation("io.micronaut.data.annotation.MappedEntity", tableAnnArgs));
                } else {
                    this.newClassTree = this.genUtils.addAnnotation(this.newClassTree, this.genUtils.createAnnotation("io.micronaut.data.annotation.MappedEntity"));
                }
            }

            @Override
            protected void generateMember(EntityMember m) throws IOException {
                String memberName = m.getMemberName();
                boolean isPKMember = m.isPrimaryKey();
                ClassGenerator.Property property = null;
                if (isPKMember) {
                    if (this.needsPKClass) {
                        this.pkClassVariables.add(this.createVariable(m));
                    } else {
                        this.pkProperty = property = this.createProperty(m);
                    }
                    String pkColumnName = (String)this.dbMappings.getCMPFieldMapping().get(memberName);
                    this.pkColumnNames.add(pkColumnName);
                    this.pkGenerated = m.isAutoIncrement();
                } else {
                    property = this.createProperty(m);
                    if (!m.isNullable()) {
                        this.nonNullableProps.add(property);
                    }
                }
                assert (property != null || property == null && isPKMember && this.needsPKClass);
                if (property != null) {
                    this.properties.add(property);
                }
            }

            @Override
            protected void generateRelationship(RelationshipRole role) throws IOException {
                String relationAnn;
                TypeElement typeEl;
                String memberName = role.getFieldName();
                if (role.isMany() && !role.isToMany()) {
                    String roleName = role.getRoleName();
                    if (roleName.endsWith("Id")) {
                        roleName = roleName.substring(0, roleName.length() - 2);
                    }
                    if (!roleName.isEmpty()) {
                        memberName = Character.toLowerCase(roleName.charAt(0)) + roleName.substring(1);
                    }
                }
                String typeName = this.getRelationshipFieldType(role, this.entityClass.getPackage());
                if (Generator.this.replacedTypeNames.containsKey(typeName)) {
                    typeName = (String)Generator.this.replacedTypeNames.get(typeName);
                }
                TypeElement typeElement = typeEl = this.moduleElement != null ? this.copy.getElements().getTypeElement(this.moduleElement, typeName) : this.copy.getElements().getTypeElement(typeName);
                assert (typeEl != null) : "null TypeElement for \"" + typeName + "\"";
                String collectionType = "java.util.Set";
                TypeMirror fieldType = typeEl.asType();
                if (role.isToMany()) {
                    TypeElement collectionTypeElem = this.moduleElement != null ? this.copy.getElements().getTypeElement(this.moduleElement, collectionType) : this.copy.getElements().getTypeElement(collectionType);
                    fieldType = this.copy.getTypes().getDeclaredType(collectionTypeElem, fieldType);
                }
                ArrayList<AnnotationTree> annotations = new ArrayList<AnnotationTree>();
                ArrayList<ExpressionTree> annArguments = new ArrayList<ExpressionTree>();
                if (role.isCascade()) {
                    annArguments.add(this.genUtils.createAnnotationArgument("cascade", this.generateJPA ? "javax.persistence.CascadeType" : "io.micronaut.data.annotation.Relation.Cascade", "ALL"));
                }
                if (role.equals(role.getParent().getRoleB())) {
                    String fName = role.getParent().getRoleA().getFieldName();
                    annArguments.add(this.genUtils.createAnnotationArgument("mappedBy", (Object)fName));
                } else if (this.generateJPA) {
                    if (role.isMany() && role.isToMany()) {
                        ArrayList<ExpressionTree> joinTableAnnArguments = new ArrayList<ExpressionTree>();
                        String jTN = (String)this.dbMappings.getJoinTableMapping().get(role.getFieldName());
                        joinTableAnnArguments.add(this.genUtils.createAnnotationArgument("name", (Object)jTN));
                        CMPMappingModel.JoinTableColumnMapping joinColumnMap = (CMPMappingModel.JoinTableColumnMapping)this.dbMappings.getJoinTableColumnMppings().get(role.getFieldName());
                        CMPMappingModel.ColumnData[] columns = joinColumnMap.getColumns();
                        CMPMappingModel.ColumnData[] refColumns = joinColumnMap.getReferencedColumns();
                        joinTableAnnArguments.add(this.genUtils.createAnnotationArgument("joinColumns", this.createJoinColumnAnnotations(columns, refColumns, null)));
                        CMPMappingModel.ColumnData[] invColumns = joinColumnMap.getInverseColumns();
                        CMPMappingModel.ColumnData[] refInvColumns = joinColumnMap.getReferencedInverseColumns();
                        joinTableAnnArguments.add(this.genUtils.createAnnotationArgument("inverseJoinColumns", this.createJoinColumnAnnotations(invColumns, refInvColumns, null)));
                        annotations.add(this.genUtils.createAnnotation("javax.persistence.JoinTable", joinTableAnnArguments));
                    } else {
                        CMPMappingModel.ColumnData[] columns = (CMPMappingModel.ColumnData[])this.dbMappings.getCmrFieldMapping().get(role.getFieldName());
                        CMPMappingModel relatedMappings = ((EntityClass)Generator.this.beanMap.get(role.getParent().getRoleB().getEntityName())).getCMPMapping();
                        CMPMappingModel.ColumnData[] invColumns = (CMPMappingModel.ColumnData[])relatedMappings.getCmrFieldMapping().get(role.getParent().getRoleB().getFieldName());
                        if (columns.length == 1) {
                            ArrayList<ExpressionTree> attrs = new ArrayList<ExpressionTree>();
                            attrs.add(this.genUtils.createAnnotationArgument("name", (Object)columns[0].getColumnName()));
                            attrs.add(this.genUtils.createAnnotationArgument("referencedColumnName", (Object)invColumns[0].getColumnName()));
                            this.makeReadOnlyIfNecessary(this.pkColumnNames, columns[0].getColumnName(), attrs);
                            annotations.add(this.genUtils.createAnnotation("javax.persistence.JoinColumn", attrs));
                        } else {
                            ExpressionTree joinColumnsNameAttrValue = this.genUtils.createAnnotationArgument(null, this.createJoinColumnAnnotations(columns, invColumns, this.pkColumnNames));
                            AnnotationTree joinColumnsAnnotation = this.genUtils.createAnnotation("javax.persistence.JoinColumns", Collections.singletonList(joinColumnsNameAttrValue));
                            annotations.add(joinColumnsAnnotation);
                        }
                    }
                }
                if (this.generateJPA && !role.isToMany() && !role.isOptional() && (role.isMany() || role.equals(role.getParent().getRoleA()))) {
                    annArguments.add(this.genUtils.createAnnotationArgument("optional", (Object)false));
                }
                if (this.generateJPA) {
                    relationAnn = role.isMany() && role.isToMany() ? "ManyToMany" : (role.isMany() ? "ManyToOne" : (role.isToMany() ? "OneToMany" : "OneToOne"));
                    annotations.add(this.genUtils.createAnnotation("javax.persistence." + relationAnn, annArguments));
                } else {
                    relationAnn = role.isMany() && role.isToMany() ? "MANY_TO_MANY" : (role.isMany() ? "MANY_TO_ONE" : (role.isToMany() ? "ONE_TO_MANY" : "ONE_TO_ONE"));
                    annArguments.add(0, this.genUtils.createAnnotationArgument("value", "io.micronaut.data.annotation.Relation.Kind", relationAnn));
                    annotations.add(this.genUtils.createAnnotation("io.micronaut.data.annotation.Relation", annArguments));
                }
                this.properties.add((ClassGenerator)this.new ClassGenerator.Property(Modifier.PRIVATE, annotations, fieldType, memberName));
            }

            @Override
            protected void finish() {
                if (this.pkProperty != null && !this.pkGenerated) {
                    VariableTree pkFieldParam = this.genUtils.removeModifiers(this.pkProperty.getField());
                    List<VariableTree> pkFieldParams = Collections.singletonList(pkFieldParam);
                    this.constructors.add(this.genUtils.createAssignmentConstructor(this.genUtils.createModifiers(Modifier.PUBLIC), this.entityClassName, pkFieldParams));
                    if (!this.nonNullableProps.isEmpty()) {
                        ArrayList<VariableTree> nonNullableParams = new ArrayList<VariableTree>(this.nonNullableProps.size() + 1);
                        nonNullableParams.add(pkFieldParam);
                        for (ClassGenerator.Property property : this.nonNullableProps) {
                            nonNullableParams.add(this.genUtils.removeModifiers(property.getField()));
                        }
                        this.constructors.add(this.genUtils.createAssignmentConstructor(this.genUtils.createModifiers(Modifier.PUBLIC), this.entityClassName, nonNullableParams));
                    }
                    if (!this.pkClassVariables.isEmpty()) {
                        StringBuilder body = new StringBuilder(30 + 30 * this.pkClassVariables.size());
                        body.append("{");
                        body.append("this." + this.pkProperty.getField().getName() + " = new " + this.pkClassName + "(");
                        Iterator<VariableTree> i = this.pkClassVariables.iterator();
                        while (i.hasNext()) {
                            body.append(i.next().getName());
                            body.append(i.hasNext() ? ", " : ");");
                        }
                        body.append("}");
                        TreeMaker make = this.copy.getTreeMaker();
                        this.constructors.add(make.Constructor(make.Modifiers(EnumSet.of(Modifier.PUBLIC), Collections.emptyList()), Collections.emptyList(), this.pkClassVariables, Collections.emptyList(), body.toString()));
                    }
                }
            }

            private List<AnnotationTree> createJoinColumnAnnotations(CMPMappingModel.ColumnData[] columns, CMPMappingModel.ColumnData[] refColumns, List<String> pkcNames) {
                ArrayList<AnnotationTree> joinCols = new ArrayList<AnnotationTree>();
                for (int colIndex = 0; colIndex < columns.length; ++colIndex) {
                    ArrayList<ExpressionTree> attrs = new ArrayList<ExpressionTree>();
                    attrs.add(this.genUtils.createAnnotationArgument("name", (Object)columns[colIndex].getColumnName()));
                    attrs.add(this.genUtils.createAnnotationArgument("referencedColumnName", (Object)refColumns[colIndex].getColumnName()));
                    if (pkcNames != null) {
                        this.makeReadOnlyIfNecessary(pkcNames, columns[colIndex].getColumnName(), attrs);
                    }
                    joinCols.add(this.genUtils.createAnnotation("javax.persistence.JoinColumn", attrs));
                }
                return joinCols;
            }

            private String getRelationshipFieldType(RelationshipRole role, String pkg) {
                RelationshipRole otherRole;
                RelationshipRole rA = role.getParent().getRoleA();
                RelationshipRole rB = role.getParent().getRoleB();
                RelationshipRole relationshipRole = otherRole = role.equals(rA) ? rB : rA;
                if (role.getEntityPkgName() != null) {
                    return otherRole.getEntityPkgName() + "." + otherRole.getEntityName();
                }
                return pkg.length() == 0 ? otherRole.getEntityName() : pkg + "." + otherRole.getEntityName();
            }

            private void makeReadOnlyIfNecessary(List<String> pkColumnNames, String testColumnName, List<ExpressionTree> attrs) {
                if (pkColumnNames.contains(testColumnName)) {
                    attrs.add(this.genUtils.createAnnotationArgument("insertable", (Object)false));
                    attrs.add(this.genUtils.createAnnotationArgument("updatable", (Object)false));
                }
            }
        }

        private abstract class ClassGenerator {
            protected final WorkingCopy copy;
            protected final GenerationUtils genUtils;
            protected final EntityClass entityClass;
            protected final CMPMappingModel dbMappings;
            protected final boolean needsPKClass;
            protected final String pkClassName;
            protected final String pkFQClassName;
            protected final List<Property> properties = new ArrayList<Property>();
            protected final List<MethodTree> methods = new ArrayList<MethodTree>();
            protected final List<MethodTree> constructors = new ArrayList<MethodTree>();
            protected final List<VariableTree> fields = new ArrayList<VariableTree>();
            protected ClassTree originalClassTree;
            protected ClassTree newClassTree;
            protected TypeElement typeElement;
            protected ModuleElement moduleElement;
            protected final boolean generateJPA;
            protected final boolean generateValidationConstraints;
            protected final boolean generateSerdeable;

            private ClassGenerator(WorkingCopy copy, EntityClass entityClass, boolean jpaSupported, boolean beanValidationSupported) throws IOException {
                copy.toPhase(JavaSource.Phase.RESOLVED);
                this.copy = copy;
                this.entityClass = entityClass;
                this.dbMappings = entityClass.getCMPMapping();
                this.needsPKClass = entityClass.isForTable() && !entityClass.isUsePkField();
                this.pkClassName = this.needsPKClass ? Generator.createPKClassName(entityClass.getClassName()) : null;
                this.pkFQClassName = entityClass.getPackage() + "." + this.pkClassName;
                this.typeElement = SourceUtils.getPublicTopLevelElement((CompilationController)copy);
                if (this.typeElement == null) {
                    throw new IllegalStateException("Cannot find a public top-level class named " + entityClass.getClassName() + " in " + FileUtil.getFileDisplayName((FileObject)copy.getFileObject()));
                }
                this.moduleElement = copy.getElements().getModuleOf(this.typeElement);
                this.originalClassTree = copy.getTrees().getTree(this.typeElement);
                assert (this.originalClassTree != null);
                this.newClassTree = this.originalClassTree;
                this.genUtils = GenerationUtils.newInstance((WorkingCopy)copy);
                this.generateJPA = jpaSupported;
                this.generateValidationConstraints = beanValidationSupported;
                this.generateSerdeable = copy.getElements().getTypeElement("io.micronaut.serde.annotation.Serdeable") != null;
            }

            protected String createFieldName(String capitalizedFieldName) {
                return this.createFieldNameImpl(capitalizedFieldName, false);
            }

            protected String createCapitalizedFieldName(String fieldName) {
                return this.createFieldNameImpl(fieldName, true);
            }

            private String createFieldNameImpl(String fieldName, boolean capitalized) {
                StringBuilder sb = new StringBuilder(fieldName);
                char firstChar = sb.charAt(0);
                sb.setCharAt(0, capitalized ? Character.toUpperCase(firstChar) : Character.toLowerCase(firstChar));
                return sb.toString();
            }

            protected Property createProperty(EntityMember m) throws IOException {
                String temporalType;
                Integer length;
                boolean isLobType;
                boolean isPKMember = m.isPrimaryKey();
                ArrayList<AnnotationTree> annotations = new ArrayList<AnnotationTree>();
                if (isPKMember && !this.needsPKClass) {
                    annotations.add(this.genUtils.createAnnotation(this.generateJPA ? "javax.persistence.Id" : "io.micronaut.data.annotation.Id"));
                    if (m.isAutoIncrement()) {
                        annotations.add(this.genUtils.createAnnotation(this.generateJPA ? "javax.persistence.GeneratedValue" : "io.micronaut.data.annotation.GeneratedValue"));
                    }
                }
                if (!m.isNullable() && this.generateValidationConstraints && !m.isAutoIncrement()) {
                    annotations.add(this.genUtils.createAnnotation("javax.validation.constraints.NotNull"));
                }
                if ((isLobType = m.isLobType()) && this.generateJPA) {
                    annotations.add(this.genUtils.createAnnotation("javax.persistence.Lob"));
                }
                ArrayList<ExpressionTree> columnAnnArguments = new ArrayList<ExpressionTree>();
                String memberName = m.getMemberName();
                String memberType = m.getMemberType();
                String columnName = (String)this.dbMappings.getCMPFieldMapping().get(memberName);
                if (!memberName.equalsIgnoreCase(columnName)) {
                    columnAnnArguments.add(this.genUtils.createAnnotationArgument(this.generateJPA ? "name" : null, (Object)columnName));
                }
                if ((length = m.getLength()) != null && this.isCharacterType(memberType) && this.generateValidationConstraints) {
                    ArrayList<ExpressionTree> sizeAnnArguments = new ArrayList<ExpressionTree>();
                    if (!m.isNullable()) {
                        sizeAnnArguments.add(this.genUtils.createAnnotationArgument("min", (Object)1));
                    }
                    sizeAnnArguments.add(this.genUtils.createAnnotationArgument("max", (Object)length));
                    annotations.add(this.genUtils.createAnnotation("javax.validation.constraints.Size", sizeAnnArguments));
                }
                if (!columnAnnArguments.isEmpty()) {
                    if (this.generateJPA) {
                        annotations.add(this.genUtils.createAnnotation("javax.persistence.Column", columnAnnArguments));
                    } else if (isPKMember && this.needsPKClass) {
                        annotations.add(this.genUtils.createAnnotation("io.micronaut.data.annotation.MappedProperty", columnAnnArguments));
                    }
                }
                if ((temporalType = this.getMemberTemporalType(m)) != null && this.generateJPA) {
                    ExpressionTree temporalAnnValueArgument = this.genUtils.createAnnotationArgument(null, "javax.persistence.TemporalType", temporalType);
                    annotations.add(this.genUtils.createAnnotation("javax.persistence.Temporal", Collections.singletonList(temporalAnnValueArgument)));
                }
                return new Property(Modifier.PRIVATE, annotations, memberType, memberName);
            }

            protected VariableTree createVariable(EntityMember m) {
                return this.genUtils.createVariable(this.typeElement, m.getMemberName(), m.getMemberType());
            }

            private boolean isCharacterType(String type) {
                return "java.lang.String".equals(type);
            }

            private String getMemberTemporalType(EntityMember m) {
                String memberType = m.getMemberType();
                String temporalType = null;
                if ("java.sql.Date".equals(memberType)) {
                    temporalType = "DATE";
                } else if ("java.sql.Time".equals(memberType)) {
                    temporalType = "TIME";
                } else if ("java.sql.Timestamp".equals(memberType)) {
                    temporalType = "TIMESTAMP";
                }
                return temporalType;
            }

            public void run() throws IOException {
                this.initialize();
                for (Object object : this.entityClass.getFields()) {
                    this.generateMember((EntityMember)object);
                }
                for (RelationshipRole roleObject : this.entityClass.getRoles()) {
                    this.generateRelationship(roleObject);
                }
                this.finish();
                TreeMaker make = this.copy.getTreeMaker();
                int position = 0;
                for (VariableTree field : this.fields) {
                    this.newClassTree = make.insertClassMember(this.newClassTree, position, (Tree)field);
                    ++position;
                }
                for (Property property : this.properties) {
                    this.newClassTree = make.insertClassMember(this.newClassTree, position, (Tree)property.getField());
                    ++position;
                }
                for (MethodTree constructor : this.constructors) {
                    this.newClassTree = make.addClassMember(this.newClassTree, (Tree)constructor);
                }
                for (Property property : this.properties) {
                    this.newClassTree = make.addClassMember(this.newClassTree, (Tree)property.getGetter());
                    this.newClassTree = make.addClassMember(this.newClassTree, (Tree)property.getSetter());
                }
                for (MethodTree method : this.methods) {
                    this.newClassTree = make.addClassMember(this.newClassTree, (Tree)method);
                }
                Logger.getLogger(Generator.class.getName()).log(Level.FINE, "Rewrite entity tree with name: {0}", this.entityClass.getTableName());
                Logger.getLogger(Generator.class.getName()).log(Level.FINE, "Rewrite entity tree with annotations: length = {0}, annotations = {1}", new Object[]{this.newClassTree.getModifiers().getAnnotations().size(), this.newClassTree.getModifiers().getAnnotations()});
                this.copy.rewrite((Tree)this.originalClassTree, (Tree)this.newClassTree);
            }

            protected abstract void initialize() throws IOException;

            protected abstract void generateMember(EntityMember var1) throws IOException;

            protected abstract void generateRelationship(RelationshipRole var1) throws IOException;

            protected abstract void finish() throws IOException;

            protected final class Property {
                private final VariableTree field;
                private final MethodTree getter;
                private final MethodTree setter;

                public Property(Modifier modifier, List<AnnotationTree> annotations, String type, String name) throws IOException {
                    this(modifier, annotations, this$1.genUtils.createType(type, this$1.typeElement), name);
                }

                public Property(Modifier modifier, List<AnnotationTree> annotations, TypeMirror type, String name) throws IOException {
                    this(modifier, annotations, this$1.copy.getTreeMaker().Type(type), name);
                }

                private Property(Modifier modifier, List<AnnotationTree> annotations, Tree typeTree, String name) throws IOException {
                    TreeMaker make = ClassGenerator.this.copy.getTreeMaker();
                    this.field = make.Variable(make.Modifiers(EnumSet.of(modifier), annotations), (CharSequence)name, typeTree, null);
                    this.getter = ClassGenerator.this.genUtils.createPropertyGetterMethod(make.Modifiers(EnumSet.of(Modifier.PUBLIC), Collections.emptyList()), name, typeTree);
                    this.setter = ClassGenerator.this.genUtils.createPropertySetterMethod(ClassGenerator.this.genUtils.createModifiers(Modifier.PUBLIC), name, typeTree);
                }

                public VariableTree getField() {
                    return this.field;
                }

                public MethodTree getGetter() {
                    return this.getter;
                }

                public MethodTree getSetter() {
                    return this.setter;
                }
            }
        }
    }

    public static class GeneratorProvider
    implements PersistenceGeneratorProvider {
        public String getGeneratorType() {
            return MicronautEntity.TYPE_MICRONAUT;
        }

        public PersistenceGenerator createGenerator() {
            return new Generator();
        }
    }
}

