/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.micronaut.completion;

import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.RecordComponentElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.TypeUtilities;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.db.sql.editor.api.completion.SQLCompletion;
import org.netbeans.modules.db.sql.editor.api.completion.SQLCompletionContext;
import org.netbeans.modules.db.sql.editor.api.completion.SQLCompletionResultSet;
import org.netbeans.modules.micronaut.completion.MicronautExpressionLanguageCompletion;
import org.netbeans.modules.micronaut.db.Utils;
import org.netbeans.modules.micronaut.expression.EvaluationContext;
import org.netbeans.modules.micronaut.expression.MicronautExpressionLanguageParser;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;

public class MicronautDataCompletionTask {
    private static final String JPA_REPOSITORY_ANNOTATION_NAME = "io.micronaut.data.annotation.Repository";
    private static final String JDBC_REPOSITORY_ANNOTATION_NAME = "io.micronaut.data.jdbc.annotation.JdbcRepository";
    private static final String REPOSITORY_TYPE_NAME = "io.micronaut.data.repository.GenericRepository";
    private static final String CONTROLLER_ANNOTATION_NAME = "io.micronaut.http.annotation.Controller";
    private static final String QUERY_ANNOTATION_TYPE_NAME = "io.micronaut.data.annotation.Query";
    private static final String GET = "get";
    private static final List<String> QUERY_PATTERNS = new ArrayList<String>(Arrays.asList("find", "get", "query", "read", "retrieve", "search"));
    private static final List<String> SPECIAL_QUERY_PATTERNS = new ArrayList<String>(Arrays.asList("count", "countDistinct", "delete", "exists", "update"));
    private static final List<String> QUERY_PROJECTIONS = new ArrayList<String>(Arrays.asList("", "Avg", "Distinct", "Max", "Min", "Sum"));
    private static final List<String> CRITERION_EXPRESSIONS = new ArrayList<String>(Arrays.asList("", "After", "Before", "Contains", "StartingWith", "StartsWith", "EndingWith", "EndsWith", "Equal", "Equals", "NotEqual", "NotEquals", "GreaterThan", "GreaterThanEquals", "LessThan", "LessThanEquals", "Like", "Ilike", "In", "InList", "InRange", "Between", "IsNull", "IsNotNull", "IsEmpty", "IsNotEmpty", "True", "False"));
    private static final List<String> COMPOSE_EXPRESSIONS = new ArrayList<String>(Arrays.asList("And", "Or"));
    private static final String BY = "By";
    private static final String ORDER_BY = "OrderBy";
    private static final String COUNT = "count";
    private static final String EXISTS = "exists";
    private static final String EMPTY = "";
    private int anchorOffset;

    public <T> List<T> query(Document doc, final int caretOffset, final ItemFactory<T> factory) {
        final ArrayList items = new ArrayList();
        try {
            ParserManager.parse(Collections.singleton(Source.create((Document)doc)), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    CompilationController cc = CompilationController.get((Parser.Result)resultIterator.getParserResult(caretOffset));
                    if (cc != null) {
                        int len;
                        cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        MicronautDataCompletionTask.this.anchorOffset = caretOffset;
                        String prefix = MicronautDataCompletionTask.EMPTY;
                        TokenSequence ts = cc.getTokenHierarchy().tokenSequence(JavaTokenId.language());
                        if (ts.move(MicronautDataCompletionTask.this.anchorOffset) == 0 || !ts.moveNext()) {
                            ts.movePrevious();
                        }
                        if ((len = MicronautDataCompletionTask.this.anchorOffset - ts.offset()) > 0 && ts.token().length() >= len) {
                            if (ts.token().id() == JavaTokenId.IDENTIFIER || ((JavaTokenId)ts.token().id()).primaryCategory().startsWith("keyword") || ((JavaTokenId)ts.token().id()).primaryCategory().equals("literal")) {
                                prefix = ts.token().text().toString().substring(0, len);
                                MicronautDataCompletionTask.this.anchorOffset = ts.offset();
                            } else if (ts.token().id() == JavaTokenId.STRING_LITERAL) {
                                prefix = ts.token().text().toString().substring(1, ts.token().length() - 1);
                                MicronautDataCompletionTask.this.anchorOffset = ts.offset() + 1;
                            } else if (ts.token().id() == JavaTokenId.MULTILINE_STRING_LITERAL) {
                                prefix = ts.token().text().toString().substring(3, len);
                                MicronautDataCompletionTask.this.anchorOffset = ts.offset() + 3;
                            }
                        }
                        Consumer consumer = (namePrefix, name, type) -> items.add(type != null ? factory.createFinderMethodItem(name, type, MicronautDataCompletionTask.this.anchorOffset) : factory.createFinderMethodNameItem(namePrefix, name, MicronautDataCompletionTask.this.anchorOffset));
                        TreeUtilities treeUtilities = cc.getTreeUtilities();
                        SourcePositions sp = cc.getTrees().getSourcePositions();
                        TreePath path = treeUtilities.pathFor(MicronautDataCompletionTask.this.anchorOffset);
                        switch (path.getLeaf().getKind()) {
                            case CLASS: 
                            case INTERFACE: {
                                MicronautDataCompletionTask.this.resolveFinderMethods((CompilationInfo)cc, path, prefix, true, consumer);
                                items.addAll(MicronautDataCompletionTask.this.resolveControllerMethods(cc, path, prefix, factory));
                                break;
                            }
                            case METHOD: {
                                Tree returnType = ((MethodTree)path.getLeaf()).getReturnType();
                                if (returnType == null || MicronautDataCompletionTask.findLastNonWhitespaceToken((TokenSequence<JavaTokenId>)ts, (int)sp.getEndPosition(path.getCompilationUnit(), returnType), MicronautDataCompletionTask.this.anchorOffset) != null) break;
                                MicronautDataCompletionTask.this.resolveFinderMethods((CompilationInfo)cc, path.getParentPath(), prefix, false, consumer);
                                break;
                            }
                            case VARIABLE: {
                                TreePath parentPath;
                                Tree type2 = ((VariableTree)path.getLeaf()).getType();
                                if (type2 == null || MicronautDataCompletionTask.findLastNonWhitespaceToken((TokenSequence<JavaTokenId>)ts, (int)sp.getEndPosition(path.getCompilationUnit(), type2), MicronautDataCompletionTask.this.anchorOffset) != null || (parentPath = path.getParentPath()).getLeaf().getKind() != Tree.Kind.CLASS && parentPath.getLeaf().getKind() != Tree.Kind.INTERFACE) break;
                                MicronautDataCompletionTask.this.resolveFinderMethods((CompilationInfo)cc, parentPath, prefix, false, consumer);
                                break;
                            }
                            case STRING_LITERAL: {
                                if (path.getParentPath().getLeaf().getKind() != Tree.Kind.ASSIGNMENT || path.getParentPath().getParentPath().getLeaf().getKind() != Tree.Kind.ANNOTATION) break;
                                items.addAll(MicronautDataCompletionTask.this.resolveExpressionLanguage((CompilationInfo)cc, path.getParentPath(), prefix, caretOffset - MicronautDataCompletionTask.this.anchorOffset, factory));
                                for (CompletionItem item : MicronautDataCompletionTask.this.resolveQueryAnnotation((CompilationInfo)cc, path.getParentPath().getParentPath(), prefix, caretOffset - MicronautDataCompletionTask.this.anchorOffset)) {
                                    items.add(factory.createSQLItem(item));
                                }
                                break;
                            }
                        }
                    }
                }
            });
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return items;
    }

    public int getAnchorOffset() {
        return this.anchorOffset;
    }

    private <T> List<T> resolveExpressionLanguage(CompilationInfo info, TreePath path, String prefix, int off, MicronautExpressionLanguageCompletion.ItemFactory<T> factory) {
        Matcher matcher = MicronautExpressionLanguageParser.MEXP_PATTERN.matcher(prefix);
        while (matcher.find() && matcher.groupCount() == 1) {
            EvaluationContext ctx;
            if (off < matcher.start(1) || off > matcher.end(1) || (ctx = EvaluationContext.get(info, path)) == null) continue;
            MicronautExpressionLanguageCompletion completion = new MicronautExpressionLanguageCompletion(info, ctx, matcher.group(1), this.anchorOffset + matcher.start(1));
            MicronautExpressionLanguageCompletion.Result<T> result = completion.query(off - matcher.start(1), factory);
            int newOffset = result.getAnchorOffset();
            if (newOffset >= 0) {
                this.anchorOffset = newOffset;
            }
            return result.getItems();
        }
        return Collections.emptyList();
    }

    private List<CompletionItem> resolveQueryAnnotation(CompilationInfo info, TreePath path, String prefix, int off) {
        TreePath clsPath;
        Element el = info.getTrees().getElement(path);
        if (el instanceof TypeElement && QUERY_ANNOTATION_TYPE_NAME.contentEquals(((TypeElement)el).getQualifiedName()) && (clsPath = info.getTreeUtilities().getPathElementOfKind(TreeUtilities.CLASS_TREE_KINDS, path)) != null && Utils.getAnnotation(info.getTrees().getElement(clsPath).getAnnotationMirrors(), JDBC_REPOSITORY_ANNOTATION_NAME) != null) {
            SQLCompletionContext ctx = SQLCompletionContext.empty().setStatement((CharSequence)prefix).setOffset(off).setDatabaseConnection(ConnectionManager.getDefault().getPreferredConnection(true));
            SQLCompletion completion = SQLCompletion.create((SQLCompletionContext)ctx);
            SQLCompletionResultSet resultSet = SQLCompletionResultSet.create();
            completion.query(resultSet, (component, offset, text) -> {
                int caretOffset = component.getCaretPosition();
                StyledDocument document = (StyledDocument)component.getDocument();
                try {
                    NbDocument.runAtomicAsUser((StyledDocument)document, () -> {
                        try {
                            int documentOffset = this.anchorOffset + offset;
                            document.remove(documentOffset, caretOffset - documentOffset);
                            document.insertString(documentOffset, text.replace("\"", "\\\""), null);
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                    });
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            });
            int newOffset = resultSet.getAnchorOffset();
            if (newOffset >= 0) {
                this.anchorOffset = newOffset;
            }
            return resultSet.getItems();
        }
        return Collections.emptyList();
    }

    private <T> List<T> resolveControllerMethods(CompilationController cc, TreePath path, String prefix, ItemFactory<T> factory) {
        List<VariableElement> repositories;
        ArrayList items = new ArrayList();
        TypeElement te = (TypeElement)cc.getTrees().getElement(path);
        AnnotationMirror controllerAnn = Utils.getAnnotation(te.getAnnotationMirrors(), CONTROLLER_ANNOTATION_NAME);
        if (controllerAnn != null && !(repositories = Utils.getRepositoriesFor((CompilationInfo)cc, te)).isEmpty()) {
            Utils.collectMissingDataEndpoints((CompilationInfo)cc, te, prefix, (repository, delegateMethod, id) -> {
                Object item = factory.createControllerMethodItem((CompilationInfo)cc, repository, delegateMethod, id, this.anchorOffset);
                if (item != null) {
                    items.add(item);
                }
            });
        }
        return items;
    }

    private void resolveFinderMethods(CompilationInfo info, TreePath path, String prefix, boolean full, Consumer consumer) throws IOException {
        TypeUtilities tu = info.getTypeUtilities();
        TypeElement entity = MicronautDataCompletionTask.getEntityFor(info, path);
        if (entity != null) {
            HashMap<String, String> prop2Types = new HashMap<String, String>();
            for (ExecutableElement method : ElementFilter.methodsIn(entity.getEnclosedElements())) {
                TypeMirror type;
                String methodName = method.getSimpleName().toString();
                if (!methodName.startsWith(GET) || methodName.length() <= 3 || !method.getParameters().isEmpty() || (type = method.getReturnType()).getKind() == TypeKind.ERROR) continue;
                methodName = methodName.substring(GET.length());
                methodName = methodName.substring(0, 1).toUpperCase(Locale.ENGLISH) + methodName.substring(1);
                prop2Types.put(methodName, tu.getTypeName(type, new TypeUtilities.TypeNameOptions[0]).toString());
            }
            for (RecordComponentElement recordComponent : ElementFilter.recordComponentsIn(entity.getEnclosedElements())) {
                TypeMirror type = recordComponent.asType();
                if (type.getKind() == TypeKind.ERROR) continue;
                String name = recordComponent.getSimpleName().toString();
                name = name.substring(0, 1).toUpperCase(Locale.ENGLISH) + name.substring(1);
                prop2Types.put(name, tu.getTypeName(type, new TypeUtilities.TypeNameOptions[0]).toString());
            }
            this.addFindByCompletions(entity, prop2Types, prefix, full, consumer);
        }
    }

    private void addFindByCompletions(TypeElement entity, Map<String, String> prop2Types, String prefix, boolean full, Consumer consumer) {
        for (String pattern : QUERY_PATTERNS) {
            String name = pattern + BY;
            if (prefix.length() >= name.length() && prefix.startsWith(name)) {
                this.addPropertyCriterionCompletions(prop2Types, name, prefix, consumer);
            } else if (Utils.startsWith(name, prefix)) {
                consumer.accept(EMPTY, name, full ? entity.getSimpleName().toString() : null);
            }
            for (String projection : QUERY_PROJECTIONS) {
                for (String propName : prop2Types.keySet()) {
                    name = pattern + projection + propName + BY;
                    if (prefix.length() >= name.length() && prefix.startsWith(name)) {
                        this.addPropertyCriterionCompletions(prop2Types, name, prefix, consumer);
                        continue;
                    }
                    if (!Utils.startsWith(name, prefix)) continue;
                    consumer.accept(EMPTY, name, full ? prop2Types.get(propName) : null);
                }
            }
        }
        for (String pattern : SPECIAL_QUERY_PATTERNS) {
            for (String propName : prop2Types.keySet()) {
                String name = pattern + propName + BY;
                if (prefix.length() >= name.length() && prefix.startsWith(name)) {
                    this.addPropertyCriterionCompletions(prop2Types, name, prefix, consumer);
                    continue;
                }
                if (!Utils.startsWith(name, prefix)) continue;
                consumer.accept(EMPTY, name, full ? (name.startsWith(COUNT) ? "int" : (name.startsWith(EXISTS) ? "boolean" : "void")) : null);
            }
        }
    }

    private void addPropertyCriterionCompletions(Map<String, String> prop2Types, String namePrefix, String prefix, Consumer consumer) {
        for (String propName : prop2Types.keySet()) {
            for (String criterion : CRITERION_EXPRESSIONS) {
                String name = propName + criterion;
                if (prefix.length() >= namePrefix.length() + name.length() && prefix.startsWith(namePrefix + name)) {
                    this.addComposeAndOrderCompletions(prop2Types, namePrefix + name, prefix, consumer);
                    continue;
                }
                if (!Utils.startsWith(namePrefix + name, prefix)) continue;
                consumer.accept(namePrefix, name, null);
            }
        }
    }

    private void addComposeAndOrderCompletions(Map<String, String> prop2Types, String namePrefix, String prefix, Consumer consumer) {
        for (String name : COMPOSE_EXPRESSIONS) {
            if (prefix.length() >= namePrefix.length() + name.length() && prefix.startsWith(namePrefix + name)) {
                this.addPropertyCriterionCompletions(prop2Types, namePrefix + name, prefix, consumer);
                continue;
            }
            if (!Utils.startsWith(namePrefix + name, prefix)) continue;
            consumer.accept(namePrefix, name, null);
        }
        for (String propName : prop2Types.keySet()) {
            String name = ORDER_BY + propName;
            if (prefix.length() >= namePrefix.length() + name.length() || !Utils.startsWith(namePrefix + name, prefix)) continue;
            consumer.accept(namePrefix, name, null);
        }
    }

    private static TypeElement getEntityFor(CompilationInfo info, TreePath path) {
        TypeElement te = (TypeElement)info.getTrees().getElement(path);
        if (te.getModifiers().contains((Object)Modifier.ABSTRACT) && Utils.getAnnotation(te.getAnnotationMirrors(), JPA_REPOSITORY_ANNOTATION_NAME) != null) {
            Types types = info.getTypes();
            TypeMirror repositoryType = types.erasure(info.getElements().getTypeElement(REPOSITORY_TYPE_NAME).asType());
            for (TypeMirror typeMirror : te.getInterfaces()) {
                TypeMirror entityType;
                List<? extends TypeMirror> typeArguments;
                if (typeMirror.getKind() != TypeKind.DECLARED || !types.isSubtype(types.erasure(typeMirror), repositoryType) || (typeArguments = ((DeclaredType)typeMirror).getTypeArguments()).isEmpty() || (entityType = typeArguments.get(0)) == null || entityType.getKind() != TypeKind.DECLARED) continue;
                return (TypeElement)((DeclaredType)entityType).asElement();
            }
        }
        return null;
    }

    private static TokenSequence<JavaTokenId> findLastNonWhitespaceToken(TokenSequence<JavaTokenId> ts, int startPos, int endPos) {
        ts.move(endPos);
        TokenSequence<JavaTokenId> last = MicronautDataCompletionTask.previousNonWhitespaceToken(ts);
        if (last == null || last.offset() < startPos) {
            return null;
        }
        return last;
    }

    private static TokenSequence<JavaTokenId> previousNonWhitespaceToken(TokenSequence<JavaTokenId> ts) {
        block3: while (ts.movePrevious()) {
            switch ((JavaTokenId)ts.token().id()) {
                case WHITESPACE: 
                case LINE_COMMENT: 
                case BLOCK_COMMENT: 
                case JAVADOC_COMMENT: {
                    continue block3;
                }
            }
            return ts;
        }
        return null;
    }

    static CharSequence getTypeName(CompilationInfo info, TypeMirror type, boolean fqn, boolean varArg) {
        EnumSet<TypeUtilities.TypeNameOptions> options = EnumSet.noneOf(TypeUtilities.TypeNameOptions.class);
        if (fqn) {
            options.add(TypeUtilities.TypeNameOptions.PRINT_FQN);
        }
        if (varArg) {
            options.add(TypeUtilities.TypeNameOptions.PRINT_AS_VARARG);
        }
        return info.getTypeUtilities().getTypeName(type, options.toArray(new TypeUtilities.TypeNameOptions[0]));
    }

    @FunctionalInterface
    private static interface Consumer {
        public void accept(String var1, String var2, String var3);
    }

    public static interface ItemFactory<T>
    extends MicronautExpressionLanguageCompletion.ItemFactory<T> {
        public T createControllerMethodItem(CompilationInfo var1, VariableElement var2, ExecutableElement var3, String var4, int var5);

        public T createFinderMethodItem(String var1, String var2, int var3);

        public T createFinderMethodNameItem(String var1, String var2, int var3);

        public T createSQLItem(CompletionItem var1);
    }
}

