/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.status;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import javax.swing.Action;
import org.netbeans.modules.mercurial.FileInformation;
import org.netbeans.modules.mercurial.HgFileNode;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.ui.diff.DiffAction;
import org.netbeans.modules.mercurial.ui.status.VersioningPanel;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

public class SyncFileNode
extends AbstractNode {
    private HgFileNode node;
    static final String COLUMN_NAME_NAME = "name";
    static final String COLUMN_NAME_PATH = "path";
    static final String COLUMN_NAME_STATUS = "status";
    static final String COLUMN_NAME_BRANCH = "branch";
    private String htmlDisplayName;
    private RequestProcessor.Task repoload;
    private final VersioningPanel panel;
    private DataObject dobj;
    private static final String[] zeros = new String[]{"", "00", "0", ""};

    public SyncFileNode(HgFileNode node, VersioningPanel _panel) {
        this(Children.LEAF, node, _panel);
    }

    private SyncFileNode(Children children, HgFileNode node, VersioningPanel _panel) {
        super(children, Lookups.fixed((Object[])node.getLookupObjects()));
        this.node = node;
        this.panel = _panel;
        this.init();
        this.initProperties();
        this.refreshHtmlDisplayName();
    }

    public File getFile() {
        return this.node.getFile();
    }

    public FileInformation getFileInformation() {
        return this.node.getInformation();
    }

    public String getName() {
        return this.node.getName();
    }

    public Action getPreferredAction() {
        if (this.node.getInformation().getStatus() == 64) {
            return null;
        }
        return SystemAction.get(DiffAction.class);
    }

    public Node.Cookie getCookie(Class klass) {
        if (this.dobj == null) {
            return super.getCookie(klass);
        }
        return this.dobj.getCookie(klass);
    }

    private void init() {
        FileObject fo = this.node.getFileObject();
        if (fo != null) {
            try {
                this.dobj = DataObject.find((FileObject)fo);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
    }

    private void initProperties() {
        if (this.node.getFile().isDirectory()) {
            this.setIconBaseWithExtension("org/openide/loaders/defaultFolder.gif");
        }
        Sheet sheet = Sheet.createDefault();
        Sheet.Set ps = Sheet.createPropertiesSet();
        ps.put((Node.Property)new NameProperty());
        ps.put((Node.Property)new PathProperty());
        ps.put((Node.Property)new StatusProperty());
        ps.put((Node.Property)new BranchProperty());
        sheet.put(ps);
        this.setSheet(sheet);
    }

    private void refreshHtmlDisplayName() {
        FileInformation info = this.node.getInformation();
        int status = info.getStatus();
        if (status == 128) {
            status = 64;
        }
        this.htmlDisplayName = Mercurial.getInstance().getMercurialAnnotator().annotateNameHtml(this.node.getFile().getName(), info, null);
        this.fireDisplayNameChange(this.node.getName(), this.node.getName());
    }

    public String getHtmlDisplayName() {
        return this.htmlDisplayName;
    }

    public void refresh() {
        this.refreshHtmlDisplayName();
    }

    public void destroy() throws IOException {
        super.destroy();
        if (this.repoload != null) {
            this.repoload.cancel();
        }
    }

    private class StatusProperty
    extends SyncFileProperty {
        public StatusProperty() {
            super(SyncFileNode.COLUMN_NAME_STATUS, String.class, NbBundle.getMessage(SyncFileNode.class, (String)"BK2007"), NbBundle.getMessage(SyncFileNode.class, (String)"BK2008"));
            String shortPath = HgUtils.getRelativePath(SyncFileNode.this.node.getFile());
            String sortable = Integer.toString(HgUtils.getComparableStatus(SyncFileNode.this.node.getInformation().getStatus()));
            this.setValue("sortkey", zeros[sortable.length()] + sortable + "\t" + shortPath + "\t" + SyncFileNode.this.getName());
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            FileInformation finfo = SyncFileNode.this.node.getInformation();
            int mask = SyncFileNode.this.panel.getDisplayStatuses();
            return finfo.getStatusText(mask);
        }
    }

    private class NameProperty
    extends SyncFileProperty {
        public NameProperty() {
            super(SyncFileNode.COLUMN_NAME_NAME, String.class, NbBundle.getMessage(SyncFileNode.class, (String)"BK2005"), NbBundle.getMessage(SyncFileNode.class, (String)"BK2006"));
            this.setValue("sortkey", SyncFileNode.this.getName());
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return SyncFileNode.this.getDisplayName();
        }
    }

    private class PathProperty
    extends SyncFileProperty {
        private String shortPath;

        public PathProperty() {
            super(SyncFileNode.COLUMN_NAME_PATH, String.class, NbBundle.getMessage(SyncFileNode.class, (String)"BK2003"), NbBundle.getMessage(SyncFileNode.class, (String)"BK2004"));
            this.shortPath = HgUtils.getRelativePath(SyncFileNode.this.node.getFile());
            this.setValue("sortkey", this.shortPath + "\t" + SyncFileNode.this.getName());
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.shortPath;
        }
    }

    private class BranchProperty
    extends SyncFileProperty {
        public BranchProperty() {
            super(SyncFileNode.COLUMN_NAME_BRANCH, String.class, NbBundle.getMessage(SyncFileNode.class, (String)"BK2001"), NbBundle.getMessage(SyncFileNode.class, (String)"BK2002"));
        }

        public Object getValue() {
            String branchInfo = SyncFileNode.this.panel.getDisplayBranchInfo();
            return branchInfo == null ? "" : branchInfo;
        }
    }

    private abstract class SyncFileProperty
    extends PropertySupport.ReadOnly {
        protected SyncFileProperty(String name, Class type, String displayName, String shortDescription) {
            super(name, type, displayName, shortDescription);
        }

        public String toString() {
            try {
                return this.getValue().toString();
            }
            catch (Exception e) {
                Mercurial.LOG.log(Level.INFO, null, e);
                return e.getLocalizedMessage();
            }
        }
    }
}

