/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.diff;

import java.awt.EventQueue;
import java.io.File;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.ui.diff.DiffAction;
import org.netbeans.modules.mercurial.ui.diff.DiffToRevision;
import org.netbeans.modules.mercurial.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.nodes.Node;
import org.openide.util.actions.SystemAction;

public class DiffToRevisionAction
extends ContextAction {
    @Override
    protected boolean enable(Node[] nodes) {
        VCSContext context = HgUtils.getCurrentContext(nodes);
        return HgUtils.isFromHgRepository(context);
    }

    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_DiffToRevision";
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        final VCSContext context = HgUtils.getCurrentContext(nodes);
        final File[] actionRoots = HgUtils.getActionRoots(context);
        if (actionRoots == null || actionRoots.length == 0) {
            return;
        }
        Utils.post((Runnable)new Runnable(){

            @Override
            public void run() {
                final File repository = Mercurial.getInstance().getRepositoryRoot(actionRoots[0]);
                try {
                    final HgLogMessage.HgRevision parent = HgCommand.getParent(repository, null, null);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            String contextName = Utils.getContextDisplayName((VCSContext)context);
                            DiffToRevisionAction.this.diff(repository, actionRoots, parent, contextName);
                        }
                    });
                }
                catch (HgException.HgCommandCanceledException parent) {
                }
                catch (HgException ex) {
                    HgUtils.notifyException(ex);
                }
            }
        });
    }

    private void diff(File repository, File[] roots, HgLogMessage.HgRevision wcParent, String contextDisplayName) {
        DiffToRevision diffPanel = new DiffToRevision(repository, wcParent);
        if (diffPanel.showDialog()) {
            ((DiffAction)SystemAction.get(DiffAction.class)).diff(roots, diffPanel.getSelectedTreeFirst(), diffPanel.getSelectedTreeSecond(), contextDisplayName, false, true);
        }
    }
}

