/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.clone;

import java.io.File;
import java.net.PasswordAuthentication;
import java.net.URISyntaxException;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.config.HgConfigFiles;
import org.netbeans.modules.mercurial.kenai.HgKenaiAccessor;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.ui.clone.Clone;
import org.netbeans.modules.mercurial.ui.clone.CloneCompleted;
import org.netbeans.modules.mercurial.ui.repository.HgURL;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgProjectUtils;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class CloneAction
extends ContextAction {
    @Override
    protected boolean enable(Node[] nodes) {
        VCSContext context = HgUtils.getCurrentContext(nodes);
        return HgUtils.isFromHgRepository(context);
    }

    @Override
    protected String getBaseName(Node[] nodes) {
        VCSContext ctx = HgUtils.getCurrentContext(nodes);
        Set<File> roots = HgUtils.getRepositoryRoots(ctx);
        return roots.size() == 1 ? "CTL_MenuItem_CloneLocal" : "CTL_MenuItem_CloneRepository";
    }

    @Override
    public String getName(String role, Node[] activatedNodes) {
        VCSContext ctx = HgUtils.getCurrentContext(activatedNodes);
        Set<File> roots = HgUtils.getRepositoryRoots(ctx);
        String name = this.getBaseName(activatedNodes);
        return roots.size() == 1 ? NbBundle.getMessage(CloneAction.class, (String)name, (Object)roots.iterator().next().getName()) : NbBundle.getMessage(CloneAction.class, (String)name);
    }

    @Override
    protected void performContextAction(final Node[] nodes) {
        HgUtils.runIfHgAvailable(new Runnable(){

            @Override
            public void run() {
                Clone clone;
                Utils.logVCSActionEvent((String)"HG");
                VCSContext context = HgUtils.getCurrentContext(nodes);
                File[] roots = HgUtils.getActionRoots(context);
                if (roots == null || roots.length == 0) {
                    return;
                }
                File root = Mercurial.getInstance().getRepositoryRoot(roots[0]);
                File tmp = root.getParentFile();
                File projFile = Utils.getProjectFile((VCSContext)context);
                String folderName = root.getName();
                Boolean projIsRepos = true;
                if (!root.equals(projFile)) {
                    projIsRepos = false;
                }
                for (int i = 0; i < 10000; ++i) {
                    if (new File(tmp, folderName + "_clone" + i).exists()) continue;
                    tmp = new File(tmp, folderName + "_clone" + i);
                    break;
                }
                if (!(clone = new Clone(root, tmp)).showDialog()) {
                    return;
                }
                CloneAction.performClone(new HgURL(root), clone.getTargetDir(), projIsRepos, projFile, true, null, null, true);
            }
        });
    }

    public static RequestProcessor.Task performClone(HgURL source, File target, boolean projIsRepos, File projFile, HgURL pullPath, HgURL pushPath, boolean scanForProjects) {
        return CloneAction.performClone(source, target, projIsRepos, projFile, false, pullPath, pushPath, scanForProjects);
    }

    private static RequestProcessor.Task performClone(final HgURL source, final File target, final boolean projIsRepos, final File projFile, final boolean isLocalClone, final HgURL pullPath, final HgURL pushPath, final boolean scanForProjects) {
        RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(source);
        final HgProgressSupport support = new HgProgressSupport(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void perform() {
                String projName = projFile != null ? HgProjectUtils.getProjectName(projFile) : null;
                OutputLogger logger = this.getLogger();
                try {
                    HgConfigFiles hgConfigFiles;
                    logger.outputInRed(NbBundle.getMessage(CloneAction.class, (String)"MSG_CLONE_TITLE"));
                    logger.outputInRed(NbBundle.getMessage(CloneAction.class, (String)"MSG_CLONE_TITLE_SEP"));
                    List<String> list = HgUtils.runWithoutIndexing(new Callable<List<String>>(){

                        @Override
                        public List<String> call() throws Exception {
                            return HgCommand.doClone(source, target, this.getLogger());
                        }
                    }, target);
                    if (!new File(HgUtils.getHgFolderForRoot(target), "hgrc").canRead() || list.contains("transaction abort!")) {
                        logger.output(list);
                        Mercurial.LOG.log(Level.WARNING, "Hg clone seems to fail: {0}", list);
                        return;
                    }
                    if (list != null && !list.isEmpty()) {
                        HgUtils.createIgnored(target);
                        logger.output(list);
                        if (projName != null) {
                            logger.outputInRed(NbBundle.getMessage(CloneAction.class, (String)"MSG_CLONE_FROM", (Object)projName, (Object)source));
                            logger.outputInRed(NbBundle.getMessage(CloneAction.class, (String)"MSG_CLONE_TO", (Object)projName, (Object)target));
                        } else {
                            logger.outputInRed(NbBundle.getMessage(CloneAction.class, (String)"MSG_EXTERNAL_CLONE_FROM", (Object)source));
                            logger.outputInRed(NbBundle.getMessage(CloneAction.class, (String)"MSG_EXTERNAL_CLONE_TO", (Object)target));
                        }
                        logger.output("");
                        if (isLocalClone) {
                            File cloneProjFile;
                            Mercurial hg = Mercurial.getInstance();
                            ProjectManager projectManager = ProjectManager.getDefault();
                            File normalizedCloneFolder = FileUtil.normalizeFile((File)target);
                            if (!projIsRepos) {
                                String name = projFile != null ? projFile.getAbsolutePath().substring(source.getPath().length() + 1) : target.getAbsolutePath();
                                cloneProjFile = new File(normalizedCloneFolder, name);
                            } else {
                                cloneProjFile = normalizedCloneFolder;
                            }
                            this.openProject(cloneProjFile, projectManager, hg);
                        } else if (scanForProjects) {
                            CloneCompleted cc = new CloneCompleted(target);
                            if (!this.isCanceled()) {
                                cc.scanForProjects(this);
                            }
                        }
                    }
                    if ((hgConfigFiles = new HgConfigFiles(target)).getException() == null) {
                        Utils.logVCSExternalRepository((String)"HG", (String)source.toHgCommandUrlStringWithoutUserInfo());
                        if (source.isKenaiURL()) {
                            this.initializeDefaultPullPushUrlForKenai(hgConfigFiles);
                            String kenaiUserName = this.getKenaiUserName();
                            if (kenaiUserName != null) {
                                hgConfigFiles.setProperty("username", kenaiUserName);
                            }
                        } else {
                            this.initializeDefaultPullPushUrl(hgConfigFiles);
                        }
                    } else {
                        Mercurial.LOG.log(Level.WARNING, "{0}: Cannot set default push and pull path", this.getClass().getName());
                        Mercurial.LOG.log(Level.INFO, null, hgConfigFiles.getException());
                    }
                }
                catch (HgException.HgCommandCanceledException list) {
                }
                catch (HgException ex) {
                    HgUtils.notifyException(ex);
                }
                finally {
                    if (!isLocalClone) {
                        logger.outputInRed(NbBundle.getMessage(CloneAction.class, (String)"MSG_CLONE_DONE"));
                        logger.output("");
                    }
                    source.clearPassword();
                    if (pullPath != null) {
                        pullPath.clearPassword();
                    }
                    if (pushPath != null) {
                        pushPath.clearPassword();
                    }
                }
            }

            private void initializeDefaultPullPushUrl(HgConfigFiles hgConfigFiles) {
                String defaultPull = hgConfigFiles.getDefaultPull(false);
                if (defaultPull == null) {
                    return;
                }
                try {
                    HgURL defaultPullURL = new HgURL(defaultPull);
                    if (pullPath == null && pushPath == null) {
                        hgConfigFiles.setProperty("default-push", defaultPull);
                    } else if (pullPath != null && pushPath == null) {
                        defaultPull = new HgURL(pullPath.toHgCommandUrlStringWithoutUserInfo(), defaultPullURL.getUserInfo(), null).toHgCommandUrlString();
                        hgConfigFiles.setProperty("default-pull", defaultPull);
                        hgConfigFiles.setProperty("default-push", defaultPull);
                    } else if (pullPath == null && pushPath != null) {
                        String defaultPush = new HgURL(pushPath.toHgCommandUrlStringWithoutUserInfo(), defaultPullURL.getUserInfo(), null).toHgCommandUrlString();
                        hgConfigFiles.setProperty("default-push", defaultPush);
                    } else if (pullPath != null && pushPath != null) {
                        defaultPull = new HgURL(pullPath.toHgCommandUrlStringWithoutUserInfo(), defaultPullURL.getUserInfo(), null).toHgCommandUrlString();
                        String defaultPush = new HgURL(pushPath.toHgCommandUrlStringWithoutUserInfo(), defaultPullURL.getUserInfo(), null).toHgCommandUrlString();
                        hgConfigFiles.setProperty("default-pull", defaultPull);
                        hgConfigFiles.setProperty("default-push", defaultPush);
                    }
                }
                catch (URISyntaxException ex) {
                    Mercurial.LOG.log(Level.INFO, null, ex);
                }
            }

            private void initializeDefaultPullPushUrlForKenai(HgConfigFiles hgConfigFiles) {
                if (pullPath == null && pushPath == null) {
                    String defaultPull = hgConfigFiles.getDefaultPull(false);
                    String modifiedPullUrl = HgURL.stripUserInfo(defaultPull);
                    hgConfigFiles.setProperty("default-pull", modifiedPullUrl);
                    hgConfigFiles.setProperty("default-push", modifiedPullUrl);
                } else if (pullPath != null && pushPath == null) {
                    String defaultPull = pullPath.toHgCommandUrlStringWithoutUserInfo();
                    hgConfigFiles.setProperty("default-pull", defaultPull);
                    hgConfigFiles.setProperty("default-push", defaultPull);
                } else if (pullPath == null && pushPath != null) {
                    String defaultPull = hgConfigFiles.getDefaultPull(false);
                    String modifiedPullUrl = HgURL.stripUserInfo(defaultPull);
                    String defaultPush = pushPath.toHgCommandUrlStringWithoutUserInfo();
                    hgConfigFiles.setProperty("default-pull", modifiedPullUrl);
                    hgConfigFiles.setProperty("default-push", defaultPush);
                } else if (pullPath != null && pushPath != null) {
                    String defaultPull = pullPath.toHgCommandUrlStringWithoutUserInfo();
                    String defaultPush = pushPath.toHgCommandUrlStringWithoutUserInfo();
                    hgConfigFiles.setProperty("default-pull", defaultPull);
                    hgConfigFiles.setProperty("default-push", defaultPush);
                }
            }

            private String getKenaiUserName() {
                PasswordAuthentication passwordAuthentication = HgKenaiAccessor.getInstance().getPasswordAuthentication(source.toUrlStringWithoutUserInfo(), false);
                return passwordAuthentication != null ? passwordAuthentication.getUserName() : null;
            }

            private void openProject(final File clonePrjFile, final ProjectManager projectManager, final Mercurial hg) throws MissingResourceException {
                SwingUtilities.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        OutputLogger logger = this.getLogger();
                        try {
                            FileObject cloneProj = FileUtil.toFileObject((File)clonePrjFile);
                            Project prj = null;
                            if (clonePrjFile != null && cloneProj != null) {
                                prj = projectManager.findProject(cloneProj);
                            }
                            if (prj != null) {
                                HgProjectUtils.openProject(prj, this);
                                hg.versionedFilesChanged();
                                hg.refreshAllAnnotations();
                            } else {
                                logger.outputInRed(NbBundle.getMessage(CloneAction.class, (String)"MSG_EXTERNAL_CLONE_PRJ_NOT_FOUND_CANT_SETASMAIN"));
                            }
                        }
                        catch (Exception ex) {
                            HgUtils.notifyException(ex);
                        }
                        finally {
                            logger.outputInRed(NbBundle.getMessage(CloneAction.class, (String)"MSG_CLONE_DONE"));
                            logger.output("");
                        }
                    }
                });
            }
        };
        support.setRepositoryRoot(source);
        support.setCancellableDelegate(new Cancellable(){

            public boolean cancel() {
                if (!Utilities.isWindows()) {
                    return true;
                }
                OutputLogger logger = support.getLogger();
                logger.outputInRed(NbBundle.getMessage(CloneAction.class, (String)"MSG_CLONE_CANCEL_ATTEMPT"));
                JOptionPane.showMessageDialog(Utilities.findDialogParent(), NbBundle.getMessage(CloneAction.class, (String)"MSG_CLONE_CANCEL_NOT_SUPPORTED"), NbBundle.getMessage(CloneAction.class, (String)"MSG_CLONE_CANCEL_NOT_SUPPORTED_TITLE"), 1);
                return false;
            }
        });
        return support.start(rp, source, NbBundle.getMessage(CloneAction.class, (String)"LBL_Clone_Progress", (Object)source));
    }
}

