/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.push;

import java.io.File;
import java.net.URISyntaxException;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.ui.push.PushAction;
import org.netbeans.modules.mercurial.ui.repository.HgURL;
import org.netbeans.modules.mercurial.ui.repository.Repository;
import org.netbeans.modules.mercurial.ui.repository.RepositoryConnection;
import org.netbeans.modules.mercurial.ui.wizards.CloneRepositoryWizardPanel;
import org.netbeans.modules.mercurial.util.HgProjectUtils;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.awt.Mnemonics;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class PushOtherAction
extends ContextAction {
    public static final String ICON_RESOURCE = "org/netbeans/modules/mercurial/resources/icons/push-setting.png";

    public PushOtherAction() {
        super(ICON_RESOURCE);
    }

    @Override
    protected boolean enable(Node[] nodes) {
        Set ctxFiles;
        VCSContext context = HgUtils.getCurrentContext(nodes);
        Set set = ctxFiles = context != null ? context.getRootFiles() : null;
        return HgUtils.isFromHgRepository(context) && ctxFiles != null && ctxFiles.size() != 0;
    }

    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_PushOther";
    }

    protected String iconResource() {
        return ICON_RESOURCE;
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        VCSContext context = HgUtils.getCurrentContext(nodes);
        File[] roots = HgUtils.getActionRoots(context);
        if (roots == null || roots.length == 0) {
            return;
        }
        File root = Mercurial.getInstance().getRepositoryRoot(roots[0]);
        int repositoryModeMask = 100;
        String title = NbBundle.getMessage(CloneRepositoryWizardPanel.class, (String)"CTL_Repository_Location");
        final JButton pushButton = new JButton();
        final Repository repository = new Repository(repositoryModeMask, title, true, root);
        repository.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                pushButton.setEnabled(repository.isValid());
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)pushButton, (String)NbBundle.getMessage(PushOtherAction.class, (String)"CTL_Push_Action_Push"));
        pushButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PushOtherAction.class, (String)"ACSD_Push_Action_Push"));
        pushButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PushOtherAction.class, (String)"ACSN_Push_Action_Push"));
        JButton cancelButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)cancelButton, (String)NbBundle.getMessage(PushOtherAction.class, (String)"CTL_Push_Action_Cancel"));
        cancelButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PushOtherAction.class, (String)"ACSD_Push_Action_Cancel"));
        cancelButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PushOtherAction.class, (String)"ACSN_Push_Action_Cancel"));
        pushButton.setEnabled(false);
        Object option = repository.show(NbBundle.getMessage(PushOtherAction.class, (String)"CTL_PushDialog_Title"), new HelpCtx(PushOtherAction.class), new Object[]{pushButton, cancelButton}, true, "hg.push.dialog");
        if (option == pushButton) {
            HgURL pushPath;
            try {
                pushPath = repository.getUrl();
            }
            catch (URISyntaxException ex) {
                Mercurial.LOG.log(Level.SEVERE, ((Object)((Object)this)).getClass().getName() + ": Could not push because of invalid URI." + repository.getUrlString());
                Mercurial.LOG.log(Level.SEVERE, ((Object)((Object)this)).getClass().getName() + ": Invalid URI: " + repository.getUrlString());
                return;
            }
            PushOtherAction.push(context, root, pushPath, repository.getRepositoryConnection());
        }
    }

    private static void push(VCSContext ctx, final File root, final HgURL pushPath, final RepositoryConnection rc) {
        if (root == null || pushPath == null) {
            return;
        }
        final String fromPrjName = HgProjectUtils.getProjectName(root);
        final String toPrjName = NbBundle.getMessage(PushAction.class, (String)"MSG_EXTERNAL_REPOSITORY");
        RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(root);
        HgProgressSupport support = new HgProgressSupport(){

            @Override
            public void perform() {
                if (rc != null) {
                    HgModuleConfig.getDefault().insertRecentUrl(rc);
                }
                PushAction.performPush(root, pushPath, fromPrjName, toPrjName, null, null, this.getLogger(), false);
            }
        };
        support.start(rp, root, NbBundle.getMessage(PushAction.class, (String)"MSG_PUSH_PROGRESS"));
    }
}

