/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial;

import java.util.logging.Level;
import javax.swing.JButton;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.Mercurial;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class ExceptionHandler {
    public static final int EX_UNKNOWN = 0;
    public static final int EX_ACTION_CANCELED_BY_USER = 2;
    public static final int EX_NO_REPOSITORY = 4;
    public static final int EX_ALREADY_TRACKED = 8;
    public static final int EX_NOT_TRACKED = 16;
    public static final int EX_CANNOT_READ_COMMIT_MSG = 32;
    public static final int EX_UNABLE_EXECUTE_CMD = 64;
    static final String ACTION_CANCELED_BY_USER = NbBundle.getMessage(ExceptionHandler.class, (String)"MSG_ActionCanceledByUser");
    private final HgException exception;
    private final int exceptionMask;

    public ExceptionHandler(HgException exception) {
        this.exception = exception;
        this.exceptionMask = ExceptionHandler.getMask(exception.getMessage());
    }

    protected int getExceptionMask() {
        return this.exceptionMask;
    }

    protected HgException getException() {
        return this.exception;
    }

    private static int getMask(String msg) {
        if (msg == null || msg.trim().equals("")) {
            return 0;
        }
        if (ExceptionHandler.isCancelledAction(msg = msg.toLowerCase())) {
            return 2;
        }
        if (ExceptionHandler.isNoRepository(msg)) {
            return 4;
        }
        if (ExceptionHandler.isNotTracked(msg)) {
            return 16;
        }
        if (ExceptionHandler.isCannotReadCommitMsg(msg)) {
            return 32;
        }
        if (ExceptionHandler.isUnableExecuteCmd(msg)) {
            return 64;
        }
        if (ExceptionHandler.isAlreadyTracked(msg)) {
            return 8;
        }
        return 0;
    }

    private static boolean isCancelledAction(String msg) {
        return msg.equals(ACTION_CANCELED_BY_USER);
    }

    public static boolean isNoRepository(String msg) {
        return (msg = msg.toLowerCase()).indexOf("abort: There is no Mercurial repository here") > -1;
    }

    public static boolean isUpdateSpansBranches(String msg) {
        return (msg = msg.toLowerCase()).indexOf("abort: update spans branches") > -1;
    }

    public static boolean isAlreadyTracked(String msg) {
        return msg.indexOf(" already tracked!") > -1;
    }

    public static boolean isNotTracked(String msg) {
        return msg.indexOf(" not tracked!") > -1;
    }

    public static boolean isCannotReadCommitMsg(String msg) {
        return msg.indexOf("abort: can't read commit message") > -1;
    }

    public static boolean isUnableExecuteCmd(String msg) {
        return msg.indexOf("unable to execute hg command") > -1;
    }

    public static boolean isUnableClone(String msg) {
        return msg.indexOf("abort: destination ") > -1;
    }

    public static boolean isNotFound(String msg) {
        return msg.indexOf("not found!") > -1;
    }

    public static boolean isNoChangeNeeded(String msg) {
        return msg.indexOf("no change needed") > -1;
    }

    public void notifyException() {
        if (ExceptionHandler.isCancelledAction(this.exception.getMessage())) {
            this.cancelledAction();
            return;
        }
        Mercurial.LOG.log(Level.INFO, null, this.exception);
    }

    public void notifyException(boolean notCanceled) {
        if (!notCanceled) {
            this.cancelledAction();
            return;
        }
        Mercurial.LOG.log(Level.INFO, null, this.exception);
    }

    public static String parseExceptionMessage(HgException exception) {
        String msg = exception.getMessage();
        int idx = msg.lastIndexOf("hg: ");
        if (idx > -1) {
            msg = msg.substring(idx);
        }
        return msg;
    }

    private void cancelledAction() {
        JButton ok = new JButton(NbBundle.getMessage(ExceptionHandler.class, (String)"CTL_Action_OK"));
        NotifyDescriptor descriptor = new NotifyDescriptor((Object)ACTION_CANCELED_BY_USER, NbBundle.getMessage(ExceptionHandler.class, (String)"CTL_ActionCanceled_Title"), -1, 2, new Object[]{ok}, (Object)ok);
        DialogDisplayer.getDefault().notify(descriptor);
    }
}

