/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.problems;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.plugin.PluginArtifactsCache;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.problem.ProblemReport;
import org.netbeans.modules.maven.api.problem.ProblemReporter;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.problems.BatchProblemNotifier;
import org.netbeans.modules.maven.problems.Bundle;
import org.netbeans.spi.project.ui.ProjectProblemResolver;
import org.netbeans.spi.project.ui.ProjectProblemsProvider;
import org.openide.cookies.EditCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.RequestProcessor;

public final class ProblemReporterImpl
implements ProblemReporter,
Comparator<ProblemReport>,
ProjectProblemsProvider {
    private static final Logger LOG = Logger.getLogger(ProblemReporterImpl.class.getName());
    public static final RequestProcessor RP = new RequestProcessor(ProblemReporterImpl.class);
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private final Set<ProblemReport> reports;
    private final Set<File> missingArtifacts;
    private final File projectPOMFile;
    private final RequestProcessor.Task reloadTask = RP.create(new Runnable(){

        @Override
        public void run() {
            LOG.log(Level.FINE, "actually reloading {0}", ProblemReporterImpl.this.projectPOMFile);
            ProblemReporterImpl.this.nbproject.fireProjectReload(true);
        }
    });
    private final FileChangeListener fcl = new FileChangeAdapter(){

        public void fileDataCreated(FileEvent fe) {
            LOG.log(Level.FINE, "due to {0} scheduling reload of {1}", new Object[]{fe.getFile(), ProblemReporterImpl.this.projectPOMFile});
            ProblemReporterImpl.this.reloadTask.schedule(1000);
            File f = FileUtil.toFile((FileObject)fe.getFile());
            if (f != null) {
                BatchProblemNotifier.resolved(f);
            } else {
                LOG.log(Level.FINE, "no java.io.File from {0}", fe);
            }
        }
    };
    private final NbMavenProjectImpl nbproject;
    private final PropertyChangeSupport chs = new PropertyChangeSupport(this);
    public static final String ACT_START_MESSAGE = "START_MESSAGE";

    public ProblemReporterImpl(NbMavenProjectImpl proj) {
        this.reports = new TreeSet<ProblemReport>(this);
        this.missingArtifacts = new HashSet<File>();
        this.nbproject = proj;
        this.projectPOMFile = this.nbproject.getPOMFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener list) {
        List<ChangeListener> list2 = this.listeners;
        synchronized (list2) {
            this.listeners.add(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener list) {
        List<ChangeListener> list2 = this.listeners;
        synchronized (list2) {
            this.listeners.remove(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addReport(ProblemReport report) {
        assert (report != null);
        Set<ProblemReport> set = this.reports;
        synchronized (set) {
            this.reports.add(report);
        }
        this.fireChange();
        this.firePropertyChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addReports(ProblemReport[] report) {
        assert (report != null);
        Set<ProblemReport> set = this.reports;
        synchronized (set) {
            for (int i = 0; i < report.length; ++i) {
                assert (report[i] != null);
                this.reports.add(report[i]);
            }
        }
        this.fireChange();
        this.firePropertyChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeReport(ProblemReport report) {
        Set<ProblemReport> set = this.reports;
        synchronized (set) {
            this.reports.remove(report);
        }
        this.fireChange();
        this.firePropertyChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        ArrayList<ChangeListener> list;
        List<ChangeListener> list2 = this.listeners;
        synchronized (list2) {
            list = new ArrayList<ChangeListener>(this.listeners);
        }
        for (ChangeListener li : list) {
            li.stateChanged(new ChangeEvent(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBroken() {
        Set<ProblemReport> set = this.reports;
        synchronized (set) {
            for (ProblemReport report : this.reports) {
                if (report.getSeverityLevel() >= 10) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ProblemReport> getReports() {
        Set<ProblemReport> set = this.reports;
        synchronized (set) {
            return new ArrayList<ProblemReport>(this.reports);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addMissingArtifact(Artifact a, boolean checkMissing) {
        Set<ProblemReport> set = this.reports;
        synchronized (set) {
            a = EmbedderFactory.getProjectEmbedder().getLocalRepository().find(a);
            File f = FileUtil.normalizeFile((File)a.getFile());
            if (f.exists() && f.canRead() && checkMissing) {
                try {
                    MavenExecutionRequest rq = EmbedderFactory.getProjectEmbedder().createMavenExecutionRequest();
                    List repos = this.nbproject.getOriginalMavenProject().getRemoteArtifactRepositories();
                    if (repos.isEmpty()) {
                        repos = rq.getRemoteRepositories();
                    }
                    EmbedderFactory.getProjectEmbedder().resolveArtifact(a, repos, EmbedderFactory.getProjectEmbedder().getLocalRepository());
                }
                catch (ArtifactNotFoundException | ArtifactResolutionException ex) {
                    return;
                }
                throw new ArtifactFoundException(a, f);
            }
            if (this.missingArtifacts.add(f)) {
                LOG.log(Level.FINE, "listening to {0} from {1}", new Object[]{f, this.projectPOMFile});
                FileUtil.addFileChangeListener((FileChangeListener)this.fcl, (File)f);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<File> getMissingArtifactFiles() {
        Set<ProblemReport> set = this.reports;
        synchronized (set) {
            return new TreeSet<File>(this.missingArtifacts);
        }
    }

    public boolean hasReportWithId(String id) {
        return this.getReportWithId(id) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProblemReport getReportWithId(String id) {
        assert (id != null);
        Set<ProblemReport> set = this.reports;
        synchronized (set) {
            for (ProblemReport rep : this.reports) {
                if (!id.equals(rep.getId())) continue;
                return rep;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearReports() {
        boolean hasAny;
        Set<ProblemReport> set = this.reports;
        synchronized (set) {
            hasAny = !this.reports.isEmpty();
            this.reports.clear();
            Iterator<File> as = this.missingArtifacts.iterator();
            while (as.hasNext()) {
                File f = as.next();
                if (f != null) {
                    LOG.log(Level.FINE, "ceasing to listen to {0} from {1}", new Object[]{f, this.projectPOMFile});
                    FileUtil.removeFileChangeListener((FileChangeListener)this.fcl, (File)f);
                    if (f.isFile()) {
                        BatchProblemNotifier.resolved(f);
                    }
                }
                as.remove();
            }
            this.missingArtifacts.clear();
        }
        if (hasAny) {
            this.fireChange();
            this.firePropertyChange();
        }
        ((PluginArtifactsCache)EmbedderFactory.getProjectEmbedder().lookupComponent(PluginArtifactsCache.class)).flush();
    }

    @Override
    public int compare(ProblemReport o1, ProblemReport o2) {
        int ret = o1.getSeverityLevel() - o2.getSeverityLevel();
        if (ret != 0) {
            return ret;
        }
        return o1.hashCode() - o2.hashCode();
    }

    public static Action createOpenFileAction(FileObject fo) {
        return new OpenActions(fo);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.chs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.chs.removePropertyChangeListener(listener);
    }

    public Collection<? extends ProjectProblemsProvider.ProjectProblem> getProblems() {
        ArrayList<ProjectProblemsProvider.ProjectProblem> toRet = new ArrayList<ProjectProblemsProvider.ProjectProblem>();
        for (ProblemReport pr : this.getReports()) {
            MavenProblemResolver res = new MavenProblemResolver(pr.getCorrectiveAction(), pr.getId() + "|" + this.nbproject.getPOMFile());
            ProjectProblemsProvider.ProjectProblem pp = pr.getSeverityLevel() == 0 ? ProjectProblemsProvider.ProjectProblem.createError((String)pr.getShortDescription(), (String)pr.getLongDescription(), (ProjectProblemResolver)res) : ProjectProblemsProvider.ProjectProblem.createWarning((String)pr.getShortDescription(), (String)pr.getLongDescription(), (ProjectProblemResolver)res);
            toRet.add(pp);
        }
        return toRet;
    }

    private void firePropertyChange() {
        this.chs.firePropertyChange("problems", null, null);
    }

    public static class ArtifactFoundException
    extends IllegalStateException {
        private final Artifact artifact;
        private final File artifactFile;

        public ArtifactFoundException(Artifact artifact, File artifactFile) {
            this.artifact = artifact;
            this.artifactFile = artifactFile;
        }
    }

    private static class OpenActions
    extends AbstractAction {
        private final FileObject fo;

        OpenActions(FileObject file) {
            this.putValue("Name", Bundle.TXT_OPEN_FILE());
            this.putValue(ProblemReporterImpl.ACT_START_MESSAGE, Bundle.ACT_OPEN_FILE_START());
            this.fo = file;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.fo != null) {
                try {
                    DataObject dobj = DataObject.find((FileObject)this.fo);
                    EditCookie edit = (EditCookie)dobj.getLookup().lookup(EditCookie.class);
                    edit.edit();
                }
                catch (DataObjectNotFoundException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public static class MavenProblemResolver
    implements ProjectProblemResolver {
        private final Action action;
        private final String id;

        public MavenProblemResolver(Action correctiveAction, String id) {
            this.action = correctiveAction;
            this.id = id;
        }

        public Future<ProjectProblemsProvider.Result> resolve() {
            FutureTask<ProjectProblemsProvider.Result> toRet = new FutureTask<ProjectProblemsProvider.Result>(new Callable<ProjectProblemsProvider.Result>(){

                @Override
                public ProjectProblemsProvider.Result call() throws Exception {
                    if (action != null) {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                action.actionPerformed(null);
                            }
                        });
                        String text = (String)action.getValue(ProblemReporterImpl.ACT_START_MESSAGE);
                        if (text != null) {
                            return ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.RESOLVED, (String)text);
                        }
                        return ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.RESOLVED);
                    }
                    return ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.UNRESOLVED, (String)Bundle.TXT_No_Res());
                }
            });
            RP.post(toRet);
            return toRet;
        }

        public int hashCode() {
            int hash = 7;
            hash = 11 * hash + (this.id != null ? this.id.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MavenProblemResolver other = (MavenProblemResolver)obj;
            return !(this.id == null ? other.id != null : !this.id.equals(other.id));
        }
    }
}

