/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.queries;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.codehaus.plexus.PlexusContainerException;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.embedder.DependencyTreeFactory;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.embedder.MavenEmbedder;
import org.netbeans.modules.maven.queries.Bundle;
import org.netbeans.modules.maven.queries.MavenDependencyResult;
import org.netbeans.modules.project.dependency.ArtifactSpec;
import org.netbeans.modules.project.dependency.Dependency;
import org.netbeans.modules.project.dependency.DependencyResult;
import org.netbeans.modules.project.dependency.ProjectDependencies;
import org.netbeans.modules.project.dependency.ProjectOperationException;
import org.netbeans.modules.project.dependency.Scope;
import org.netbeans.modules.project.dependency.Scopes;
import org.netbeans.modules.project.dependency.spi.ProjectDependenciesImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class MavenDependenciesImplementation
implements ProjectDependenciesImplementation {
    private static final String ELEMENT_PATH = "path";
    private static final String ELEMENT_PROCESSOR_PATHS = "annotationProcessorPaths";
    private static final Logger LOG = Logger.getLogger(MavenDependenciesImplementation.class.getName());
    private final Project project;
    private NbMavenProject nbMavenProject;
    private static final Set<Scope> SCOPES = new HashSet<Scope>();
    static final Map<Scope, String> scope2Maven;
    static final Map<String, Scope> maven2Scope;
    static final Map<Scope, Collection<Scope>> directScopes;
    static final Map<Scope, Collection<Scope>> impliedScopes;
    static final Map<Scope, Collection<Scope>> reverseImplied;

    public MavenDependenciesImplementation(Project project) {
        this.project = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        MavenDependenciesImplementation mavenDependenciesImplementation = this;
        synchronized (mavenDependenciesImplementation) {
            if (this.nbMavenProject != null) {
                return;
            }
            this.nbMavenProject = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
        }
    }

    static String mavenScope(Scope s) {
        return scope2Maven.getOrDefault(s, "compile");
    }

    private ArtifactSpec mavenToArtifactSpec(Artifact a) {
        FileObject f = a.getFile() == null ? null : FileUtil.toFileObject((File)a.getFile());
        String v = a.getVersion();
        if ("".equals(v)) {
            v = null;
        }
        if (a.isSnapshot()) {
            return ArtifactSpec.createSnapshotSpec((String)a.getGroupId(), (String)a.getArtifactId(), (String)a.getType(), (String)a.getClassifier(), (String)v, (boolean)a.isOptional(), (FileObject)f, (Object)a);
        }
        return ArtifactSpec.createVersionSpec((String)a.getGroupId(), (String)a.getArtifactId(), (String)a.getType(), (String)a.getClassifier(), (String)v, (boolean)a.isOptional(), (FileObject)f, (Object)a);
    }

    private DependencyResult findDeclaredDependencies(ProjectDependencies.DependencyQuery query, MavenEmbedder embedder) {
        MavenProject proj;
        NbMavenProjectImpl impl = (NbMavenProjectImpl)this.project.getLookup().lookup(NbMavenProjectImpl.class);
        try {
            proj = impl.getFreshOriginalMavenProject().get();
        }
        catch (InterruptedException | CancellationException | ExecutionException ex) {
            throw new ProjectOperationException(this.project, ProjectOperationException.State.ERROR, "Unexpected exception", (Throwable)ex);
        }
        ArrayList<org.netbeans.modules.project.dependency.Dependency> children = new ArrayList<org.netbeans.modules.project.dependency.Dependency>();
        for (Dependency d : proj.getDependencies()) {
            Scope s;
            String aId = d.getArtifactId();
            String gID = d.getGroupId();
            String scope = d.getScope();
            String classsifier = d.getClassifier();
            String type = d.getType();
            String version = d.getVersion();
            ArtifactSpec a = version != null && version.endsWith("-SNAPSHOT") ? ArtifactSpec.createSnapshotSpec((String)gID, (String)aId, (String)type, (String)classsifier, (String)version, (boolean)d.isOptional(), d.getSystemPath() == null ? null : FileUtil.toFileObject((File)new File(d.getSystemPath(), aId)), (Object)d) : ArtifactSpec.createVersionSpec((String)gID, (String)aId, (String)type, (String)classsifier, (String)version, (boolean)d.isOptional(), d.getSystemPath() == null ? null : FileUtil.toFileObject((File)new File(d.getSystemPath(), aId)), (Object)d);
            Scope scope2 = s = scope == null ? Scopes.COMPILE : maven2Scope.get(scope);
            if (s == null) {
                s = Scopes.COMPILE;
            }
            org.netbeans.modules.project.dependency.Dependency dep = org.netbeans.modules.project.dependency.Dependency.create((ArtifactSpec)a, (Scope)s, Collections.emptyList(), (Object)d);
            children.add(dep);
        }
        PluginPropertyUtils.PluginConfigPathParams params = new PluginPropertyUtils.PluginConfigPathParams("org.apache.maven.plugins", "maven-compiler-plugin", ELEMENT_PROCESSOR_PATHS, ELEMENT_PATH);
        List<Artifact> arts = PluginPropertyUtils.getPluginPathProperty(this.project, params, false, null);
        if (arts != null) {
            for (Artifact a : arts) {
                ArtifactSpec ann = this.mavenToArtifactSpec(a);
                org.netbeans.modules.project.dependency.Dependency annDep = org.netbeans.modules.project.dependency.Dependency.create((ArtifactSpec)ann, (Scope)Scopes.PROCESS, Collections.emptyList(), (Object)ann);
                children.add(annDep);
            }
        }
        ArtifactSpec prjSpec = this.mavenToArtifactSpec(proj.getArtifact());
        org.netbeans.modules.project.dependency.Dependency root = org.netbeans.modules.project.dependency.Dependency.create((ArtifactSpec)prjSpec, (Scope)Scopes.DECLARED, children, (Object)proj);
        return new MavenDependencyResult(proj, root, query.getScopes(), Collections.emptyList(), this.project, impl.getProjectWatcher());
    }

    static Collection<Scope> implies(Scope s) {
        return impliedScopes.getOrDefault(s, Collections.emptyList());
    }

    static Collection<Scope> impliedBy(Scope s) {
        return reverseImplied.getOrDefault(s, Collections.emptyList());
    }

    public DependencyResult findDependencies(ProjectDependencies.DependencyQuery query) {
        DependencyNode n;
        MavenEmbedder embedder;
        this.init();
        Set scopes = query.getScopes();
        final Dependency.Filter filter = query.getFilter();
        MavenProject mp = this.nbMavenProject.getMavenProject();
        if (NbMavenProject.isErrorPlaceholder(mp)) {
            if (this.nbMavenProject.isMavenProjectLoaded()) {
                throw new ProjectOperationException(this.project, ProjectOperationException.State.BROKEN, Bundle.ERR_DependencyOnBrokenProject());
            }
            throw new ProjectOperationException(this.project, ProjectOperationException.State.UNINITIALIZED, Bundle.ERR_DependencyNotPrimed());
        }
        if (query.isOffline()) {
            try {
                if (query.isFlushChaches()) {
                    embedder = EmbedderFactory.createProjectLikeEmbedder();
                }
                embedder = EmbedderFactory.getProjectEmbedder();
            }
            catch (PlexusContainerException ex) {
                throw new ProjectOperationException(this.project, ProjectOperationException.State.ERROR, Bundle.ERR_DependencyGraphError(), ex.getCause());
            }
        } else {
            try {
                embedder = EmbedderFactory.getOnlineEmbedder();
            }
            catch (IllegalStateException ex) {
                throw new ProjectOperationException(this.project, ProjectOperationException.State.ERROR, Bundle.ERR_DependencyGraphError(), ex.getCause());
            }
        }
        if (query.getScopes().contains(Scopes.DECLARED)) {
            return this.findDeclaredDependencies(query, embedder);
        }
        Collection mavenScopes = scopes.stream().map(MavenDependenciesImplementation::mavenScope).filter(Objects::nonNull).collect(Collectors.toList());
        try {
            n = DependencyTreeFactory.createDependencyTree((MavenProject)mp, (MavenEmbedder)embedder, (Collection)mavenScopes);
        }
        catch (MavenExecutionException ex) {
            throw new ProjectOperationException(this.project, ProjectOperationException.State.OK, Bundle.ERR_DependencyGraphError(), ex.getCause());
        }
        catch (AssertionError e) {
            if (EmbedderFactory.isOfflineException((Throwable)((Object)e))) {
                throw new ProjectOperationException(this.project, ProjectOperationException.State.OFFLINE, Bundle.ERR_DependencyGraphOffline());
            }
            throw e;
        }
        final Set allScopes = Stream.concat(scopes.stream(), scopes.stream().flatMap(x -> MavenDependenciesImplementation.impliedBy(x).stream())).collect(Collectors.toSet());
        Dependency.Filter compositeFiter = new Dependency.Filter(){

            public boolean accept(Scope s, ArtifactSpec a) {
                return allScopes.contains(s) && (filter == null || filter.accept(s, a));
            }
        };
        Converter c = new Converter(compositeFiter);
        if (scopes.contains(Scopes.PROCESS)) {
            PluginPropertyUtils.PluginConfigPathParams params = new PluginPropertyUtils.PluginConfigPathParams("org.apache.maven.plugins", "maven-compiler-plugin", ELEMENT_PROCESSOR_PATHS, ELEMENT_PATH);
            List<Object> arts = PluginPropertyUtils.getPluginPathProperty(this.project, params, true, null);
            if (arts == null) {
                arts = Collections.emptyList();
            }
            c.annotationProcessors = arts;
        }
        org.netbeans.modules.project.dependency.Dependency root = c.convertDependencies(n);
        return new MavenDependencyResult(this.nbMavenProject.getMavenProject(), root, new ArrayList<Scope>(scopes), c.broken, this.project, this.nbMavenProject);
    }

    static Scope scope(Artifact a) {
        String as = a.getScope();
        if (as == null) {
            return Scopes.COMPILE;
        }
        switch (as) {
            case "compile": {
                return Scopes.COMPILE;
            }
            case "runtime": 
            case "compile+runtime": 
            case "runtime+system": {
                return Scopes.RUNTIME;
            }
            case "import": 
            case "system": {
                return Scopes.EXTERNAL;
            }
            case "test": {
                return Scopes.TEST;
            }
        }
        return Scopes.COMPILE;
    }

    private static String getFullArtifactId(Artifact a) {
        if (a.getDependencyTrail() == null) {
            return "/" + a.getId();
        }
        return String.join((CharSequence)"/", a.getDependencyTrail()) + "/" + a.getId();
    }

    static boolean dependencyEquals(org.netbeans.modules.project.dependency.Dependency dspec, Dependency mavenD) {
        ArtifactSpec spec = dspec.getArtifact();
        String mavenClass = mavenD.getClassifier();
        if ("".equals(mavenClass)) {
            mavenClass = null;
        }
        if (!(Objects.equals(spec.getGroupId(), mavenD.getGroupId()) && Objects.equals(spec.getArtifactId(), mavenD.getArtifactId()) && Objects.equals(spec.getClassifier(), mavenClass) && Objects.equals(spec.getVersionSpec(), mavenD.getVersion()))) {
            return false;
        }
        if (spec.getType() != null && !Objects.equals(spec.getType(), mavenD.getType())) {
            return false;
        }
        return dspec.getScope() == null || Objects.equals(MavenDependenciesImplementation.mavenScope(dspec.getScope()), mavenD.getScope());
    }

    static boolean artifactEquals(ArtifactSpec spec, Artifact mavenA) {
        String mavenClass = mavenA.getClassifier();
        if ("".equals(mavenClass)) {
            mavenClass = null;
        }
        if (!(Objects.equals(spec.getGroupId(), mavenA.getGroupId()) && Objects.equals(spec.getArtifactId(), mavenA.getArtifactId()) && Objects.equals(spec.getClassifier(), mavenClass) && Objects.equals(spec.getVersionSpec(), mavenA.getVersion()))) {
            return false;
        }
        return spec.getType() == null || Objects.equals(spec.getType(), mavenA.getType());
    }

    static {
        SCOPES.add(Scopes.COMPILE);
        SCOPES.add(Scopes.RUNTIME);
        SCOPES.add(Scopes.EXTERNAL);
        SCOPES.add(Scopes.TEST);
        scope2Maven = new HashMap<Scope, String>();
        maven2Scope = new HashMap<String, Scope>();
        directScopes = new HashMap<Scope, Collection<Scope>>();
        impliedScopes = new HashMap<Scope, Collection<Scope>>();
        reverseImplied = new HashMap<Scope, Collection<Scope>>();
        scope2Maven.put(Scopes.PROCESS, "compile");
        scope2Maven.put(Scopes.COMPILE, "compile");
        scope2Maven.put(Scopes.RUNTIME, "runtime");
        scope2Maven.put(Scopes.TEST, "test");
        scope2Maven.put(Scopes.EXTERNAL, "provided");
        maven2Scope.put("compile", Scopes.COMPILE);
        maven2Scope.put("runtime", Scopes.RUNTIME);
        maven2Scope.put("test", Scopes.TEST);
        maven2Scope.put("provided", Scopes.EXTERNAL);
        directScopes.put(Scopes.API, Arrays.asList(Scopes.COMPILE));
        directScopes.put(Scopes.PROCESS, Arrays.asList(Scopes.COMPILE));
        directScopes.put(Scopes.EXTERNAL, Arrays.asList(Scopes.COMPILE));
        directScopes.put(Scopes.COMPILE, Arrays.asList(Scopes.RUNTIME, Scopes.TEST));
        directScopes.put(Scopes.RUNTIME, Arrays.asList(Scopes.TEST));
        impliedScopes.put(Scopes.API, Arrays.asList(Scopes.COMPILE, Scopes.RUNTIME, Scopes.TEST));
        impliedScopes.put(Scopes.PROCESS, Arrays.asList(Scopes.COMPILE, Scopes.RUNTIME, Scopes.TEST));
        impliedScopes.put(Scopes.EXTERNAL, Arrays.asList(Scopes.COMPILE, Scopes.RUNTIME, Scopes.TEST));
        impliedScopes.put(Scopes.COMPILE, Arrays.asList(Scopes.RUNTIME, Scopes.TEST));
        impliedScopes.put(Scopes.RUNTIME, Arrays.asList(Scopes.TEST));
        reverseImplied.put(Scopes.TEST, Arrays.asList(Scopes.RUNTIME, Scopes.COMPILE, Scopes.API, Scopes.EXTERNAL, Scopes.PROCESS));
        reverseImplied.put(Scopes.RUNTIME, Arrays.asList(Scopes.COMPILE, Scopes.API, Scopes.EXTERNAL, Scopes.PROCESS));
        reverseImplied.put(Scopes.COMPILE, Arrays.asList(Scopes.API, Scopes.EXTERNAL, Scopes.PROCESS));
    }

    private class Converter {
        final Map<String, List<DependencyNode>> realNodes = new HashMap<String, List<DependencyNode>>();
        final Dependency.Filter filter;
        final Set<ArtifactSpec> broken = new HashSet<ArtifactSpec>();
        List<Artifact> annotationProcessors = Collections.emptyList();

        public Converter(Dependency.Filter filter) {
            this.filter = filter;
        }

        private void findRealNodes(DependencyNode n) {
            if (n.getArtifact() == null) {
                return;
            }
            Artifact a = n.getArtifact();
            if (n.getState() != 0) {
                return;
            }
            this.realNodes.putIfAbsent(a.getId(), n.getChildren());
            this.realNodes.put(MavenDependenciesImplementation.getFullArtifactId(a), n.getChildren());
            for (DependencyNode c : n.getChildren()) {
                this.findRealNodes(c);
            }
        }

        private org.netbeans.modules.project.dependency.Dependency convertDependencies(DependencyNode n) {
            this.findRealNodes(n);
            return this.convert2(true, n, new HashSet<ArtifactSpec>());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private org.netbeans.modules.project.dependency.Dependency convert2(boolean root, DependencyNode n, Set<ArtifactSpec> visited) {
            ArrayList<org.netbeans.modules.project.dependency.Dependency> ch = new ArrayList<org.netbeans.modules.project.dependency.Dependency>();
            ArtifactSpec currentArtifact = MavenDependenciesImplementation.this.mavenToArtifactSpec(n.getArtifact());
            if (!visited.add(currentArtifact)) {
                return null;
            }
            List<DependencyNode> children = n.getChildren();
            Artifact thisArtifact = n.getArtifact();
            Artifact relatedArtifact = n.getRelatedArtifact();
            switch (n.getState()) {
                case 1: 
                case 3: {
                    if (relatedArtifact != null) {
                        children = this.realNodes.get(MavenDependenciesImplementation.getFullArtifactId(relatedArtifact));
                    }
                    if (children != null) break;
                    children = this.realNodes.getOrDefault(n.getArtifact().getId(), n.getChildren());
                    break;
                }
                case 2: {
                    if (relatedArtifact != null) {
                        if (Objects.equals(relatedArtifact.getGroupId(), thisArtifact.getGroupId()) && Objects.equals(relatedArtifact.getArtifactId(), thisArtifact.getArtifactId())) {
                            thisArtifact = relatedArtifact;
                            children = this.realNodes.getOrDefault(relatedArtifact.getId(), n.getChildren());
                            break;
                        }
                        return null;
                    }
                    return null;
                }
            }
            try {
                org.netbeans.modules.project.dependency.Dependency dependency;
                if (root && !this.annotationProcessors.isEmpty()) {
                    for (Artifact a : this.annotationProcessors) {
                        ArtifactSpec annoSpec = MavenDependenciesImplementation.this.mavenToArtifactSpec(a);
                        ch.add(org.netbeans.modules.project.dependency.Dependency.create((ArtifactSpec)annoSpec, (Scope)Scopes.PROCESS, Collections.emptyList(), (Object)annoSpec));
                    }
                }
                for (DependencyNode c : children) {
                    org.netbeans.modules.project.dependency.Dependency cd = this.convert2(false, c, visited);
                    if (cd == null) continue;
                    ch.add(cd);
                }
                ArtifactSpec aspec = MavenDependenciesImplementation.this.mavenToArtifactSpec(thisArtifact);
                if (aspec.getLocalFile() == null) {
                    this.broken.add(aspec);
                }
                Scope s = MavenDependenciesImplementation.scope(thisArtifact);
                if (!root && !this.filter.accept(s, aspec)) {
                    dependency = null;
                    return dependency;
                }
                dependency = org.netbeans.modules.project.dependency.Dependency.create((ArtifactSpec)aspec, (Scope)s, ch, (Object)n);
                return dependency;
            }
            finally {
                visited.remove(currentArtifact);
            }
        }
    }
}

