/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.customizer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.plaf.UIResource;
import javax.xml.namespace.QName;
import org.apache.maven.model.InputLocation;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.PlatformsCustomizer;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.java.source.BuildArtifactMapper;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.ModelUtils;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.api.customizer.ModelHandle2;
import org.netbeans.modules.maven.api.customizer.support.CheckBoxUpdater;
import org.netbeans.modules.maven.api.customizer.support.ComboBoxUpdater;
import org.netbeans.modules.maven.classpath.BootClassPathImpl;
import org.netbeans.modules.maven.customizer.Bundle;
import org.netbeans.modules.maven.customizer.CustomizerProviderImpl;
import org.netbeans.modules.maven.customizer.MavenProjectPropertiesUiSupport;
import org.netbeans.modules.maven.customizer.WarnPanel;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.pom.Build;
import org.netbeans.modules.maven.model.pom.Configuration;
import org.netbeans.modules.maven.model.pom.POMComponent;
import org.netbeans.modules.maven.model.pom.POMExtensibilityElement;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Plugin;
import org.netbeans.modules.maven.options.DontShowAgainSettings;
import org.netbeans.modules.maven.options.MavenVersionSettings;
import org.netbeans.spi.project.AuxiliaryProperties;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Pair;
import org.openide.util.Union2;
import org.openide.util.WeakListeners;

public class CompilePanel
extends JPanel
implements HelpCtx.Provider {
    private static final Logger LOG = Logger.getLogger(CompilePanel.class.getName());
    private final ModelHandle2 handle;
    private final Project project;
    private static boolean warningShown = false;
    private JButton btnMngPlatform;
    private JCheckBox cbCompileOnSave;
    private JCheckBox cbDebug;
    private JCheckBox cbLint;
    private JComboBox comJavaPlatform;
    private JComboBox<String> comSourceLevel;
    private JLabel lblHint1;
    private JLabel lblHint2;
    private JLabel lblJavaPlatform;
    private JLabel lblJavaPlatform1;
    private final Map<String, CompilerParamOperation> operations = new HashMap<String, CompilerParamOperation>();

    public CompilePanel(ModelHandle2 handle, Project prj, MavenProjectPropertiesUiSupport uiSupport) {
        this.initComponents();
        this.handle = handle;
        this.project = prj;
        this.comJavaPlatform.setModel(uiSupport.getPlatformComboBoxModel());
        this.comJavaPlatform.setRenderer(new PlatformsRenderer());
        this.comSourceLevel.setEditable(false);
        this.comSourceLevel.setModel(uiSupport.getSourceLevelComboBoxModel());
        this.initValues();
    }

    private void initValues() {
        String sourceLevel = SourceLevelQuery.getSourceLevel((FileObject)this.project.getProjectDirectory());
        if ("1.8".equals(sourceLevel)) {
            sourceLevel = "8";
        }
        this.comSourceLevel.setSelectedItem(sourceLevel);
        this.comSourceLevel.addActionListener(new ActionListener(){
            private ModelOperation<POMModel> operation;

            @Override
            public void actionPerformed(ActionEvent ae) {
                CompilePanel.this.handle.removePOMModification(this.operation);
                String sourceLevel = (String)CompilePanel.this.comSourceLevel.getSelectedItem();
                String source = PluginPropertyUtils.getPluginProperty(CompilePanel.this.handle.getProject(), "org.apache.maven.plugins", "maven-compiler-plugin", "source", "compile", null);
                if (source != null && source.contains(sourceLevel)) {
                    return;
                }
                this.operation = new SourceLevelOperation(CompilePanel.this.handle, sourceLevel);
                CompilePanel.this.handle.addPOMModification(this.operation);
            }
        });
        final boolean cosSupported = BuildArtifactMapper.isCompileOnSaveSupported();
        if (!cosSupported) {
            this.cbCompileOnSave.setEnabled(false);
        }
        new CheckBoxUpdater(this.cbCompileOnSave){
            private String modifiedValue;
            private ModelOperation<POMModel> operation;

            @Override
            public boolean getDefaultValue() {
                return false;
            }

            @Override
            public Boolean getValue() {
                Properties props;
                if (!cosSupported) {
                    return false;
                }
                String val = this.modifiedValue;
                if (val == null) {
                    val = CompilePanel.this.handle.getRawAuxiliaryProperty("netbeans.compile.on.save", true);
                }
                if (val == null && (props = CompilePanel.this.handle.getProject().getProperties()) != null) {
                    val = props.getProperty("netbeans.compile.on.save");
                }
                return "all".equals(val) ? Boolean.valueOf(true) : null;
            }

            @Override
            public void setValue(Boolean v) {
                String value;
                CompilePanel.this.handle.removePOMModification(this.operation);
                this.modifiedValue = null;
                boolean cosEnabled = v != null ? v.booleanValue() : this.getDefaultValue();
                String string = value = cosEnabled ? "all" : "none";
                if ("all".equals(value) && !warningShown && DontShowAgainSettings.getDefault().showWarningAboutApplicationCoS()) {
                    EventQueue.invokeLater(() -> {
                        WarnPanel panel = new WarnPanel(NbBundle.getMessage(CompilePanel.class, (String)"HINT_ApplicationCoS"));
                        NotifyDescriptor.Message dd = new NotifyDescriptor.Message((Object)panel, -1);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
                        if (panel.disabledWarning()) {
                            DontShowAgainSettings.getDefault().dontshowWarningAboutApplicationCoSAnymore();
                        }
                    });
                    warningShown = true;
                }
                boolean hasConfig = CompilePanel.this.handle.getRawAuxiliaryProperty("netbeans.compile.on.save", true) != null;
                org.netbeans.modules.maven.model.pom.Project p = CompilePanel.this.handle.getPOMModel().getProject();
                if (p.getProperties() != null && p.getProperties().getProperty("netbeans.compile.on.save") != null) {
                    this.modifiedValue = value;
                    this.operation = new ModelPropertyOperation("netbeans.compile.on.save", this.modifiedValue);
                    CompilePanel.this.handle.addPOMModification(this.operation);
                    if (hasConfig) {
                        CompilePanel.this.handle.setRawAuxiliaryProperty("netbeans.compile.on.save", null, true);
                    }
                } else {
                    CompilePanel.this.handle.setRawAuxiliaryProperty("netbeans.compile.on.save", value, true);
                }
            }
        };
        new CheckBoxUpdater(this.cbDebug){
            private static final String PARAM_DEBUG = "debug";

            @Override
            public Boolean getValue() {
                String val = CompilePanel.this.getCompilerParam(CompilePanel.this.handle, PARAM_DEBUG);
                if (val != null && Boolean.parseBoolean(val) != this.getDefaultValue()) {
                    return Boolean.valueOf(val);
                }
                return null;
            }

            @Override
            public void setValue(Boolean value) {
                String text = value == null ? String.valueOf(this.getDefaultValue()) : value.toString();
                CompilePanel.this.modifyCompilerParamOperation(CompilePanel.this.handle, PARAM_DEBUG, text, String.valueOf(this.getDefaultValue()));
            }

            @Override
            public boolean getDefaultValue() {
                return true;
            }
        };
        new CheckBoxUpdater(this.cbLint){
            private final boolean currentlyEnabled;
            private final boolean notInParentPom;
            private ModelOperation<POMModel> operation;
            {
                CompilerArgsQueryResult result = CompilerArgsQuery.getCompilerArgs(CompilePanel.this.handle);
                if (result != null && 4.isLintEnabled(result.args)) {
                    this.currentlyEnabled = true;
                    this.notInParentPom = 4.getModelIdWithoutPackaging(CompilePanel.this.handle).equals(result.modelId);
                } else {
                    this.currentlyEnabled = false;
                    this.notInParentPom = false;
                }
            }

            @Override
            public Boolean getValue() {
                return this.currentlyEnabled && this.notInParentPom ? Boolean.valueOf(true) : null;
            }

            @Override
            public boolean getDefaultValue() {
                return this.currentlyEnabled;
            }

            private static String getModelIdWithoutPackaging(ModelHandle2 handle) {
                MavenProject project = handle.getProject();
                String modelId = project.getModel().getId();
                String packaging = project.getModel().getPackaging();
                if (packaging != null && !packaging.isEmpty()) {
                    modelId = modelId.replace(":" + packaging + ":", ":");
                }
                return modelId;
            }

            private static boolean isLintEnabled(List<String> args) {
                if (args.contains("-Xlint")) {
                    return true;
                }
                for (String arg : args) {
                    if (!arg.startsWith("-Xlint:") || !List.of(arg.substring(7).split(",")).contains("all")) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void setValue(Boolean value) {
                if (this.operation != null) {
                    CompilePanel.this.handle.removePOMModification(this.operation);
                }
                if (value == null) {
                    return;
                }
                this.operation = new CompilerLintArgOperation(value);
                CompilePanel.this.handle.addPOMModification(this.operation);
            }
        };
        ComboBoxUpdater<Union2<JavaPlatform, String>> platformComboBoxUpdater = new ComboBoxUpdater<Union2<JavaPlatform, String>>(this.comJavaPlatform, this.lblJavaPlatform){
            private String modifiedValue;
            private static final String DEFAULT_PLATFORM_VALUE = "@@DEFAULT@@";
            private ModelOperation<POMModel> operation;

            @Override
            public Union2<JavaPlatform, String> getValue() {
                org.netbeans.modules.maven.model.pom.Properties props;
                String val = this.modifiedValue;
                if (val == null && (props = CompilePanel.this.handle.getPOMModel().getProject().getProperties()) != null) {
                    val = props.getProperty("netbeans.hint.jdkPlatform");
                }
                if (val == null) {
                    val = CompilePanel.this.handle.getRawAuxiliaryProperty("netbeans.hint.jdkPlatform", true);
                }
                if (val != null) {
                    if (val.equals(DEFAULT_PLATFORM_VALUE)) {
                        return Union2.createFirst((Object)JavaPlatformManager.getDefault().getDefaultPlatform());
                    }
                    return Optional.ofNullable(BootClassPathImpl.getActivePlatform(val)).filter(JavaPlatform::isValid).map(jp -> Union2.createFirst((Object)jp)).orElse(Union2.createSecond((Object)val));
                }
                Pair<String, JavaPlatform> nameJpP = CompilePanel.this.getSelPlatform();
                return Optional.ofNullable((JavaPlatform)nameJpP.second()).filter(JavaPlatform::isValid).map(jp -> Union2.createFirst((Object)jp)).orElseGet(() -> Union2.createSecond((Object)((String)nameJpP.first())));
            }

            @Override
            public Union2<JavaPlatform, String> getDefaultValue() {
                return Union2.createFirst((Object)JavaPlatformManager.getDefault().getDefaultPlatform());
            }

            @Override
            public void setValue(Union2<JavaPlatform, String> value) {
                String platformId;
                Union2 platf;
                CompilePanel.this.handle.removePOMModification(this.operation);
                this.modifiedValue = null;
                Union2 union2 = platf = value == null ? Union2.createFirst((Object)JavaPlatformManager.getDefault().getDefaultPlatform()) : value;
                if (platf.hasFirst()) {
                    JavaPlatform jp = (JavaPlatform)platf.first();
                    platformId = JavaPlatformManager.getDefault().getDefaultPlatform().equals(jp) ? null : (String)jp.getProperties().get("platform.ant.name");
                } else {
                    platformId = (String)platf.second();
                }
                boolean hasConfig = CompilePanel.this.handle.getRawAuxiliaryProperty("netbeans.hint.jdkPlatform", true) != null;
                String string = this.modifiedValue = platformId == null ? DEFAULT_PLATFORM_VALUE : platformId;
                if (CompilePanel.this.handle.getProject().getProperties().containsKey("netbeans.hint.jdkPlatform")) {
                    this.operation = new ModelPropertyOperation("netbeans.hint.jdkPlatform", this.modifiedValue);
                    CompilePanel.this.handle.addPOMModification(this.operation);
                    if (hasConfig) {
                        CompilePanel.this.handle.setRawAuxiliaryProperty("netbeans.hint.jdkPlatform", null, true);
                    }
                } else {
                    CompilePanel.this.handle.setRawAuxiliaryProperty("netbeans.hint.jdkPlatform", platformId, true);
                }
            }
        };
        platformComboBoxUpdater.ancestorAdded(null);
        platformComboBoxUpdater.ancestorRemoved(null);
    }

    private Pair<String, JavaPlatform> getSelPlatform() {
        String platformId = ((AuxiliaryProperties)this.project.getLookup().lookup(AuxiliaryProperties.class)).get("netbeans.hint.jdkPlatform", true);
        return Pair.of((Object)platformId, (Object)BootClassPathImpl.getActivePlatform(platformId));
    }

    private void initComponents() {
        JPanel idePanel = new JPanel();
        this.cbCompileOnSave = new JCheckBox();
        this.lblHint1 = new JLabel();
        this.lblHint2 = new JLabel();
        JPanel compilerPanel = new JPanel();
        this.cbDebug = new JCheckBox();
        this.cbLint = new JCheckBox();
        JPanel jdkPanel = new JPanel();
        this.lblJavaPlatform = new JLabel();
        this.lblJavaPlatform1 = new JLabel();
        this.comJavaPlatform = new JComboBox();
        this.comSourceLevel = new JComboBox();
        this.btnMngPlatform = new JButton();
        this.setPreferredSize(new Dimension(576, 303));
        idePanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(CompilePanel.class, (String)"CompilePanel.idePanel.border.title")));
        Mnemonics.setLocalizedText((AbstractButton)this.cbCompileOnSave, (String)NbBundle.getMessage(CompilePanel.class, (String)"CompilePanel.cbCompileOnSave.text"));
        Mnemonics.setLocalizedText((JLabel)this.lblHint1, (String)NbBundle.getMessage(CompilePanel.class, (String)"CompilePanel.lblHint1.text"));
        Mnemonics.setLocalizedText((JLabel)this.lblHint2, (String)NbBundle.getMessage(CompilePanel.class, (String)"CompilePanel.lblHint2.text"));
        GroupLayout idePanelLayout = new GroupLayout(idePanel);
        idePanel.setLayout(idePanelLayout);
        idePanelLayout.setHorizontalGroup(idePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(idePanelLayout.createSequentialGroup().addContainerGap().addGroup(idePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, idePanelLayout.createSequentialGroup().addComponent(this.cbCompileOnSave, -1, -1, Short.MAX_VALUE).addGap(66, 66, 66)).addComponent(this.lblHint2, GroupLayout.Alignment.TRAILING).addGroup(idePanelLayout.createSequentialGroup().addComponent(this.lblHint1).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        idePanelLayout.setVerticalGroup(idePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(idePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.cbCompileOnSave).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lblHint1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblHint2, -1, 37, Short.MAX_VALUE)));
        compilerPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(CompilePanel.class, (String)"CompilePanel.compilerPanel.border.title")));
        Mnemonics.setLocalizedText((AbstractButton)this.cbDebug, (String)NbBundle.getMessage(CompilePanel.class, (String)"CompilePanel.cbDebug.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbLint, (String)NbBundle.getMessage(CompilePanel.class, (String)"CompilePanel.cbLint.text"));
        GroupLayout compilerPanelLayout = new GroupLayout(compilerPanel);
        compilerPanel.setLayout(compilerPanelLayout);
        compilerPanelLayout.setHorizontalGroup(compilerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(compilerPanelLayout.createSequentialGroup().addContainerGap().addGroup(compilerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbDebug).addComponent(this.cbLint)).addContainerGap(-1, Short.MAX_VALUE)));
        compilerPanelLayout.setVerticalGroup(compilerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(compilerPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.cbDebug).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbLint).addContainerGap(-1, Short.MAX_VALUE)));
        jdkPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(CompilePanel.class, (String)"CompilePanel.jdkPanel.border.title")));
        this.lblJavaPlatform.setLabelFor(this.comJavaPlatform);
        Mnemonics.setLocalizedText((JLabel)this.lblJavaPlatform, (String)NbBundle.getMessage(CompilePanel.class, (String)"CompilePanel.lblJavaPlatform.text"));
        this.lblJavaPlatform1.setLabelFor(this.comJavaPlatform);
        Mnemonics.setLocalizedText((JLabel)this.lblJavaPlatform1, (String)NbBundle.getMessage(CompilePanel.class, (String)"CompilePanel.lblJavaPlatform1.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnMngPlatform, (String)NbBundle.getMessage(CompilePanel.class, (String)"CompilePanel.btnMngPlatform.text"));
        this.btnMngPlatform.addActionListener(this::btnMngPlatformActionPerformed);
        GroupLayout jdkPanelLayout = new GroupLayout(jdkPanel);
        jdkPanel.setLayout(jdkPanelLayout);
        jdkPanelLayout.setHorizontalGroup(jdkPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jdkPanelLayout.createSequentialGroup().addContainerGap().addGroup(jdkPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblJavaPlatform).addComponent(this.lblJavaPlatform1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jdkPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.comSourceLevel, -2, 72, -2).addGroup(jdkPanelLayout.createSequentialGroup().addComponent(this.comJavaPlatform, 0, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnMngPlatform))).addContainerGap()));
        jdkPanelLayout.setVerticalGroup(jdkPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jdkPanelLayout.createSequentialGroup().addContainerGap().addGroup(jdkPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblJavaPlatform).addComponent(this.comJavaPlatform, -2, -1, -2).addComponent(this.btnMngPlatform)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jdkPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblJavaPlatform1).addComponent(this.comSourceLevel, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.btnMngPlatform.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CompilePanel.class, (String)"CompilePanel.btnMngPlatform.AccessibleContext.accessibleDescription"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(idePanel, -1, -1, Short.MAX_VALUE).addComponent(jdkPanel, -1, -1, Short.MAX_VALUE).addComponent(compilerPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(jdkPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(compilerPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(idePanel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void btnMngPlatformActionPerformed(ActionEvent evt) {
        PlatformsCustomizer.showCustomizer((JavaPlatform)((JavaPlatform)this.getSelPlatform().second()));
    }

    private void modifyCompilerParamOperation(ModelHandle2 handle, String param, String value, String defaultValue) {
        String current = PluginPropertyUtils.getPluginProperty(handle.getProject(), "org.apache.maven.plugins", "maven-compiler-plugin", param, "compile", null);
        if (current != null && current.contains(value) || current == null && defaultValue.equals(value)) {
            ModelOperation removed = this.operations.remove(param);
            if (removed != null) {
                handle.removePOMModification((ModelOperation<POMModel>)removed);
            }
            return;
        }
        ModelOperation removed = this.operations.remove(param);
        if (removed != null) {
            handle.removePOMModification((ModelOperation<POMModel>)removed);
        }
        CompilerParamOperation added = new CompilerParamOperation(param, value);
        this.operations.put(param, added);
        handle.addPOMModification(added);
    }

    String getCompilerParam(ModelHandle2 handle, String param) {
        CompilerParamOperation oper = this.operations.get(param);
        if (oper != null) {
            return oper.value;
        }
        return PluginPropertyUtils.getPluginProperty(handle.getProject(), "org.apache.maven.plugins", "maven-compiler-plugin", param, "compile", null);
    }

    private static Configuration getOrCreateCompilerConfig(POMModel model) {
        Plugin plugin;
        Plugin old = null;
        Build build = model.getProject().getBuild();
        if (build != null) {
            old = build.findPluginById("org.apache.maven.plugins", "maven-compiler-plugin");
            if (old == null && build.getPluginManagement() != null) {
                old = build.getPluginManagement().findPluginById("org.apache.maven.plugins", "maven-compiler-plugin");
            }
        } else {
            build = model.getFactory().createBuild();
            model.getProject().setBuild(build);
        }
        if (old != null) {
            plugin = old;
        } else {
            plugin = model.getFactory().createPlugin();
            plugin.setGroupId("org.apache.maven.plugins");
            plugin.setArtifactId("maven-compiler-plugin");
            plugin.setVersion(MavenVersionSettings.getDefault().getVersion("org.apache.maven.plugins", "maven-compiler-plugin"));
            build.addPlugin(plugin);
        }
        Configuration config = plugin.getConfiguration();
        if (config == null) {
            config = model.getFactory().createConfiguration();
            plugin.setConfiguration(config);
        }
        return config;
    }

    private static POMExtensibilityElement getOrCreateElement(POMModel model, POMComponent parent, String name, String text) {
        POMExtensibilityElement elem = CompilePanel.getElement(parent, name, text);
        if (elem != null) {
            return elem;
        }
        return CompilePanel.createElement(model, parent, name, text);
    }

    private static POMExtensibilityElement createElement(POMModel model, POMComponent parent, String name, String text) {
        POMExtensibilityElement elem = model.getFactory().createPOMExtensibilityElement(QName.valueOf(name));
        if (text != null) {
            elem.setElementText(text);
        }
        parent.addExtensibilityElement(elem);
        return elem;
    }

    private static POMExtensibilityElement getElement(POMComponent parent, String name, String text) {
        for (POMExtensibilityElement element : parent.getExtensibilityElements()) {
            if (!element.getQName().getLocalPart().equals(name) || text != null && !text.equals(element.getElementText())) continue;
            return element;
        }
        return null;
    }

    public HelpCtx getHelpCtx() {
        return CustomizerProviderImpl.HELP_CTX;
    }

    private class PlatformsRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        public PlatformsRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Union2 u2;
            this.setName("ComboBox.listRenderer");
            Object strValue = value instanceof Union2 ? ((u2 = (Union2)value).hasFirst() ? ((JavaPlatform)u2.first()).getDisplayName() : "<html><font color=\"#A40000\">" + Bundle.TXT_BrokenPlatformFmt(u2.second())) : Optional.ofNullable(value).map(Object::toString).orElse("");
            this.setText((String)strValue);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }

        @Override
        public String getName() {
            String name = super.getName();
            return name == null ? "ComboBox.renderer" : name;
        }
    }

    private record CompilerParamOperation(String param, String value) implements ModelOperation<POMModel>
    {
        public void performOperation(POMModel model) {
            Configuration config = CompilePanel.getOrCreateCompilerConfig(model);
            config.setSimpleParameter(this.param, this.value);
        }
    }

    static class PlatformsModel
    extends AbstractListModel
    implements ComboBoxModel,
    PropertyChangeListener {
        private static final long serialVersionUID = 1L;
        private List<Union2<JavaPlatform, String>> data;
        private Union2<JavaPlatform, String> sel;
        private final Project project;
        private final ModelHandle2 handle;

        public PlatformsModel(Project project, ModelHandle2 handle) {
            this.project = project;
            this.handle = handle;
            JavaPlatformManager jpm = JavaPlatformManager.getDefault();
            this.getPlatforms(jpm);
            jpm.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)jpm));
            this.sel = Union2.createFirst((Object)jpm.getDefaultPlatform());
        }

        @Override
        public int getSize() {
            return this.data.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.data.get(index);
        }

        @Override
        public void setSelectedItem(Object anItem) {
            this.sel = (Union2)anItem;
            this.fireContentsChanged(this, 0, this.data.size());
        }

        public Union2<JavaPlatform, String> getSelectedItem() {
            return this.sel;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            JavaPlatformManager jpm = JavaPlatformManager.getDefault();
            this.getPlatforms(jpm);
            this.fireContentsChanged(this, 0, this.data.size());
        }

        private void getPlatforms(JavaPlatformManager jpm) {
            List tmp = Arrays.stream(jpm.getPlatforms(null, new Specification("j2se", null))).filter(JavaPlatform::isValid).peek(jp -> LOG.log(Level.FINE, "Adding JavaPlaform: {0}", jp.getDisplayName())).map(jp -> Union2.createFirst((Object)jp)).sorted((jp1, jp2) -> PlatformsModel.displayName((Union2<JavaPlatform, String>)jp2).compareTo(PlatformsModel.displayName((Union2<JavaPlatform, String>)jp1))).collect(Collectors.toCollection(ArrayList::new));
            String val = null;
            org.netbeans.modules.maven.model.pom.Properties props = this.handle.getPOMModel().getProject().getProperties();
            if (props != null) {
                val = props.getProperty("netbeans.hint.jdkPlatform");
            }
            if (val == null) {
                val = this.handle.getRawAuxiliaryProperty("netbeans.hint.jdkPlatform", true);
            }
            String broken = null;
            if (val != null) {
                JavaPlatform jp3 = BootClassPathImpl.getActivePlatform(val);
                if (jp3 == null || !jp3.isValid()) {
                    broken = val;
                }
            } else {
                Pair<String, JavaPlatform> nameJpP = this.getSelPlatform();
                if (nameJpP.second() == null || !((JavaPlatform)nameJpP.second()).isValid()) {
                    broken = (String)nameJpP.first();
                }
            }
            if (broken != null) {
                tmp.add(Union2.createSecond((Object)broken));
            }
            this.data = tmp;
        }

        private static String displayName(Union2<JavaPlatform, String> item) {
            return item.hasFirst() ? ((JavaPlatform)item.first()).getDisplayName() : (String)item.second();
        }

        private Pair<String, JavaPlatform> getSelPlatform() {
            String platformId = ((AuxiliaryProperties)this.project.getLookup().lookup(AuxiliaryProperties.class)).get("netbeans.hint.jdkPlatform", true);
            return Pair.of((Object)platformId, (Object)BootClassPathImpl.getActivePlatform(platformId));
        }
    }

    private static class CompilerArgsQuery
    implements PluginPropertyUtils.ConfigurationBuilder<CompilerArgsQueryResult> {
        private CompilerArgsQuery() {
        }

        private static CompilerArgsQueryResult getCompilerArgs(ModelHandle2 handle) {
            return PluginPropertyUtils.getPluginPropertyBuildable(handle.getProject(), "org.apache.maven.plugins", "maven-compiler-plugin", "compile", new CompilerArgsQuery());
        }

        @Override
        public CompilerArgsQueryResult build(Xpp3Dom config, ExpressionEvaluator eval) {
            Object object;
            Xpp3Dom[] args;
            Xpp3Dom container;
            if (config != null && (container = config.getChild("compilerArgs")) != null && (args = container.getChildren("arg")) != null && (object = container.getInputLocation()) instanceof InputLocation) {
                InputLocation location = (InputLocation)object;
                return new CompilerArgsQueryResult(Stream.of(args).map(a -> a.getValue()).toList(), location.getSource().getModelId());
            }
            return null;
        }
    }

    record CompilerArgsQueryResult(List<String> args, String modelId) {
    }

    private record CompilerLintArgOperation(boolean add) implements ModelOperation<POMModel>
    {
        public void performOperation(POMModel model) {
            Configuration config = CompilePanel.getOrCreateCompilerConfig(model);
            POMExtensibilityElement args = CompilePanel.getOrCreateElement(model, (POMComponent)config, "compilerArgs", null);
            boolean updated = false;
            for (POMExtensibilityElement arg : args.getExtensibilityElements()) {
                String text = arg.getElementText();
                if (!arg.getQName().getLocalPart().equals("arg") || text == null) continue;
                if (text.equals("-Xlint")) {
                    if (this.add) continue;
                    updated |= true;
                    args.removeExtensibilityElement(arg);
                    continue;
                }
                if (!text.startsWith("-Xlint:")) continue;
                if (this.add) {
                    updated |= CompilerLintArgOperation.removeOption("none", arg);
                    continue;
                }
                updated |= CompilerLintArgOperation.removeOption("all", arg);
            }
            if (!updated) {
                if (this.add) {
                    CompilePanel.createElement(model, (POMComponent)args, "arg", "-Xlint");
                } else {
                    CompilePanel.createElement(model, (POMComponent)args, "arg", "-Xlint:none");
                }
            }
            if (args.getExtensibilityElements().isEmpty()) {
                config.removeExtensibilityElement(args);
            }
            if (config.getExtensibilityElements().isEmpty()) {
                ((Plugin)config.getParent()).setConfiguration(null);
            }
        }

        private static boolean removeOption(String option, POMExtensibilityElement arg) {
            String text = arg.getElementText();
            if (text.equals("-Xlint:" + option)) {
                ((POMComponent)arg.getParent()).removeExtensibilityElement(arg);
                return true;
            }
            if (text.contains(option + ",")) {
                arg.setElementText(text.replace(option + ",", ""));
                return true;
            }
            if (text.endsWith("," + option)) {
                arg.setElementText(text.substring(0, text.length() - (option.length() + 1)));
                return true;
            }
            return false;
        }
    }

    private record SourceLevelOperation(ModelHandle2 handle, String sourceLevel) implements ModelOperation<POMModel>
    {
        public void performOperation(POMModel model) {
            org.netbeans.modules.maven.model.pom.Properties prop;
            org.netbeans.modules.maven.model.pom.Project project = model.getProject();
            if (project != null && project.getProperties() != null && ((prop = project.getProperties()).getProperty("maven.compiler.release") != null || prop.getProperty("maven.compiler.source") != null || prop.getProperty("maven.compiler.target") != null)) {
                this.updateInProperties(prop);
                return;
            }
            String s = PluginPropertyUtils.getPluginProperty(this.handle.getProject(), "org.apache.maven.plugins", "maven-compiler-plugin", "source", null, null);
            String t = PluginPropertyUtils.getPluginProperty(this.handle.getProject(), "org.apache.maven.plugins", "maven-compiler-plugin", "target", null, null);
            String r = PluginPropertyUtils.getPluginProperty(this.handle.getProject(), "org.apache.maven.plugins", "maven-compiler-plugin", "release", null, null);
            if (s == null && t == null && r == null) {
                if (project != null) {
                    org.netbeans.modules.maven.model.pom.Properties prop2 = project.getProperties();
                    if (prop2 == null) {
                        prop2 = model.getFactory().createProperties();
                        project.setProperties(prop2);
                    }
                    this.updateInProperties(prop2);
                }
            } else {
                ModelUtils.setSourceLevel(model, this.sourceLevel);
                if (project != null && project.getProperties() != null) {
                    org.netbeans.modules.maven.model.pom.Properties prop3 = project.getProperties();
                    prop3.setProperty("maven.compiler.source", null);
                    prop3.setProperty("maven.compiler.target", null);
                    prop3.setProperty("maven.compiler.release", null);
                }
            }
        }

        private void updateInProperties(org.netbeans.modules.maven.model.pom.Properties prop) {
            if (prop.getProperty("maven.compiler.release") != null || !this.sourceLevel.contains(".") && prop.getProperty("maven.compiler.source") == null && prop.getProperty("maven.compiler.target") == null) {
                prop.setProperty("maven.compiler.release", this.sourceLevel);
                prop.setProperty("maven.compiler.source", null);
                prop.setProperty("maven.compiler.target", null);
            } else {
                prop.setProperty("maven.compiler.source", this.sourceLevel);
                prop.setProperty("maven.compiler.target", this.sourceLevel);
            }
        }
    }

    private record ModelPropertyOperation(String key, String value) implements ModelOperation<POMModel>
    {
        public void performOperation(POMModel model) {
            org.netbeans.modules.maven.model.pom.Properties modprops = model.getProject().getProperties();
            if (modprops == null) {
                modprops = model.getFactory().createProperties();
                model.getProject().setProperties(modprops);
            }
            modprops.setProperty(this.key, this.value);
        }
    }

    static final class SourceLevelComboBoxModel
    extends AbstractListModel<String>
    implements ComboBoxModel<String> {
        private final ComboBoxModel platformComboBoxModel;
        private String selectedSourceLevel;
        private List<Integer> sourceLevelRange;
        private static final long serialVersionUID = 1L;

        public SourceLevelComboBoxModel(ComboBoxModel platformComboBoxModel, String selectedSourceLevel) {
            this.selectedSourceLevel = selectedSourceLevel;
            this.platformComboBoxModel = platformComboBoxModel;
            this.platformComboBoxModel.addListDataListener(new ListDataListener(){

                @Override
                public void contentsChanged(ListDataEvent e) {
                    this.resetCache();
                    this.validateSelection();
                }

                @Override
                public void intervalAdded(ListDataEvent e) {
                }

                @Override
                public void intervalRemoved(ListDataEvent e) {
                }
            });
        }

        @Override
        public int getSize() {
            return this.getSourceLevelRange().size();
        }

        @Override
        public String getElementAt(int index) {
            List<Integer> sourceLevels = this.getSourceLevelRange();
            assert (index >= 0 && index < sourceLevels.size());
            return SourceLevelComboBoxModel.versionToString(sourceLevels.get(index));
        }

        @Override
        public void setSelectedItem(Object obj) {
            this.selectedSourceLevel = obj == null ? null : (String)obj;
            this.fireContentsChanged(this, 0, this.getSize());
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedSourceLevel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void resetCache() {
            SourceLevelComboBoxModel sourceLevelComboBoxModel = this;
            synchronized (sourceLevelComboBoxModel) {
                this.sourceLevelRange = null;
            }
            this.fireContentsChanged(this, 0, this.getSize());
        }

        public void validateSelection() {
            List<Integer> range = this.getSourceLevelRange();
            if (this.selectedSourceLevel != null && !range.isEmpty()) {
                int selected = SourceLevelComboBoxModel.stringToVersion(this.selectedSourceLevel);
                if (selected > range.get(0)) {
                    this.setSelectedItem(SourceLevelComboBoxModel.versionToString(range.get(0)));
                } else if (selected < range.get(range.size() - 1)) {
                    this.setSelectedItem(SourceLevelComboBoxModel.versionToString(range.get(range.size() - 1)));
                }
            }
        }

        private synchronized List<Integer> getSourceLevelRange() {
            if (this.sourceLevelRange == null) {
                Union2 union = (Union2)this.platformComboBoxModel.getSelectedItem();
                if (!union.hasFirst()) {
                    return List.of();
                }
                JavaPlatform platform = (JavaPlatform)union.first();
                if (platform != null) {
                    int max = SourceLevelComboBoxModel.stringToVersion(platform.getSpecification().getVersion().toString());
                    int min = SourceLevelComboBoxModel.minSourceLevelFor(max);
                    this.sourceLevelRange = IntStream.range(min, max + 1).map(i -> max - i + min).boxed().toList();
                } else {
                    this.sourceLevelRange = List.of();
                }
            }
            return this.sourceLevelRange;
        }

        private static int minSourceLevelFor(int version) {
            if (version >= 20) {
                return 8;
            }
            if (version >= 14) {
                return 7;
            }
            if (version >= 9) {
                return 6;
            }
            if (version >= 8) {
                return 2;
            }
            return 1;
        }

        private static String versionToString(int version) {
            return version < 8 ? "1." + version : String.valueOf(version);
        }

        private static int stringToVersion(String version) {
            return version.startsWith("1.") ? Integer.parseInt(version.substring(2)) : Integer.parseInt(version);
        }
    }
}

