/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.queries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.InputSource;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelBuildingResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.codehaus.plexus.PlexusContainerException;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.embedder.DependencyTreeFactory;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.embedder.MavenEmbedder;
import org.netbeans.modules.maven.queries.Bundle;
import org.netbeans.modules.project.dependency.ArtifactSpec;
import org.netbeans.modules.project.dependency.Dependency;
import org.netbeans.modules.project.dependency.DependencyResult;
import org.netbeans.modules.project.dependency.ProjectDependencies;
import org.netbeans.modules.project.dependency.ProjectOperationException;
import org.netbeans.modules.project.dependency.Scope;
import org.netbeans.modules.project.dependency.Scopes;
import org.netbeans.modules.project.dependency.SourceLocation;
import org.netbeans.modules.project.dependency.spi.ProjectDependenciesImplementation;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;

public class MavenDependenciesImplementation
implements ProjectDependenciesImplementation {
    private static final Logger LOG = Logger.getLogger(MavenDependenciesImplementation.class.getName());
    private final Project project;
    private NbMavenProject nbMavenProject;
    private static final Set<Scope> SCOPES = new HashSet<Scope>();
    static final Map<Scope, String> mavenScopes;

    public MavenDependenciesImplementation(Project project) {
        this.project = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        MavenDependenciesImplementation mavenDependenciesImplementation = this;
        synchronized (mavenDependenciesImplementation) {
            if (this.nbMavenProject != null) {
                return;
            }
            this.nbMavenProject = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
        }
    }

    static String mavenScope(Scope s) {
        return mavenScopes.getOrDefault(s, "runtime");
    }

    public ArtifactSpec getProjectArtifact() {
        this.init();
        return this.mavenToArtifactSpec(this.nbMavenProject.getMavenProject().getArtifact());
    }

    private ArtifactSpec mavenToArtifactSpec(Artifact a) {
        FileObject f;
        FileObject fileObject = f = a.getFile() == null ? null : FileUtil.toFileObject((File)a.getFile());
        if (a.isSnapshot()) {
            return ArtifactSpec.createSnapshotSpec((String)a.getGroupId(), (String)a.getArtifactId(), (String)a.getType(), (String)a.getClassifier(), (String)a.getVersion(), (boolean)a.isOptional(), (FileObject)f, (Object)a);
        }
        return ArtifactSpec.createVersionSpec((String)a.getGroupId(), (String)a.getArtifactId(), (String)a.getType(), (String)a.getClassifier(), (String)a.getVersion(), (boolean)a.isOptional(), (FileObject)f, (Object)a);
    }

    public DependencyResult findDependencies(ProjectDependencies.DependencyQuery query) {
        DependencyNode n;
        MavenEmbedder embedder;
        this.init();
        Set scopes = query.getScopes();
        final Dependency.Filter filter = query.getFilter();
        MavenProject mp = this.nbMavenProject.getMavenProject();
        if (NbMavenProject.isErrorPlaceholder(mp)) {
            if (this.nbMavenProject.isMavenProjectLoaded()) {
                throw new ProjectOperationException(this.project, ProjectOperationException.State.BROKEN, Bundle.ERR_DependencyOnBrokenProject());
            }
            throw new ProjectOperationException(this.project, ProjectOperationException.State.UNINITIALIZED, Bundle.ERR_DependencyNotPrimed());
        }
        if (query.isOffline()) {
            try {
                if (query.isFlushChaches()) {
                    embedder = EmbedderFactory.createProjectLikeEmbedder();
                }
                embedder = EmbedderFactory.getProjectEmbedder();
            }
            catch (PlexusContainerException ex) {
                throw new ProjectOperationException(this.project, ProjectOperationException.State.ERROR, Bundle.ERR_DependencyGraphError(), ex.getCause());
            }
        } else {
            try {
                embedder = EmbedderFactory.getOnlineEmbedder();
            }
            catch (IllegalStateException ex) {
                throw new ProjectOperationException(this.project, ProjectOperationException.State.ERROR, Bundle.ERR_DependencyGraphError(), ex.getCause());
            }
        }
        Collection mavenScopes = scopes.stream().map(MavenDependenciesImplementation::mavenScope).collect(Collectors.toList());
        try {
            n = DependencyTreeFactory.createDependencyTree((MavenProject)mp, (MavenEmbedder)embedder, (Collection)mavenScopes);
        }
        catch (MavenExecutionException ex) {
            throw new ProjectOperationException(this.project, ProjectOperationException.State.OK, Bundle.ERR_DependencyGraphError(), ex.getCause());
        }
        catch (AssertionError e) {
            if (EmbedderFactory.isOfflineException((Throwable)((Object)e))) {
                throw new ProjectOperationException(this.project, ProjectOperationException.State.OFFLINE, Bundle.ERR_DependencyGraphOffline());
            }
            throw e;
        }
        final HashSet allScopes = new HashSet();
        ArrayDeque processScopes = new ArrayDeque(scopes);
        while (!processScopes.isEmpty()) {
            Scope s = (Scope)processScopes.poll();
            HashSet<Scope> newScopes = new HashSet<Scope>();
            newScopes.add(s);
            for (Scope t : SCOPES) {
                if (s.includes(t)) {
                    newScopes.add(t);
                    continue;
                }
                if (!t.implies(s)) continue;
                newScopes.add(t);
            }
            newScopes.removeAll(allScopes);
            allScopes.addAll(newScopes);
            processScopes.addAll(newScopes);
        }
        HashSet<ArtifactSpec> broken = new HashSet<ArtifactSpec>();
        Dependency.Filter compositeFiter = new Dependency.Filter(){

            public boolean accept(Scope s, ArtifactSpec a) {
                return allScopes.contains(s) && (filter == null || filter.accept(s, a));
            }
        };
        return new Result(this.nbMavenProject.getMavenProject(), this.convert2(n, compositeFiter, broken), new ArrayList<Scope>(scopes), broken);
    }

    static Scope scope(Artifact a) {
        String as = a.getScope();
        if (as == null) {
            return Scopes.COMPILE;
        }
        switch (as) {
            case "compile": {
                return Scopes.COMPILE;
            }
            case "runtime": 
            case "compile+runtime": 
            case "runtime+system": {
                return Scopes.RUNTIME;
            }
            case "import": 
            case "system": {
                return Scopes.EXTERNAL;
            }
            case "test": {
                return Scopes.TEST;
            }
        }
        return Scopes.COMPILE;
    }

    private org.netbeans.modules.project.dependency.Dependency convert2(DependencyNode n, Dependency.Filter filter, Set<ArtifactSpec> broken) {
        Scope s;
        ArtifactSpec aspec;
        ArrayList<org.netbeans.modules.project.dependency.Dependency> ch = new ArrayList<org.netbeans.modules.project.dependency.Dependency>();
        for (DependencyNode c : n.getChildren()) {
            org.netbeans.modules.project.dependency.Dependency cd = this.convert2(c, filter, broken);
            if (cd == null) continue;
            ch.add(cd);
        }
        Artifact a = n.getArtifact();
        String cs = a.getClassifier();
        if ("".equals(cs)) {
            cs = null;
        }
        if ((aspec = this.mavenToArtifactSpec(a)).getLocalFile() == null) {
            broken.add(aspec);
        }
        if (!filter.accept(s = MavenDependenciesImplementation.scope(a), aspec)) {
            return null;
        }
        return org.netbeans.modules.project.dependency.Dependency.create((ArtifactSpec)aspec, (Scope)s, ch, (Object)n);
    }

    static boolean dependencyEquals(org.netbeans.modules.project.dependency.Dependency dspec, Dependency mavenD) {
        ArtifactSpec spec = dspec.getArtifact();
        String mavenClass = mavenD.getClassifier();
        if ("".equals(mavenClass)) {
            mavenClass = null;
        }
        if (!(Objects.equals(spec.getGroupId(), mavenD.getGroupId()) && Objects.equals(spec.getArtifactId(), mavenD.getArtifactId()) && Objects.equals(spec.getClassifier(), mavenClass) || !Objects.equals(spec.getVersionSpec(), mavenD.getVersion()))) {
            return false;
        }
        if (spec.getType() != null && !Objects.equals(spec.getType(), mavenD.getType())) {
            return false;
        }
        return dspec.getScope() == null || Objects.equals(MavenDependenciesImplementation.mavenScope(dspec.getScope()), mavenD.getScope());
    }

    static boolean artifactEquals(ArtifactSpec spec, Artifact mavenA) {
        String mavenClass = mavenA.getClassifier();
        if ("".equals(mavenClass)) {
            mavenClass = null;
        }
        if (!(Objects.equals(spec.getGroupId(), mavenA.getGroupId()) && Objects.equals(spec.getArtifactId(), mavenA.getArtifactId()) && Objects.equals(spec.getClassifier(), mavenClass) || !Objects.equals(spec.getVersionSpec(), mavenA.getVersion()))) {
            return false;
        }
        return spec.getType() == null || Objects.equals(spec.getType(), mavenA.getType());
    }

    static {
        SCOPES.add(Scopes.COMPILE);
        SCOPES.add(Scopes.RUNTIME);
        SCOPES.add(Scopes.EXTERNAL);
        SCOPES.add(Scopes.TEST);
        mavenScopes = new HashMap<Scope, String>();
        mavenScopes.put(Scopes.PROCESS, "compile");
        mavenScopes.put(Scopes.COMPILE, "compile");
        mavenScopes.put(Scopes.RUNTIME, "runtime");
        mavenScopes.put(Scopes.TEST, "test");
        mavenScopes.put(Scopes.EXTERNAL, "provided");
    }

    class Result
    implements DependencyResult,
    PropertyChangeListener {
        final MavenProject project;
        final org.netbeans.modules.project.dependency.Dependency rootNode;
        final Collection<Scope> scopes;
        final Collection<ArtifactSpec> problems;
        PropertyChangeListener wL;
        Model effectiveModel;
        Map<FileObject, StyledDocument> openedPoms = new HashMap<FileObject, StyledDocument>();
        private List<ChangeListener> listeners;

        public Result(MavenProject proj, org.netbeans.modules.project.dependency.Dependency rootNode, Collection<Scope> scopes, Collection<ArtifactSpec> problems) {
            this.project = proj;
            this.rootNode = rootNode;
            this.scopes = scopes;
            this.problems = problems;
        }

        public Project getProject() {
            return MavenDependenciesImplementation.this.project;
        }

        public Collection<ArtifactSpec> getProblemArtifacts() {
            return Collections.unmodifiableCollection(this.problems);
        }

        public org.netbeans.modules.project.dependency.Dependency getRoot() {
            return this.rootNode;
        }

        public boolean isValid() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChangeListener(ChangeListener l) {
            boolean attach = false;
            Result result = this;
            synchronized (result) {
                if (this.listeners == null) {
                    attach = true;
                    this.listeners = new ArrayList<ChangeListener>();
                }
                this.listeners.add(l);
            }
            if (!attach) {
                return;
            }
            this.wL = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)MavenDependenciesImplementation.this.nbMavenProject);
            MavenDependenciesImplementation.this.nbMavenProject.addPropertyChangeListener(this.wL);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeChangeListener(ChangeListener l) {
            boolean detach = false;
            Result result = this;
            synchronized (result) {
                if (this.listeners == null) {
                    return;
                }
                this.listeners.remove(l);
                if (this.listeners.isEmpty()) {
                    MavenDependenciesImplementation.this.nbMavenProject.removePropertyChangeListener(this.wL);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ArrayList<ChangeListener> ll;
            if (!"MavenProject".equals(evt.getPropertyName())) {
                return;
            }
            Result result = this;
            synchronized (result) {
                if (this.listeners == null || this.listeners.isEmpty()) {
                    return;
                }
                ll = new ArrayList<ChangeListener>(this.listeners);
            }
            ChangeEvent e = new ChangeEvent(this);
            for (ChangeListener l : ll) {
                l.stateChanged(e);
            }
        }

        public String toString() {
            return "Depdenencies for " + this.getRoot().getArtifact() + " " + this.scopes.toString();
        }

        public Lookup getLookup() {
            return Lookup.EMPTY;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SourceLocation getDeclarationRange(org.netbeans.modules.project.dependency.Dependency dep) throws IOException {
            LineDocument ld;
            StyledDocument d;
            Object pd;
            if (this.effectiveModel == null) {
                ModelBuildingResult res;
                try {
                    res = EmbedderFactory.getProjectEmbedder().executeModelBuilder(this.project.getFile());
                }
                catch (ModelBuildingException ex) {
                    throw new IOException(Bundle.ERR_ModelBuildFailed(), ex);
                }
                Result ex = this;
                synchronized (ex) {
                    if (this.effectiveModel == null) {
                        this.effectiveModel = res.getEffectiveModel();
                    }
                }
            }
            org.netbeans.modules.project.dependency.Dependency topLevel = null;
            org.netbeans.modules.project.dependency.Dependency search = dep;
            Dependency selected = null;
            if (dep.getProjectData() instanceof DependencyNode && (pd = (DependencyNode)dep.getProjectData()) != this.rootNode.getProjectData() && pd.getParent() != this.rootNode.getProjectData()) {
                while ((pd = pd.getParent()).getParent() != this.rootNode.getProjectData()) {
                }
                List rootDeps = this.rootNode.getChildren();
                for (org.netbeans.modules.project.dependency.Dependency cd : rootDeps) {
                    if (!MavenDependenciesImplementation.artifactEquals(cd.getArtifact(), pd.getArtifact())) continue;
                    search = cd;
                    topLevel = cd;
                    break;
                }
            }
            for (Dependency d2 : this.effectiveModel.getDependencies()) {
                if (!MavenDependenciesImplementation.dependencyEquals(dep, d2)) continue;
                selected = d2;
                break;
            }
            if (selected == null) {
                return null;
            }
            InputLocation l = selected.getLocation((Object)"");
            InputSource s = l.getSource();
            String path = s.getLocation();
            FileObject fo = FileUtil.toFileObject((File)new File(path));
            if (fo == null) {
                return null;
            }
            Result result = this;
            synchronized (result) {
                d = this.openedPoms.get(fo);
            }
            if (d == null) {
                DataObject dobj = DataObject.find((FileObject)fo);
                EditorCookie cake = (EditorCookie)dobj.getLookup().lookup(EditorCookie.class);
                if (cake == null) {
                    return null;
                }
                d = cake.openDocument();
                Result result2 = this;
                synchronized (result2) {
                    this.openedPoms.put(fo, d);
                }
            }
            if ((ld = (LineDocument)LineDocumentUtils.as((Document)d, LineDocument.class)) == null) {
                return new SourceLocation(fo, -1, -1, (Object)topLevel);
            }
            int so = LineDocumentUtils.getLineStartFromIndex((LineDocument)ld, (int)(l.getLineNumber() - 1)) + l.getColumnNumber() - 1;
            int[] depStart = new int[]{so};
            int[] depEnd = new int[]{so};
            d.render(() -> {
                try {
                    int end;
                    int from = Math.max(0, so - 15);
                    String text = ld.getText(from, ld.getLength() - from);
                    int start = text.lastIndexOf("<dependency", so - from);
                    if (start > -1) {
                        depStart[0] = start + from;
                    }
                    if ((end = text.indexOf("</dependency", so - from)) != -1) {
                        int end2 = text.indexOf(">", end += 10);
                        if (end2 > 0) {
                            end = end2 + 1;
                        }
                        depEnd[0] = end + from;
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            });
            return new SourceLocation(fo, depStart[0], depEnd[0], (Object)topLevel);
        }
    }
}

