/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.customizer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.codehaus.plexus.util.StringUtils;
import org.jdom.Verifier;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.TextValueCompleter;
import org.netbeans.modules.maven.actions.RunCustomMavenAction;
import org.netbeans.modules.maven.api.ProjectProfileHandler;
import org.netbeans.modules.maven.api.customizer.ModelHandle2;
import org.netbeans.modules.maven.customizer.AddPropertyDialog;
import org.netbeans.modules.maven.customizer.Bundle;
import org.netbeans.modules.maven.customizer.CustomizerProviderImpl;
import org.netbeans.modules.maven.customizer.WarnPanel;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.execute.ActionToGoalUtils;
import org.netbeans.modules.maven.execute.DefaultReplaceTokenProvider;
import org.netbeans.modules.maven.execute.model.ActionToGoalMapping;
import org.netbeans.modules.maven.execute.model.NetbeansActionMapping;
import org.netbeans.modules.maven.options.DontShowAgainSettings;
import org.netbeans.modules.maven.runjar.PropertySplitter;
import org.netbeans.modules.maven.spi.grammar.GoalsProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ActionMappings
extends JPanel
implements HelpCtx.Provider {
    public static final String CUSTOM_ACTION_PREFIX = "CUSTOM-";
    private static final RequestProcessor RP = new RequestProcessor(ActionMappings.class);
    private NbMavenProjectImpl project;
    private ModelHandle2 handle;
    private final HashMap<String, String> titles = new HashMap();
    private final GoalsListener goalsListener;
    private final TextValueCompleter goalcompleter;
    private final TextValueCompleter profilecompleter;
    private final ProfilesListener profilesListener;
    private final PackagingsListener packagingsListener;
    private final PropertiesListener propertiesListener;
    private final RecursiveListener recursiveListener;
    private final DepsListener depsListener;
    private ActionToGoalMapping actionmappings;
    private ActionListener comboListener;
    private JButton btnAdd;
    private JButton btnAddProps;
    private JButton btnRemove;
    private JCheckBox cbBuildWithDeps;
    private JCheckBox cbRecursively;
    private JComboBox comConfiguration;
    private JEditorPane epProperties;
    private JButton jButton1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane5;
    private JLabel lblConfiguration;
    private JLabel lblGoals;
    private JLabel lblHint;
    private JLabel lblMappings;
    private JLabel lblPackagings;
    private JLabel lblProfiles;
    private JLabel lblProperties;
    private JList lstMappings;
    private JTextField txtGoals;
    private JTextField txtPackagings;
    private JTextField txtProfiles;

    private ActionMappings() {
        this.initComponents();
        this.lstMappings.setCellRenderer(new Renderer());
        this.lstMappings.setSelectionMode(0);
        this.goalsListener = new GoalsListener();
        this.profilesListener = new ProfilesListener();
        this.packagingsListener = new PackagingsListener();
        this.propertiesListener = new PropertiesListener();
        this.recursiveListener = new RecursiveListener();
        this.depsListener = new DepsListener();
        FocusListener focus = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (e.getComponent() == ActionMappings.this.txtGoals) {
                    ActionMappings.this.lblHint.setText(NbBundle.getMessage(ActionMappings.class, (String)"ActionMappings.txtGoals.hint"));
                }
                if (e.getComponent() == ActionMappings.this.txtProfiles) {
                    ActionMappings.this.lblHint.setText(NbBundle.getMessage(ActionMappings.class, (String)"ActinMappings.txtProfiles.hint"));
                }
                if (e.getComponent() == ActionMappings.this.epProperties) {
                    ActionMappings.this.lblHint.setText(NbBundle.getMessage(ActionMappings.class, (String)"ActinMappings.txtProperties.hint"));
                }
                if (e.getComponent() == ActionMappings.this.txtPackagings) {
                    ActionMappings.this.lblHint.setText(NbBundle.getMessage(ActionMappings.class, (String)"ActinMappings.txtPackagings.hint"));
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                ActionMappings.this.lblHint.setText("");
            }
        };
        this.txtGoals.addFocusListener(focus);
        this.txtProfiles.addFocusListener(focus);
        this.epProperties.addFocusListener(focus);
        this.txtPackagings.addFocusListener(focus);
        this.goalcompleter = new TextValueCompleter(Collections.emptyList(), this.txtGoals, " ");
        this.profilecompleter = new TextValueCompleter(Collections.emptyList(), this.txtProfiles, " ");
        if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
            this.lblHint.setOpaque(true);
            this.jScrollPane2.setBorder(null);
        }
    }

    public ActionMappings(ActionToGoalMapping mapp) {
        this();
        this.actionmappings = mapp;
        this.loadMappings();
        this.cbRecursively.setVisible(false);
        this.comConfiguration.setVisible(false);
        this.lblConfiguration.setVisible(false);
        this.clearFields();
        Mnemonics.setLocalizedText((AbstractButton)this.btnAdd, (String)NbBundle.getMessage(ActionMappings.class, (String)"ActionMappings.btnAdd.text2"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnRemove, (String)NbBundle.getMessage(ActionMappings.class, (String)"ActionMappings.btnRemove.text2"));
    }

    public ActionMappings(ModelHandle2 hand, NbMavenProjectImpl proj) {
        this();
        this.project = proj;
        this.handle = hand;
        this.txtPackagings.setVisible(false);
        this.lblPackagings.setVisible(false);
        this.jButton1.setVisible(false);
        this.titles.put("build", NbBundle.getMessage(ActionMappings.class, (String)"COM_Build_project"));
        this.titles.put("clean", NbBundle.getMessage(ActionMappings.class, (String)"COM_Clean_project"));
        this.titles.put("compile.single", NbBundle.getMessage(ActionMappings.class, (String)"COM_Compile_file"));
        this.titles.put("debug", NbBundle.getMessage(ActionMappings.class, (String)"COM_Debug_project"));
        this.titles.put("debug.single.main", NbBundle.getMessage(ActionMappings.class, (String)"COM_Debug_file_main"));
        this.titles.put("debug.single.deploy", NbBundle.getMessage(ActionMappings.class, (String)"COM_Debug_file_deploy"));
        this.titles.put("debug.stepinto", null);
        this.titles.put("debug.test.single", NbBundle.getMessage(ActionMappings.class, (String)"COM_Debug_test"));
        this.titles.put("rebuild", NbBundle.getMessage(ActionMappings.class, (String)"COM_ReBuild_project"));
        this.titles.put("run", NbBundle.getMessage(ActionMappings.class, (String)"COM_Run_project"));
        this.titles.put("run.single.main", NbBundle.getMessage(ActionMappings.class, (String)"COM_Run_file_main"));
        this.titles.put("run.single.deploy", NbBundle.getMessage(ActionMappings.class, (String)"COM_Run_file_deploy"));
        this.titles.put("test", NbBundle.getMessage(ActionMappings.class, (String)"COM_Test_project"));
        this.titles.put("test.single", NbBundle.getMessage(ActionMappings.class, (String)"COM_Test_file"));
        this.titles.put("profile", NbBundle.getMessage(ActionMappings.class, (String)"COM_Profile_project"));
        this.titles.put("profile.single.main", NbBundle.getMessage(ActionMappings.class, (String)"COM_Profile_file_main"));
        this.titles.put("profile.single.deploy", NbBundle.getMessage(ActionMappings.class, (String)"COM_Profile_file_deploy"));
        this.titles.put("profile.test.single", NbBundle.getMessage(ActionMappings.class, (String)"COM_Profile_test"));
        this.titles.put("javadoc", NbBundle.getMessage(ActionMappings.class, (String)"COM_Javadoc_project"));
        this.titles.put("build-with-dependencies", NbBundle.getMessage(ActionMappings.class, (String)"COM_Build_WithDeps_project"));
        this.titles.put("integration-test.single", NbBundle.getMessage(ActionMappings.class, (String)"COM_Integration_Test_file"));
        this.titles.put("debug.integration-test.single", NbBundle.getMessage(ActionMappings.class, (String)"COM_Debug_Integration_test"));
        this.comConfiguration.setEditable(false);
        this.comConfiguration.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component com = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (com instanceof JLabel && value == ActionMappings.this.handle.getActiveConfiguration()) {
                    com.setFont(com.getFont().deriveFont(1));
                }
                return com;
            }
        });
        this.setupConfigurations();
        this.loadMappings();
        this.clearFields();
        this.comboListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionMappings.this.clearFields();
                ActionMappings.this.loadMappings();
                ActionMappings.this.addListeners();
            }
        };
    }

    private boolean isGlobal() {
        return this.project == null;
    }

    public static void showAddPropertyPopupMenu(JButton btn, JTextComponent area, JTextField goalsField, @NullAllowed NbMavenProjectImpl project) {
        JPopupMenu menu = new JPopupMenu();
        menu.add(new SkipTestsAction(area));
        menu.add(new DebugMavenAction(area));
        menu.add(new EnvVarAction(area));
        menu.add(ActionMappings.createJdkSubmenu(area));
        menu.add(ActionMappings.createGlobalVarSubmenu(area));
        if (project != null) {
            menu.add(new PluginPropertyAction(area, goalsField, project));
        }
        menu.add(ActionMappings.createFileSelectionSubmenu(area));
        menu.show(btn, btn.getSize().width, 0);
    }

    private void addListeners() {
        this.comConfiguration.addActionListener(this.comboListener);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.clearFields();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.setupConfigurations();
        this.loadMappings();
        this.addListeners();
        RP.post(new Runnable(){

            @Override
            public void run() {
                final HashSet<String> strs = new HashSet<String>();
                GoalsProvider provider = (GoalsProvider)Lookup.getDefault().lookup(GoalsProvider.class);
                if (provider != null) {
                    strs.addAll(provider.getAvailableGoals());
                }
                try {
                    strs.addAll(EmbedderFactory.getProjectEmbedder().getLifecyclePhases());
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                }
                List<String> allProfiles = null;
                if (ActionMappings.this.project != null) {
                    ProjectProfileHandler profileHandler = (ProjectProfileHandler)ActionMappings.this.project.getLookup().lookup(ProjectProfileHandler.class);
                    allProfiles = profileHandler.getAllProfiles();
                }
                final List<String> profiles = allProfiles;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ActionMappings.this.goalcompleter.setValueList(strs, false);
                        if (profiles != null) {
                            ActionMappings.this.profilecompleter.setValueList(profiles, false);
                        }
                    }
                });
            }
        });
    }

    private void initComponents() {
        this.lblConfiguration = new JLabel();
        this.comConfiguration = new JComboBox();
        this.jScrollPane1 = new JScrollPane();
        this.lstMappings = new JList();
        this.btnAdd = new JButton();
        this.btnRemove = new JButton();
        this.lblGoals = new JLabel();
        this.txtGoals = new JTextField();
        this.lblProfiles = new JLabel();
        this.txtProfiles = new JTextField();
        this.lblProperties = new JLabel();
        this.cbRecursively = new JCheckBox();
        this.lblMappings = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.lblHint = new JLabel();
        this.btnAddProps = new JButton();
        this.cbBuildWithDeps = new JCheckBox();
        this.jScrollPane5 = new JScrollPane();
        this.epProperties = new JEditorPane();
        this.lblPackagings = new JLabel();
        this.txtPackagings = new JTextField();
        this.jButton1 = new JButton();
        this.setLayout(new GridBagLayout());
        this.lblConfiguration.setLabelFor(this.comConfiguration);
        Mnemonics.setLocalizedText((JLabel)this.lblConfiguration, (String)NbBundle.getMessage(ActionMappings.class, (String)"ActionMappings.lblConfiguration.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.add((Component)this.lblConfiguration, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.ipadx = 427;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 18, 0, 12);
        this.add((Component)this.comConfiguration, gridBagConstraints);
        this.comConfiguration.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ActionMappings.class, (String)"ActionMappings.comConfiguration.AccessibleContext.accessibleDescription"));
        this.jScrollPane1.setMinimumSize(new Dimension(243, 130));
        this.jScrollPane1.setPreferredSize(new Dimension(243, 130));
        this.lstMappings.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                ActionMappings.this.lstMappingsValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.lstMappings);
        this.lstMappings.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ActionMappings.class, (String)"ActionMappings.lstMappings.AccessibleContext.accessibleDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 62;
        gridBagConstraints.ipady = -21;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 18, 0, 0);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.btnAdd, (String)NbBundle.getMessage(ActionMappings.class, (String)"ActionMappings.btnAdd.text"));
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActionMappings.this.btnAddActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 15;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 12);
        this.add((Component)this.btnAdd, gridBagConstraints);
        this.btnAdd.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ActionMappings.class, (String)"ActionMappings.btnAdd.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnRemove, (String)NbBundle.getMessage(ActionMappings.class, (String)"ActionMappings.btnRemove.text"));
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActionMappings.this.btnRemoveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 14;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 12);
        this.add((Component)this.btnRemove, gridBagConstraints);
        this.btnRemove.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ActionMappings.class, (String)"ActionMappings.btnRemove.AccessibleContext.accessibleDescription"));
        this.lblGoals.setLabelFor(this.txtGoals);
        Mnemonics.setLocalizedText((JLabel)this.lblGoals, (String)NbBundle.getMessage(ActionMappings.class, (String)"ActionMappings.lblGoals.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(20, 12, 0, 0);
        this.add((Component)this.lblGoals, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.ipadx = 455;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(18, 18, 0, 12);
        this.add((Component)this.txtGoals, gridBagConstraints);
        this.txtGoals.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ActionMappings.class, (String)"ActionMappings.txtGoals.AccessibleContext.accessibleDescription"));
        this.lblProfiles.setLabelFor(this.txtProfiles);
        Mnemonics.setLocalizedText((JLabel)this.lblProfiles, (String)NbBundle.getMessage(ActionMappings.class, (String)"ActionMappings.lblProfiles.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 12, 0, 0);
        this.add((Component)this.lblProfiles, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.ipadx = 455;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 18, 0, 12);
        this.add((Component)this.txtProfiles, gridBagConstraints);
        this.txtProfiles.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ActionMappings.class, (String)"ActionMappings.txtProfiles.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((JLabel)this.lblProperties, (String)NbBundle.getMessage(ActionMappings.class, (String)"ActionMappings.lblProperties.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.add((Component)this.lblProperties, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.cbRecursively, (String)NbBundle.getMessage(ActionMappings.class, (String)"ActionMappings.cbRecursively.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 18, 0, 0);
        this.add((Component)this.cbRecursively, gridBagConstraints);
        this.lblMappings.setLabelFor(this.lstMappings);
        Mnemonics.setLocalizedText((JLabel)this.lblMappings, (String)NbBundle.getMessage(ActionMappings.class, (String)"LBL_Actions"));
        this.lblMappings.setVerticalAlignment(3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.add((Component)this.lblMappings, gridBagConstraints);
        this.jScrollPane2.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.lblHint.setVerticalAlignment(3);
        this.jScrollPane2.setViewportView(this.lblHint);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 17;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 436;
        gridBagConstraints.ipady = 120;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 18, 0, 12);
        this.add((Component)this.jScrollPane2, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.btnAddProps, (String)NbBundle.getMessage(ActionMappings.class, (String)"ActionMappings.btnAddProps.text"));
        this.btnAddProps.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActionMappings.this.btnAddPropsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.add((Component)this.btnAddProps, gridBagConstraints);
        this.btnAddProps.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ActionMappings.class, (String)"ActionMappings.btnAddProps.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbBuildWithDeps, (String)NbBundle.getMessage(ActionMappings.class, (String)"ActionMappings.cbBuildWithDeps.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 18, 0, 0);
        this.add((Component)this.cbBuildWithDeps, gridBagConstraints);
        this.cbBuildWithDeps.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ActionMappings.class, (String)"ActionMappings.cbBuildWithDeps.AccessibleContext.accessibleDescription"));
        this.epProperties.setContentType("text/x-properties");
        this.jScrollPane5.setViewportView(this.epProperties);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 437;
        gridBagConstraints.ipady = 24;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 18, 0, 12);
        this.add((Component)this.jScrollPane5, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.lblPackagings, (String)NbBundle.getMessage(ActionMappings.class, (String)"ActionMappings.lblPackagings.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 12, 0, 0);
        this.add((Component)this.lblPackagings, gridBagConstraints);
        this.txtPackagings.setText(NbBundle.getMessage(ActionMappings.class, (String)"ActionMappings.txtPackagings.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.ipadx = 455;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 18, 0, 12);
        this.add((Component)this.txtPackagings, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(ActionMappings.class, (String)"ActionMappings.jButton1.text"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActionMappings.this.jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 12);
        this.add((Component)this.jButton1, gridBagConstraints);
    }

    private void btnAddActionPerformed(ActionEvent evt) {
        NonEmptyInputLine nd = new NonEmptyInputLine(NbBundle.getMessage(ActionMappings.class, (String)"TIT_Add_action"), NbBundle.getMessage(ActionMappings.class, (String)"LBL_AddAction"));
        Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
        if (ret == NotifyDescriptor.OK_OPTION) {
            NetbeansActionMapping nam = new NetbeansActionMapping();
            nam.setDisplayName(nd.getInputText());
            nam.setActionName(CUSTOM_ACTION_PREFIX + nd.getInputText());
            this.getActionMappings().addAction(nam);
            if (this.handle != null) {
                this.handle.markAsModified(this.getActionMappings());
            }
            MappingWrapper wr = new MappingWrapper(nam);
            wr.setUserDefined(true);
            ((DefaultListModel)this.lstMappings.getModel()).addElement(wr);
            this.lstMappings.setSelectedIndex(this.lstMappings.getModel().getSize() - 1);
            this.lstMappings.ensureIndexIsVisible(this.lstMappings.getModel().getSize() - 1);
        }
    }

    private void btnRemoveActionPerformed(ActionEvent evt) {
        Object obj = this.lstMappings.getSelectedValue();
        if (obj == null) {
            return;
        }
        MappingWrapper wr = (MappingWrapper)obj;
        NetbeansActionMapping mapp = wr.getMapping();
        if (mapp != null) {
            if (mapp.getActionName().startsWith(CUSTOM_ACTION_PREFIX)) {
                ((DefaultListModel)this.lstMappings.getModel()).removeElement(wr);
            }
            if (wr.getToolbarIconPath() != null) {
                try {
                    RunCustomMavenAction.deleteDeclaration(wr.getActionName());
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            Iterator<NetbeansActionMapping> it = this.getActionMappings().getActions().iterator();
            while (it.hasNext()) {
                if (!mapp.getActionName().equals(it.next().getActionName())) continue;
                it.remove();
                mapp = this.handle != null ? ActionToGoalUtils.getDefaultMapping(mapp.getActionName(), this.project) : null;
                wr.setMapping(mapp);
                wr.setUserDefined(false);
                this.lstMappingsValueChanged(null);
                if (this.handle == null) break;
                this.handle.markAsModified(this.getActionMappings());
                break;
            }
        }
    }

    private void updateEnabledControls(MappingWrapper wr) {
        boolean notEmpty;
        boolean bl = notEmpty = wr != null;
        if (notEmpty) {
            this.lblGoals.setEnabled(true);
            this.lblHint.setEnabled(true);
            this.lblPackagings.setEnabled(true);
            this.lblProfiles.setEnabled(true);
            this.lblProperties.setEnabled(true);
            this.txtGoals.setEnabled(true);
            this.epProperties.setEnabled(true);
            this.txtProfiles.setEnabled(true);
            this.cbRecursively.setEnabled(true);
            this.cbBuildWithDeps.setEnabled(true);
            this.btnAddProps.setEnabled(true);
            this.btnRemove.setEnabled(true);
            if (this.isGlobal()) {
                this.txtPackagings.setEnabled(true);
            }
        } else {
            this.clearFields();
            this.btnRemove.setEnabled(false);
        }
    }

    private void lstMappingsValueChanged(ListSelectionEvent evt) {
        MappingWrapper wr = (MappingWrapper)this.lstMappings.getSelectedValue();
        this.updateEnabledControls(wr);
        if (wr != null) {
            NetbeansActionMapping mapp = wr.getMapping();
            this.txtGoals.getDocument().removeDocumentListener(this.goalsListener);
            this.txtProfiles.getDocument().removeDocumentListener(this.profilesListener);
            this.epProperties.getDocument().removeDocumentListener(this.propertiesListener);
            this.cbRecursively.removeActionListener(this.recursiveListener);
            this.cbBuildWithDeps.removeActionListener(this.depsListener);
            if (this.isGlobal()) {
                this.txtPackagings.getDocument().removeDocumentListener(this.packagingsListener);
                this.txtPackagings.setText(this.createSpaceSeparatedList(mapp != null ? mapp.getPackagings() : Collections.emptyList()));
                this.txtPackagings.getDocument().addDocumentListener(this.packagingsListener);
            }
            this.txtGoals.setText(this.createSpaceSeparatedList(mapp != null ? mapp.getGoals() : Collections.emptyList()));
            this.txtProfiles.setText(this.createSpaceSeparatedList(mapp != null ? mapp.getActivatedProfiles() : Collections.emptyList()));
            this.epProperties.setText(ActionMappings.createPropertiesList(mapp != null ? mapp.getProperties() : Collections.emptyMap()));
            this.epProperties.setCaretPosition(0);
            if (this.handle != null && "pom".equals(this.handle.getProject().getPackaging())) {
                this.cbRecursively.setEnabled(true);
                this.cbRecursively.setSelected(mapp != null ? mapp.isRecursive() : true);
            }
            this.cbBuildWithDeps.setSelected(mapp != null && "build-with-dependencies".equals(mapp.getPreAction()));
            if (mapp != null && "build-with-dependencies".equals(mapp.getActionName())) {
                this.cbBuildWithDeps.setEnabled(false);
            } else {
                this.cbBuildWithDeps.setEnabled(true);
            }
            this.txtGoals.getDocument().addDocumentListener(this.goalsListener);
            this.txtProfiles.getDocument().addDocumentListener(this.profilesListener);
            this.epProperties.getDocument().addDocumentListener(this.propertiesListener);
            this.cbRecursively.addActionListener(this.recursiveListener);
            this.cbBuildWithDeps.addActionListener(this.depsListener);
            this.btnAddProps.setEnabled(true);
            this.updateColor(wr);
            if (this.handle == null) {
                this.updateToolbarButton(wr);
            }
        }
    }

    private void btnAddPropsActionPerformed(ActionEvent evt) {
        ActionMappings.showAddPropertyPopupMenu(this.btnAddProps, this.epProperties, this.txtGoals, this.project);
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        Object obj = this.lstMappings.getSelectedValue();
        if (obj != null) {
            MappingWrapper wr = (MappingWrapper)obj;
            if (wr.getToolbarIconPath() != null) {
                wr.setToolbarPath(null);
                this.updateToolbarButton(wr);
            } else {
                Object ret;
                boolean hasAvailable;
                JPanel pnl = new JPanel();
                pnl.setLayout(new FlowLayout(3));
                pnl.add(new JLabel(Bundle.LBL_SetIcon()));
                List<String> allIcons = RunCustomMavenAction.createAllActionIcons();
                for (int i = 0; i < this.lstMappings.getModel().getSize(); ++i) {
                    MappingWrapper wr0 = (MappingWrapper)this.lstMappings.getModel().getElementAt(i);
                    if (wr0.getToolbarIconPath() == null) continue;
                    allIcons.remove(wr0.getToolbarIconPath());
                }
                DefaultComboBoxModel<String> cbModel = new DefaultComboBoxModel<String>(allIcons.toArray(new String[0]));
                if (cbModel.getSize() != 0) {
                    hasAvailable = true;
                    JComboBox<Object> cb = new JComboBox<Object>();
                    cb.setModel(cbModel);
                    pnl.add(cb);
                    cb.setRenderer(new DefaultListCellRenderer(){

                        @Override
                        public Component getListCellRendererComponent(JList arg0, Object arg1, int arg2, boolean arg3, boolean arg4) {
                            Component sup = super.getListCellRendererComponent((JList<?>)arg0, arg1, arg2, arg3, arg4);
                            if (sup instanceof JLabel && arg1 != null) {
                                JLabel lbl = (JLabel)sup;
                                lbl.setIcon(ImageUtilities.loadImageIcon((String)((String)arg1), (boolean)false));
                                lbl.setText("");
                            }
                            return sup;
                        }
                    });
                } else {
                    hasAvailable = false;
                    pnl.add(new JLabel(Bundle.LBL_No_More_Icons()));
                }
                DialogDescriptor dd = new DialogDescriptor((Object)pnl, Bundle.TIT_SetIcon());
                if (!hasAvailable) {
                    dd.setOptions(new Object[]{Bundle.BTN_Close()});
                    dd.setClosingOptions(dd.getOptions());
                }
                if ((ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd)) == DialogDescriptor.OK_OPTION) {
                    wr.setToolbarPath((String)cbModel.getSelectedItem());
                    this.updateToolbarButton(wr);
                }
            }
        }
    }

    private void loadMappings() {
        DefaultListModel<MappingWrapper> model = new DefaultListModel<MappingWrapper>();
        if (this.handle != null) {
            boolean isWar = "war".equalsIgnoreCase(this.project.getProjectWatcher().getPackagingType());
            this.addSingleAction("build", model);
            this.addSingleAction("clean", model);
            this.addSingleAction("rebuild", model);
            this.addSingleAction("build-with-dependencies", model);
            this.addSingleAction("test", model);
            this.addSingleAction("test.single", model);
            this.addSingleAction("integration-test.single", model);
            this.addSingleAction("run", model);
            this.addSingleAction("run.single.main", model);
            if (isWar) {
                this.addSingleAction("run.single.deploy", model);
            }
            this.addSingleAction("debug", model);
            this.addSingleAction("debug.single.main", model);
            if (isWar) {
                this.addSingleAction("debug.single.deploy", model);
            }
            this.addSingleAction("debug.test.single", model);
            this.addSingleAction("debug.integration-test.single", model);
            this.addSingleAction("profile", model);
            this.addSingleAction("profile.single.main", model);
            if (isWar) {
                this.addSingleAction("profile.single.deploy", model);
            }
            this.addSingleAction("javadoc", model);
        }
        for (NetbeansActionMapping elem : this.getActionMappings().getActions()) {
            if (!elem.getActionName().startsWith(CUSTOM_ACTION_PREFIX)) continue;
            MappingWrapper wr = new MappingWrapper(elem);
            model.addElement(wr);
            wr.setUserDefined(true);
        }
        this.lstMappings.setModel(model);
    }

    private void addSingleAction(String action, DefaultListModel model) {
        NetbeansActionMapping mapp = null;
        for (NetbeansActionMapping elem : this.getActionMappings().getActions()) {
            if (!action.equals(elem.getActionName())) continue;
            mapp = elem;
            break;
        }
        boolean userDefined = true;
        if (mapp == null) {
            mapp = ActionToGoalUtils.getDefaultMapping(action, this.project);
            userDefined = false;
        }
        MappingWrapper wr = mapp == null ? new MappingWrapper(action) : new MappingWrapper(mapp);
        wr.setUserDefined(userDefined);
        model.addElement(wr);
    }

    private String createSpaceSeparatedList(List<String> list) {
        if (list != null) {
            StringBuilder b = new StringBuilder();
            for (String elem : list) {
                if (b.length() > 0) {
                    b.append(' ');
                }
                b.append(elem);
            }
            return b.toString();
        }
        return "";
    }

    public HelpCtx getHelpCtx() {
        return CustomizerProviderImpl.HELP_CTX;
    }

    private void clearFields() {
        this.comConfiguration.removeActionListener(this.comboListener);
        this.txtGoals.getDocument().removeDocumentListener(this.goalsListener);
        this.txtProfiles.getDocument().removeDocumentListener(this.profilesListener);
        this.epProperties.getDocument().removeDocumentListener(this.propertiesListener);
        this.txtPackagings.getDocument().removeDocumentListener(this.packagingsListener);
        this.txtGoals.setText("");
        this.txtProfiles.setText("");
        this.epProperties.setText("");
        this.txtPackagings.setText("");
        this.txtGoals.getDocument().addDocumentListener(this.goalsListener);
        this.txtProfiles.getDocument().addDocumentListener(this.profilesListener);
        this.epProperties.getDocument().addDocumentListener(this.propertiesListener);
        this.txtPackagings.getDocument().addDocumentListener(this.packagingsListener);
        this.txtGoals.setEnabled(false);
        this.epProperties.setEnabled(false);
        this.txtProfiles.setEnabled(false);
        this.txtPackagings.setEnabled(false);
        this.updateColor(null);
        this.cbRecursively.setEnabled(false);
        this.cbBuildWithDeps.setEnabled(false);
        this.btnAddProps.setEnabled(false);
        if (this.handle == null) {
            this.jButton1.setEnabled(false);
            this.jButton1.setIcon(null);
            this.jButton1.setText(Bundle.BTN_ShowToolbar());
        }
        this.lblGoals.setEnabled(false);
        this.lblHint.setEnabled(false);
        this.lblPackagings.setEnabled(false);
        this.lblProfiles.setEnabled(false);
        this.lblProperties.setEnabled(false);
    }

    private void updateColor(MappingWrapper wr) {
        if (this.isGlobal()) {
            return;
        }
        Font fnt = this.lblGoals.getFont();
        fnt = fnt.deriveFont(wr != null && wr.isUserDefined() ? 1 : 0);
        this.lblGoals.setFont(fnt);
        this.lblProperties.setFont(fnt);
        this.lblProfiles.setFont(fnt);
    }

    public static String createPropertiesList(Map<? extends String, ? extends String> properties) {
        StringBuilder b = new StringBuilder();
        if (properties != null) {
            for (Map.Entry<? extends String, ? extends String> entry : properties.entrySet()) {
                if (b.length() > 0) {
                    b.append('\n');
                }
                b.append(entry.getKey()).append('=').append(entry.getValue());
                if (!entry.getValue().endsWith("\\")) continue;
                b.append(" ");
            }
        }
        return b.toString();
    }

    private void writeProperties(NetbeansActionMapping mapp) {
        mapp.setProperties(ActionMappings.convertStringToActionProperties(this.epProperties.getText()));
        if (this.handle != null) {
            this.handle.markAsModified(this.getActionMappings());
        }
    }

    public static Map<String, String> convertStringToActionProperties(String text) {
        PropertySplitter split = new PropertySplitter(text);
        String tok = split.nextPair();
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        while (tok != null) {
            String[] prp = StringUtils.split((String)tok, (String)"=", (int)2);
            if (prp.length >= 1) {
                String key = prp[0];
                if (key.startsWith("-D")) {
                    key = key.substring("-D".length());
                }
                if (key.startsWith("-")) {
                    key = key.substring(1);
                }
                if (key.endsWith("=")) {
                    key = key.substring(0, key.length() - 1);
                }
                if (key.trim().length() > 0 && Verifier.checkElementName((String)key.trim()) == null) {
                    props.put(key.trim(), prp.length > 1 ? prp[1] : "");
                }
            }
            tok = split.nextPair();
        }
        return props;
    }

    private ActionToGoalMapping getActionMappings() {
        assert (this.handle != null || this.actionmappings != null);
        if (this.handle != null) {
            return this.handle.getActionMappings((ModelHandle2.Configuration)this.comConfiguration.getSelectedItem());
        }
        return this.actionmappings;
    }

    private void updateToolbarButton(MappingWrapper wr) {
        this.jButton1.setEnabled(true);
        if (wr.getToolbarIconPath() != null) {
            this.jButton1.setIcon(ImageUtilities.loadImageIcon((String)wr.getToolbarIconPath(), (boolean)false));
            this.jButton1.setText(Bundle.BTN_HideToolbar());
        } else {
            this.jButton1.setIcon(null);
            this.jButton1.setText(Bundle.BTN_ShowToolbar());
        }
    }

    public void applyToolbarChanges() {
        for (int i = 0; i < this.lstMappings.getModel().getSize(); ++i) {
            MappingWrapper wr = (MappingWrapper)this.lstMappings.getModel().getElementAt(i);
            if (!wr.hasToolbarPathChanged()) continue;
            if (wr.getOrigToolbarIconPath() != null) {
                try {
                    RunCustomMavenAction.deleteDeclaration(wr.getActionName());
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            if (wr.getToolbarIconPath() == null) continue;
            try {
                RunCustomMavenAction.createActionDeclaration(wr.getActionName(), wr.getActionName(), wr.getToolbarIconPath());
                continue;
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void setupConfigurations() {
        if (this.handle != null) {
            this.lblConfiguration.setVisible(true);
            this.comConfiguration.setVisible(true);
            DefaultComboBoxModel<ModelHandle2.Configuration> comModel = new DefaultComboBoxModel<ModelHandle2.Configuration>();
            for (ModelHandle2.Configuration conf : this.handle.getConfigurations()) {
                comModel.addElement(conf);
            }
            this.comConfiguration.setModel(comModel);
            this.comConfiguration.setSelectedItem(this.handle.getActiveConfiguration());
        } else {
            this.lblConfiguration.setVisible(false);
            this.comConfiguration.setVisible(false);
            DefaultComboBoxModel comModel = new DefaultComboBoxModel();
            this.comConfiguration.setModel(comModel);
        }
    }

    private static JMenu createGlobalVarSubmenu(JTextComponent area) {
        JMenu menu = new JMenu();
        menu.setText(Bundle.ActionMappings_globalVar());
        Map<String, String> vars = DefaultReplaceTokenProvider.readVariables();
        boolean hasAny = false;
        for (Map.Entry<String, String> ent : vars.entrySet()) {
            hasAny = true;
            menu.add(new UseGlobalVarAction(area, ent.getKey()));
        }
        if (!hasAny) {
            menu.setEnabled(false);
        }
        return menu;
    }

    private static JMenu createJdkSubmenu(JTextComponent area) {
        JMenu menu = new JMenu();
        menu.setText(Bundle.ActionMappings_jdkVar());
        boolean hasAny = false;
        for (JavaPlatform platform : JavaPlatformManager.getDefault().getInstalledPlatforms()) {
            hasAny = true;
            if (platform.getInstallFolders().size() <= 0) continue;
            menu.add(new JdkAction(area, platform.getDisplayName(), (FileObject)platform.getInstallFolders().iterator().next()));
        }
        if (!hasAny) {
            menu.setEnabled(false);
        }
        return menu;
    }

    private static JMenu createFileSelectionSubmenu(JTextComponent area) {
        JMenu menu = new JMenu();
        menu.setText(Bundle.ActionMappings_fileExpressions());
        menu.add(new FileVariableAction(area, "packageClassName"));
        menu.add(new FileVariableAction(area, "className"));
        menu.add(new FileVariableAction(area, "classNameWithExtension"));
        menu.add(new FileVariableAction(area, "webPagePath"));
        menu.add(new FileVariableAction(area, "classPathScope"));
        menu.add(new FileVariableAction(area, "absolutePathName"));
        return menu;
    }

    private static void replacePattern(String pattern, JTextComponent area, String replace, boolean select) {
        String props = area.getText();
        Matcher match = Pattern.compile(pattern, 32).matcher(props);
        if (match.matches()) {
            int begin = props.indexOf("skipTests");
            props = props.replace("skipTests" + match.group(1), replace);
            area.setText(props);
            if (select) {
                area.setSelectionStart(begin);
                area.setSelectionEnd(begin + replace.length());
                area.requestFocusInWindow();
            }
        } else {
            String sep = "\n";
            if (props.endsWith("\n") || props.trim().length() == 0) {
                sep = "";
            }
            props = props + sep + replace;
            area.setText(props);
            if (select) {
                area.setSelectionStart(props.length() - replace.length());
                area.setSelectionEnd(props.length());
                area.requestFocusInWindow();
            }
        }
    }

    private static class NonEmptyInputLine
    extends NotifyDescriptor.InputLine
    implements DocumentListener {
        NonEmptyInputLine(String text, String title) {
            super(text, title);
            this.textField.getDocument().addDocumentListener(this);
            this.checkValid();
        }

        @Override
        public void insertUpdate(DocumentEvent arg0) {
            this.checkValid();
        }

        @Override
        public void removeUpdate(DocumentEvent arg0) {
            this.checkValid();
        }

        @Override
        public void changedUpdate(DocumentEvent arg0) {
            this.checkValid();
        }

        private void checkValid() {
            this.setValid(this.textField.getText() != null && this.textField.getText().trim().length() > 0);
        }
    }

    static class FileVariableAction
    extends AbstractAction {
        private final JTextComponent area;
        private final String key;

        FileVariableAction(JTextComponent area, String key) {
            this.putValue("Name", "${" + key + "}");
            this.area = area;
            this.key = key;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                this.area.getDocument().insertString(this.area.getCaretPosition(), "${" + this.key + "}", null);
            }
            catch (BadLocationException ex) {
                String text = this.area.getText();
                text = text + "${" + this.key + "}";
                this.area.setText(text);
                this.area.requestFocusInWindow();
            }
        }
    }

    static class UseGlobalVarAction
    extends AbstractAction {
        private final JTextComponent area;
        private final String key;

        UseGlobalVarAction(JTextComponent area, String key) {
            this.putValue("Name", "${" + key + "}");
            this.area = area;
            this.key = key;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                this.area.getDocument().insertString(this.area.getCaretPosition(), "${" + this.key + "}", null);
            }
            catch (BadLocationException ex) {
                String text = this.area.getText();
                text = text + "${" + this.key + "}";
                this.area.setText(text);
                this.area.requestFocusInWindow();
            }
        }
    }

    static class JdkAction
    extends AbstractAction {
        private final JTextComponent area;
        private final String value;

        JdkAction(JTextComponent area, String displayName, FileObject value) {
            this.putValue("Name", displayName);
            this.area = area;
            this.value = FileUtil.toFile((FileObject)value).getAbsolutePath();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String props = this.area.getText();
            String sep = "\n";
            if (props.endsWith("\n") || props.trim().length() == 0) {
                sep = "";
            }
            String val = "Env.JAVA_HOME=" + this.value;
            props = props + sep + val;
            this.area.setText(props);
            this.area.setSelectionStart(props.length() - val.length());
            this.area.setSelectionEnd(props.length());
            this.area.requestFocusInWindow();
        }
    }

    static class EnvVarAction
    extends AbstractAction {
        private final JTextComponent area;

        EnvVarAction(JTextComponent area) {
            this.putValue("Name", NbBundle.getMessage(ActionMappings.class, (String)"ActionMappings.envVar"));
            this.area = area;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String props = this.area.getText();
            String sep = "\n";
            if (props.endsWith("\n") || props.trim().length() == 0) {
                sep = "";
            }
            props = props + sep + "Env.FOO=bar";
            this.area.setText(props);
            this.area.setSelectionStart(props.length() - "Env.FOO=bar".length());
            this.area.setSelectionEnd(props.length());
            this.area.requestFocusInWindow();
        }
    }

    static class PluginPropertyAction
    extends AbstractAction {
        private final JTextComponent area;
        private final JTextField goals;
        private final NbMavenProjectImpl project;

        PluginPropertyAction(JTextComponent area, JTextField goals, NbMavenProjectImpl prj) {
            this.putValue("Name", NbBundle.getMessage(ActionMappings.class, (String)"TXT_PLUGIN_EXPRESSION"));
            this.area = area;
            this.goals = goals;
            this.project = prj;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GoalsProvider provider = (GoalsProvider)Lookup.getDefault().lookup(GoalsProvider.class);
            if (provider != null) {
                String expr;
                AddPropertyDialog panel = new AddPropertyDialog(this.project, this.goals.getText());
                DialogDescriptor dd = new DialogDescriptor((Object)panel, Bundle.TIT_PLUGIN_EXPRESSION());
                dd.setOptions(new Object[]{panel.getOkButton(), DialogDescriptor.CANCEL_OPTION});
                dd.setClosingOptions(new Object[]{panel.getOkButton(), DialogDescriptor.CANCEL_OPTION});
                DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
                if (dd.getValue() == panel.getOkButton() && (expr = panel.getSelectedExpression()) != null) {
                    String props = this.area.getText();
                    String sep = "\n";
                    if (props.endsWith("\n") || props.trim().length() == 0) {
                        sep = "";
                    }
                    props = props + sep + expr + "=";
                    this.area.setText(props);
                    this.area.setSelectionStart(props.length() - (expr + "=").length());
                    this.area.setSelectionEnd(props.length());
                    this.area.requestFocusInWindow();
                }
            }
        }
    }

    static class DebugMavenAction
    extends AbstractAction {
        private final JTextComponent area;

        DebugMavenAction(JTextComponent area) {
            this.putValue("Name", NbBundle.getMessage(ActionMappings.class, (String)"ActionMappings.debugMaven"));
            this.area = area;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String replace = "jpda.listen=maven";
            String pattern = ".*jpda.listen([\\s]*=[\\s]*[\\S]+).*";
            ActionMappings.replacePattern(pattern, this.area, replace, true);
        }
    }

    static class SkipTestsAction
    extends AbstractAction {
        private final JTextComponent area;

        SkipTestsAction(JTextComponent area) {
            this.putValue("Name", NbBundle.getMessage(ActionMappings.class, (String)"ActionMappings.skipTests"));
            this.area = area;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String replace = "skipTests=true";
            String pattern = ".*skipTests([\\s]*=[\\s]*[\\S]+).*";
            ActionMappings.replacePattern(pattern, this.area, replace, true);
        }
    }

    private class DepsListener
    implements ActionListener {
        private boolean shown = false;

        private DepsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MappingWrapper map = (MappingWrapper)ActionMappings.this.lstMappings.getSelectedValue();
            if (map != null) {
                if (!map.isUserDefined()) {
                    NetbeansActionMapping mapping = map.getMapping();
                    if (mapping == null) {
                        mapping = new NetbeansActionMapping();
                        mapping.setActionName(map.getActionName());
                    }
                    ActionMappings.this.getActionMappings().addAction(mapping);
                    map.setUserDefined(true);
                    ActionMappings.this.updateColor(map);
                }
                if (ActionMappings.this.cbBuildWithDeps.isSelected()) {
                    if (!this.shown && DontShowAgainSettings.getDefault().showWarningAboutBuildWithDependencies()) {
                        WarnPanel panel = new WarnPanel(Bundle.HINT_Build_WithDependencies());
                        NotifyDescriptor.Message dd = new NotifyDescriptor.Message((Object)panel, -1);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
                        if (panel.disabledWarning()) {
                            DontShowAgainSettings.getDefault().dontShowWarningAboutBuildWithDependenciesAnymore();
                        }
                        this.shown = true;
                    }
                    map.getMapping().setPreAction("build-with-dependencies");
                } else {
                    map.getMapping().setPreAction(null);
                }
                if (ActionMappings.this.handle != null) {
                    ActionMappings.this.handle.markAsModified(ActionMappings.this.getActionMappings());
                }
            }
        }
    }

    private class RecursiveListener
    implements ActionListener {
        private RecursiveListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MappingWrapper map = (MappingWrapper)ActionMappings.this.lstMappings.getSelectedValue();
            if (map != null) {
                if (!map.isUserDefined()) {
                    NetbeansActionMapping mapping = map.getMapping();
                    if (mapping == null) {
                        mapping = new NetbeansActionMapping();
                        mapping.setActionName(map.getActionName());
                    }
                    ActionMappings.this.getActionMappings().addAction(mapping);
                    map.setUserDefined(true);
                    ActionMappings.this.updateColor(map);
                }
                map.getMapping().setRecursive(ActionMappings.this.cbRecursively.isSelected());
                if (ActionMappings.this.handle != null) {
                    ActionMappings.this.handle.markAsModified(ActionMappings.this.getActionMappings());
                }
            }
        }
    }

    private class PropertiesListener
    extends TextFieldListener {
        private PropertiesListener() {
        }

        @Override
        protected MappingWrapper doUpdate() {
            MappingWrapper wr = super.doUpdate();
            if (wr != null) {
                NetbeansActionMapping mapp = wr.getMapping();
                ActionMappings.this.writeProperties(mapp);
            }
            return wr;
        }
    }

    private class PackagingsListener
    extends TextFieldListener {
        private PackagingsListener() {
        }

        @Override
        protected MappingWrapper doUpdate() {
            MappingWrapper wr = super.doUpdate();
            if (wr != null) {
                String text = ActionMappings.this.txtPackagings.getText().trim();
                StringTokenizer tok = new StringTokenizer(text, " ,");
                NetbeansActionMapping mapp = wr.getMapping();
                ArrayList<String> packs = new ArrayList<String>();
                while (tok.hasMoreTokens()) {
                    String token = tok.nextToken();
                    packs.add(token.trim());
                }
                mapp.setPackagings(packs);
                if (ActionMappings.this.handle != null) {
                    ActionMappings.this.handle.markAsModified(ActionMappings.this.getActionMappings());
                }
            }
            return wr;
        }
    }

    private class ProfilesListener
    extends TextFieldListener {
        private ProfilesListener() {
        }

        @Override
        protected MappingWrapper doUpdate() {
            MappingWrapper wr = super.doUpdate();
            if (wr != null) {
                String text = ActionMappings.this.txtProfiles.getText();
                StringTokenizer tok = new StringTokenizer(text, " ,");
                NetbeansActionMapping mapp = wr.getMapping();
                ArrayList<String> profs = new ArrayList<String>();
                while (tok.hasMoreTokens()) {
                    String token = tok.nextToken();
                    profs.add(token);
                }
                mapp.setActivatedProfiles(profs);
                if (ActionMappings.this.handle != null) {
                    ActionMappings.this.handle.markAsModified(ActionMappings.this.getActionMappings());
                }
            }
            return wr;
        }
    }

    private class GoalsListener
    extends TextFieldListener {
        private GoalsListener() {
        }

        @Override
        protected MappingWrapper doUpdate() {
            MappingWrapper wr = super.doUpdate();
            boolean wasEnabled = ActionToGoalUtils.isDisabledMapping(wr.getMapping());
            if (wr != null) {
                String text = ActionMappings.this.txtGoals.getText();
                StringTokenizer tok = new StringTokenizer(text, " ");
                NetbeansActionMapping mapp = wr.getMapping();
                ArrayList<String> goals = new ArrayList<String>();
                while (tok.hasMoreTokens()) {
                    String token = tok.nextToken();
                    goals.add(token);
                }
                mapp.setGoals(goals);
                if (ActionMappings.this.handle != null) {
                    ActionMappings.this.handle.markAsModified(ActionMappings.this.getActionMappings());
                }
                if (ActionToGoalUtils.isDisabledMapping(wr.getMapping()) != wasEnabled) {
                    ActionMappings.this.lstMappings.repaint();
                }
            }
            return wr;
        }
    }

    private abstract class TextFieldListener
    implements DocumentListener {
        private TextFieldListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.doUpdate();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.doUpdate();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.doUpdate();
        }

        protected MappingWrapper doUpdate() {
            MappingWrapper map = (MappingWrapper)ActionMappings.this.lstMappings.getSelectedValue();
            if (map != null && !map.isUserDefined()) {
                NetbeansActionMapping mapping = map.getMapping();
                if (mapping == null) {
                    mapping = new NetbeansActionMapping();
                    mapping.setActionName(map.getActionName());
                    map.setMapping(mapping);
                }
                ActionMappings.this.getActionMappings().addAction(mapping);
                if (ActionMappings.this.handle != null) {
                    ActionMappings.this.handle.markAsModified(ActionMappings.this.getActionMappings());
                }
                map.setUserDefined(true);
                ActionMappings.this.updateColor(map);
            }
            return map;
        }
    }

    private class MappingWrapper {
        private NetbeansActionMapping mapping;
        private final String action;
        private boolean userDefined = false;
        private final String origToolbarIconPath;
        private String toolbarIconPath;

        MappingWrapper(String action) {
            this.action = action;
            this.toolbarIconPath = this.origToolbarIconPath = RunCustomMavenAction.actionDeclarationIconPath(action);
        }

        MappingWrapper(NetbeansActionMapping mapp) {
            this.action = mapp.getActionName();
            this.mapping = mapp;
            this.toolbarIconPath = this.origToolbarIconPath = RunCustomMavenAction.actionDeclarationIconPath(this.action);
        }

        public void setMapping(NetbeansActionMapping mapp) {
            this.mapping = mapp;
        }

        public String getActionName() {
            return this.action;
        }

        public NetbeansActionMapping getMapping() {
            return this.mapping;
        }

        public String toString() {
            if (ActionMappings.this.titles.get(this.action) != null) {
                return (String)ActionMappings.this.titles.get(this.action);
            }
            if (this.mapping != null) {
                if (this.mapping.getDisplayName() != null) {
                    return this.mapping.getDisplayName();
                }
                return this.mapping.getActionName();
            }
            return this.action;
        }

        public boolean isUserDefined() {
            return this.userDefined;
        }

        public void setUserDefined(boolean userDefined) {
            this.userDefined = userDefined;
        }

        public void setToolbarPath(String path) {
            this.toolbarIconPath = path;
        }

        public boolean hasToolbarPathChanged() {
            return this.toolbarIconPath == null && this.origToolbarIconPath != null || this.toolbarIconPath != null && !this.toolbarIconPath.equals(this.origToolbarIconPath);
        }

        public String getOrigToolbarIconPath() {
            return this.origToolbarIconPath;
        }

        public String getToolbarIconPath() {
            return this.toolbarIconPath;
        }
    }

    private static class Renderer
    extends DefaultListCellRenderer {
        private Renderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int arg2, boolean arg3, boolean arg4) {
            Component supers = super.getListCellRendererComponent((JList<?>)list, value, arg2, arg3, arg4);
            if (supers instanceof JLabel && value instanceof MappingWrapper) {
                MappingWrapper wr = (MappingWrapper)value;
                JLabel lbl = (JLabel)supers;
                if (wr.isUserDefined()) {
                    lbl.setFont(lbl.getFont().deriveFont(1));
                } else {
                    lbl.setFont(lbl.getFont().deriveFont(0));
                }
                if (ActionToGoalUtils.isDisabledMapping(wr.getMapping())) {
                    lbl.setForeground(Color.lightGray);
                    lbl.setText(Bundle.FMT_DisabledAction(lbl.getText()));
                }
            }
            return supers;
        }
    }
}

