/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee.ui.nodes;

import java.awt.Image;
import java.io.File;
import java.util.Collections;
import org.netbeans.api.project.Project;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.maven.j2ee.ui.nodes.Bundle;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;

class WebPagesNode
extends FilterNode {
    private boolean isTopLevelNode = false;
    private Project project;
    private FileObject file;

    WebPagesNode(Project proj, Node orig, File root) {
        this(proj, orig, root, true);
    }

    private WebPagesNode(Project proj, Node orig, File root, boolean isTopLevel) {
        super(orig, (Children)(orig.getChildren() == FilterNode.Children.LEAF ? FilterNode.Children.LEAF : new WebAppFilterChildren(proj, orig, root)));
        this.project = proj;
        this.isTopLevelNode = isTopLevel;
        if (isTopLevel) {
            this.file = FileUtil.toFileObject((File)root);
        }
    }

    public String getDisplayName() {
        if (this.isTopLevelNode) {
            String displayName;
            String webRootPath = this.file.getPath();
            if (webRootPath.endsWith("src/main/webapp")) {
                displayName = Bundle.LBL_Web_Pages();
            } else {
                String projectPath = this.project.getProjectDirectory().getPath();
                displayName = Bundle.LBL_Web_Pages() + " (" + webRootPath.replaceAll(projectPath, "") + ")";
            }
            try {
                displayName = this.file.getFileSystem().getDecorator().annotateName(displayName, Collections.singleton(this.file));
            }
            catch (FileStateInvalidException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
            return displayName;
        }
        return this.getOriginal().getDisplayName();
    }

    public String getHtmlDisplayName() {
        if (!this.isTopLevelNode) {
            return this.getOriginal().getHtmlDisplayName();
        }
        try {
            String s = Bundle.LBL_Web_Pages();
            String result = this.file.getFileSystem().getDecorator().annotateNameHtml(s, Collections.singleton(this.file));
            if (result != null && !s.equals(result)) {
                return result;
            }
        }
        catch (FileStateInvalidException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
        return super.getHtmlDisplayName();
    }

    public Image getIcon(int param) {
        Image retValue = super.getIcon(param);
        if (this.isTopLevelNode) {
            retValue = ImageUtilities.mergeImages((Image)retValue, (Image)ImageUtilities.loadImage((String)"org/netbeans/modules/maven/j2ee/ui/resources/WebPagesBadge.png"), (int)8, (int)8);
        }
        return retValue;
    }

    public Image getOpenedIcon(int param) {
        Image retValue = super.getOpenedIcon(param);
        if (this.isTopLevelNode) {
            retValue = ImageUtilities.mergeImages((Image)retValue, (Image)ImageUtilities.loadImage((String)"org/netbeans/modules/maven/j2ee/ui/resources/WebPagesBadge.png"), (int)8, (int)8);
        }
        return retValue;
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + (this.isTopLevelNode ? 1 : 0);
        hash = 67 * hash + (this.file != null ? this.file.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        WebPagesNode other = (WebPagesNode)((Object)obj);
        if (this.isTopLevelNode != other.isTopLevelNode) {
            return false;
        }
        return this.file == other.file || this.file != null && this.file.equals(other.file);
    }

    private static class WebAppFilterChildren
    extends FilterNode.Children {
        private final File root;
        private final Project project;

        private WebAppFilterChildren(Project proj, Node original, File rootpath) {
            super(original);
            this.root = rootpath;
            this.project = proj;
        }

        protected Node[] createNodes(Node obj) {
            FileObject fobj = (FileObject)obj.getLookup().lookup(FileObject.class);
            if (fobj != null) {
                if (!VisibilityQuery.getDefault().isVisible(fobj)) {
                    return new Node[0];
                }
                WebPagesNode n = new WebPagesNode(this.project, obj, this.root, false);
                return new Node[]{n};
            }
            Node origos = obj;
            return new Node[]{origos.cloneNode()};
        }
    }
}

