/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.indexer;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

final class MatchWords
implements Predicate<String> {
    private final List<MatchState> matchers = new ArrayList<MatchState>();
    private ThreadLocal<MatchState[]> local = new ThreadLocal();

    MatchWords(String[] strings) {
        for (String s : strings) {
            this.matchers.add(new MatchState(s));
        }
    }

    private MatchState[] matchers() {
        MatchState[] result = this.local.get();
        if (result == null) {
            result = new MatchState[this.matchers.size()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = this.matchers.get(i).copy();
            }
            this.local.set(result);
        }
        return result;
    }

    @Override
    public boolean test(String t) {
        MatchState[] mtchrs;
        int max = t.length();
        for (MatchState mtchr : mtchrs = this.matchers()) {
            mtchr.reset();
        }
        for (int i = 0; i < max; ++i) {
            char c = t.charAt(i);
            for (int j = 0; j < mtchrs.length; ++j) {
                mtchrs[j].check(c);
                if (!mtchrs[j].isMatched()) continue;
                return true;
            }
        }
        return false;
    }

    private static final class MatchState {
        private final char[] what;
        private int matched = 0;
        private boolean failed = false;

        MatchState(String what) {
            this.what = what.toCharArray();
        }

        MatchState(char[] what) {
            this.what = what;
        }

        public MatchState copy() {
            return new MatchState(this.what);
        }

        private void reset() {
            this.matched = 0;
            this.failed = false;
        }

        boolean isMatched() {
            return this.matched >= this.what.length;
        }

        void check(char c) {
            if (this.failed || this.isMatched()) {
                return;
            }
            if (this.what[this.matched] == c) {
                ++this.matched;
            } else {
                this.failed = true;
            }
        }
    }
}

