/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.hints.pom;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.Map;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.modules.maven.hints.pom.spi.Configuration;
import org.netbeans.modules.maven.hints.pom.spi.POMErrorFixBase;
import org.netbeans.modules.maven.hints.pom.spi.POMErrorFixProvider;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

class HintsPanelLogic
implements MouseListener,
KeyListener,
TreeSelectionListener,
ChangeListener,
ActionListener {
    private final Map<POMErrorFixBase, ModifiedPreferences> changes = new HashMap<POMErrorFixBase, ModifiedPreferences>();
    private static final Map<Configuration.HintSeverity, Integer> severity2index = new HashMap<Configuration.HintSeverity, Integer>();
    private static final String DESCRIPTION_HEADER = "<html><head></head><body>";
    private static final String DESCRIPTION_FOOTER = "</body></html>";
    private JTree errorTree;
    private JComboBox severityComboBox;
    private JCheckBox tasklistCheckBox;
    private JPanel customizerPanel;
    private JEditorPane descriptionTextArea;

    HintsPanelLogic() {
    }

    void connect(JTree errorTree, JComboBox severityComboBox, JCheckBox tasklistCheckBox, JPanel customizerPanel, JEditorPane descriptionTextArea) {
        this.errorTree = errorTree;
        this.severityComboBox = severityComboBox;
        this.tasklistCheckBox = tasklistCheckBox;
        this.customizerPanel = customizerPanel;
        this.descriptionTextArea = descriptionTextArea;
        errorTree.addKeyListener(this);
        errorTree.addMouseListener(this);
        errorTree.getSelectionModel().addTreeSelectionListener(this);
        severityComboBox.addActionListener(this);
        tasklistCheckBox.addChangeListener(this);
        this.valueChanged(null);
    }

    void disconnect() {
        this.errorTree.removeKeyListener(this);
        this.errorTree.removeMouseListener(this);
        this.errorTree.getSelectionModel().removeTreeSelectionListener(this);
        this.severityComboBox.removeActionListener(this);
        this.tasklistCheckBox.removeChangeListener(this);
        this.componentsSetEnabled(false);
        for (POMErrorFixBase hint : this.changes.keySet()) {
            Configuration config;
            if (hint instanceof POMErrorFixProvider) {
                ((POMErrorFixProvider)hint).cancel();
            }
            if ((config = hint.getConfiguration()) == null) continue;
            config.resetSavedValues();
        }
        this.changes.clear();
    }

    synchronized void applyChanges() {
        for (Map.Entry<POMErrorFixBase, ModifiedPreferences> entry : this.changes.entrySet()) {
            POMErrorFixBase hint = entry.getKey();
            ModifiedPreferences mn = entry.getValue();
            mn.store(hint.getConfiguration().getPreferences());
        }
    }

    boolean isChanged() {
        boolean isChanged = false;
        for (Map.Entry<POMErrorFixBase, ModifiedPreferences> entry : this.changes.entrySet()) {
            POMErrorFixBase hint = entry.getKey();
            Preferences prefs = entry.getValue();
            try {
                for (String key : prefs.keys()) {
                    String current = prefs.get(key, null);
                    String saved = key.equals("enabled") ? Boolean.toString((Boolean)hint.getConfiguration().getSavedValue(key)) : (key.equals("severity") ? ((Configuration.HintSeverity)((Object)hint.getConfiguration().getSavedValue(key))).toPreferenceString() : ((POMErrorFixProvider)hint).getSavedValue(hint.getCustomizer(prefs), key));
                    boolean bl = current == null ? saved != null : !current.equals(saved);
                    if (!(isChanged |= bl)) continue;
                    return true;
                }
            }
            catch (BackingStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return isChanged;
    }

    synchronized Preferences getCurrentPrefernces(POMErrorFixBase hint) {
        Preferences node = this.changes.get(hint);
        return node == null ? hint.getConfiguration().getPreferences() : node;
    }

    synchronized Preferences getPreferences4Modification(POMErrorFixBase hint) {
        Preferences node = this.changes.get(hint);
        if (node == null) {
            node = new ModifiedPreferences(hint.getConfiguration().getPreferences());
            this.changes.put(hint, (ModifiedPreferences)node);
        }
        return node;
    }

    static Object getUserObject(TreePath path) {
        if (path == null) {
            return null;
        }
        DefaultMutableTreeNode tn = (DefaultMutableTreeNode)path.getLastPathComponent();
        return tn.getUserObject();
    }

    static Object getUserObject(DefaultMutableTreeNode node) {
        return node.getUserObject();
    }

    boolean isSelected(DefaultMutableTreeNode node) {
        for (int i = 0; i < node.getChildCount(); ++i) {
            POMErrorFixBase hint;
            DefaultMutableTreeNode ch = (DefaultMutableTreeNode)node.getChildAt(i);
            Object o = ch.getUserObject();
            if (!(o instanceof POMErrorFixBase) || !(hint = (POMErrorFixBase)o).getConfiguration().isEnabled(this.getCurrentPrefernces(hint))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Rectangle r;
        Point p = e.getPoint();
        TreePath path = this.errorTree.getPathForLocation(e.getPoint().x, e.getPoint().y);
        if (path != null && (r = this.errorTree.getPathBounds(path)) != null) {
            r.width = r.height;
            if (r.contains(p)) {
                this.toggle(path);
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        JTree tree;
        TreePath path;
        if ((e.getKeyCode() == 32 || e.getKeyCode() == 10) && e.getSource() instanceof JTree && this.toggle(path = (tree = (JTree)e.getSource()).getSelectionPath())) {
            e.consume();
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent ex) {
        Object o = HintsPanelLogic.getUserObject(this.errorTree.getSelectionPath());
        if (o instanceof POMErrorFixBase) {
            POMErrorFixBase hint = (POMErrorFixBase)o;
            this.componentsSetEnabled(true);
            Preferences p = this.getCurrentPrefernces(hint);
            Configuration.HintSeverity severity = hint.getConfiguration().getSeverity(p);
            if (severity != null) {
                this.severityComboBox.setSelectedIndex(severity2index.get((Object)severity));
                this.severityComboBox.setEnabled(true);
            } else {
                this.severityComboBox.setSelectedIndex(severity2index.get((Object)Configuration.HintSeverity.ERROR));
                this.severityComboBox.setEnabled(false);
            }
            String description = hint.getConfiguration().getDescription();
            this.descriptionTextArea.setText(description == null ? "" : this.wrapDescription(description));
            this.customizerPanel.removeAll();
            JComponent c = hint.getCustomizer(ex == null ? this.getCurrentPrefernces(hint) : this.getPreferences4Modification(hint));
            if (c != null) {
                this.customizerPanel.add((Component)c, "Center");
            }
            this.customizerPanel.getParent().invalidate();
            ((JComponent)this.customizerPanel.getParent()).revalidate();
            this.customizerPanel.getParent().repaint();
        } else {
            this.componentsSetEnabled(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.errorTree.getSelectionPath() == null) {
            return;
        }
        Object o = HintsPanelLogic.getUserObject(this.errorTree.getSelectionPath());
        if (o instanceof POMErrorFixBase) {
            POMErrorFixBase hint = (POMErrorFixBase)o;
            Preferences p = this.getPreferences4Modification(hint);
            if (hint.getConfiguration().getSeverity(p) != null && this.severityComboBox.equals(e.getSource())) {
                hint.getConfiguration().setSeverity(p, this.index2severity(this.severityComboBox.getSelectedIndex()));
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
    }

    private String wrapDescription(String description) {
        return new StringBuffer(DESCRIPTION_HEADER).append(description).append(DESCRIPTION_FOOTER).toString();
    }

    private Configuration.HintSeverity index2severity(int index) {
        for (Map.Entry<Configuration.HintSeverity, Integer> e : severity2index.entrySet()) {
            if (e.getValue() != index) continue;
            return e.getKey();
        }
        throw new IllegalStateException("Unknown severity");
    }

    private boolean toggle(TreePath treePath) {
        if (treePath == null) {
            return false;
        }
        Object o = HintsPanelLogic.getUserObject(treePath);
        DefaultTreeModel model = (DefaultTreeModel)this.errorTree.getModel();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        if (o instanceof POMErrorFixBase) {
            POMErrorFixBase hint = (POMErrorFixBase)o;
            boolean value = !hint.getConfiguration().isEnabled(this.getCurrentPrefernces(hint));
            Preferences mn = this.getPreferences4Modification(hint);
            hint.getConfiguration().setEnabled(mn, value);
            model.nodeChanged(node);
            model.nodeChanged(node.getParent());
        } else if (o instanceof FileObject) {
            boolean value = !this.isSelected(node);
            for (int i = 0; i < node.getChildCount(); ++i) {
                POMErrorFixBase hint;
                boolean cv;
                DefaultMutableTreeNode ch = (DefaultMutableTreeNode)node.getChildAt(i);
                Object cho = ch.getUserObject();
                if (!(cho instanceof POMErrorFixBase) || (cv = (hint = (POMErrorFixBase)cho).getConfiguration().isEnabled(this.getCurrentPrefernces(hint))) == value) continue;
                Preferences mn = this.getPreferences4Modification(hint);
                hint.getConfiguration().setEnabled(mn, value);
                model.nodeChanged(ch);
            }
            model.nodeChanged(node);
        }
        return false;
    }

    private void componentsSetEnabled(boolean enabled) {
        if (!enabled) {
            this.customizerPanel.removeAll();
            this.customizerPanel.getParent().invalidate();
            ((JComponent)this.customizerPanel.getParent()).revalidate();
            this.customizerPanel.getParent().repaint();
            this.severityComboBox.setSelectedIndex(severity2index.get((Object)Configuration.HintSeverity.WARNING));
            this.descriptionTextArea.setText("");
        }
        this.severityComboBox.setEnabled(enabled);
        this.tasklistCheckBox.setEnabled(enabled);
        this.descriptionTextArea.setEnabled(enabled);
    }

    static {
        severity2index.put(Configuration.HintSeverity.ERROR, 0);
        severity2index.put(Configuration.HintSeverity.WARNING, 1);
    }

    private static class ModifiedPreferences
    extends AbstractPreferences {
        private final Map<String, Object> map = new HashMap<String, Object>();

        public ModifiedPreferences(Preferences node) {
            super(null, "");
            try {
                for (String key : node.keys()) {
                    this.put(key, node.get(key, null));
                }
            }
            catch (BackingStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        public void store(Preferences target) {
            try {
                for (String key : this.keys()) {
                    target.put(key, this.get(key, null));
                }
            }
            catch (BackingStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        @Override
        protected void putSpi(String key, String value) {
            this.map.put(key, value);
        }

        @Override
        protected String getSpi(String key) {
            return (String)this.map.get(key);
        }

        @Override
        protected void removeSpi(String key) {
            this.map.remove(key);
        }

        @Override
        protected void removeNodeSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected String[] keysSpi() throws BackingStoreException {
            String[] array = new String[this.map.keySet().size()];
            return this.map.keySet().toArray(array);
        }

        @Override
        protected String[] childrenNamesSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected AbstractPreferences childSpi(String name) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected void syncSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected void flushSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

