/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.graph;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.graph.DependencyGraphScene;
import org.netbeans.modules.java.graph.GraphEdge;
import org.netbeans.modules.java.graph.GraphNode;
import org.netbeans.modules.java.graph.GraphNodeImplementation;
import org.netbeans.modules.maven.api.ModelUtils;
import org.netbeans.modules.maven.graph.Bundle;
import org.netbeans.modules.maven.graph.DependencyGraphTopComponent;
import org.netbeans.modules.maven.graph.FixVersionConflictPanel;
import org.netbeans.modules.maven.graph.MavenAction;
import org.netbeans.modules.maven.graph.MavenDependencyNode;
import org.netbeans.modules.maven.model.pom.Dependency;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

public class FixVersionConflictAction
extends MavenAction {
    FixVersionConflictAction(DependencyGraphTopComponent ownerTC, DependencyGraphScene scene, GraphNode<MavenDependencyNode> rootNode, GraphNode<MavenDependencyNode> node, POMModel model, Project project) {
        super(ownerTC, scene, rootNode, node, model, project);
        this.putValue("Name", Bundle.TIT_FixConflict());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        FixVersionConflictPanel fixPanel = new FixVersionConflictPanel(this.scene, (GraphNode<MavenDependencyNode>)this.node);
        DialogDescriptor dd = new DialogDescriptor((Object)fixPanel, Bundle.TIT_FixConflict());
        Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
        if (ret == DialogDescriptor.OK_OPTION) {
            FixVersionConflictPanel.FixDescription res = fixPanel.getResult();
            this.fixDependency(res);
            this.updateGraph(res);
            this.save();
        }
    }

    private void fixDependency(FixVersionConflictPanel.FixDescription fixContent) {
        if (!this.model.startTransaction()) {
            return;
        }
        if (this.model.getProject() == null) {
            Logger.getLogger(FixVersionConflictAction.class.getName()).warning("#238748 we got a graph, but the model turned invalid for some reason. if you have steps to reproduce, please reopen the issue.");
            return;
        }
        try {
            if (fixContent.isSet && fixContent.version2Set != null) {
                Dependency dep = ModelUtils.checkModelDependency((POMModel)this.model, (String)this.nodeArtif.getGroupId(), (String)this.nodeArtif.getArtifactId(), (boolean)true);
                dep.setVersion(fixContent.version2Set.toString());
            }
            if (fixContent.isExclude) {
                this.excludeDepFromModel((MavenDependencyNode)this.node.getImpl(), fixContent.exclusionTargets);
            }
        }
        finally {
            this.model.endTransaction();
        }
    }

    private void updateGraph(FixVersionConflictPanel.FixDescription fixContent) {
        if (fixContent.isSet) {
            ((MavenDependencyNode)this.node.getImpl()).getArtifact().setVersion(fixContent.version2Set.toString());
            Collection incoming = this.scene.findNodeEdges((Object)this.node, false, true);
            for (GraphEdge age : incoming) {
                this.scene.notifyModelChanged(age);
            }
            this.scene.notifyModelChanged(this.node);
            if (this.scene.findEdgesBetween((Object)this.rootNode, (Object)this.node).isEmpty()) {
                GraphEdge ed = this.scene.addEdge((GraphNodeImplementation)((MavenDependencyNode)this.rootNode.getImpl()), (GraphNodeImplementation)((MavenDependencyNode)this.node.getImpl()));
                ed.setPrimaryPath(true);
                this.scene.setEdgeTarget((Object)ed, (Object)this.node);
                this.scene.setEdgeSource((Object)ed, (Object)this.rootNode);
                this.node.setPrimaryLevel(1);
                this.node.setParent((GraphNodeImplementation)((MavenDependencyNode)this.rootNode.getImpl()));
                ((MavenDependencyNode)this.rootNode.getImpl()).addChild((MavenDependencyNode)this.node.getImpl());
                this.scene.validate();
            }
        }
        if (fixContent.isExclude) {
            this.updateGraphAfterExclusion((GraphNode<MavenDependencyNode>)this.node, fixContent.exclusionTargets, fixContent.conflictParents);
        }
    }
}

