/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.format.checkstyle;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.codehaus.plexus.util.IOUtil;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.embedder.MavenEmbedder;
import org.netbeans.modules.maven.format.checkstyle.ModuleConvertor;
import org.netbeans.spi.project.AuxiliaryProperties;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class AuxPropsImpl
implements AuxiliaryProperties,
PropertyChangeListener {
    private final Project project;
    private Properties cache;
    private boolean recheck = true;
    private final List<String> defaults = new ArrayList<String>();
    private final AtomicBoolean enabledSet = new AtomicBoolean(false);
    private boolean enabled = false;
    private final RequestProcessor RP = new RequestProcessor("Download checkstyle plugin classpath", 1);

    public AuxPropsImpl(Project prj) {
        this.project = prj;
        this.defaults.add("config/sun_checks.xml");
        this.defaults.add("config/maven_checks.xml");
        this.defaults.add("config/avalon_checks.xml");
        this.defaults.add("config/turbine_checks.xml");
        NbMavenProject.addPropertyChangeListener((Project)prj, (PropertyChangeListener)this);
    }

    private FileObject cacheDir() throws IOException {
        return ProjectUtils.getCacheDirectory((Project)this.project, AuxPropsImpl.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileObject copyToCacheDir(InputStream in) throws IOException {
        FileObject cacheDir = this.cacheDir();
        FileObject file = cacheDir.getFileObject("checkstyle-checker.xml");
        if (file == null) {
            file = cacheDir.createData("checkstyle-checker", "xml");
        }
        InputStream inst = in;
        OutputStream outst = null;
        try {
            outst = file.getOutputStream();
            FileUtil.copy((InputStream)in, (OutputStream)outst);
        }
        finally {
            IOUtil.close((InputStream)inst);
            IOUtil.close((OutputStream)outst);
        }
        return file;
    }

    private Properties convert() {
        try {
            FileObject cachedFile = this.cacheDir().getFileObject("checkstyle-checker.xml");
            boolean hasCached = cachedFile != null && this.cache != null;
            ModuleConvertor mc = new ModuleConvertor();
            FileObject fo = this.project.getProjectDirectory().getFileObject("target/checkstyle-checker.xml");
            if (fo != null) {
                if (hasCached && cachedFile.getSize() == fo.getSize()) {
                    return this.cache;
                }
                fo = this.copyToCacheDir(fo.getInputStream());
            } else {
                FileObject pom = this.project.getProjectDirectory().getFileObject("pom.xml");
                if (hasCached && pom != null && cachedFile.lastModified().after(pom.lastModified())) {
                    return this.cache;
                }
                String loc = PluginPropertyUtils.getReportPluginProperty((Project)this.project, (String)"org.apache.maven.plugins", (String)"maven-checkstyle-plugin", (String)"configLocation", null);
                if (loc == null && AuxPropsImpl.definesCheckStyle(this.project)) {
                    loc = "config/sun_checks.xml";
                }
                if (loc != null && this.defaults.contains(loc)) {
                    InputStream in = this.getClass().getClassLoader().getResourceAsStream("org/netbeans/modules/maven/format/checkstyle/" + loc);
                    fo = this.copyToCacheDir(in);
                } else if (loc != null) {
                    File file = FileUtilities.resolveFilePath((File)FileUtil.toFile((FileObject)this.project.getProjectDirectory()), (String)loc);
                    if (file != null && file.exists()) {
                        fo = this.copyToCacheDir(FileUtil.toFileObject((File)file).getInputStream());
                    } else {
                        List<File> deps = this.findDependencyArtifacts();
                        if (deps.size() > 0) {
                            FileObject root;
                            File d;
                            FileObject fileFO;
                            Iterator<File> iterator = deps.iterator();
                            while (iterator.hasNext() && (!FileUtil.isArchiveFile((FileObject)(fileFO = FileUtil.toFileObject((File)(d = iterator.next())))) || (root = FileUtil.getArchiveRoot((FileObject)fileFO)) == null || (fo = root.getFileObject(loc)) == null)) {
                            }
                        }
                        if (fo == null) {
                            try {
                                final URL url = new URL(loc);
                                this.RP.post(new Runnable(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    @Override
                                    public void run() {
                                        InputStream urlis = null;
                                        try {
                                            urlis = url.openStream();
                                            byte[] arr = IOUtil.toByteArray((InputStream)urlis);
                                            AuxPropsImpl auxPropsImpl = AuxPropsImpl.this;
                                            synchronized (auxPropsImpl) {
                                                ByteArrayInputStream bais = new ByteArrayInputStream(arr);
                                                AuxPropsImpl.this.copyToCacheDir(bais);
                                                AuxPropsImpl.this.recheck = true;
                                            }
                                        }
                                        catch (IOException ex) {
                                            ex.printStackTrace();
                                        }
                                        finally {
                                            IOUtil.close((InputStream)urlis);
                                        }
                                    }
                                });
                            }
                            catch (MalformedURLException malformedURLException) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
            if (fo != null) {
                return mc.convert(fo.getInputStream());
            }
        }
        catch (IOException io) {
            Exceptions.printStackTrace((Throwable)io);
        }
        return new Properties();
    }

    static boolean definesCheckStyle(Project prj) {
        NbMavenProject project = (NbMavenProject)prj.getLookup().lookup(NbMavenProject.class);
        assert (project != null) : "Requires a maven project instance";
        return AuxPropsImpl.definesCheckStyle(project.getMavenProject());
    }

    static boolean definesCheckStyle(MavenProject prj) {
        for (ReportPlugin plug : prj.getReportPlugins()) {
            if (!"org.apache.maven.plugins".equals(plug.getGroupId()) || !"maven-checkstyle-plugin".equals(plug.getArtifactId())) continue;
            return true;
        }
        return false;
    }

    private List<File> findDependencyArtifacts() {
        ArrayList<File> cpFiles = new ArrayList<File>();
        final NbMavenProject p = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
        List plugins = p.getMavenProject().getBuildPlugins();
        for (Plugin plug : plugins) {
            if (!"maven-checkstyle-plugin".equals(plug.getArtifactId()) || !"org.apache.maven.plugins".equals(plug.getGroupId())) continue;
            List deps = plug.getDependencies();
            final MavenEmbedder online = EmbedderFactory.getOnlineEmbedder();
            online.setUpLegacySupport();
            final MavenProjectBuilder builder = (MavenProjectBuilder)online.lookupComponent(MavenProjectBuilder.class);
            assert (builder != null) : "MavenProjectBuilder component not found in maven";
            for (Dependency d : deps) {
                final Artifact projectArtifact = online.createArtifactWithClassifier(d.getGroupId(), d.getArtifactId(), d.getVersion(), d.getType(), d.getClassifier());
                String localPath = online.getLocalRepository().pathOf(projectArtifact);
                File f = FileUtil.normalizeFile((File)new File(online.getLocalRepository().getBasedir(), localPath));
                if (f.exists()) {
                    cpFiles.add(f);
                    continue;
                }
                this.RP.post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            online.setUpLegacySupport();
                            builder.buildFromRepository(projectArtifact, p.getMavenProject().getRemoteArtifactRepositories(), online.getLocalRepository());
                            AuxPropsImpl auxPropsImpl = AuxPropsImpl.this;
                            synchronized (auxPropsImpl) {
                                AuxPropsImpl.this.recheck = true;
                            }
                        }
                        catch (ProjectBuildingException ex) {
                            ex.printStackTrace();
                        }
                    }
                });
            }
        }
        return cpFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Properties getCache() {
        if (this.enabledSet.compareAndSet(false, true)) {
            String en = ((AuxiliaryProperties)this.project.getLookup().lookup(AuxiliaryProperties.class)).get("netbeans.checkstyle.format", true);
            this.enabled = en != null && Boolean.parseBoolean(en);
        }
        AuxPropsImpl auxPropsImpl = this;
        synchronized (auxPropsImpl) {
            if (this.cache == null || this.recheck) {
                if (this.enabled) {
                    try {
                        RequestProcessor rp = new RequestProcessor("Checkstyle cache", 1);
                        this.cache = (Properties)rp.submit((Callable)new Callable<Properties>(){

                            @Override
                            public Properties call() throws Exception {
                                return AuxPropsImpl.this.convert();
                            }
                        }).get();
                    }
                    catch (InterruptedException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    catch (ExecutionException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                } else {
                    this.cache = new Properties();
                }
                this.recheck = false;
            }
        }
        return this.cache;
    }

    public String get(String key, boolean shared) {
        if ("netbeans.checkstyle.format".equals(key)) {
            return null;
        }
        if (shared) {
            return this.getCache().getProperty(key);
        }
        return null;
    }

    public void put(String key, String value, boolean shared) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public Iterable<String> listKeys(boolean shared) {
        if (shared) {
            ArrayList<String> str = new ArrayList<String>();
            for (Object k : this.getCache().keySet()) {
                str.add((String)k);
            }
            return str;
        }
        return new ArrayList<String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("MavenProject".equals(evt.getPropertyName())) {
            this.enabledSet.compareAndSet(true, false);
            AuxPropsImpl auxPropsImpl = this;
            synchronized (auxPropsImpl) {
                this.recheck = true;
            }
        }
    }
}

