/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.yaml;

import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.ChangeListener;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.Severity;
import org.netbeans.modules.csl.api.StructureItem;
import org.netbeans.modules.csl.spi.DefaultError;
import org.netbeans.modules.languages.yaml.YamlParserResult;
import org.netbeans.modules.languages.yaml.YamlSection;
import org.netbeans.modules.languages.yaml.YamlTokenId;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Task;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.SourceModificationEvent;
import org.openide.util.NbBundle;
import org.snakeyaml.engine.v2.exceptions.ParserException;
import org.snakeyaml.engine.v2.exceptions.ScannerException;

public class YamlParser
extends Parser {
    private static final Logger LOGGER = Logger.getLogger(YamlParser.class.getName());
    private static final int MAX_LENGTH = 524288;
    private YamlParserResult lastResult;
    static final Pattern[] SPEC_PATTERN_REPLACEMENTS = new Pattern[]{Pattern.compile("@"), Pattern.compile("\\?"), Pattern.compile("!(?!(omap|!omap))")};

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    public void cancel() {
    }

    public Parser.Result getResult(Task task) throws ParseException {
        assert (this.lastResult != null) : "getResult() called prior parse()";
        return this.lastResult;
    }

    private static String asString(CharSequence sequence) {
        if (sequence instanceof String) {
            return (String)sequence;
        }
        return sequence.toString();
    }

    private boolean isTooLarge(String source) {
        return source.length() > 524288;
    }

    private YamlParserResult resultForTooLargeFile(Snapshot snapshot) {
        YamlParserResult result = new YamlParserResult(snapshot);
        DefaultError error = new DefaultError(null, NbBundle.getMessage(YamlParser.class, (String)"TooLarge"), null, snapshot.getSource().getFileObject(), 0, 0, Severity.WARNING);
        result.addError((Error)error);
        return result;
    }

    static void replaceWithSpaces(StringBuilder source, String startToken, String endToken) {
        int startReplace = source.indexOf(startToken);
        if (startReplace == -1) {
            return;
        }
        while (startReplace > -1) {
            int endReplace = source.indexOf(endToken, startReplace) + 1;
            if (endReplace > startReplace) {
                for (int i = startReplace; i <= endReplace; ++i) {
                    source.setCharAt(i, ' ');
                }
                startReplace = source.indexOf(startToken, endReplace);
                continue;
            }
            startReplace = -1;
        }
    }

    static void replacePhpFragments(StringBuilder source) {
        YamlParser.replaceWithSpaces(source, "<?", "?>");
    }

    static void replaceMustache(StringBuilder source) {
        YamlParser.replaceWithSpaces(source, "{{", "}}");
    }

    private static void replaceCommonSpecialCharacters(StringBuilder source) {
        for (int i = 0; i < SPEC_PATTERN_REPLACEMENTS.length; ++i) {
            Pattern pattern = SPEC_PATTERN_REPLACEMENTS[i];
            Matcher m = pattern.matcher(source);
            while (m.find()) {
                for (int idx = m.start(); idx < m.end(); ++idx) {
                    source.setCharAt(idx, '_');
                }
            }
        }
    }

    private static String replaceInlineRegexBrackets(String source) {
        Pattern p = Pattern.compile("\\^/.*?\\[.*?\\].*?,");
        Matcher m = p.matcher(source);
        while (m.find()) {
            String found = m.group();
            String replaced = found.replace('[', '_').replace(']', '_');
            source = source.replace(found, replaced);
        }
        return source;
    }

    YamlParserResult parse(String src, Snapshot snapshot) {
        if (this.isTooLarge(src)) {
            return this.resultForTooLargeFile(snapshot);
        }
        StringBuilder sb = new StringBuilder(src);
        YamlParser.replacePhpFragments(sb);
        YamlParser.replaceMustache(sb);
        YamlParser.replaceCommonSpecialCharacters(sb);
        YamlParserResult result = new YamlParserResult(snapshot);
        LinkedList<YamlSection> sources = new LinkedList<YamlSection>();
        sources.push(new YamlSection(sb.toString()));
        int sourceLength = Integer.MAX_VALUE;
        int stallCounter = 0;
        while (!sources.isEmpty()) {
            int len = 0;
            for (YamlSection source : sources) {
                len += source.length();
            }
            if (len < sourceLength) {
                sourceLength = len;
                stallCounter = 0;
            } else {
                ++stallCounter;
            }
            if (stallCounter < 2) {
                YamlSection section = (YamlSection)sources.pop();
                try {
                    List<? extends StructureItem> items = section.collectItems(snapshot);
                    result.addStructure(items);
                    continue;
                }
                catch (ScannerException se) {
                    result.addError((Error)section.processException(snapshot, se));
                    for (YamlSection part : section.splitOnException(se)) {
                        sources.push(part);
                    }
                    continue;
                }
                catch (ParserException pe) {
                    result.addError((Error)section.processException(snapshot, pe));
                    for (YamlSection part : section.splitOnException(pe)) {
                        sources.push(part);
                    }
                    continue;
                }
                catch (Exception ex) {
                    String message = ex.getMessage();
                    if (message == null || message.length() <= 0) continue;
                    result.addError((Error)this.processError(message, snapshot, 0));
                    continue;
                }
            }
            sources.clear();
        }
        return result;
    }

    private DefaultError processError(String message, Snapshot snapshot, int pos) {
        if (message.startsWith("ScannerException null ")) {
            message = message.substring(22);
        } else if (message.startsWith("ParserException ")) {
            message = message.substring(16);
        }
        char firstChar = message.charAt(0);
        char upcasedChar = Character.toUpperCase(firstChar);
        if (firstChar != upcasedChar) {
            message = upcasedChar + message.substring(1);
        }
        return new DefaultError(null, message, null, snapshot.getSource().getFileObject(), pos, pos, Severity.ERROR);
    }

    public void parse(Snapshot snapshot, Task task, SourceModificationEvent event) throws ParseException {
        String source = YamlParser.asString(snapshot.getText());
        if (this.isTooLarge(source)) {
            LOGGER.log(Level.FINE, "Skipping {0}, too large to parse (length: {1})", new Object[]{snapshot.getSource().getFileObject(), source.length()});
            this.lastResult = this.resultForTooLargeFile(snapshot);
            return;
        }
        try {
            StringBuilder sb = new StringBuilder();
            TokenHierarchy hi = TokenHierarchy.create((CharSequence)source, YamlTokenId.language());
            TokenSequence ts = hi.tokenSequence();
            int offset = 0;
            ts.move(offset);
            while (ts.moveNext()) {
                Token t = ts.token();
                TokenId id = t.id();
                if (id == YamlTokenId.RUBY_EXPR) {
                    String marker = "__";
                    sb.append(marker);
                    int n = t.length() - marker.length();
                    for (int i = 0; i < n; ++i) {
                        sb.append(' ');
                    }
                    continue;
                }
                if (id == YamlTokenId.RUBY || id == YamlTokenId.RUBYCOMMENT || id == YamlTokenId.DELIMITER) {
                    for (int i = 0; i < t.length(); ++i) {
                        sb.append(' ');
                    }
                    continue;
                }
                sb.append(t.text().toString());
            }
            source = sb.toString();
            this.lastResult = this.parse(source, snapshot);
        }
        catch (Exception ioe) {
            this.lastResult = new YamlParserResult(snapshot);
        }
    }
}

