/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.neon.completion;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.CodeCompletionContext;
import org.netbeans.modules.csl.api.CodeCompletionHandler;
import org.netbeans.modules.csl.api.CodeCompletionResult;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ParameterInfo;
import org.netbeans.modules.csl.spi.DefaultCompletionResult;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.languages.neon.completion.NeonCompletionContext;
import org.netbeans.modules.languages.neon.completion.NeonCompletionContextFinder;
import org.netbeans.modules.languages.neon.completion.NeonCompletionProposal;
import org.netbeans.modules.languages.neon.completion.NeonElement;
import org.netbeans.modules.languages.neon.lexer.NeonTokenId;
import org.netbeans.modules.languages.neon.parser.NeonParser;

public class NeonCompletionHandler
implements CodeCompletionHandler {
    static final Set<NeonElement> SERVICE_CONFIG_OPTS = new HashSet<NeonElement>();

    public CodeCompletionResult complete(CodeCompletionContext context) {
        ArrayList<CompletionProposal> completionProposals = new ArrayList<CompletionProposal>();
        ParserResult parserResult = context.getParserResult();
        if (parserResult instanceof NeonParser.NeonParserResult) {
            NeonParser.NeonParserResult neonParserResult = (NeonParser.NeonParserResult)parserResult;
            NeonCompletionProposal.CompletionRequest request = new NeonCompletionProposal.CompletionRequest();
            int caretOffset = context.getCaretOffset();
            request.prefix = context.getPrefix();
            String properPrefix = this.getPrefix(neonParserResult, caretOffset, true);
            request.anchorOffset = caretOffset - (properPrefix == null ? 0 : properPrefix.length());
            request.parserResult = neonParserResult;
            NeonCompletionContext completionContext = NeonCompletionContextFinder.find(request.parserResult, caretOffset);
            completionContext.complete(completionProposals, request);
        }
        return new DefaultCompletionResult(completionProposals, false);
    }

    public String document(ParserResult info, ElementHandle element) {
        return null;
    }

    public ElementHandle resolveLink(String link, ElementHandle originalHandle) {
        return null;
    }

    public String getPrefix(ParserResult info, int caretOffset, boolean upToOffset) {
        return PrefixResolver.create(info, caretOffset, upToOffset).resolve();
    }

    public CodeCompletionHandler.QueryType getAutoQuery(JTextComponent component, String typedText) {
        return CodeCompletionHandler.QueryType.NONE;
    }

    public String resolveTemplateVariable(String variable, ParserResult info, int caretOffset, String name, Map parameters) {
        return null;
    }

    public Set<String> getApplicableTemplates(Document doc, int selectionBegin, int selectionEnd) {
        return null;
    }

    public ParameterInfo parameters(ParserResult info, int caretOffset, CompletionProposal proposal) {
        return ParameterInfo.NONE;
    }

    static {
        SERVICE_CONFIG_OPTS.add(NeonElement.Factory.create("setup", "setup:"));
        SERVICE_CONFIG_OPTS.add(NeonElement.Factory.create("class", "class: ${Class}"));
        SERVICE_CONFIG_OPTS.add(NeonElement.Factory.create("arguments", "arguments: [${argument}]"));
        SERVICE_CONFIG_OPTS.add(NeonElement.Factory.create("factory", "factory: ${Class}::${method}"));
        SERVICE_CONFIG_OPTS.add(NeonElement.Factory.create("autowired", "autowired: ${no}"));
    }

    private static final class PrefixResolver {
        private final ParserResult info;
        private final int offset;
        private final boolean upToOffset;
        private String result = "";

        static PrefixResolver create(ParserResult info, int offset, boolean upToOffset) {
            return new PrefixResolver(info, offset, upToOffset);
        }

        private PrefixResolver(ParserResult info, int offset, boolean upToOffset) {
            this.info = info;
            this.offset = offset;
            this.upToOffset = upToOffset;
        }

        String resolve() {
            TokenHierarchy th = this.info.getSnapshot().getTokenHierarchy();
            if (th != null) {
                this.processHierarchy(th);
            }
            return this.result;
        }

        private void processHierarchy(TokenHierarchy<?> th) {
            TokenSequence tts = th.tokenSequence(NeonTokenId.language());
            if (tts != null) {
                this.processTopSequence((TokenSequence<NeonTokenId>)tts);
            }
        }

        private void processTopSequence(TokenSequence<NeonTokenId> tts) {
            tts.move(this.offset);
            if (tts.moveNext() || tts.movePrevious()) {
                this.processToken(tts);
            }
        }

        private void processToken(TokenSequence<NeonTokenId> ts) {
            Token token;
            if (ts.offset() == this.offset) {
                ts.movePrevious();
            }
            if ((token = ts.token()) != null) {
                this.processSelectedToken(ts);
            }
        }

        private void processSelectedToken(TokenSequence<NeonTokenId> ts) {
            NeonTokenId id = (NeonTokenId)ts.token().id();
            if (PrefixResolver.isValidTokenId(id)) {
                this.createResult(ts);
            }
        }

        private void createResult(TokenSequence<NeonTokenId> ts) {
            if (this.upToOffset) {
                String text = ts.token().text().toString();
                this.result = text.substring(0, this.offset - ts.offset());
            }
        }

        private static boolean isValidTokenId(NeonTokenId id) {
            return NeonTokenId.NEON_LITERAL.equals((Object)id) || NeonTokenId.NEON_BLOCK.equals((Object)id) || NeonTokenId.NEON_VALUED_BLOCK.equals((Object)id);
        }
    }
}

