/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.hcl.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.antlr.v4.runtime.NoViableAltException;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.netbeans.modules.languages.hcl.ast.HCLArithmeticOperation;
import org.netbeans.modules.languages.hcl.ast.HCLCollection;
import org.netbeans.modules.languages.hcl.ast.HCLConditionalOperation;
import org.netbeans.modules.languages.hcl.ast.HCLElement;
import org.netbeans.modules.languages.hcl.ast.HCLExpression;
import org.netbeans.modules.languages.hcl.ast.HCLForExpression;
import org.netbeans.modules.languages.hcl.ast.HCLFunction;
import org.netbeans.modules.languages.hcl.ast.HCLIdentifier;
import org.netbeans.modules.languages.hcl.ast.HCLLiteral;
import org.netbeans.modules.languages.hcl.ast.HCLResolveOperation;
import org.netbeans.modules.languages.hcl.ast.HCLTemplate;
import org.netbeans.modules.languages.hcl.ast.HCLVariable;
import org.netbeans.modules.languages.hcl.grammar.HCLParser;

public class HCLExpressionFactory {
    private final Consumer<HCLElement.CreateContext> createAction;

    public HCLExpressionFactory(Consumer<HCLElement.CreateContext> createAction) {
        this.createAction = createAction;
    }

    public HCLExpressionFactory() {
        this(null);
    }

    public final HCLExpression process(HCLParser.ExpressionContext ctx) throws UnsupportedOperationException {
        return this.expr(ctx);
    }

    protected HCLExpression expr(HCLParser.ExpressionContext ctx) throws UnsupportedOperationException {
        if (ctx == null) {
            return null;
        }
        if (ctx.op != null) {
            if (ctx.left != null && ctx.right != null) {
                HCLArithmeticOperation.Operator op = HCLExpressionFactory.binOp(ctx.op.getType());
                return this.created(new HCLArithmeticOperation.Binary(op, this.expr(ctx.left), this.expr(ctx.right)), ctx);
            }
            if (ctx.right != null) {
                switch (ctx.op.getType()) {
                    case 23: {
                        return this.created(new HCLArithmeticOperation.Unary(HCLArithmeticOperation.Operator.NOT, this.expr(ctx.right)), ctx);
                    }
                    case 29: {
                        return this.created(new HCLArithmeticOperation.Unary(HCLArithmeticOperation.Operator.MINUS, this.expr(ctx.right)), ctx);
                    }
                }
            }
            if (ctx.exprCond != null && ctx.exprTrue != null && ctx.exprFalse != null) {
                return this.created(new HCLConditionalOperation(this.expr(ctx.exprCond), this.expr(ctx.exprTrue), this.expr(ctx.exprFalse)), ctx);
            }
        } else {
            return ctx.exprTerm() != null ? this.expr(ctx.exprTerm()) : null;
        }
        throw new UnsupportedOperationException("Unsupported expression: " + ctx.getText());
    }

    protected HCLExpression expr(HCLParser.ExprTermContext ctx) {
        NoViableAltException nva;
        if (ctx == null) {
            return null;
        }
        HCLExpression ret = null;
        if (ctx.LPAREN() != null && ctx.RPAREN() != null) {
            ret = this.expr(ctx.expression());
        } else if (ctx.literalValue() != null) {
            ret = this.expr(ctx.literalValue());
        } else if (ctx.collectionValue() != null) {
            ret = this.expr(ctx.collectionValue());
        } else if (ctx.functionCall() != null) {
            ret = this.expr(ctx.functionCall());
        } else if (ctx.templateExpr() != null) {
            ret = this.expr(ctx.templateExpr());
        } else if (ctx.forExpr() != null) {
            ret = this.expr(ctx.forExpr());
        } else if (ctx.variableExpr() != null) {
            ret = this.expr(ctx.variableExpr());
        } else if (ctx.getAttr() != null) {
            ret = this.expr(this.expr(ctx.exprTerm()), ctx.getAttr());
        } else if (ctx.index() != null) {
            ret = this.expr(this.expr(ctx.exprTerm()), ctx.index());
        } else if (ctx.splat() != null) {
            HCLParser.SplatContext splat = ctx.splat();
            ret = this.expr(ctx.exprTerm(), splat);
        }
        if (ctx.exception != null && ctx.exception instanceof NoViableAltException && (nva = (NoViableAltException)ctx.exception).getStartToken().getType() == 27) {
            return this.created(new HCLResolveOperation.Attribute(ret, null), nva.getStartToken());
        }
        return ret;
    }

    protected HCLExpression expr(HCLParser.VariableExprContext ctx) {
        return ctx != null ? (HCLExpression)this.created(new HCLVariable(this.id(ctx.IDENTIFIER())), ctx) : null;
    }

    protected HCLExpression expr(HCLParser.LiteralValueContext ctx) throws UnsupportedOperationException {
        if (ctx == null) {
            return null;
        }
        if (ctx.stringLit() != null) {
            return ctx.stringLit().stringContent() != null ? (HCLExpression)this.created(new HCLLiteral.StringLit(ctx.stringLit().stringContent().getText()), ctx) : (HCLExpression)this.created(new HCLLiteral.StringLit(""), ctx);
        }
        if (ctx.TRUE() != null) {
            return this.created(HCLLiteral.TRUE, ctx);
        }
        if (ctx.FALSE() != null) {
            return this.created(HCLLiteral.FALSE, ctx);
        }
        if (ctx.NULL() != null) {
            return this.created(HCLLiteral.NULL, ctx);
        }
        if (ctx.NUMERIC_LIT() != null) {
            return this.created(new HCLLiteral.NumericLit(ctx.NUMERIC_LIT().getText()), ctx);
        }
        throw new UnsupportedOperationException("Unsupported literal: " + ctx.getText());
    }

    protected HCLExpression expr(HCLParser.CollectionValueContext ctx) throws UnsupportedOperationException {
        if (ctx == null) {
            return null;
        }
        if (ctx.tuple() != null) {
            HCLParser.TupleContext tuple = ctx.tuple();
            LinkedList<HCLExpression> elements = new LinkedList<HCLExpression>();
            for (HCLParser.ExpressionContext ec : tuple.expression()) {
                elements.add(this.expr(ec));
            }
            return new HCLCollection.Tuple((List<HCLExpression>)elements);
        }
        if (ctx.object() != null) {
            HCLParser.ObjectContext object = ctx.object();
            LinkedList<HCLCollection.ObjectElement> elements = new LinkedList<HCLCollection.ObjectElement>();
            int group = 0;
            HCLParser.ObjectElemContext prev = null;
            for (HCLParser.ObjectElemContext ec : object.objectElem()) {
                if (prev != null && ec.key != null) {
                    group += prev.stop.getLine() + 1 < ec.key.start.getLine() ? 1 : 0;
                }
                elements.add(new HCLCollection.ObjectElement(this.expr(ec.key), this.expr(ec.value), group));
                prev = ec;
            }
            return new HCLCollection.Object((List<HCLCollection.ObjectElement>)elements);
        }
        throw new UnsupportedOperationException("Unsupported collection: " + ctx.getText());
    }

    protected HCLExpression expr(HCLParser.FunctionCallContext ctx) {
        if (ctx == null) {
            return null;
        }
        List<HCLExpression> args = Collections.emptyList();
        boolean expand = false;
        if (ctx.arguments() != null) {
            args = new ArrayList(ctx.arguments().expression().size());
            for (HCLParser.ExpressionContext ectx : ctx.arguments().expression()) {
                args.add(this.expr(ectx));
            }
            expand = ctx.arguments().ELLIPSIS() != null;
        }
        return this.created(new HCLFunction(this.id(ctx.IDENTIFIER()), args, expand), ctx);
    }

    private static HCLArithmeticOperation.Operator binOp(int tokenType) {
        switch (tokenType) {
            case 30: {
                return HCLArithmeticOperation.Operator.MUL;
            }
            case 31: {
                return HCLArithmeticOperation.Operator.DIV;
            }
            case 32: {
                return HCLArithmeticOperation.Operator.MOD;
            }
            case 28: {
                return HCLArithmeticOperation.Operator.ADD;
            }
            case 29: {
                return HCLArithmeticOperation.Operator.SUB;
            }
            case 34: {
                return HCLArithmeticOperation.Operator.OR;
            }
            case 33: {
                return HCLArithmeticOperation.Operator.AND;
            }
            case 21: {
                return HCLArithmeticOperation.Operator.LT;
            }
            case 20: {
                return HCLArithmeticOperation.Operator.LTE;
            }
            case 19: {
                return HCLArithmeticOperation.Operator.GT;
            }
            case 18: {
                return HCLArithmeticOperation.Operator.GTE;
            }
            case 7: {
                return HCLArithmeticOperation.Operator.EQUALS;
            }
            case 22: {
                return HCLArithmeticOperation.Operator.NOT_EQUALS;
            }
        }
        return null;
    }

    protected HCLExpression expr(HCLParser.TemplateExprContext ctx) {
        if (ctx == null) {
            return null;
        }
        if (ctx.heredoc() != null) {
            return this.expr(ctx.heredoc());
        }
        if (ctx.quotedTemplate() != null) {
            return this.expr(ctx.quotedTemplate());
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected HCLExpression expr(HCLParser.HeredocContext ctx) {
        if (ctx == null) {
            return null;
        }
        LinkedList<HCLTemplate.Part> parts = new LinkedList<HCLTemplate.Part>();
        String startText = ctx.HEREDOC_START().getText();
        boolean indented = startText.startsWith("<<~");
        int markerStart = indented ? 3 : 2;
        int markerEnd = startText.endsWith("\r\n") ? 2 : 1;
        String marker = startText.substring(markerStart, startText.length() - markerEnd);
        int indent = -1;
        if (indented) {
            String content = ctx.heredocTemplate() != null ? ctx.heredocTemplate().getText() : "";
            AtomicInteger mIndent = new AtomicInteger(Integer.MAX_VALUE);
            content.lines().filter(line -> !line.isBlank()).forEach(line -> {
                int left;
                for (left = 0; left < line.length() && line.charAt(left) == ' '; ++left) {
                }
                mIndent.set(Math.min(mIndent.get(), left));
            });
            indent = mIndent.get();
        }
        if (ctx.heredocTemplate() != null && ctx.heredocTemplate().children != null) {
            for (ParseTree pt : ctx.heredocTemplate().children) {
                if (pt instanceof HCLParser.HeredocContentContext) {
                    parts.add(new HCLTemplate.StringPart(pt.getText()));
                }
                if (pt instanceof HCLParser.InterpolationContext) {
                    parts.add(new HCLTemplate.InterpolationPart(pt.getText()));
                }
                if (!(pt instanceof HCLParser.TemplateContext)) continue;
                parts.add(new HCLTemplate.TemplatePart(pt.getText()));
            }
        }
        return this.created(new HCLTemplate.HereDoc(marker, indent, parts), ctx);
    }

    protected HCLExpression expr(HCLParser.QuotedTemplateContext ctx) {
        if (ctx == null) {
            return null;
        }
        LinkedList<HCLTemplate.Part> parts = new LinkedList<HCLTemplate.Part>();
        for (ParseTree pt : ctx.children) {
            if (pt instanceof HCLParser.StringContentContext) {
                parts.add(new HCLTemplate.StringPart(pt.getText()));
            }
            if (pt instanceof HCLParser.InterpolationContext) {
                parts.add(new HCLTemplate.InterpolationPart(pt.getText()));
            }
            if (!(pt instanceof HCLParser.TemplateContext)) continue;
            parts.add(new HCLTemplate.TemplatePart(pt.getText()));
        }
        return new HCLTemplate.StringTemplate(parts);
    }

    protected HCLExpression expr(HCLParser.ForExprContext ctx) {
        HCLExpression condExpr;
        if (ctx == null) {
            return null;
        }
        boolean isTuple = ctx.forTupleExpr() != null;
        HCLParser.ForIntroContext intro = isTuple ? ctx.forTupleExpr().forIntro() : ctx.forObjectExpr().forIntro();
        HCLIdentifier keyVar = null;
        HCLIdentifier valueVar = null;
        if (intro.second != null) {
            keyVar = this.id(intro.first);
            valueVar = this.id(intro.second);
        } else {
            valueVar = this.id(intro.first);
        }
        HCLExpression iterable = this.expr(intro.expression());
        HCLParser.ForCondContext cond = isTuple ? ctx.forTupleExpr().forCond() : ctx.forObjectExpr().forCond();
        HCLExpression hCLExpression = condExpr = cond != null ? this.expr(cond.expression()) : null;
        if (isTuple) {
            HCLExpression result = this.expr(ctx.forTupleExpr().expression());
            return this.created(new HCLForExpression.Tuple(keyVar, valueVar, iterable, condExpr, result), ctx);
        }
        boolean grouping = ctx.forObjectExpr().ELLIPSIS() != null;
        HCLExpression resultKey = this.expr(ctx.forObjectExpr().key);
        HCLExpression resultValue = this.expr(ctx.forObjectExpr().value);
        return this.created(new HCLForExpression.Object(keyVar, valueVar, iterable, condExpr, resultKey, resultValue, grouping), ctx);
    }

    protected HCLExpression expr(HCLParser.ExprTermContext exprTerm, HCLParser.SplatContext splat) {
        HCLExpression base = this.expr(exprTerm);
        if (splat.attrSplat() != null) {
            base = this.expr(base, splat);
            for (HCLParser.GetAttrContext ac : splat.attrSplat().getAttr()) {
                base = this.expr(base, ac);
            }
        }
        if (splat.fullSplat() != null) {
            base = this.expr(base, splat);
            for (ParseTree pt : splat.fullSplat().children) {
                if (pt instanceof HCLParser.GetAttrContext) {
                    HCLParser.GetAttrContext ac = (HCLParser.GetAttrContext)pt;
                    base = this.expr(base, ac);
                }
                if (!(pt instanceof HCLParser.IndexContext)) continue;
                base = this.expr(base, (HCLParser.IndexContext)pt);
            }
        }
        return base;
    }

    protected HCLExpression expr(HCLExpression base, HCLParser.SplatContext ctx) throws UnsupportedOperationException {
        if (ctx.attrSplat() != null) {
            HCLParser.AttrSplatContext splat = ctx.attrSplat();
            return this.created(new HCLResolveOperation.AttrSplat(base), splat.DOT().getSymbol(), splat.STAR().getSymbol());
        }
        if (ctx.fullSplat() != null) {
            HCLParser.FullSplatContext splat = ctx.fullSplat();
            return this.created(new HCLResolveOperation.FullSplat(base), splat.LBRACK().getSymbol(), splat.RBRACK().getSymbol());
        }
        throw new UnsupportedOperationException("Unsupported Splat operation. Should not happen. Check the Grammar!");
    }

    protected HCLExpression expr(HCLExpression base, HCLParser.GetAttrContext ctx) {
        return this.created(new HCLResolveOperation.Attribute(base, this.id(ctx.IDENTIFIER())), ctx);
    }

    protected HCLExpression expr(HCLExpression base, HCLParser.IndexContext idx) {
        HCLExpression index = idx.expression() != null ? this.expr(idx.expression()) : (HCLExpression)this.created(new HCLLiteral.NumericLit(idx.LEGACY_INDEX().getText().substring(1)), idx);
        return this.created(new HCLResolveOperation.Index(base, index, idx.LEGACY_INDEX() != null), idx);
    }

    private HCLIdentifier id(TerminalNode tn) {
        return tn != null ? this.id(tn.getSymbol()) : null;
    }

    protected HCLIdentifier id(Token t) {
        return t != null && t.getType() == 40 ? (HCLIdentifier)this.created(new HCLIdentifier.SimpleId(t.getText()), t) : null;
    }

    private <E extends HCLElement> E created(E element, Token token) {
        return this.created(element, token, token);
    }

    private <E extends HCLElement> E created(E element, ParserRuleContext ctx) {
        return this.created(element, ctx.start, ctx.stop);
    }

    private <E extends HCLElement> E created(E element, Token start, Token stop) {
        this.elementCreated(element, start, stop);
        return element;
    }

    private void elementCreated(HCLElement element, Token start, Token stop) {
        if (this.createAction != null) {
            this.createAction.accept(new HCLElement.CreateContext(element, start, stop));
        }
    }
}

