/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.hcl.terraform;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.csl.api.ColoringAttributes;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.SemanticAnalyzer;
import org.netbeans.modules.languages.hcl.ast.HCLAttribute;
import org.netbeans.modules.languages.hcl.ast.HCLBlock;
import org.netbeans.modules.languages.hcl.ast.HCLIdentifier;
import org.netbeans.modules.languages.hcl.ast.SourceRef;
import org.netbeans.modules.languages.hcl.terraform.TerraformParserResult;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;

public final class TerraformSemanticAnalyzer
extends SemanticAnalyzer<TerraformParserResult> {
    private volatile boolean cancelled;
    private Map<OffsetRange, Set<ColoringAttributes>> semanticHighlights;

    public Map<OffsetRange, Set<ColoringAttributes>> getHighlights() {
        return this.semanticHighlights;
    }

    protected final synchronized boolean isCancelled() {
        return this.cancelled;
    }

    protected final synchronized void resume() {
        this.cancelled = false;
    }

    public void run(TerraformParserResult result, SchedulerEvent event) {
        this.resume();
        if (this.isCancelled()) {
            return;
        }
        HashMap<OffsetRange, Set<ColoringAttributes>> highlights = new HashMap<OffsetRange, Set<ColoringAttributes>>();
        SourceRef refs = result.getReferences();
        for (HCLBlock hCLBlock : result.getDocument().getBlocks()) {
            List<HCLIdentifier> decl = hCLBlock.getDeclaration();
            HCLIdentifier type = decl.get(0);
            TerraformParserResult.BlockType bt = TerraformParserResult.BlockType.get(type.id());
            if (bt != null) {
                refs.getOffsetRange(type).ifPresent(range -> highlights.put((OffsetRange)range, ColoringAttributes.CLASS_SET));
                if (decl.size() > 1) {
                    for (int i = 1; i < decl.size(); ++i) {
                        HCLIdentifier id = decl.get(i);
                        refs.getOffsetRange(id).ifPresent(range -> highlights.put((OffsetRange)range, ColoringAttributes.CONSTRUCTOR_SET));
                    }
                }
            }
            this.markAttributes(highlights, refs, hCLBlock);
        }
        this.semanticHighlights = highlights;
    }

    private void markAttributes(Map<OffsetRange, Set<ColoringAttributes>> highlights, SourceRef refs, HCLBlock block) {
        for (HCLAttribute hCLAttribute : block.getAttributes()) {
            refs.getOffsetRange(hCLAttribute.getName()).ifPresent(range -> highlights.put((OffsetRange)range, ColoringAttributes.FIELD_SET));
        }
        for (HCLBlock hCLBlock : block.getBlocks()) {
            this.markAttributes(highlights, refs, hCLBlock);
        }
    }

    public int getPriority() {
        return 0;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.EDITOR_SENSITIVE_TASK_SCHEDULER;
    }

    public void cancel() {
        this.cancelled = true;
    }
}

