/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.antlr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.StructureItem;
import org.netbeans.modules.csl.spi.ParserResult;
import org.openide.filesystems.FileObject;

public abstract class AntlrStructureItem
implements ElementHandle,
StructureItem {
    final String name;
    final FileObject source;
    final int startOffset;
    final int stopOffset;

    public AntlrStructureItem(String name, FileObject source, int startOffset, int stopOffset) {
        this.name = name;
        this.source = source;
        this.startOffset = startOffset;
        this.stopOffset = stopOffset;
    }

    public String getSortText() {
        return this.name;
    }

    public String getHtml(HtmlFormatter formatter) {
        formatter.appendText(this.name);
        return formatter.getText();
    }

    public ElementHandle getElementHandle() {
        return this;
    }

    public long getPosition() {
        return this.startOffset;
    }

    public long getEndPosition() {
        return this.stopOffset;
    }

    public ImageIcon getCustomIcon() {
        return null;
    }

    public FileObject getFileObject() {
        return this.source;
    }

    public String getMimeType() {
        return this.source.getMIMEType();
    }

    public String getName() {
        return this.name;
    }

    public String getIn() {
        return null;
    }

    public Set<Modifier> getModifiers() {
        return Collections.emptySet();
    }

    public boolean signatureEquals(ElementHandle handle) {
        return false;
    }

    public OffsetRange getOffsetRange(ParserResult result) {
        return new OffsetRange(this.startOffset, this.stopOffset);
    }

    public static final class RuleStructureItem
    extends AntlrStructureItem {
        final boolean fragment;

        public RuleStructureItem(String name, boolean fragment, FileObject source, int startOffset, int stopOffset) {
            super(name, source, startOffset, stopOffset);
            this.fragment = fragment;
        }

        public boolean isLeaf() {
            return true;
        }

        public List<? extends StructureItem> getNestedItems() {
            return Collections.emptyList();
        }

        public ElementKind getKind() {
            if (this.fragment) {
                return ElementKind.CONSTANT;
            }
            return Character.isUpperCase(this.name.charAt(0)) ? ElementKind.FIELD : ElementKind.RULE;
        }
    }

    public static final class ModeStructureItem
    extends AntlrStructureItem {
        public final List<RuleStructureItem> rules = new ArrayList<RuleStructureItem>();

        public ModeStructureItem(FileObject source, int startOffset, int stopOffset) {
            super("DEFAULT_MODE", source, startOffset, stopOffset);
        }

        public ModeStructureItem(String name, FileObject source, int startOffset, int stopOffset) {
            super(name, source, startOffset, stopOffset);
        }

        public boolean isLeaf() {
            return this.rules.isEmpty();
        }

        public List<? extends StructureItem> getNestedItems() {
            return this.rules;
        }

        public ElementKind getKind() {
            return ElementKind.CLASS;
        }
    }
}

